/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.j2ee.common.ui;

import com.ibm.etools.j2ee.ui.plugin.J2EEUIPlugin;
import com.ibm.etools.javaee.web.internal.provider.EJBJarInWarItemProvider;
import com.ibm.etools.jee.ui.navigator.internal.WebSocketNode;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.internal.ui.javaeditor.InternalClassFileEditorInput;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jst.j2ee.internal.actions.AbstractOpenAction;
import org.eclipse.jst.j2ee.internal.plugin.J2EEUIMessages;
import org.eclipse.jst.javaee.ejb.EJBJar;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorRegistry;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.part.ISetSelectionTarget;
import org.eclipse.wst.common.internal.emfworkbench.WorkbenchResourceHelper;

public class OpenJavaEEResourceAction
extends AbstractOpenAction {
    public static final String ID = "org.eclipse.jst.j2ee.internal.internal.ui.actions.OpenJ2EEResourceAction";

    public OpenJavaEEResourceAction() {
        super(J2EEUIMessages.getResourceString((String)"OpenJ2EEResourceAction.0"));
    }

    public String getID() {
        return ID;
    }

    protected void openAppropriateEditor(IResource r) {
        if (r == null) {
            return;
        }
        IWorkbenchPage page = null;
        IEditorPart editor = null;
        try {
            page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
            if (this.currentDescriptor != null && (editor = page.openEditor((IEditorInput)new FileEditorInput((IFile)r), this.currentDescriptor.getId())) instanceof ISetSelectionTarget) {
                ((ISetSelectionTarget)editor).selectReveal((ISelection)this.getStructuredSelection());
            }
        }
        catch (Exception e) {
            MessageDialog.openError((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)J2EEUIMessages.getResourceString((String)"Problems_Opening_Editor_ERROR_"), (String)e.getMessage());
        }
    }

    protected void openAppropriateEditor(IClassFile cf) {
        if (cf == null) {
            return;
        }
        IWorkbenchPage page = null;
        IEditorPart editor = null;
        try {
            page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
            if (this.currentDescriptor != null && (editor = page.openEditor((IEditorInput)new InternalClassFileEditorInput(cf), this.currentDescriptor.getId())) instanceof ISetSelectionTarget) {
                ((ISetSelectionTarget)editor).selectReveal((ISelection)this.getStructuredSelection());
            }
        }
        catch (Exception e) {
            MessageDialog.openError((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)J2EEUIMessages.getResourceString((String)"Problems_Opening_Editor_ERROR_"), (String)e.getMessage());
        }
    }

    public void run() {
        if (!this.isEnabled()) {
            return;
        }
        if (this.srcObject instanceof EJBJarInWarItemProvider) {
            EJBJarInWarItemProvider obj = null;
            obj = (EJBJarInWarItemProvider)((Object)this.srcObject);
            EJBJar ejbJar = obj.getCachedEJBJar();
            IFile resource = WorkbenchResourceHelper.getFile((EObject)((EObject)ejbJar));
            if (resource != null && resource.exists()) {
                this.openAppropriateEditor((IResource)resource);
            }
            return;
        }
        if (this.srcObject instanceof WebSocketNode) {
            WebSocketNode wsNode = (WebSocketNode)((Object)this.srcObject);
            Object obj = wsNode.getResource();
            if (obj != null) {
                if (obj instanceof IResource) {
                    IResource res = (IResource)obj;
                    if (res != null && res.exists()) {
                        this.openAppropriateEditor(res);
                    }
                } else if (obj instanceof IClassFile) {
                    IClassFile cf = (IClassFile)obj;
                    this.openAppropriateEditor(cf);
                }
            }
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean updateSelection(IStructuredSelection s) {
        if (!super.updateSelection(s)) {
            return false;
        }
        Object obj = s.getFirstElement();
        if (obj instanceof EJBJarInWarItemProvider) {
            this.srcObject = obj;
            EJBJarInWarItemProvider ejbInWar = null;
            ejbInWar = (EJBJarInWarItemProvider)((Object)this.srcObject);
            EJBJar ejbJar = ejbInWar.getCachedEJBJar();
            IFile file = WorkbenchResourceHelper.getFile((EObject)((EObject)ejbJar));
            IContentType contentType = IDE.getContentType((IFile)file);
            IEditorRegistry registry = PlatformUI.getWorkbench().getEditorRegistry();
            if (file == null) return true;
            if (file.exists()) {
                this.currentDescriptor = registry.getDefaultEditor(file.getName(), contentType);
                return true;
            }
            this.currentDescriptor = null;
            return false;
        }
        if (!(obj instanceof WebSocketNode)) {
            this.setAttributesFromDescriptor();
            this.currentDescriptor = null;
            this.srcObject = obj;
            return false;
        }
        this.srcObject = obj;
        WebSocketNode wsNode = (WebSocketNode)((Object)obj);
        Object nodeObj = wsNode.getResource();
        if (nodeObj instanceof IResource) {
            IResource res = (IResource)nodeObj;
            if (res == null) return true;
            if (res.exists()) {
                IContentType contentType = IDE.getContentType((IFile)((IFile)res));
                IEditorRegistry registry = PlatformUI.getWorkbench().getEditorRegistry();
                this.currentDescriptor = registry.getDefaultEditor(res.getName(), contentType);
                return true;
            }
            this.currentDescriptor = null;
            return false;
        }
        if (!(nodeObj instanceof IClassFile)) return true;
        IClassFile cf = (IClassFile)nodeObj;
        if (cf == null) {
            this.currentDescriptor = null;
            return false;
        }
        IPath path = cf.getPath();
        if (!path.toFile().exists()) {
            path = cf.getResource().getLocation();
        }
        try {
            ZipFile zipFile = new ZipFile(path.toFile());
            if (!(cf.getParent() instanceof IPackageFragment)) return true;
            String pkgName = cf.getParent().getElementName();
            ZipEntry zipFileEntry = null;
            if (!pkgName.isEmpty()) {
                zipFileEntry = zipFile.getEntry(pkgName + "/" + cf.getElementName());
                if (zipFileEntry == null) {
                    zipFileEntry = zipFile.getEntry(pkgName.replace('.', '/') + "/" + cf.getElementName());
                }
            } else {
                zipFileEntry = zipFile.getEntry(cf.getElementName());
            }
            if (zipFileEntry == null) return true;
            InputStream stream = zipFile.getInputStream(zipFileEntry);
            IContentType type = Platform.getContentTypeManager().findContentTypeFor(stream, "*.class");
            IEditorRegistry registry = PlatformUI.getWorkbench().getEditorRegistry();
            this.currentDescriptor = registry.getDefaultEditor("*.class", type);
            return true;
        }
        catch (Exception e) {
            J2EEUIPlugin.logError(e.getMessage());
            return true;
        }
    }
}

