/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.j2ee.common.presentation.temp;

import com.ibm.etools.j2ee.common.nls.CommonEditResourceHandler;
import com.ibm.etools.j2ee.common.presentation.temp.MavenDefaultSettings;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.internal.utils.Messages;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jst.common.project.facet.core.internal.FacetCorePlugin;
import org.eclipse.jst.j2ee.internal.plugin.J2EEPlugin;
import org.eclipse.jst.j2ee.internal.plugin.J2EEPreferences;
import org.eclipse.jst.j2ee.internal.project.ProjectSupportResourceHandler;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;

public class J2EEProjectStructurePreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private static final int INDENT = 10;
    private static final String PROD_PROP_SOURCE_FOLDER = "defaultJavaSourceFolder";
    private Group earMembershipDescGroup;
    private Button addProjectToEarButton;
    private Text earContentText;
    private Text ejbContentText;
    private Text dynWebContentText;
    private Text connectorText;
    private Text appClientText;
    private Text utilitySourceText;
    private String earContent;
    private Group generateDeploymentDescGroup;
    private Button generateDDForEarButton;
    private Button generateDDForWeb25Button;
    private Button generateDDForWeb30Button;
    private Button generateDDForEJBButton;
    private Button generateDDForAppClientButton;
    private Button generateDDForConnectorButton;
    private Text dynWebSourceText;
    private Text dynWebOutputText;
    private Text ejbOutputText;
    private Text appClientOutputText;
    private Text jcaOutputText;
    private Text utilityOutputText;
    private ControlDecoration webSrcDecoration;
    private ControlDecoration webContentDecoration;
    private ControlDecoration webOuputDecoration;
    private ControlDecoration ejbSrcDecoration;
    private ControlDecoration ejbOuputDecoration;
    private ControlDecoration appClientSrcDecoration;
    private ControlDecoration appClientOuputDecoration;
    private ControlDecoration jcaSrcDecoration;
    private ControlDecoration jcaOuputDecoration;
    private ControlDecoration utilitySrcDecoration;
    private ControlDecoration utilityOuputDecoration;
    private ControlDecoration earContentDecoration;
    private J2EEPreferences preferences = J2EEPlugin.getDefault().getJ2EEPreferences();
    boolean initializing = false;
    private FieldDecorationRegistry registry = FieldDecorationRegistry.getDefault();
    private Map<ControlDecoration, Boolean> validMap = new HashMap<ControlDecoration, Boolean>();

    public void init(IWorkbench workbench) {
    }

    protected Control createContents(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(272));
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, "com.ibm.etools.j2ee.ui.J2EE_PREFERENCE_PAGE");
        this.createEarMembershipGroup(composite);
        this.createSpacer(composite);
        this.earContent = this.preferences.getSetting("earContent");
        this.createEARPreferenceSection(composite);
        this.createDynWebPreferenceSection(composite);
        this.createEJBPreferenceSection(composite);
        this.createAppClientPreferenceSection(composite);
        this.createJCAPreferenceSection(composite);
        this.createUtilityPreferenceSection(composite);
        this.createSpacer(composite);
        this.createGenerateDeploymentDescriptorGroup(composite);
        this.initializeValues(false);
        return composite;
    }

    private void createEarMembershipGroup(Composite parent) {
        GridData gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.setEarMembershipDescGroup(new Group(parent, 0));
        this.getEarMembershipDescGroup().setLayout((Layout)new GridLayout());
        this.getEarMembershipDescGroup().setLayoutData((Object)gd);
        this.getEarMembershipDescGroup().setText(CommonEditResourceHandler.ADD_TO_EAR_DESC_LABEL);
        this.addProjectToEarButton = new Button((Composite)this.getEarMembershipDescGroup(), 32);
        GridData data1 = new GridData();
        data1.horizontalIndent = 10;
        this.addProjectToEarButton.setLayoutData((Object)data1);
        this.addProjectToEarButton.setText(CommonEditResourceHandler.EAR_MEMBERSHIP_LABEL);
    }

    private void createGenerateDeploymentDescriptorGroup(Composite parent) {
        GridData gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.setGenerateDeploymentDescGroup(new Group(parent, 0));
        this.getGenerateDeploymentDescGroup().setLayout((Layout)new GridLayout());
        this.getGenerateDeploymentDescGroup().setLayoutData((Object)gd);
        this.getGenerateDeploymentDescGroup().setText(CommonEditResourceHandler.GENERATE_DEPLOYMENT_DESC_LABEL);
        this.generateDDForEarButton = new Button((Composite)this.getGenerateDeploymentDescGroup(), 32);
        GridData data1 = new GridData();
        data1.horizontalIndent = 10;
        this.generateDDForEarButton.setLayoutData((Object)data1);
        this.generateDDForEarButton.setText(CommonEditResourceHandler.GENERATE_DEPLOYMENT_EAR_LABEL);
        this.generateDDForEJBButton = new Button((Composite)this.getGenerateDeploymentDescGroup(), 32);
        GridData data2 = new GridData();
        data2.horizontalIndent = 10;
        this.generateDDForEJBButton.setLayoutData((Object)data2);
        this.generateDDForEJBButton.setText(CommonEditResourceHandler.GENERATE_DEPLOYMENT_EJB_LABEL);
        this.generateDDForWeb25Button = new Button((Composite)this.getGenerateDeploymentDescGroup(), 32);
        GridData data3 = new GridData();
        data3.horizontalIndent = 10;
        this.generateDDForWeb25Button.setLayoutData((Object)data3);
        this.generateDDForWeb25Button.setText(CommonEditResourceHandler.GENERATE_DEPLOYMENT_WEB25_LABEL);
        this.generateDDForWeb30Button = new Button((Composite)this.getGenerateDeploymentDescGroup(), 32);
        GridData data4 = new GridData();
        data4.horizontalIndent = 10;
        this.generateDDForWeb30Button.setLayoutData((Object)data4);
        this.generateDDForWeb30Button.setText(CommonEditResourceHandler.GENERATE_DEPLOYMENT_WEB30_LABEL);
        this.generateDDForAppClientButton = new Button((Composite)this.getGenerateDeploymentDescGroup(), 32);
        GridData data5 = new GridData();
        data5.horizontalIndent = 10;
        this.generateDDForAppClientButton.setLayoutData((Object)data5);
        this.generateDDForAppClientButton.setText(CommonEditResourceHandler.GENERATE_DEPLOYMENT_APP_CLIENT_LABEL);
        this.generateDDForConnectorButton = new Button((Composite)this.getGenerateDeploymentDescGroup(), 32);
        GridData data6 = new GridData();
        data6.horizontalIndent = 10;
        this.generateDDForConnectorButton.setLayoutData((Object)data6);
        this.generateDDForConnectorButton.setText(CommonEditResourceHandler.GENERATE_DEPLOYMENT_CONNECTOR_LABEL);
    }

    public void setGenerateDeploymentDescGroup(Group generateDeploymentDescGroup) {
        this.generateDeploymentDescGroup = generateDeploymentDescGroup;
    }

    private void createSpacer(Composite parent) {
        Label space = new Label(parent, 0);
        GridData data = new GridData(768);
        space.setLayoutData((Object)data);
    }

    public boolean performOk() {
        J2EEPreferences preferences = J2EEPlugin.getDefault().getJ2EEPreferences();
        preferences.setValue("addToEarByDefault", this.addProjectToEarButton.getSelection());
        preferences.setValue("earContent", this.earContentText.getText());
        preferences.setValue("webContent", this.dynWebContentText.getText());
        preferences.setValue("ejbContent", this.ejbContentText.getText());
        preferences.setValue("jcaContent", this.connectorText.getText());
        preferences.setValue("appClientContent", this.appClientText.getText());
        preferences.setValue("application_generate_dd", this.generateDDForEarButton.getSelection());
        preferences.setValue("ejb_generate_dd", this.generateDDForEJBButton.getSelection());
        preferences.setValue("dynamic_web_generate_dd", this.generateDDForWeb25Button.getSelection());
        preferences.setValue("ee6_dynamic_web_generate_dd", this.generateDDForWeb30Button.getSelection());
        preferences.setValue("app_client_generate_dd", this.generateDDForAppClientButton.getSelection());
        preferences.setValue("ee6_connector_generate_dd", this.generateDDForConnectorButton.getSelection());
        preferences.setValue("ee7_connector_generate_dd", this.generateDDForConnectorButton.getSelection());
        preferences.setValue("ejbOutput", this.ejbOutputText.getText());
        preferences.setValue("dynWebSource", this.dynWebSourceText.getText());
        preferences.setValue("dynWebOutput", this.dynWebOutputText.getText());
        preferences.setValue("appClientOutput", this.appClientOutputText.getText());
        preferences.setValue("jcaOutput", this.jcaOutputText.getText());
        preferences.setPersistOnChange(true);
        preferences.persist();
        FacetCorePlugin.getDefault().getPluginPreferences().setValue("defaultSource", this.utilitySourceText.getText());
        FacetCorePlugin.getDefault().getPluginPreferences().setValue("outputFolder", this.utilityOutputText.getText());
        FacetCorePlugin.getDefault().savePluginPreferences();
        return super.performOk();
    }

    public boolean performCancel() {
        if (!this.earContentText.getText().equals(this.earContent)) {
            this.preferences.setValue("earContent", this.earContent);
        }
        return super.performCancel();
    }

    public Button getAddProjectToEarButton() {
        return this.addProjectToEarButton;
    }

    public void setAddProjectToEarButton(Button addProjectToEarButton) {
        this.addProjectToEarButton = addProjectToEarButton;
    }

    public Text getEarContentText() {
        return this.earContentText;
    }

    public void setEarContentText(Text earContentText) {
        this.earContentText = earContentText;
    }

    public Text getEjbContentText() {
        return this.ejbContentText;
    }

    public void setEjbContentText(Text ejbContentText) {
        this.ejbContentText = ejbContentText;
    }

    public Text getDynWebContentText() {
        return this.dynWebContentText;
    }

    public void setDynWebContentText(Text dynWebContentText) {
        this.dynWebContentText = dynWebContentText;
    }

    public Text getConnectorText() {
        return this.connectorText;
    }

    public void setConnectorText(Text connectorText) {
        this.connectorText = connectorText;
    }

    public Text getAppClientText() {
        return this.appClientText;
    }

    public void setAppClientText(Text appClientText) {
        this.appClientText = appClientText;
    }

    public Text getUtilitySourceText() {
        return this.utilitySourceText;
    }

    public void setUtilitySourceText(Text utilitySourceText) {
        this.utilitySourceText = utilitySourceText;
    }

    public Text getDynWebSourceText() {
        return this.dynWebSourceText;
    }

    public void setDynWebSourceText(Text dynWebSourceText) {
        this.dynWebSourceText = dynWebSourceText;
    }

    public Text getDynWebOutputText() {
        return this.dynWebOutputText;
    }

    public void setDynWebOutputText(Text dynWebOutputText) {
        this.dynWebOutputText = dynWebOutputText;
    }

    public Text getEjbOutputText() {
        return this.ejbOutputText;
    }

    public void setEjbOutputText(Text ejbOutputText) {
        this.ejbOutputText = ejbOutputText;
    }

    public Text getAppClientOutputText() {
        return this.appClientOutputText;
    }

    public void setAppClientOutputText(Text appClientOutputText) {
        this.appClientOutputText = appClientOutputText;
    }

    public Text getJcaOutputText() {
        return this.jcaOutputText;
    }

    public void setJcaOutputText(Text jcaOutputText) {
        this.jcaOutputText = jcaOutputText;
    }

    public Text getUtilityOutputText() {
        return this.utilityOutputText;
    }

    public void setUtilityOutputText(Text utilityOutputText) {
        this.utilityOutputText = utilityOutputText;
    }

    protected void performDefaults() {
        this.initializeValues(true);
        super.performDefaults();
    }

    private void initializeValues(boolean isDefault) {
        J2EEPreferences preferences = J2EEPlugin.getDefault().getJ2EEPreferences();
        if (isDefault) {
            this.addProjectToEarButton.setSelection(preferences.getDefaultBoolean("addToEarByDefault"));
            this.earContentText.setText(preferences.getDefaultString("earContent"));
            this.ejbContentText.setText(preferences.getDefaultString("ejbContent"));
            this.dynWebContentText.setText(preferences.getDefaultString("webContent"));
            this.connectorText.setText(preferences.getDefaultString("jcaContent"));
            this.appClientText.setText(preferences.getDefaultString("appClientContent"));
            this.ejbOutputText.setText(preferences.getDefaultString("ejbOutput"));
            this.dynWebSourceText.setText(preferences.getDefaultString("dynWebSource"));
            this.dynWebOutputText.setText(preferences.getDefaultString("dynWebOutput"));
            this.jcaOutputText.setText(preferences.getDefaultString("jcaContent"));
            this.appClientOutputText.setText(preferences.getDefaultString("appClientOutput"));
            this.utilityOutputText.setText(J2EEPlugin.getDefault().getJ2EEPreferences().getDefaultOutputFolderName());
            this.utilitySourceText.setText(this.getDefaultJavaSrcFolder());
            this.generateDDForEarButton.setSelection(preferences.getDefaultBoolean("application_generate_dd"));
            this.generateDDForEJBButton.setSelection(preferences.getDefaultBoolean("ejb_generate_dd"));
            this.generateDDForWeb25Button.setSelection(preferences.getDefaultBoolean("dynamic_web_generate_dd"));
            this.generateDDForWeb30Button.setSelection(preferences.getDefaultBoolean("ee6_dynamic_web_generate_dd"));
            this.generateDDForAppClientButton.setSelection(preferences.getDefaultBoolean("app_client_generate_dd"));
            this.generateDDForConnectorButton.setSelection(preferences.getDefaultBoolean("ee6_connector_generate_dd"));
        } else {
            this.initializing = true;
            this.addProjectToEarButton.setSelection(preferences.getBoolean("addToEarByDefault"));
            this.earContentText.setText(preferences.getString("earContent"));
            this.ejbContentText.setText(preferences.getString("ejbContent"));
            this.dynWebContentText.setText(preferences.getString("webContent"));
            this.connectorText.setText(preferences.getString("jcaContent"));
            this.appClientText.setText(preferences.getString("appClientContent"));
            this.utilitySourceText.setText(FacetCorePlugin.getJavaSrcFolder());
            this.ejbOutputText.setText(preferences.getString("ejbOutput"));
            this.dynWebSourceText.setText(preferences.getString("dynWebSource"));
            this.dynWebOutputText.setText(preferences.getString("dynWebOutput"));
            this.jcaOutputText.setText(preferences.getString("jcaOutput"));
            this.appClientOutputText.setText(preferences.getString("appClientOutput"));
            this.utilityOutputText.setText(preferences.getUtilityOutputFolderName());
            this.generateDDForEarButton.setSelection(preferences.getBoolean("application_generate_dd"));
            this.generateDDForEJBButton.setSelection(preferences.getBoolean("ejb_generate_dd"));
            this.generateDDForWeb25Button.setSelection(preferences.getBoolean("dynamic_web_generate_dd"));
            this.generateDDForWeb30Button.setSelection(preferences.getBoolean("ee6_dynamic_web_generate_dd"));
            this.generateDDForAppClientButton.setSelection(preferences.getBoolean("app_client_generate_dd"));
            this.generateDDForConnectorButton.setSelection(preferences.getBoolean("ee6_connector_generate_dd"));
            this.initializing = false;
        }
    }

    public String getDefaultJavaSrcFolder() {
        String srcFolder = FacetCorePlugin.getDefault().getPluginPreferences().getDefaultString("defaultSource");
        if (srcFolder == null || srcFolder.equals("")) {
            if (Platform.getProduct() != null && ((srcFolder = Platform.getProduct().getProperty(PROD_PROP_SOURCE_FOLDER)) == null || srcFolder.equals(""))) {
                srcFolder = Platform.getProduct().getProperty("defaultSource");
            }
            if (srcFolder == null || srcFolder.equals("")) {
                srcFolder = "src/main/java";
            }
        }
        return srcFolder;
    }

    public Group getGenerateDeploymentDescGroup() {
        return this.generateDeploymentDescGroup;
    }

    public Group getEarMembershipDescGroup() {
        return this.earMembershipDescGroup;
    }

    public void setEarMembershipDescGroup(Group earMembershipDescGroup) {
        this.earMembershipDescGroup = earMembershipDescGroup;
    }

    public void dispose() {
        this.validMap.clear();
        this.validMap = null;
    }

    private void createEARPreferenceSection(Composite parent) {
        GridData gd = new GridData(768);
        gd.horizontalSpan = 2;
        Group group = new Group(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        group.setLayout((Layout)layout);
        group.setLayoutData((Object)gd);
        group.setText(CommonEditResourceHandler.EAR_CONTENT_LABEL);
        Label earLabel = new Label((Composite)group, 0);
        this.setUIAttributesToContentLabel(earLabel);
        this.earContentText = new Text((Composite)group, 2048);
        this.setUIAttributesToText(this.earContentText);
        this.earContentDecoration = new ControlDecoration((Control)this.earContentText, 16512);
        this.earContentText.addListener(24, new Listener(){

            public void handleEvent(Event event) {
                String folderName = ((Text)event.widget).getText();
                if (!folderName.isEmpty()) {
                    MessageTuple msg = J2EEProjectStructurePreferencePage.this.validateFolderName(folderName);
                    J2EEProjectStructurePreferencePage.this.updateHoverStatus(msg, J2EEProjectStructurePreferencePage.this.earContentDecoration);
                    if (msg == null) {
                        msg = J2EEProjectStructurePreferencePage.this.validateFolderForCharacters(folderName);
                        J2EEProjectStructurePreferencePage.this.updateHoverStatus(msg, J2EEProjectStructurePreferencePage.this.earContentDecoration);
                        J2EEProjectStructurePreferencePage.this.preferences.setValue("earContent", folderName);
                    }
                } else {
                    J2EEProjectStructurePreferencePage.this.updateHoverStatus(null, J2EEProjectStructurePreferencePage.this.earContentDecoration);
                }
            }
        });
    }

    private void createDynWebPreferenceSection(Composite parent) {
        GridData gd = new GridData(768);
        gd.horizontalSpan = 2;
        Group group = new Group(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        group.setLayout((Layout)layout);
        group.setLayoutData((Object)gd);
        group.setText(CommonEditResourceHandler.DYNAMIC_WEB_CONTENT_LABEL);
        Label sourceLabel = new Label((Composite)group, 0);
        this.setUIAttributesToJavaSourceLabel(sourceLabel);
        this.dynWebSourceText = new Text((Composite)group, 2048);
        this.setUIAttributesToText(this.dynWebSourceText);
        this.webSrcDecoration = new ControlDecoration((Control)this.dynWebSourceText, 16512);
        this.dynWebSourceText.addListener(24, new Listener(){

            public void handleEvent(Event event) {
                String folderName = ((Text)event.widget).getText();
                MessageTuple msg = J2EEProjectStructurePreferencePage.this.validateFolder(folderName);
                J2EEProjectStructurePreferencePage.this.updateHoverStatus(msg, J2EEProjectStructurePreferencePage.this.webSrcDecoration);
                if (msg == null) {
                    msg = J2EEProjectStructurePreferencePage.this.validateSourceAndOutputFolderCase(J2EEProjectStructurePreferencePage.this.dynWebSourceText.getText(), folderName);
                    J2EEProjectStructurePreferencePage.this.updateHoverStatus(msg, J2EEProjectStructurePreferencePage.this.webSrcDecoration);
                }
                if (msg == null) {
                    msg = J2EEProjectStructurePreferencePage.this.validateWebContentAndSourceUnique(folderName, J2EEProjectStructurePreferencePage.this.dynWebContentText.getText());
                    J2EEProjectStructurePreferencePage.this.updateHoverStatus(msg, J2EEProjectStructurePreferencePage.this.webSrcDecoration);
                }
            }
        });
        Label outputLabel = new Label((Composite)group, 0);
        this.setUIAttributesToJavaOutputLabel(outputLabel);
        this.dynWebOutputText = new Text((Composite)group, 2048);
        this.setUIAttributesToText(this.dynWebOutputText);
        this.webOuputDecoration = new ControlDecoration((Control)this.dynWebOutputText, 16512);
        this.dynWebOutputText.addListener(24, new Listener(){

            public void handleEvent(Event event) {
                String folderName = ((Text)event.widget).getText();
                MessageTuple msg = J2EEProjectStructurePreferencePage.this.validateFolder(folderName);
                J2EEProjectStructurePreferencePage.this.updateHoverStatus(msg, J2EEProjectStructurePreferencePage.this.webOuputDecoration);
                if (msg == null) {
                    msg = J2EEProjectStructurePreferencePage.this.validateSourceAndOutputFolderCase(J2EEProjectStructurePreferencePage.this.dynWebSourceText.getText(), folderName);
                    J2EEProjectStructurePreferencePage.this.updateHoverStatus(msg, J2EEProjectStructurePreferencePage.this.webSrcDecoration);
                }
                if (msg == null) {
                    msg = J2EEProjectStructurePreferencePage.this.validateWebConfigAndOutputFolder(J2EEProjectStructurePreferencePage.this.dynWebContentText.getText(), folderName);
                    J2EEProjectStructurePreferencePage.this.updateHoverStatus(msg, J2EEProjectStructurePreferencePage.this.webOuputDecoration);
                }
            }
        });
        Label dynWebLabel = new Label((Composite)group, 0);
        this.setUIAttributesToContentLabel(dynWebLabel);
        this.dynWebContentText = new Text((Composite)group, 2048);
        this.setUIAttributesToText(this.dynWebContentText);
        this.webContentDecoration = new ControlDecoration((Control)this.dynWebContentText, 16512);
        this.dynWebContentText.addListener(24, new Listener(){

            public void handleEvent(Event event) {
                String folderName = ((Text)event.widget).getText();
                MessageTuple msg = J2EEProjectStructurePreferencePage.this.validateFolder(folderName);
                J2EEProjectStructurePreferencePage.this.updateHoverStatus(msg, J2EEProjectStructurePreferencePage.this.webContentDecoration);
                if (msg == null) {
                    msg = J2EEProjectStructurePreferencePage.this.validateWebContentAndSourceUnique(J2EEProjectStructurePreferencePage.this.dynWebSourceText.getText(), folderName);
                    J2EEProjectStructurePreferencePage.this.updateHoverStatus(msg, J2EEProjectStructurePreferencePage.this.webContentDecoration);
                }
                if (msg == null) {
                    msg = J2EEProjectStructurePreferencePage.this.validateWebConfigAndOutputFolder(folderName, J2EEProjectStructurePreferencePage.this.dynWebOutputText.getText());
                    J2EEProjectStructurePreferencePage.this.updateHoverStatus(msg, J2EEProjectStructurePreferencePage.this.webOuputDecoration);
                }
            }
        });
    }

    private void createEJBPreferenceSection(Composite parent) {
        GridData gd = new GridData(768);
        gd.horizontalSpan = 2;
        Group group = new Group(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        group.setLayout((Layout)layout);
        group.setLayoutData((Object)gd);
        group.setText(CommonEditResourceHandler.EJB_CONTENT_LABEL);
        Label sourceLabel = new Label((Composite)group, 0);
        this.setUIAttributesToJavaSourceLabel(sourceLabel);
        this.ejbContentText = new Text((Composite)group, 2048);
        this.setUIAttributesToText(this.ejbContentText);
        this.ejbSrcDecoration = new ControlDecoration((Control)this.ejbContentText, 16512);
        this.ejbContentText.addListener(24, new Listener(){

            public void handleEvent(Event event) {
                String folderName = ((Text)event.widget).getText();
                MessageTuple msg = J2EEProjectStructurePreferencePage.this.validateFolder(folderName);
                J2EEProjectStructurePreferencePage.this.updateHoverStatus(msg, J2EEProjectStructurePreferencePage.this.ejbSrcDecoration);
                if (msg == null) {
                    msg = J2EEProjectStructurePreferencePage.this.validateSourceAndOutputFolderCase(folderName, J2EEProjectStructurePreferencePage.this.ejbOutputText.getText());
                    J2EEProjectStructurePreferencePage.this.updateHoverStatus(msg, J2EEProjectStructurePreferencePage.this.ejbSrcDecoration);
                }
            }
        });
        Label outputLabel = new Label((Composite)group, 0);
        this.setUIAttributesToJavaOutputLabel(outputLabel);
        this.ejbOutputText = new Text((Composite)group, 2048);
        this.setUIAttributesToText(this.ejbOutputText);
        this.ejbOuputDecoration = new ControlDecoration((Control)this.ejbOutputText, 16512);
        this.ejbOutputText.addListener(24, new Listener(){

            public void handleEvent(Event event) {
                String folderName = ((Text)event.widget).getText();
                MessageTuple msg = J2EEProjectStructurePreferencePage.this.validateFolder(folderName);
                J2EEProjectStructurePreferencePage.this.updateHoverStatus(msg, J2EEProjectStructurePreferencePage.this.ejbOuputDecoration);
                if (msg == null) {
                    msg = J2EEProjectStructurePreferencePage.this.validateSourceAndOutputFolderCase(J2EEProjectStructurePreferencePage.this.ejbContentText.getText(), folderName);
                    J2EEProjectStructurePreferencePage.this.updateHoverStatus(msg, J2EEProjectStructurePreferencePage.this.ejbSrcDecoration);
                }
            }
        });
    }

    private void createAppClientPreferenceSection(Composite parent) {
        GridData gd = new GridData(768);
        gd.horizontalSpan = 2;
        Group group = new Group(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        group.setLayout((Layout)layout);
        group.setLayoutData((Object)gd);
        group.setText(CommonEditResourceHandler.APPCLIENT_CONTENT_LABEL);
        Label sourceLabel = new Label((Composite)group, 0);
        this.setUIAttributesToJavaSourceLabel(sourceLabel);
        this.appClientText = new Text((Composite)group, 2048);
        this.setUIAttributesToText(this.appClientText);
        this.appClientSrcDecoration = new ControlDecoration((Control)this.appClientText, 16512);
        this.appClientText.addListener(24, new Listener(){

            public void handleEvent(Event event) {
                String folderName = ((Text)event.widget).getText();
                MessageTuple msg = J2EEProjectStructurePreferencePage.this.validateFolder(folderName);
                J2EEProjectStructurePreferencePage.this.updateHoverStatus(msg, J2EEProjectStructurePreferencePage.this.appClientSrcDecoration);
                if (msg == null) {
                    msg = J2EEProjectStructurePreferencePage.this.validateSourceAndOutputFolderCase(folderName, J2EEProjectStructurePreferencePage.this.appClientOutputText.getText());
                    J2EEProjectStructurePreferencePage.this.updateHoverStatus(msg, J2EEProjectStructurePreferencePage.this.appClientSrcDecoration);
                }
            }
        });
        Label outputLabel = new Label((Composite)group, 0);
        this.setUIAttributesToJavaOutputLabel(outputLabel);
        this.appClientOutputText = new Text((Composite)group, 2048);
        this.setUIAttributesToText(this.appClientOutputText);
        this.appClientOuputDecoration = new ControlDecoration((Control)this.appClientOutputText, 16512);
        this.appClientOutputText.addListener(24, new Listener(){

            public void handleEvent(Event event) {
                String folderName = ((Text)event.widget).getText();
                MessageTuple msg = J2EEProjectStructurePreferencePage.this.validateFolder(folderName);
                J2EEProjectStructurePreferencePage.this.updateHoverStatus(msg, J2EEProjectStructurePreferencePage.this.appClientOuputDecoration);
                if (msg == null) {
                    msg = J2EEProjectStructurePreferencePage.this.validateSourceAndOutputFolderCase(J2EEProjectStructurePreferencePage.this.appClientText.getText(), folderName);
                    J2EEProjectStructurePreferencePage.this.updateHoverStatus(msg, J2EEProjectStructurePreferencePage.this.appClientSrcDecoration);
                }
            }
        });
    }

    private void createJCAPreferenceSection(Composite parent) {
        GridData gd = new GridData(768);
        gd.horizontalSpan = 2;
        Group group = new Group(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        group.setLayout((Layout)layout);
        group.setLayoutData((Object)gd);
        group.setText(CommonEditResourceHandler.CONNECTOR_CONTENT_LABEL);
        Label sourceLabel = new Label((Composite)group, 0);
        this.setUIAttributesToJavaSourceLabel(sourceLabel);
        this.connectorText = new Text((Composite)group, 2048);
        this.setUIAttributesToText(this.connectorText);
        this.jcaSrcDecoration = new ControlDecoration((Control)this.connectorText, 16512);
        this.connectorText.addListener(24, new Listener(){

            public void handleEvent(Event event) {
                String folderName = ((Text)event.widget).getText();
                MessageTuple msg = J2EEProjectStructurePreferencePage.this.validateFolder(folderName);
                J2EEProjectStructurePreferencePage.this.updateHoverStatus(msg, J2EEProjectStructurePreferencePage.this.jcaSrcDecoration);
                J2EEProjectStructurePreferencePage.this.updateHoverStatus(msg, J2EEProjectStructurePreferencePage.this.jcaSrcDecoration);
                if (msg == null) {
                    msg = J2EEProjectStructurePreferencePage.this.validateSourceAndOutputFolderCase(folderName, J2EEProjectStructurePreferencePage.this.jcaOutputText.getText());
                    J2EEProjectStructurePreferencePage.this.updateHoverStatus(msg, J2EEProjectStructurePreferencePage.this.jcaSrcDecoration);
                }
            }
        });
        Label outputLabel = new Label((Composite)group, 0);
        this.setUIAttributesToJavaOutputLabel(outputLabel);
        this.jcaOutputText = new Text((Composite)group, 2048);
        this.setUIAttributesToText(this.jcaOutputText);
        this.jcaOuputDecoration = new ControlDecoration((Control)this.jcaOutputText, 16512);
        this.jcaOutputText.addListener(24, new Listener(){

            public void handleEvent(Event event) {
                String folderName = ((Text)event.widget).getText();
                MessageTuple msg = J2EEProjectStructurePreferencePage.this.validateFolder(folderName);
                J2EEProjectStructurePreferencePage.this.updateHoverStatus(msg, J2EEProjectStructurePreferencePage.this.jcaOuputDecoration);
                if (msg == null) {
                    msg = J2EEProjectStructurePreferencePage.this.validateSourceAndOutputFolderCase(J2EEProjectStructurePreferencePage.this.connectorText.getText(), folderName);
                    J2EEProjectStructurePreferencePage.this.updateHoverStatus(msg, J2EEProjectStructurePreferencePage.this.jcaSrcDecoration);
                }
            }
        });
    }

    private void createUtilityPreferenceSection(Composite parent) {
        GridData gd = new GridData(768);
        gd.horizontalSpan = 2;
        Group group = new Group(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        group.setLayout((Layout)layout);
        group.setLayoutData((Object)gd);
        group.setText(CommonEditResourceHandler.UTILITY_CONTENT_LABEL);
        Label sourceLabel = new Label((Composite)group, 0);
        this.setUIAttributesToJavaSourceLabel(sourceLabel);
        this.utilitySourceText = new Text((Composite)group, 2048);
        this.setUIAttributesToText(this.utilitySourceText);
        this.utilitySrcDecoration = new ControlDecoration((Control)this.utilitySourceText, 16512);
        this.utilitySourceText.addListener(24, new Listener(){

            public void handleEvent(Event event) {
                String folderName = ((Text)event.widget).getText();
                MessageTuple msg = J2EEProjectStructurePreferencePage.this.validateFolder(folderName);
                J2EEProjectStructurePreferencePage.this.updateHoverStatus(msg, J2EEProjectStructurePreferencePage.this.utilitySrcDecoration);
                if (msg == null) {
                    msg = J2EEProjectStructurePreferencePage.this.validateSourceAndOutputFolderCase(folderName, J2EEProjectStructurePreferencePage.this.utilityOutputText.getText());
                    J2EEProjectStructurePreferencePage.this.updateHoverStatus(msg, J2EEProjectStructurePreferencePage.this.utilitySrcDecoration);
                }
            }
        });
        Label outputLabel = new Label((Composite)group, 0);
        this.setUIAttributesToJavaOutputLabel(outputLabel);
        this.utilityOutputText = new Text((Composite)group, 2048);
        this.setUIAttributesToText(this.utilityOutputText);
        this.utilityOuputDecoration = new ControlDecoration((Control)this.utilityOutputText, 16512);
        this.utilityOutputText.addListener(24, new Listener(){

            public void handleEvent(Event event) {
                String folderName = ((Text)event.widget).getText();
                MessageTuple msg = J2EEProjectStructurePreferencePage.this.validateFolder(folderName);
                J2EEProjectStructurePreferencePage.this.updateHoverStatus(msg, J2EEProjectStructurePreferencePage.this.utilityOuputDecoration);
                if (msg == null) {
                    msg = J2EEProjectStructurePreferencePage.this.validateSourceAndOutputFolderCase(J2EEProjectStructurePreferencePage.this.utilitySourceText.getText(), folderName);
                    J2EEProjectStructurePreferencePage.this.updateHoverStatus(msg, J2EEProjectStructurePreferencePage.this.utilitySrcDecoration);
                }
            }
        });
    }

    private void setUIAttributesToJavaSourceLabel(Label sourceLabel) {
        GridData data = new GridData();
        data.horizontalIndent = 10;
        sourceLabel.setLayoutData((Object)data);
        sourceLabel.setText(CommonEditResourceHandler.JAVA_CONTENT_DESC_LABEL);
    }

    private void setUIAttributesToText(Text text) {
        GridData data = new GridData(768);
        data.horizontalIndent = 10;
        text.setLayoutData((Object)data);
    }

    private void setUIAttributesToJavaOutputLabel(Label outputLabel) {
        GridData data = new GridData();
        data.horizontalIndent = 10;
        outputLabel.setLayoutData((Object)data);
        outputLabel.setText(CommonEditResourceHandler.JAVA_CONTENT_OUTPUT_LABEL);
    }

    private void setUIAttributesToContentLabel(Label label) {
        GridData data = new GridData();
        data.horizontalIndent = 10;
        label.setLayoutData((Object)data);
        label.setText(CommonEditResourceHandler.CONTENT_DIRECTORY__DESC_LABEL);
    }

    protected MessageTuple validateFolder(String folderName) {
        MessageTuple msg = this.validateFolderForEmptyValue(folderName);
        if (msg != null) {
            return msg;
        }
        msg = this.validateFolderName(folderName);
        if (msg != null) {
            return msg;
        }
        msg = this.validateFolderForCharacters(folderName);
        return msg;
    }

    protected MessageTuple validateFolderForEmptyValue(String folderName) {
        MessageTuple msg = null;
        if (folderName == null || folderName.trim().length() == 0) {
            return new MessageTuple(CommonEditResourceHandler.CONTENT_DIRECTORY_EMPTY, 3);
        }
        return msg;
    }

    private MessageTuple validateFolderName(String folderName) {
        MessageTuple msg = null;
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        Path path = new Path(folderName);
        int max = path.segmentCount();
        for (int i = 0; i < max; ++i) {
            IStatus status = workspace.validateName(path.segment(i), 2);
            if (status.isOK()) continue;
            return new MessageTuple(status.getMessage(), status.getSeverity());
        }
        return msg;
    }

    private MessageTuple validateFolderForCharacters(String folderName) {
        MessageTuple msg = null;
        if (folderName.indexOf(35) != -1) {
            String message = NLS.bind((String)Messages.resources_invalidCharInName, (Object)"#", (Object)folderName);
            return new MessageTuple(message, 3);
        }
        return msg;
    }

    private MessageTuple validateSourceAndOutputFolderCase(String sourceFolder, String outputFolder) {
        if (sourceFolder.equalsIgnoreCase(outputFolder) && !sourceFolder.equals(outputFolder)) {
            return new MessageTuple(ProjectSupportResourceHandler.SOURCE_OUPUT_FOLDER_DIFF_BYCASE_ONLY, 3);
        }
        return null;
    }

    private MessageTuple validateWebContentAndSourceUnique(String srcFolderName, String contentFolderName) {
        MessageTuple msg = null;
        if (contentFolderName.equals(srcFolderName)) {
            return new MessageTuple(CommonEditResourceHandler.DYNAMIC_WEBPROJECT_PREFERENCE_VALIDATION, 3);
        }
        return msg;
    }

    private MessageTuple validateWebConfigAndOutputFolder(String contentFolderName, String outputFolderName) {
        String expectedOutFolder = contentFolderName + "/WEB-INF/classes";
        if (!expectedOutFolder.equals(outputFolderName)) {
            return new MessageTuple(ProjectSupportResourceHandler.getString((String)ProjectSupportResourceHandler.DYNAMIC_WEB_PERFORMANCE_VALIDATION, (Object[])new Object[]{expectedOutFolder}), 2);
        }
        return null;
    }

    private void updateHoverStatus(MessageTuple msg, ControlDecoration decoration) {
        if (msg != null) {
            switch (msg.getSeverity()) {
                case 1: {
                    Image newImage = this.registry.getFieldDecoration("DEC_INFORMATION").getImage();
                    decoration.setDescriptionText(msg.getMessage());
                    decoration.setImage(newImage);
                    decoration.show();
                    break;
                }
                case 2: {
                    Image newImage = this.registry.getFieldDecoration("DEC_WARNING").getImage();
                    decoration.setDescriptionText(msg.getMessage());
                    decoration.setImage(newImage);
                    decoration.show();
                    break;
                }
                case 3: 
                case 4: {
                    Image newImage = this.registry.getFieldDecoration("DEC_ERROR").getImage();
                    decoration.setDescriptionText(msg.getMessage());
                    decoration.setImage(newImage);
                    decoration.show();
                    this.validMap.put(decoration, Boolean.FALSE);
                    this.setMessage(CommonEditResourceHandler.SEE_ERROR, 3);
                    this.setValid(false);
                    break;
                }
            }
        } else {
            decoration.setDescriptionText(null);
            decoration.hide();
            if (this.validMap.containsKey(decoration)) {
                this.validMap.remove(decoration);
            }
            for (ControlDecoration control : this.validMap.keySet()) {
                if (this.validMap.get(control).booleanValue()) continue;
                this.setValid(false);
                this.setMessage(CommonEditResourceHandler.SEE_ERROR, 3);
                return;
            }
            this.setMessage(null);
            this.setValid(true);
        }
    }

    public void setMavenPreferences() {
        this.addProjectToEarButton.setSelection(false);
        this.earContentText.setText(MavenDefaultSettings.MavenDefaultSettings0);
        this.ejbContentText.setText(MavenDefaultSettings.MavenDefaultSettings2);
        this.dynWebContentText.setText(MavenDefaultSettings.MavenDefaultSettings1);
        this.connectorText.setText(MavenDefaultSettings.MavenDefaultSettings2);
        this.appClientText.setText(MavenDefaultSettings.MavenDefaultSettings3);
        this.ejbOutputText.setText(MavenDefaultSettings.MavenDefaultSettings3);
        this.dynWebSourceText.setText(MavenDefaultSettings.MavenDefaultSettings2);
        this.dynWebOutputText.setText(MavenDefaultSettings.MavenDefaultSettings3);
        this.jcaOutputText.setText(MavenDefaultSettings.MavenDefaultSettings3);
        this.appClientOutputText.setText(MavenDefaultSettings.MavenDefaultSettings2);
        this.utilityOutputText.setText(MavenDefaultSettings.MavenDefaultSettings4);
        this.utilitySourceText.setText(MavenDefaultSettings.MavenDefaultSettings3);
        this.generateDDForEarButton.setSelection(false);
        this.generateDDForEJBButton.setSelection(false);
        this.generateDDForWeb25Button.setSelection(false);
        this.generateDDForWeb30Button.setSelection(false);
        this.generateDDForAppClientButton.setSelection(false);
        this.generateDDForConnectorButton.setSelection(false);
    }

    private class MessageTuple {
        private String message;
        private int severity;

        public MessageTuple(String message, int severity) {
            this.message = message;
            this.severity = severity;
        }

        public String getMessage() {
            return this.message;
        }

        public int getSeverity() {
            return this.severity;
        }
    }
}

