/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.j2ee.common.presentation.temp;

import com.ibm.etools.j2ee.J2EEProjectUtilities;
import com.ibm.etools.j2ee.common.nls.CommonEditResourceHandler;
import com.ibm.etools.j2ee.common.nls.ICommonConstants;
import com.ibm.etools.j2ee.common.presentation.temp.IJ2EEPreferenceConstants;
import com.ibm.etools.j2ee.common.presentation.temp.Messages;
import com.ibm.etools.j2ee.ui.plugin.J2EEUIPlugin;
import com.ibm.etools.j2ee.ui.plugin.J2EEUIPreferences;
import java.util.ArrayList;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jst.j2ee.internal.common.classpath.J2EEComponentClasspathUpdater;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;

public class J2EEPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage,
ICommonConstants,
IJ2EEPreferenceConstants {
    private static final int INDENT = 10;
    private Group headingDeployment;
    private Button incrementalDeployment;
    private Button useEARLibraries;
    private Button useEARLibrariesJDTExport;
    private Button useWebAppLibraries;
    private Combo duplicateManifestCombo;
    private Combo duplicateWebLibCombo;
    private Combo missingManifestCombo;
    private Combo missingWebLibCombo;
    private static final int ERROR = 0;
    private static final int WARNING = 1;
    private static final int IGNORE = 2;
    public Color DESC_COLOR = new Color(null, 0, 0, 0);

    public void init(IWorkbench workbench) {
    }

    protected Control createContents(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(272));
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, "com.ibm.etools.j2ee.ui.J2EE_PREFERENCE_PAGE");
        this.createDeploymentGroup(composite);
        this.createLibrariesGroup(composite);
        this.createClasspathGroup(composite);
        this.initializeValues();
        return composite;
    }

    private void createLibrariesGroup(Composite parent) {
        GridData gd = new GridData(768);
        gd.horizontalSpan = 2;
        Group group = new Group(parent, 0);
        group.setForeground(this.DESC_COLOR);
        group.setLayout((Layout)new GridLayout());
        group.setLayoutData((Object)gd);
        group.setText(Messages.J2EEPreferencePage_0);
        this.useEARLibraries = new Button((Composite)group, 32);
        GridData data1 = new GridData();
        data1.horizontalIndent = 10;
        this.useEARLibraries.setLayoutData((Object)data1);
        this.useEARLibraries.setText(Messages.J2EEPreferencePage_1);
        this.useEARLibrariesJDTExport = new Button((Composite)group, 32);
        GridData data2 = new GridData();
        data2.horizontalIndent = 30;
        this.useEARLibrariesJDTExport.setLayoutData((Object)data2);
        this.useEARLibrariesJDTExport.setText(Messages.J2EEPreferencePage_11);
        this.useWebAppLibraries = new Button((Composite)group, 32);
        GridData data3 = new GridData();
        data3.horizontalIndent = 10;
        this.useWebAppLibraries.setLayoutData((Object)data3);
        this.useWebAppLibraries.setText(Messages.J2EEPreferencePage_2);
    }

    private void createClasspathGroup(Composite parent) {
        GridData gd0 = new GridData(768);
        gd0.horizontalSpan = 2;
        Group group = new Group(parent, 0);
        group.setForeground(this.DESC_COLOR);
        group.setLayout((Layout)new GridLayout(2, false));
        group.setLayoutData((Object)gd0);
        group.setText(Messages.J2EEPreferencePage_3);
        String[] items = new String[]{Messages.J2EEPreferencePage_4, Messages.J2EEPreferencePage_5, Messages.J2EEPreferencePage_6};
        Label label1 = new Label((Composite)group, 0);
        label1.setText(Messages.J2EEPreferencePage_7);
        GridData gd1 = new GridData(512);
        gd1.horizontalIndent = 10;
        label1.setLayoutData((Object)gd1);
        this.duplicateManifestCombo = new Combo((Composite)group, 8);
        this.duplicateManifestCombo.setItems(items);
        GridData gd2 = new GridData(128);
        this.duplicateManifestCombo.setLayoutData((Object)gd2);
        Label label2 = new Label((Composite)group, 0);
        label2.setText(Messages.J2EEPreferencePage_8);
        GridData gd3 = new GridData(512);
        gd3.horizontalIndent = 10;
        label2.setLayoutData((Object)gd3);
        this.duplicateWebLibCombo = new Combo((Composite)group, 8);
        this.duplicateWebLibCombo.setItems(items);
        GridData gd4 = new GridData(128);
        this.duplicateWebLibCombo.setLayoutData((Object)gd4);
        Label label3 = new Label((Composite)group, 0);
        label3.setText(Messages.J2EEPreferencePage_9);
        GridData gd5 = new GridData(512);
        gd5.horizontalIndent = 10;
        label3.setLayoutData((Object)gd5);
        this.missingManifestCombo = new Combo((Composite)group, 8);
        this.missingManifestCombo.setItems(items);
        GridData gd6 = new GridData(128);
        this.missingManifestCombo.setLayoutData((Object)gd6);
        Label label4 = new Label((Composite)group, 0);
        label4.setText(Messages.J2EEPreferencePage_10);
        GridData gd7 = new GridData(512);
        gd7.horizontalIndent = 10;
        label4.setLayoutData((Object)gd7);
        this.missingWebLibCombo = new Combo((Composite)group, 8);
        this.missingWebLibCombo.setItems(items);
        GridData gd8 = new GridData(128);
        this.missingWebLibCombo.setLayoutData((Object)gd8);
    }

    private void createDeploymentGroup(Composite parent) {
        GridData gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.setHeadingDeployment(new Group(parent, 0));
        this.getHeadingDeployment().setForeground(this.DESC_COLOR);
        this.getHeadingDeployment().setLayout((Layout)new GridLayout());
        this.getHeadingDeployment().setLayoutData((Object)gd);
        this.getHeadingDeployment().setText(CommonEditResourceHandler.GROUP_DEPLOYMENT_LABEL);
        this.setIncrementalDeployment(new Button((Composite)this.getHeadingDeployment(), 32));
        GridData data1 = new GridData();
        data1.horizontalIndent = 10;
        this.getIncrementalDeployment().setLayoutData((Object)data1);
        this.getIncrementalDeployment().setText(CommonEditResourceHandler.INCREMENTAL_DEPLOYMENT_LABEL);
    }

    public boolean performOk() {
        J2EEUIPreferences preferences = J2EEUIPlugin.getDefault().getJ2EEUIPreferences();
        preferences.setIncrementalDeploymentEnabled(this.getIncrementalDeployment().getSelection());
        boolean classpathChanged = false;
        if (preferences.getUseEARLibraries() != this.useEARLibraries.getSelection()) {
            classpathChanged = true;
            preferences.setUseEARLibraries(this.useEARLibraries.getSelection());
        }
        if (preferences.getUseEARLibrariesJDTExport() != this.useEARLibrariesJDTExport.getSelection()) {
            classpathChanged = true;
            preferences.setUseEARLibrariesJDTExport(this.useEARLibrariesJDTExport.getSelection());
        }
        if (preferences.getUseWebLibaries() != this.useWebAppLibraries.getSelection()) {
            classpathChanged = true;
            preferences.setUseWebLibraries(this.useWebAppLibraries.getSelection());
        }
        this.storeCompilerCombo(this.duplicateManifestCombo, preferences);
        this.storeCompilerCombo(this.duplicateWebLibCombo, preferences);
        this.storeCompilerCombo(this.missingManifestCombo, preferences);
        this.storeCompilerCombo(this.missingWebLibCombo, preferences);
        preferences.setPersistOnChange(true);
        preferences.persist();
        if (classpathChanged) {
            IProject[] allProjectsArray = J2EEProjectUtilities.getAllProjects();
            ArrayList<IProject> allProjects = new ArrayList<IProject>();
            for (int i = 0; i < allProjectsArray.length; ++i) {
                allProjects.add(allProjectsArray[i]);
            }
            J2EEComponentClasspathUpdater.getInstance().forceUpdate(allProjects);
        }
        return super.performOk();
    }

    private void initializeValues() {
        J2EEUIPreferences preferences = J2EEUIPlugin.getDefault().getJ2EEUIPreferences();
        this.getIncrementalDeployment().setSelection(preferences.isIncrementalDeploymentEnabled());
        this.useEARLibraries.setSelection(preferences.getUseEARLibraries());
        this.useEARLibrariesJDTExport.setSelection(preferences.getUseEARLibrariesJDTExport());
        this.useWebAppLibraries.setSelection(preferences.getUseWebLibaries());
        this.initCompilerCombo(this.duplicateManifestCombo);
        this.initCompilerCombo(this.duplicateWebLibCombo);
        this.initCompilerCombo(this.missingManifestCombo);
        this.initCompilerCombo(this.missingWebLibCombo);
    }

    private String getCompilerPropertyName(Combo combo) {
        if (combo == this.duplicateManifestCombo) {
            return "com.ibm.etools.j2ee.preferences.duplicateManifestClasspath";
        }
        if (combo == this.duplicateWebLibCombo) {
            return "com.ibm.etools.j2ee.preferences.duplicateWebLibClasspath";
        }
        if (combo == this.missingManifestCombo) {
            return "com.ibm.etools.j2ee.preferences.missingManifestClasspath";
        }
        if (combo == this.missingWebLibCombo) {
            return "com.ibm.etools.j2ee.preferences.missingWebLibClasspath";
        }
        return null;
    }

    private void storeCompilerCombo(Combo combo, J2EEUIPreferences preferences) {
        String propertyName = this.getCompilerPropertyName(combo);
        String propertyValue = null;
        int selectedIndex = combo.getSelectionIndex();
        switch (selectedIndex) {
            case 0: {
                propertyValue = "error";
                break;
            }
            case 1: {
                propertyValue = "warning";
                break;
            }
            case 2: {
                propertyValue = "ignore";
                break;
            }
            default: {
                propertyValue = "warning";
            }
        }
        preferences.setSetting(propertyName, propertyValue);
    }

    private void initCompilerCombo(Combo combo) {
        String propertyName = this.getCompilerPropertyName(combo);
        combo.select(J2EEPreferencePage.getSeverityForCompilerSetting(propertyName));
    }

    private static int getSeverityForCompilerSetting(String propertyName) {
        J2EEUIPreferences preferences = J2EEUIPlugin.getDefault().getJ2EEUIPreferences();
        String propertyValue = preferences.getSetting(propertyName);
        if (propertyValue.equals("error")) {
            return 0;
        }
        if (propertyValue.equals("warning")) {
            return 1;
        }
        if (propertyValue.equals("ignore")) {
            return 2;
        }
        return 1;
    }

    public Group getHeadingDeployment() {
        return this.headingDeployment;
    }

    public void setHeadingDeployment(Group headingDeployment) {
        this.headingDeployment = headingDeployment;
    }

    public Button getIncrementalDeployment() {
        return this.incrementalDeployment;
    }

    public void setIncrementalDeployment(Button incrementalDeployment) {
        this.incrementalDeployment = incrementalDeployment;
    }

    public void setTitle(String title) {
        super.setTitle(Messages.J2EEPreferencePage_12);
    }

    public void dispose() {
        this.DESC_COLOR.dispose();
    }
}

