/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.j2ee.common.dialogs;

import com.ibm.etools.emf.workbench.ui.nls.EMFWorkbenchUIResourceHandler;
import java.util.Vector;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.SelectionDialog;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class ProjectSelectionDialog
extends SelectionDialog {
    protected TableViewer projectList;
    protected Label statusMessage;
    protected Vector projects;
    protected String[] includeNatureIds = new String[0];
    protected String[] excludeNatureIds = new String[0];
    boolean showClosedProjects = false;
    boolean isSingleSelect = true;
    protected String noProjectsAvailableText = EMFWorkbenchUIResourceHandler.There_are_no_projects_available_that_match_the_selection_criteria__1;
    protected String[] helpText = new String[0];

    public ProjectSelectionDialog(Shell parentShell) {
        super(parentShell);
    }

    protected Control createDialogArea(Composite parent) {
        if (this.getMessage() != null) {
            this.createMessageBox(parent);
        }
        Composite dialogArea = (Composite)super.createDialogArea(parent);
        this.createTableControl(dialogArea);
        if (this.helpText.length > 0) {
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, this.helpText[0]);
        }
        return dialogArea;
    }

    protected Composite createMessageBox(Composite parent) {
        Composite comp = new Composite(parent, 0);
        comp.setBackground(new Color(null, 255, 255, 255));
        comp.setLayout((Layout)new GridLayout());
        comp.setLayoutData((Object)new GridData(768));
        Label message = new Label(comp, 1);
        message.setBackground(new Color(null, 255, 255, 255));
        message.setFont(parent.getFont());
        message.setText(this.getMessage());
        return comp;
    }

    protected Vector calculateProjects() {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IProject[] projects = root.getProjects();
        Vector<IProject> results = new Vector<IProject>();
        for (int i = 0; i < projects.length; ++i) {
            IProject iProject = projects[i];
            if (!this.includeProject(iProject) || iProject.isOpen() != !this.showClosedProjects) continue;
            results.add(iProject);
        }
        return results;
    }

    protected boolean includeProject(IProject project) {
        return this.hasIncludeNatures(project) && !this.hasExcludeNatures(project);
    }

    protected boolean hasIncludeNatures(IProject project) {
        return this.hasNatureIds(project, this.includeNatureIds);
    }

    protected boolean hasExcludeNatures(IProject project) {
        if (this.excludeNatureIds.length > 0) {
            return this.hasNatureIds(project, this.excludeNatureIds);
        }
        return false;
    }

    protected boolean hasNatureIds(IProject project, String[] natureIds) {
        boolean hasOneNature = false;
        for (int i = 0; i < natureIds.length; ++i) {
            String natureId = natureIds[i];
            try {
                if (!project.hasNature(natureId)) continue;
                hasOneNature = true;
                continue;
            }
            catch (CoreException e) {
                hasOneNature = false;
            }
        }
        return hasOneNature;
    }

    protected Vector getProjects() {
        if (this.projects == null) {
            this.projects = this.calculateProjects();
        }
        return this.projects;
    }

    protected ILabelProvider getProjectLabelProvider() {
        return new WorkbenchLabelProvider();
    }

    protected IStructuredContentProvider getProjectContentProvider() {
        return new IStructuredContentProvider(){

            public Object[] getElements(Object inputElement) {
                Vector v = (Vector)inputElement;
                return v.toArray(new Object[v.size()]);
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        };
    }

    public IProject getProject() {
        Object[] res = this.getResult();
        if (res.length != 0) {
            return (IProject)res[0];
        }
        return null;
    }

    public void setIncludeNatures(String[] natureIds) {
        this.includeNatureIds = natureIds;
    }

    public void setIsSingleSelection(boolean isSingleSelect) {
        this.isSingleSelect = isSingleSelect;
    }

    public void setExcludeNatures(String[] natureIds) {
        this.excludeNatureIds = natureIds;
    }

    public void showClosedProjects(boolean show) {
        this.showClosedProjects = show;
    }

    protected void okPressed() {
        IStructuredSelection selectedProjects = (IStructuredSelection)this.projectList.getSelection();
        this.setResult(selectedProjects.toList());
        super.okPressed();
    }

    protected void createButtonsForButtonBar(Composite parent) {
        super.createButtonsForButtonBar(parent);
        this.getButton(0).setEnabled(false);
    }

    protected void createTableControl(Composite dialogArea) {
        Vector tProjects = this.getProjects();
        if (tProjects == null || tProjects.isEmpty()) {
            this.createNoProjectAvailableLabel(dialogArea);
            return;
        }
        this.projectList = new TableViewer(dialogArea, 2052);
        GridData data = new GridData(1808);
        data.heightHint = 150;
        data.widthHint = 200;
        this.projectList.getControl().setLayoutData((Object)data);
        this.projectList.setLabelProvider((IBaseLabelProvider)this.getProjectLabelProvider());
        this.projectList.setContentProvider((IContentProvider)this.getProjectContentProvider());
        this.projectList.setInput((Object)tProjects);
        this.projectList.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                ProjectSelectionDialog.this.okPressed();
            }
        });
        this.projectList.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (ProjectSelectionDialog.this.projectList.getSelection().isEmpty()) {
                    ProjectSelectionDialog.this.getButton(0).setEnabled(false);
                } else {
                    ProjectSelectionDialog.this.getButton(0).setEnabled(true);
                }
            }
        });
        this.statusMessage = new Label(dialogArea, 0);
        this.statusMessage.setLayoutData((Object)new GridData(768));
    }

    protected void createNoProjectAvailableLabel(Composite dialogArea) {
        Label label = new Label(dialogArea, 64);
        label.setText(this.getNoProjectAvailableText());
        GridData data = new GridData(1808);
        data.heightHint = 75;
        data.widthHint = 300;
        label.setLayoutData((Object)data);
    }

    protected String getNoProjectAvailableText() {
        return this.noProjectsAvailableText;
    }

    public void setNoProjectsAvailableText(String noProjectsAvailableText) {
        this.noProjectsAvailableText = noProjectsAvailableText;
    }

    public void setHelpText(String[] helpText) {
        this.helpText = helpText;
    }
}

