/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.ejb.ui.wizards.operations;

import com.ibm.etools.ejb.ui.operations.CreateFinderMethodCommandWTP;
import com.ibm.etools.ejb.ui.operations.EditFinderSigCommandWTP;
import com.ibm.etools.ejb.ui.wizards.operations.QueryDataModel;
import com.ibm.etools.j2ee.common.operations.ModelModifierOperation;
import com.ibm.etools.j2ee.common.operations.ModelModifierOperationDataModel;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jst.j2ee.ejb.MethodElement;
import org.eclipse.jst.j2ee.ejb.Query;
import org.eclipse.jst.j2ee.ejb.QueryMethod;
import org.eclipse.jst.j2ee.ejb.ReturnTypeMapping;
import org.eclipse.jst.j2ee.ejb.internal.impl.EjbFactoryImpl;
import org.eclipse.wst.common.internal.emfworkbench.integration.ModifierHelper;

public class QueryOperation
extends ModelModifierOperation {
    private QueryDataModel model;
    private String description;
    private String statement;
    private MethodElement methodElement;
    private boolean editing;
    private boolean shouldCodegen = false;
    private Command codeGen = null;

    public QueryOperation(ModelModifierOperationDataModel dataModel) {
        super(dataModel);
        this.model = (QueryDataModel)dataModel;
        this.description = this.model.getStringProperty("QueryDataModel.DESCRIPTION");
        this.statement = this.model.getStringProperty("QueryDataModel.QUERY_STATEMENT");
        Object qm = this.model.getProperty("QueryDataModel.EXSISTING_QUERY_METHOD");
        this.methodElement = qm == null ? (MethodElement)this.model.getProperty("EJBDataModel.METHOD_ELEMENT") : (QueryMethod)qm;
    }

    protected void doInitialize(IProgressMonitor monitor) {
        super.doInitialize(monitor);
        this.model.setArtifactEditHolder(this.getArtifactEdit());
    }

    public Query getQuery() {
        return (Query)this.model.getProperty("QueryDataModel.QUERY");
    }

    protected void addHelpers() {
        this.model = (QueryDataModel)this.operationDataModel;
        List helpers = this.createFinder(this.model);
        for (int i = 0; i < helpers.size(); ++i) {
            this.modifier.addHelper((ModifierHelper)helpers.get(i));
        }
        this.modifier.addAdditionalCommand(this.codeGen);
    }

    private List createFinder(QueryDataModel model) {
        List helpers = null;
        helpers = this.createQueryModifierHelpers();
        if (!this.isExistingMethodElementEditing()) {
            this.codeGen = this.shouldCodegen && !this.editing ? new CreateFinderMethodCommandWTP(model) : new EditFinderSigCommandWTP(model);
        }
        return helpers;
    }

    private List createQueryModifierHelpers() {
        ArrayList<ModifierHelper> helpers = new ArrayList<ModifierHelper>();
        ModifierHelper helper = null;
        if (this.model.getProperty("QueryDataModel.QUERY") != null) {
            helper = this.createStatementHelper();
            if (helper != null) {
                helpers.add(helper);
            }
            if ((helper = this.createDescriptionHelper()) != null) {
                helpers.add(helper);
            }
            if ((helper = this.createMethodElementNameHelper()) != null) {
                helpers.add(helper);
            }
            if ((helper = this.createMethodElementParmsHelper()) != null) {
                helpers.add(helper);
            }
            this.shouldCodegen = this.model.getBooleanProperty("QueryDataModel.PARAM_LIST_CHANGED");
            this.setEditing(true);
        } else {
            this.shouldCodegen = true;
            helper = this.createQueryHelper();
            if (helper != null) {
                helpers.add(helper);
            }
        }
        return helpers;
    }

    private ModifierHelper createQueryHelper() {
        ModifierHelper helper = new ModifierHelper();
        helper.setOwner((EObject)this.model.getEnterpriseBean());
        helper.setFeature((EStructuralFeature)EjbFactoryImpl.getPackage().getContainerManagedEntity_Queries());
        Query query = EjbFactoryImpl.getActiveFactory().createQuery();
        query.setEjbQL(this.statement);
        query.setDescription(this.description);
        if (this.model.getBooleanProperty("QueryDataModel.EJB_SELECT") && this.model.getBooleanProperty("QueryDataModel.REMOTE_TYPE_BOOLEAN")) {
            query.setReturnTypeMapping(ReturnTypeMapping.REMOTE_LITERAL);
        }
        if (this.methodElement instanceof QueryMethod) {
            query.setQueryMethod((QueryMethod)this.methodElement);
        }
        helper.setValue((Object)query);
        return helper;
    }

    private ModifierHelper createMethodElementParmsHelper() {
        List parameters = (List)this.model.getProperty("QueryDataModel.PARAM_LIST");
        if (parameters == null) {
            return null;
        }
        Object editedParams = "";
        String holder = "";
        for (int i = 0; i < parameters.size(); ++i) {
            holder = parameters.get(i).toString();
            int location = holder.indexOf(32);
            editedParams = (String)editedParams + holder.substring(0, location);
            editedParams = (String)editedParams + " ";
        }
        ModifierHelper methodParmHelper = new ModifierHelper();
        methodParmHelper.setOwner((EObject)this.getQuery().getQueryMethod());
        methodParmHelper.setFeature((EStructuralFeature)EjbFactoryImpl.getPackage().getMethodElement_Parms());
        methodParmHelper.setValue(editedParams);
        return methodParmHelper;
    }

    private ModifierHelper createMethodElementNameHelper() {
        ModifierHelper methodNameHelper = new ModifierHelper();
        methodNameHelper.setOwner((EObject)this.getQuery().getQueryMethod());
        methodNameHelper.setFeature((EStructuralFeature)EjbFactoryImpl.getPackage().getMethodElement_Name());
        methodNameHelper.setValue(this.model.getProperty("QueryDataModel.METHOD_NAME"));
        return methodNameHelper;
    }

    private ModifierHelper createDescriptionHelper() {
        ModifierHelper desHelper = new ModifierHelper();
        desHelper.setOwner((EObject)this.getQuery());
        desHelper.setFeature((EStructuralFeature)EjbFactoryImpl.getPackage().getQuery_Description());
        String value = this.description == null ? "" : this.description;
        desHelper.setValue((Object)value);
        return desHelper;
    }

    private ModifierHelper createStatementHelper() {
        ModifierHelper helper = new ModifierHelper();
        helper.setOwner((EObject)this.getQuery());
        helper.setFeature((EStructuralFeature)EjbFactoryImpl.getPackage().getQuery_EjbQL());
        String value = this.statement == null ? "" : this.statement;
        helper.setValue((Object)value);
        return helper;
    }

    public boolean isExistingMethodElementEditing() {
        return this.model.getProperty("QueryDataModel.QUERY") == null && this.model.getProperty("QueryDataModel.EXSISTING_QUERY_METHOD") != null;
    }

    public void setEditing(boolean editing) {
        this.editing = editing;
    }
}

