/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.ejb.ui.wizards.helpers;

import com.ibm.etools.ejb.creation.wizard.PageHelper;
import com.ibm.etools.j2ee.ui.plugin.J2EEUIPlugin;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jem.internal.adapters.jdom.JavaClassJDOMAdaptor;
import org.eclipse.jem.java.JavaClass;
import org.eclipse.jst.j2ee.ejb.EnterpriseBean;

public class FindersWizardSearchScope
implements IJavaSearchScope {
    private IJavaSearchScope javaScope;
    private IJavaSearchScope collectionScope;
    private IJavaSearchScope enumScope;
    private EnterpriseBean bean;
    private String clientInterface = "";
    private boolean isLocal = false;

    public FindersWizardSearchScope(IProject project, EnterpriseBean bean, boolean isForLocal) {
        this.bean = bean;
        this.isLocal = isForLocal;
        this.init(project);
    }

    protected void init(IProject project) {
        try {
            IResource resource;
            IType type;
            this.javaScope = SearchEngine.createWorkspaceScope();
            IType collectionType = PageHelper.findType("java.util.Collection", project);
            IType enumType = PageHelper.findType("java.util.Enumeration", project);
            if (collectionType != null) {
                this.collectionScope = SearchEngine.createHierarchyScope((IType)collectionType);
            }
            if (enumType != null) {
                this.enumScope = SearchEngine.createHierarchyScope((IType)enumType);
            }
            JavaClass javaClass = null;
            javaClass = this.isLocal ? this.bean.getLocalInterface() : this.bean.getRemoteInterface();
            JavaClassJDOMAdaptor adapter = null;
            if (javaClass != null && (adapter = (JavaClassJDOMAdaptor)EcoreUtil.getAdapter((List)javaClass.eAdapters(), (Object)"JavaReflection")) != null && (type = adapter.getSourceType()) != null && (resource = type.getUnderlyingResource()) != null) {
                this.clientInterface = resource.getFullPath().toString();
            }
        }
        catch (Exception e) {
            J2EEUIPlugin.logError(e);
        }
    }

    public boolean encloses(String resourcePath) {
        if (resourcePath.equals(this.clientInterface)) {
            return true;
        }
        if (this.collectionScope != null && this.collectionScope.encloses(resourcePath)) {
            return true;
        }
        return this.enumScope != null && this.enumScope.encloses(resourcePath);
    }

    public boolean encloses(IJavaElement element) {
        if (this.collectionScope != null && this.collectionScope.encloses(element)) {
            return true;
        }
        return this.enumScope != null && this.enumScope.encloses(element);
    }

    public IPath[] enclosingProjectsAndJars() {
        return this.javaScope.enclosingProjectsAndJars();
    }

    public boolean includesBinaries() {
        return true;
    }

    public boolean includesClasspaths() {
        return true;
    }

    public void setIncludesBinaries(boolean includesBinaries) {
    }

    public void setIncludesClasspaths(boolean includesClasspaths) {
    }
}

