/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.ejb.ui.wizards.helpers;

import com.ibm.etools.ejb.codegen.EJBGenHelpers;
import com.ibm.etools.ejb.ui.wizards.helpers.EJBFindersWizardEditModel;
import com.ibm.etools.ejb.ui.wizards.helpers.MethodParameter;
import com.ibm.etools.j2ee.ui.plugin.J2EEUIPlugin;
import java.util.List;
import org.eclipse.emf.common.command.AbstractCommand;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.jdom.DOMFactory;
import org.eclipse.jdt.core.jdom.IDOMMethod;
import org.eclipse.jst.common.jdt.internal.integration.WorkingCopyProvider;
import org.eclipse.jst.j2ee.componentcore.EnterpriseArtifactEdit;
import org.eclipse.swt.widgets.Shell;

public class EditFinderSigCommand
extends AbstractCommand {
    protected EJBFindersWizardEditModel model;
    protected IDOMMethod[] methods;
    protected IDOMMethod[] oldMethods;
    protected IMethod[] savedMethods;

    public EditFinderSigCommand(EJBFindersWizardEditModel model) {
        this.model = model;
    }

    public void redo() {
        try {
            this.model.getEJBJar().eResource().setModified(true);
            EJBGenHelpers.editMethods((IMethod[])this.savedMethods, (IDOMMethod[])this.methods, (WorkingCopyProvider)((EnterpriseArtifactEdit)this.model.getArtifactEdit()), (Object)J2EEUIPlugin.getActiveWorkbenchWindow().getShell());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void undo() {
        try {
            this.model.getEJBJar().eResource().setModified(true);
            EJBGenHelpers.editMethods((IMethod[])this.savedMethods, (IDOMMethod[])this.oldMethods, (WorkingCopyProvider)((EnterpriseArtifactEdit)this.model.getArtifactEdit()), (Object)J2EEUIPlugin.getActiveWorkbenchWindow().getShell());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void execute() {
        this.savedMethods = this.model.getEditIMethods();
        this.methods = new IDOMMethod[this.savedMethods.length];
        this.oldMethods = new IDOMMethod[this.savedMethods.length];
        if (this.savedMethods.length == 0) {
            return;
        }
        DOMFactory fDOMFactory = new DOMFactory();
        for (int i = 0; i < this.savedMethods.length; ++i) {
            this.execute(this.savedMethods[i], i, fDOMFactory);
        }
    }

    private void execute(IMethod savedMethod, int index, DOMFactory fDOMFactory) {
        IDOMMethod method;
        String source;
        try {
            source = savedMethod.getSource();
        }
        catch (JavaModelException e) {
            return;
        }
        this.methods[index] = method = this.createDOMMethod(savedMethod, index, fDOMFactory, source);
        this.oldMethods[index] = method;
        try {
            this.model.getEJBJar().eResource().setModified(true);
            Shell ctx = J2EEUIPlugin.getActiveWorkbenchWindow() != null ? J2EEUIPlugin.getActiveWorkbenchWindow().getShell() : null;
            EJBGenHelpers.editMethod((IMethod)savedMethod, (IDOMMethod)method, (WorkingCopyProvider)((EnterpriseArtifactEdit)this.model.getArtifactEdit()), (Object)ctx);
        }
        catch (Exception e) {
            J2EEUIPlugin.logError(e);
        }
    }

    private IDOMMethod createDOMMethod(IMethod savedMethod, int index, DOMFactory fDOMFactory, String source) {
        String[] names;
        String[] types;
        IDOMMethod method = fDOMFactory.createMethod(source);
        List paramList = this.model.getParameterList();
        if (paramList != null) {
            types = new String[paramList.size()];
            names = new String[paramList.size()];
        } else {
            types = new String[]{};
            names = new String[]{};
        }
        if (paramList != null) {
            for (int i = 0; i < paramList.size(); ++i) {
                MethodParameter param = (MethodParameter)paramList.get(i);
                types[i] = param.getParameterType();
                names[i] = param.getParameterName();
            }
        }
        method.setReturnType(this.model.getReturnType());
        method.setName(this.model.getMethodName());
        method.setParameters(types, names);
        this.setExceptionTypes(savedMethod, method);
        return method;
    }

    private void setExceptionTypes(IMethod savedMethod, IDOMMethod method) {
        try {
            String[] typeNames = savedMethod.getExceptionTypes();
            if (typeNames.length > 0) {
                String[] excepNames = new String[typeNames.length];
                for (int i = 0; i < typeNames.length; ++i) {
                    excepNames[i] = Signature.toString((String)typeNames[i]);
                }
                method.setExceptions(excepNames);
            }
        }
        catch (JavaModelException javaModelException) {
            // empty catch block
        }
    }

    public boolean canExecute() {
        return true;
    }
}

