/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.ejb.ui.wizards.helpers;

import com.ibm.etools.ejb.ui.wizards.helpers.EJBFindersWizardEditModel;
import com.ibm.etools.ejb.ui.wizards.helpers.MethodParameter;
import com.ibm.etools.j2ee.ui.plugin.J2EEUIPlugin;
import java.util.List;
import java.util.Vector;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.common.command.AbstractCommand;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IImportDeclaration;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.jdom.DOMFactory;
import org.eclipse.jdt.core.jdom.IDOMMethod;
import org.eclipse.jem.internal.adapters.jdom.JDOMSearchHelper;
import org.eclipse.jem.internal.adapters.jdom.JavaClassJDOMAdaptor;
import org.eclipse.jem.java.JavaClass;
import org.eclipse.jst.j2ee.ejb.componentcore.util.EJBArtifactEdit;

public class CreateFinderMethodCommand
extends AbstractCommand {
    protected EJBFindersWizardEditModel model;
    DOMFactory fDOMFactory;
    protected static final String TAB = "\t";
    protected static final char TAB_CHAR = '\t';
    protected Vector createdMethods = new Vector();
    protected Vector imports = new Vector();

    public CreateFinderMethodCommand(EJBFindersWizardEditModel model) {
        this.model = model;
    }

    protected CreateFinderMethodCommand(String label) {
        super(label);
    }

    protected CreateFinderMethodCommand(String label, String description) {
        super(label, description);
    }

    public void redo() {
        this.execute();
    }

    protected boolean prepare() {
        return true;
    }

    public void execute() {
        if (this.model != null) {
            try {
                JavaClass javaClass;
                if (this.model.isLocal() && this.model.isFinderMethod()) {
                    javaClass = this.model.getEnterpriseBean().getLocalHomeInterface();
                    this.createMethod(javaClass, this.model.getLocalExceptions(), false);
                }
                if (this.model.isRemote() && this.model.isFinderMethod()) {
                    javaClass = this.model.getEnterpriseBean().getHomeInterface();
                    this.createMethod(javaClass, this.model.getRemoteExceptions(), false);
                }
                if (this.model.isEjbSelectMethod()) {
                    javaClass = this.model.getEnterpriseBean().getEjbClass();
                    this.createMethod(javaClass, this.model.getBeanClassExceptions(), true);
                }
            }
            catch (Exception e) {
                J2EEUIPlugin.logError(e);
            }
        }
    }

    protected void createMethod(JavaClass javaClass, String[] exceptions, boolean abstractMethod) throws CoreException, JavaModelException {
        int i;
        String[] names;
        String[] types;
        JavaClassJDOMAdaptor adapter = (JavaClassJDOMAdaptor)EcoreUtil.getAdapter((List)javaClass.eAdapters(), (Object)"JavaReflection");
        IType type = adapter.getSourceType();
        ICompilationUnit wc = ((EJBArtifactEdit)this.model.getArtifactEdit()).getWorkingCopy(type.getCompilationUnit(), false);
        if (wc == null) {
            return;
        }
        List paramList = this.model.getParameterList();
        if (paramList != null) {
            types = new String[paramList.size()];
            names = new String[paramList.size()];
        } else {
            types = new String[]{};
            names = new String[]{};
        }
        if (paramList != null) {
            for (i = 0; i < paramList.size(); ++i) {
                MethodParameter param = (MethodParameter)paramList.get(i);
                types[i] = param.getParameterType();
                names[i] = param.getParameterName();
            }
        }
        for (i = 0; i < types.length; ++i) {
            String string = types[i];
            types[i] = Signature.createTypeSignature((String)string, (boolean)true);
        }
        this.fDOMFactory = new DOMFactory();
        IDOMMethod method = this.fDOMFactory.createMethod();
        method.setBody(null);
        if (abstractMethod) {
            method.setFlags(1025);
        } else {
            method.setFlags(1);
        }
        method.setReturnType(this.model.getReturnType());
        method.setName(this.model.getMethodName());
        method.setParameters(types, names);
        method.setExceptions(exceptions);
        StringBuffer buffer = new StringBuffer(method.getContents());
        buffer.insert(0, TAB);
        IMethod typeMethod = type.getMethod(this.model.getMethodName(), types);
        IMethod currentMethod = null;
        if (!typeMethod.exists()) {
            type = wc.getType(type.getElementName());
            currentMethod = type.createMethod(buffer.toString(), null, false, null);
            this.createdMethods.add(currentMethod);
            String[] importTypes = currentMethod.getParameterTypes();
            if (currentMethod.getReturnType() != null) {
                importTypes = new String[currentMethod.getParameterTypes().length + 1];
                System.arraycopy(currentMethod.getParameterTypes(), 0, importTypes, 0, currentMethod.getParameterTypes().length);
                importTypes[importTypes.length - 1] = currentMethod.getReturnType();
            }
            this.addImports(importTypes, type, currentMethod.getCompilationUnit());
        }
    }

    public boolean canUndo() {
        return this.createdMethods != null && !this.createdMethods.isEmpty();
    }

    public void undo() {
        if (this.canUndo()) {
            try {
                int i;
                for (i = 0; i < this.createdMethods.size(); ++i) {
                    IMethod method = (IMethod)this.createdMethods.get(i);
                    if (method.isBinary()) continue;
                    method.delete(true, null);
                }
                for (i = 0; i < this.imports.size(); ++i) {
                    IImportDeclaration importStatement = (IImportDeclaration)this.imports.get(i);
                    importStatement.delete(true, null);
                }
            }
            catch (Exception e) {
                J2EEUIPlugin.logError(e);
            }
        }
    }

    protected void addImports(String[] typeNames, IType aType, ICompilationUnit cu) throws JavaModelException {
        for (int i = 0; i < typeNames.length; ++i) {
            String resolvedName;
            String name = Signature.toString((String)typeNames[i]);
            if (name.equals(resolvedName = JDOMSearchHelper.resolveSimpleTypeName((IType)aType, (String)name)) || resolvedName.startsWith("java.lang")) continue;
            this.imports.add(cu.createImport(resolvedName, null, null));
        }
    }
}

