/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.ejb.ui.wizards.dialogs;

import com.ibm.etools.common.frameworks.internal.datamodel.WTPOperationDataModel;
import com.ibm.etools.common.ui.nls.CommonAppEJBResourceHandler;
import com.ibm.etools.common.ui.wizards.IWizardConstants;
import com.ibm.etools.common.ui.wizards.dialogs.SimpleDialog;
import com.ibm.etools.common.ui.wizards.nls.CommonAppEJBWizardsResourceHandler;
import com.ibm.etools.ejb.creation.wizard.PageHelper;
import com.ibm.etools.ejb.ui.wizards.helpers.MethodParameter;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import java.util.EventListener;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaConventions;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.ui.dialogs.FilteredTypesSelectionDialog;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jem.java.JavaClass;
import org.eclipse.jem.java.internal.impl.JavaClassImpl;
import org.eclipse.jem.workbench.utility.JemProjectUtilities;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.TypedListener;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.common.frameworks.internal.ui.TimedModifyListener;

public class QueryAddMethodParamDialog
extends SimpleDialog
implements ActionListener {
    MethodParameter param;
    WTPOperationDataModel model;
    Composite composite;
    List list;
    Combo fieldTypeCombo;
    Text fieldNameText;
    Button checkButton;
    Button fieldTypebutton;
    boolean isArrayControlVisible = true;
    protected static final String[] nativeTypes = IWizardConstants.NATIVETYPES;

    public QueryAddMethodParamDialog(Shell parentShell, WTPOperationDataModel wtpModel, MethodParameter parameter) {
        super(parentShell);
        this.model = wtpModel;
        this.param = parameter;
    }

    public void setIsArrayControlVisible(boolean visible) {
        if (this.checkButton != null) {
            this.checkButton.setVisible(visible);
        }
        this.isArrayControlVisible = visible;
    }

    @Override
    protected void validateControls() {
        IStatus status;
        this.setOKStatus();
        this.setPageComplete(true);
        if (this.fieldNameText.getText().trim().equals("")) {
            this.setErrorStatus(CommonAppEJBWizardsResourceHandler.Name_cannot_be_empty_UI_);
            this.setPageComplete(false);
            return;
        }
        if (this.list != null && !this.list.isEmpty()) {
            for (int i = 0; i < this.list.size(); ++i) {
                MethodParameter p;
                Object o = this.list.get(i);
                if (!(o instanceof MethodParameter) || (p = (MethodParameter)o) == this.param || !p.getParameterName().equals(this.fieldNameText.getText().trim())) continue;
                this.setErrorStatus(CommonAppEJBWizardsResourceHandler.Parameter_name_already_exist_UI_);
                this.setPageComplete(false);
                return;
            }
        }
        if (!(status = JavaConventions.validateFieldName((String)this.fieldNameText.getText())).isOK()) {
            this.setErrorStatus(CommonAppEJBWizardsResourceHandler.Invalid_method_parameter_name_);
            this.setPageComplete(false);
            return;
        }
        if (this.fieldTypeCombo.getText().trim().equals("")) {
            this.setErrorStatus(CommonAppEJBWizardsResourceHandler.Type_cannot_be_empty_UI_);
            this.setPageComplete(false);
            return;
        }
    }

    @Override
    protected Control createTopLevelComposite(Composite parent) {
        this.setTitle(CommonAppEJBWizardsResourceHandler.Method_Parameter_UI_);
        this.getShell().setText(CommonAppEJBWizardsResourceHandler.Add_Method_Parameter_UI_);
        this.composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 10;
        layout.marginHeight = 10;
        layout.numColumns = 2;
        this.composite.setLayout((Layout)layout);
        this.composite.setLayoutData((Object)new GridData(1808));
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.composite, "com.ibm.etools.j2ee.ui.EJBQL_METHOD_PARM_PAGE");
        this.createControlsFieldNameAndType(this.composite);
        this.createControlsIsArray(this.composite);
        return this.composite;
    }

    protected void createControlsFieldNameAndType(Composite parent) {
        Composite inputComposite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.numColumns = 3;
        inputComposite.setLayout((Layout)layout);
        GridData gridData = new GridData(1808);
        inputComposite.setLayoutData((Object)gridData);
        Label label = new Label(inputComposite, 0);
        label.setText(CommonAppEJBResourceHandler.Name__UI_);
        this.fieldNameText = new Text(inputComposite, 2052);
        this.fieldNameText.setFocus();
        gridData = new GridData(768);
        this.fieldNameText.setLayoutData((Object)gridData);
        this.fieldNameText.addListener(24, (Listener)this);
        Label label2 = new Label(inputComposite, 0);
        label2.setText("");
        label2 = new Label(inputComposite, 0);
        label2.setText(CommonAppEJBResourceHandler.Type__UI_);
        this.fieldTypeCombo = new Combo(inputComposite, 2048);
        gridData = new GridData(768);
        gridData.widthHint = 250;
        this.fieldTypeCombo.setLayoutData((Object)gridData);
        this.fieldTypeCombo.setItems(nativeTypes);
        TimedModifyListener timedListener = new TimedModifyListener((ActionListener)this);
        TypedListener listener = new TypedListener((EventListener)timedListener);
        this.fieldTypeCombo.addListener(2, (Listener)listener);
        this.fieldTypeCombo.addListener(24, (Listener)listener);
        this.fieldTypeCombo.addListener(3, (Listener)listener);
        this.fieldTypeCombo.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent arg0) {
                QueryAddMethodParamDialog.this.validateControls();
            }

            public void widgetDefaultSelected(SelectionEvent arg0) {
            }
        });
        this.fieldTypebutton = new Button(parent, 0);
        gridData = new GridData(264);
        this.fieldTypebutton.setLayoutData((Object)gridData);
        this.fieldTypebutton.setText(CommonAppEJBResourceHandler.button_browse_UI_);
        this.fieldTypebutton.addListener(13, (Listener)this);
    }

    protected void createControlsIsArray(Composite parent) {
        Composite arrayComposite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.numColumns = 3;
        arrayComposite.setLayout((Layout)layout);
        GridData gridData = new GridData(1808);
        gridData.horizontalIndent = 10;
        arrayComposite.setLayoutData((Object)gridData);
        this.checkButton = new Button(arrayComposite, 32);
        this.checkButton.setText(CommonAppEJBWizardsResourceHandler.Array_UI_);
        this.checkButton.setVisible(this.isArrayControlVisible);
    }

    @Override
    public void handleEvent(Event event) {
        if (event.widget == this.fieldTypebutton) {
            this.openBrowse();
        }
        super.handleEvent(event);
    }

    protected void openBrowse() {
        IType rType;
        String r;
        Object o;
        IProject proj = (IProject)this.model.getProperty("QueryDataModel.PROJECT");
        FilteredTypesSelectionDialog dialog = null;
        try {
            dialog = (FilteredTypesSelectionDialog)JavaUI.createTypeDialog((Shell)this.getShell(), (IRunnableContext)new ProgressMonitorDialog(this.getShell()), (IProject)proj, (int)512, (boolean)false);
        }
        catch (JavaModelException javaModelException) {
            // empty catch block
        }
        if (dialog == null) {
            return;
        }
        dialog.setTitle(CommonAppEJBWizardsResourceHandler.Type_Selection_Dialog_finder__UI_);
        dialog.setMessage(CommonAppEJBWizardsResourceHandler.Select_parameter_type__UI_);
        if (dialog.open() == 0 && (o = dialog.getFirstResult()) instanceof IType && (r = (rType = (IType)o).getFullyQualifiedName()) != null) {
            this.fieldTypeCombo.setText(r);
        }
    }

    protected void okPressed() {
        if (this.param == null) {
            this.param = new MethodParameter(this.getParamType(), this.fieldNameText.getText().trim(), this.checkButton.getSelection());
        } else {
            this.param.setParameterName(this.fieldNameText.getText().trim());
            this.param.setParameterType(this.getParamType());
            this.param.setIsArray(this.checkButton.getSelection());
        }
        super.okPressed();
    }

    protected String getParamType() {
        return this.fieldTypeCombo.getText().trim();
    }

    public MethodParameter getParameter() {
        return this.param;
    }

    @Override
    public void enter() {
        super.enter();
        this.list = (List)this.model.getProperty("QueryDataModel.PARAM_LIST");
        if (this.param != null) {
            this.fieldNameText.setText(this.param.getParameterName());
            this.fieldTypeCombo.setText(this.param.getParameterTypeIgnoreArray());
            this.checkButton.setSelection(this.param.isArray());
            this.validateControls();
        }
    }

    protected void validateFieldType() {
        String fieldTypeString = this.fieldTypeCombo.getText();
        if (!Arrays.asList(nativeTypes).contains(fieldTypeString)) {
            JavaConventions.validateJavaTypeName((String)fieldTypeString);
            boolean isqualified = this.isQualified(fieldTypeString);
            IType type = this.findType(fieldTypeString);
            if (isqualified) {
                if (type == null) {
                    this.setErrorStatus(CommonAppEJBWizardsResourceHandler.type_does_not_exist_);
                    this.setPageComplete(false);
                }
            } else {
                String javaLangString;
                IType langType;
                boolean isprimitive = this.isPrimitiveType(fieldTypeString);
                if (!isprimitive && (langType = this.findType(javaLangString = "java.lang." + fieldTypeString)) == null) {
                    if (type != null) {
                        this.setErrorStatus(CommonAppEJBWizardsResourceHandler.the_type_cannot_be_of_type_that_exists_);
                        this.setPageComplete(false);
                    } else {
                        this.setErrorStatus(CommonAppEJBWizardsResourceHandler.enter_fully_qualified_type_);
                        this.setPageComplete(false);
                    }
                }
            }
        }
    }

    public boolean checkIfFieldTypeInDefaultPackage(String attributeType) {
        JavaClass jclass = JavaClassImpl.createClassRef((String)attributeType);
        String refClassName = jclass.getQualifiedName();
        char[] charArray = refClassName.toCharArray();
        for (int i = 0; i < charArray.length; ++i) {
            if (charArray[i] != '.') continue;
            return false;
        }
        return true;
    }

    protected boolean isQualified(String typeName) {
        return typeName.indexOf(".") != -1;
    }

    protected IType findType(String aFieldType) {
        PageHelper.setJavaProject(JemProjectUtilities.getJavaProject((IProject)((IProject)this.model.getProperty("QueryDataModel.PROJECT"))));
        if (PageHelper.getJavaProject() == null) {
            return null;
        }
        String typeName = aFieldType;
        if (typeName.trim().length() == 0) {
            return null;
        }
        IType type = PageHelper.findType(typeName);
        if (type != null) {
            return type;
        }
        return null;
    }

    protected boolean isPrimitiveType(String typeName) {
        if (typeName.trim().length() == 0) {
            return false;
        }
        int n = nativeTypes.length;
        for (int i = 0; i < n; ++i) {
            if (!nativeTypes[i].equals(typeName)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.validateControls();
    }
}

