/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.ejb.ui.wizards;

import com.ibm.etools.common.ui.nls.CommonAppEJBResourceHandler;
import com.ibm.etools.common.ui.wizards.GenericCommandWizard;
import com.ibm.etools.common.ui.wizards.SimpleCommandWizardPage;
import com.ibm.etools.common.ui.wizards.nls.CommonAppEJBWizardsResourceHandler;
import com.ibm.etools.ejb.ui.wizards.helpers.OneBeanWizardEditModel;
import com.ibm.etools.j2ee.ui.plugin.J2EEUIPlugin;
import java.util.Vector;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jst.j2ee.common.SecurityRole;
import org.eclipse.jst.j2ee.common.SecurityRoleRef;
import org.eclipse.jst.j2ee.common.internal.impl.SecurityRoleRefImpl;
import org.eclipse.jst.j2ee.ejb.EJBJar;
import org.eclipse.jst.j2ee.ejb.EnterpriseBean;
import org.eclipse.jst.j2ee.ejb.internal.impl.EjbFactoryImpl;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wst.common.internal.emfworkbench.integration.ModifierHelper;

public class SecurityRoleReferenceWizardPage
extends SimpleCommandWizardPage {
    private static final Integer PAGE_OK = new Integer(3);
    Text nameValue;
    Text descValue;
    Combo linkCombo;
    OneBeanWizardEditModel model;

    public SecurityRoleReferenceWizardPage(String pageName) {
        super(pageName);
        this.setImageDescriptor(J2EEUIPlugin.getDefault().getImageDescriptor("secur_role_ref_wiz"));
    }

    @Override
    protected Composite createTopLevelComposite(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(768));
        Label nameLabel = new Label(composite, 0);
        nameLabel.setText(CommonAppEJBResourceHandler.Name__UI_);
        this.nameValue = new Text(composite, 2048);
        this.nameValue.setLayoutData((Object)new GridData(768));
        Label linkLabel = new Label(composite, 0);
        linkLabel.setText(CommonAppEJBResourceHandler.Link__UI_);
        this.linkCombo = new Combo(composite, 2060);
        this.linkCombo.setLayoutData((Object)new GridData(768));
        this.linkCombo.setItems(this.getSecurityRoles());
        this.linkCombo.select(0);
        Label descLabel = new Label(composite, 0);
        descLabel.setText(CommonAppEJBResourceHandler.Description__UI_);
        descLabel.setLayoutData((Object)new GridData(2));
        this.descValue = new Text(composite, 2626);
        GridData data = new GridData(768);
        data.heightHint = 60;
        this.descValue.setLayoutData((Object)data);
        return composite;
    }

    @Override
    protected void addListeners() {
        this.nameValue.addListener(24, (Listener)this);
    }

    @Override
    protected void validateControls() {
        this.setOKStatus(PAGE_OK);
        if (this.nameValue.getText() == null || this.nameValue.getText().trim().equals("")) {
            this.setErrorStatus(PAGE_OK, CommonAppEJBWizardsResourceHandler.Name_cannot_be_empty_UI_);
            return;
        }
        if (this.model.getEnterpriseBean() != null) {
            EnterpriseBean bean = this.model.getEnterpriseBean();
            EList refs = bean.getSecurityRoleRefs();
            for (int i = 0; i < refs.size(); ++i) {
                SecurityRoleRef ref = (SecurityRoleRef)refs.get(i);
                if (!ref.getName().equals(this.nameValue.getText().trim())) continue;
                this.setErrorStatus(PAGE_OK, CommonAppEJBWizardsResourceHandler.Name_already_exist_UI_);
                return;
            }
        }
    }

    @Override
    public ModifierHelper[] createCommandHelper() {
        ModifierHelper[] helpers = new ModifierHelper[1];
        ModifierHelper helper = new ModifierHelper();
        if (this.model.getEnterpriseBean() != null) {
            SecurityRoleRefImpl ref = new SecurityRoleRefImpl();
            ref.setName(this.nameValue.getText().trim());
            ref.setDescription(this.descValue.getText().trim());
            if (this.linkCombo.getSelectionIndex() != 0) {
                ref.setLink(this.linkCombo.getText().trim());
            }
            helper.setOwner((EObject)this.model.getEnterpriseBean());
            helper.setFeature((EStructuralFeature)EjbFactoryImpl.getPackage().getEnterpriseBean_SecurityRoleRefs());
            helper.setValue((Object)ref);
            helpers[0] = helper;
        }
        return helpers;
    }

    public String[] getSecurityRoles() {
        EJBJar jar;
        Vector<String> names = new Vector<String>();
        names.add(CommonAppEJBWizardsResourceHandler.None_UI_);
        if (this.model == null) {
            this.loadData();
        }
        if (this.model.getEJBJar() != null && (jar = this.model.getEJBJar()).getAssemblyDescriptor() != null) {
            EList s = jar.getAssemblyDescriptor().getSecurityRoles();
            for (int i = 0; i < s.size(); ++i) {
                SecurityRole sec = (SecurityRole)s.get(i);
                names.add(sec.getRoleName());
            }
        }
        return names.toArray(new String[names.size()]);
    }

    protected void loadData() {
        if (this.getWizard() instanceof GenericCommandWizard) {
            GenericCommandWizard wizard = (GenericCommandWizard)this.getWizard();
            this.model = (OneBeanWizardEditModel)wizard.getWizardEditModel();
        }
    }
}

