/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.ejb.ui.wizards;

import com.ibm.etools.common.ui.wizards.IWizardConstants;
import com.ibm.etools.common.ui.wizards.nls.CommonAppEJBWizardsResourceHandler;
import com.ibm.etools.ejb.ui.nls.EJBUIResourceHandler;
import com.ibm.etools.j2ee.common.wizard.J2EEWizardPage;
import com.ibm.etools.j2ee.ejb.creation.operations.ClientViewModel;
import com.ibm.etools.j2ee.ui.plugin.J2EEUIPlugin;
import java.util.Collections;
import java.util.List;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jst.j2ee.ejb.EnterpriseBean;
import org.eclipse.jst.j2ee.internal.plugin.J2EEPlugin;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.PlatformUI;

public class ClientViewWizardPageOne
extends J2EEWizardPage
implements IWizardConstants {
    private Button deleteInterfaceButton;
    private Button removeInterfaceButton;
    private Group headingPromote;
    private Group headingNew;
    private Group headingDelete;
    private ClientViewModel clientViewModel;
    private Button localFromRemoteButton;
    private Button remoteFromLocalButton;
    private Button newRemoteInterfaceButton;
    private Button newLocalInterfaceButton;
    private EnterpriseBean ejbBean;
    private static final Integer PAGE_OK = new Integer(2);
    private static final int INDENT = 15;
    private boolean hasDevRole = J2EEPlugin.hasDevelopmentRole();

    public ClientViewWizardPageOne(String pageName) {
        super(pageName);
        this.setTitle(CommonAppEJBWizardsResourceHandler.Client_View_Page_Title_UI_);
        this.setDescription(CommonAppEJBWizardsResourceHandler.Create_a_new_client_view_for_an_Enterprise_Bean_UI_);
        this.setImageDescriptor(J2EEUIPlugin.getDefault().getImageDescriptor("new_clientview_wiz"));
    }

    @Override
    protected Composite createTopLevelComposite(Composite parent) {
        this.loadData();
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.verticalSpacing = 0;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(768));
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, "com.ibm.etools.j2ee.ui.EJB_CREATECLIENTVIEW_PAGE1");
        this.createNewInterfaceButtons(composite);
        this.createSpacer(composite);
        this.createSpacer(composite);
        this.createPromoteButtons(composite);
        this.createSpacer(composite);
        this.createSpacer(composite);
        this.createDeleteButtons(composite);
        this.setSelectionsEnable();
        return composite;
    }

    public void createDeleteButtons(Composite parent) {
        this.setHeadingDelete(new Group(parent, 0));
        this.getHeadingDelete().setForeground(DESC_COLOR);
        this.getHeadingDelete().setLayout((Layout)new GridLayout());
        this.getHeadingDelete().setLayoutData((Object)new GridData(768));
        this.getHeadingDelete().setText(CommonAppEJBWizardsResourceHandler.Remove_andor_delete_the_existing_client_view_);
        this.setRemoveInterfaceButton(new Button((Composite)this.headingDelete, 32));
        this.getRemoveInterfaceButton().setText(CommonAppEJBWizardsResourceHandler.Remove_existing_client_view_from_enterprise_bean);
        GridData data = new GridData();
        data.horizontalIndent = 15;
        this.getRemoveInterfaceButton().setLayoutData((Object)data);
        this.setDeleteInterfaceButton(new Button((Composite)this.headingDelete, 32));
        this.getDeleteInterfaceButton().setText(CommonAppEJBWizardsResourceHandler.Delete_existing_client_view_from_project);
        data = new GridData();
        data.horizontalIndent = 15;
        this.getDeleteInterfaceButton().setLayoutData((Object)data);
    }

    private void createNewInterfaceButtons(Composite parent) {
        this.setHeadingNew(new Group(parent, 0));
        this.getHeadingNew().setForeground(DESC_COLOR);
        this.getHeadingNew().setLayout((Layout)new GridLayout());
        this.getHeadingNew().setLayoutData((Object)new GridData(768));
        this.getHeadingNew().setText(CommonAppEJBWizardsResourceHandler.Create_new_client_view_UI_);
        this.setNewLocalInterfaceButton(new Button((Composite)this.headingNew, 32));
        GridData data1 = new GridData();
        data1.horizontalIndent = 15;
        this.getNewLocalInterfaceButton().setLayoutData((Object)data1);
        this.getNewLocalInterfaceButton().setText(CommonAppEJBWizardsResourceHandler.New_Local_Group__new_Local_and_Local_Home_interfaces__UI_);
        this.setNewRemoteInterfaceButton(new Button((Composite)this.headingNew, 32));
        GridData dataHome = new GridData();
        dataHome.horizontalIndent = 15;
        this.getNewRemoteInterfaceButton().setLayoutData((Object)dataHome);
        this.getNewRemoteInterfaceButton().setText(CommonAppEJBWizardsResourceHandler.New_Remote_Group__new_Remote_and_Remote_Home_interfaces__UI_);
    }

    private void createSpacer(Composite parent) {
        Label space = new Label(parent, 0);
        GridData data = new GridData(768);
        space.setLayoutData((Object)data);
    }

    private void createPromoteButtons(Composite parent) {
        this.setHeadingPromote(new Group(parent, 0));
        this.getHeadingPromote().setForeground(IWizardConstants.DESC_COLOR);
        this.getHeadingPromote().setLayout((Layout)new GridLayout());
        this.getHeadingPromote().setLayoutData((Object)new GridData(768));
        this.getHeadingPromote().setText(CommonAppEJBWizardsResourceHandler.Create_new_client_view_from_an_existing_view_UI_);
        this.setLocalFromRemoteButton(new Button((Composite)this.headingPromote, 32));
        GridData data1 = new GridData();
        data1.horizontalIndent = 15;
        this.getLocalFromRemoteButton().setLayoutData((Object)data1);
        this.getLocalFromRemoteButton().setText(CommonAppEJBWizardsResourceHandler.Promote_Remote_Methods__promote_Remote_methods_to_Local_Intefaces__UI_);
        this.setRemoteFromLocalButton(new Button((Composite)this.headingPromote, 32));
        GridData dataHome = new GridData();
        dataHome.horizontalIndent = 15;
        this.getRemoteFromLocalButton().setLayoutData((Object)dataHome);
        this.getRemoteFromLocalButton().setText(CommonAppEJBWizardsResourceHandler.Promote_Local_Methods__promote_Local_methods_to_Remote_Intefaces__UI_);
    }

    public void loadData() {
        this.setEjbBean(this.getClientViewModel().getEjbBean());
        this.getClientViewModel().setHomeExistingName(this.getEjbBean().getHomeInterfaceName());
        this.getClientViewModel().setRemoteExistingName(this.getEjbBean().getRemoteInterfaceName());
        this.getClientViewModel().setLocalExistingName(this.getEjbBean().getLocalInterfaceName());
        this.getClientViewModel().setLocalHomeExistingName(this.getEjbBean().getLocalHomeInterfaceName());
    }

    public void setSelectionsEnable() {
        if (!this.hasDevRole) {
            this.getHeadingPromote().setEnabled(false);
            this.getRemoteFromLocalButton().setSelection(false);
            this.getRemoteFromLocalButton().setEnabled(false);
            this.getLocalFromRemoteButton().setEnabled(false);
            this.getLocalFromRemoteButton().setEnabled(false);
            this.getDeleteInterfaceButton().setSelection(false);
            this.getDeleteInterfaceButton().setEnabled(false);
        }
        if (!this.isEJB2_X()) {
            this.setHeadingButtonsEnable(false);
            this.setLocalButtonsEnable(false);
            this.getRemoteFromLocalButton().setEnabled(false);
            if (this.getClientViewModel().hasRemoteInterfaces()) {
                this.setRemoteButtonsEnable(false);
            }
        } else {
            if (this.getClientViewModel().hasLocalInterfaces()) {
                this.setLocalButtonsEnable(false);
            } else if (this.getClientViewModel().hasRemoteInterfaces()) {
                this.setRemoteButtonsEnable(false);
            }
            if (this.getClientViewModel().hasRemoteInterfaces() && this.getClientViewModel().hasLocalInterfaces()) {
                this.setHeadingButtonsEnable(false);
            } else if (!this.getClientViewModel().hasRemoteInterfaces() && !this.getClientViewModel().hasLocalInterfaces()) {
                this.setHeadingHasNoInterfaces(false);
            }
        }
    }

    public void setRemoteButtonsEnable(boolean selection) {
        this.getNewRemoteInterfaceButton().setEnabled(selection);
        this.getRemoteFromLocalButton().setEnabled(selection && this.hasDevRole);
    }

    public void setLocalButtonsEnable(boolean selection) {
        this.getNewLocalInterfaceButton().setEnabled(selection);
        this.getLocalFromRemoteButton().setEnabled(selection && this.hasDevRole);
    }

    public void setHeadingButtonsEnable(boolean selection) {
        this.getHeadingNew().setEnabled(selection);
        this.getHeadingPromote().setEnabled(selection && this.hasDevRole);
        this.getDeleteInterfaceButton().setEnabled(selection && this.hasDevRole);
        this.getRemoveInterfaceButton().setEnabled(selection);
        this.getHeadingDelete().setEnabled(selection);
    }

    public void setHeadingHasNoInterfaces(boolean selection) {
        this.getHeadingPromote().setEnabled(selection && this.hasDevRole);
        this.getRemoteFromLocalButton().setEnabled(selection && this.hasDevRole);
        this.getLocalFromRemoteButton().setEnabled(selection && this.hasDevRole);
        this.getDeleteInterfaceButton().setEnabled(selection && this.hasDevRole);
        this.getRemoveInterfaceButton().setEnabled(selection);
        this.getHeadingDelete().setEnabled(selection);
    }

    @Override
    protected void addListeners() {
        this.getNewLocalInterfaceButton().addListener(13, (Listener)this);
        this.getNewRemoteInterfaceButton().addListener(13, (Listener)this);
        this.getRemoteFromLocalButton().addListener(13, (Listener)this);
        this.getLocalFromRemoteButton().addListener(13, (Listener)this);
        this.getDeleteInterfaceButton().addListener(13, (Listener)this);
        this.getRemoveInterfaceButton().addListener(13, (Listener)this);
    }

    @Override
    public void handleEvent(Event event) {
        if (event.widget == this.getNewRemoteInterfaceButton()) {
            this.handleCreationOperations();
        } else if (event.widget == this.getNewLocalInterfaceButton()) {
            this.handleCreationOperations();
        } else if (event.widget == this.getRemoteFromLocalButton()) {
            this.handleRemoteFromLocalButtonPressed();
        } else if (event.widget == this.getLocalFromRemoteButton()) {
            this.handleLocalFromRemoteButtonPressed();
        } else if (event.widget == this.getDeleteInterfaceButton()) {
            this.handleRemoveOperations();
        } else if (event.widget == this.getRemoveInterfaceButton()) {
            this.handleRemoveOperations();
        }
        super.handleEvent(event);
    }

    protected void handleCreationOperations() {
        if (this.getNewRemoteInterfaceButton().getSelection() && this.getNewLocalInterfaceButton().getSelection()) {
            this.handleNewRemoteInterfaceButtonPressed();
            this.handleNewLocalInterfaceButtonPressed();
        } else {
            this.handleNewRemoteInterfaceButtonPressed();
            this.handleNewLocalInterfaceButtonPressed();
        }
    }

    protected void handleNewRemoteInterfaceButtonPressed() {
        if (this.getNewRemoteInterfaceButton().getSelection()) {
            this.getClientViewModel().setShouldCreateRemoteCommand(true);
            this.handleRemoveOperations();
        } else {
            this.getClientViewModel().setShouldCreateRemoteCommand(false);
        }
    }

    protected void handleNewLocalInterfaceButtonPressed() {
        if (this.getNewLocalInterfaceButton().getSelection()) {
            this.getClientViewModel().setShouldCreateLocalCommand(true);
            this.handleRemoveOperations();
        } else {
            this.getClientViewModel().setShouldCreateLocalCommand(false);
        }
    }

    protected void handleRemoteFromLocalButtonPressed() {
        if (this.getRemoteFromLocalButton().getSelection()) {
            this.getNewRemoteInterfaceButton().setSelection(true);
            if (this.getEjbBean().getLocalInterface().getMethods() != null && this.getEjbBean().getLocalHomeInterface().getMethods() != null) {
                this.getClientViewModel().setMethodCollection((List)this.getEjbBean().getLocalInterface().getMethods());
                this.getClientViewModel().setHomeMethodCollection((List)this.getEjbBean().getLocalHomeInterface().getMethods());
            } else {
                this.setMethodListEmpty();
            }
            this.handleRemoveOperations();
        }
    }

    protected void handleLocalFromRemoteButtonPressed() {
        if (this.getLocalFromRemoteButton().getSelection()) {
            this.getNewLocalInterfaceButton().setSelection(true);
            if (this.getEjbBean().getHomeInterface().getMethods() != null && this.getEjbBean().getRemoteInterface().getMethods() != null) {
                this.getClientViewModel().setHomeMethodCollection((List)this.getEjbBean().getHomeInterface().getMethods());
                this.getClientViewModel().setMethodCollection((List)this.getEjbBean().getRemoteInterface().getMethods());
            } else {
                this.setMethodListEmpty();
            }
            this.handleRemoveOperations();
        }
    }

    protected void handleRemoveOperations() {
        if (this.getRemoveInterfaceButton().getSelection()) {
            this.handleRemoveButtonPressed();
        }
        if (this.getDeleteInterfaceButton().getSelection()) {
            this.handleDeleteButtonPressed();
        }
    }

    protected void whichOneToDelete() {
        if (this.getNewRemoteInterfaceButton().getSelection()) {
            this.getClientViewModel().setShouldDeleteLocal(true);
            this.getClientViewModel().setShouldDeleteRemote(false);
        } else if (this.getNewLocalInterfaceButton().getSelection()) {
            this.getClientViewModel().setShouldDeleteRemote(true);
            this.getClientViewModel().setShouldDeleteLocal(false);
        }
    }

    protected void handleDeleteButtonPressed() {
        if (this.getDeleteInterfaceButton().getSelection()) {
            this.getRemoveInterfaceButton().setSelection(true);
            this.getClientViewModel().setShouldDelete(true);
            this.whichOneToDelete();
            if (this.getNewRemoteInterfaceButton().getSelection()) {
                this.setLocalExisting();
            } else if (this.getNewLocalInterfaceButton().getSelection()) {
                this.setRemoteExisting();
            }
        }
    }

    protected void handleRemoveButtonPressed() {
        if (this.getDeleteInterfaceButton().getSelection()) {
            this.getRemoveInterfaceButton().setSelection(true);
        }
        if (this.getRemoveInterfaceButton().getSelection()) {
            this.getClientViewModel().setShouldDelete(false);
            this.whichOneToDelete();
        }
    }

    protected void setMethodListEmpty() {
        this.getClientViewModel().setHomeMethodCollection(Collections.EMPTY_LIST);
        this.getClientViewModel().setMethodCollection(Collections.EMPTY_LIST);
    }

    public boolean isEJB2_X() {
        return this.getEjbBean().getVersionID() >= 20;
    }

    public ClientViewModel getClientViewModel() {
        return this.clientViewModel;
    }

    public void setClientViewModel(ClientViewModel clientViewModel) {
        this.clientViewModel = clientViewModel;
    }

    public Button getNewRemoteInterfaceButton() {
        return this.newRemoteInterfaceButton;
    }

    public void setNewRemoteInterfaceButton(Button newRemoteInterfaceButton) {
        this.newRemoteInterfaceButton = newRemoteInterfaceButton;
    }

    public EnterpriseBean getEjbBean() {
        return this.ejbBean;
    }

    public void setEjbBean(EnterpriseBean ejbBean) {
        this.ejbBean = ejbBean;
    }

    @Override
    protected void validateControls() {
        this.setOKStatus(PAGE_OK);
        if (!(this.getNewLocalInterfaceButton().getSelection() || this.getNewRemoteInterfaceButton().getSelection() || this.getRemoteFromLocalButton().getSelection() || this.getLocalFromRemoteButton().getSelection())) {
            this.setErrorStatus(PAGE_OK, EJBUIResourceHandler.An_operation_must_be_selected__1);
        }
    }

    public Button getLocalFromRemoteButton() {
        return this.localFromRemoteButton;
    }

    public void setLocalFromRemoteButton(Button localFromRemoteButton) {
        this.localFromRemoteButton = localFromRemoteButton;
    }

    public Button getRemoteFromLocalButton() {
        return this.remoteFromLocalButton;
    }

    public void setRemoteFromLocalButton(Button remoteFromLocalButton) {
        this.remoteFromLocalButton = remoteFromLocalButton;
    }

    public Button getNewLocalInterfaceButton() {
        return this.newLocalInterfaceButton;
    }

    public void setNewLocalInterfaceButton(Button newLocalInterfaceButton) {
        this.newLocalInterfaceButton = newLocalInterfaceButton;
    }

    public Group getHeadingPromote() {
        return this.headingPromote;
    }

    public void setHeadingPromote(Group headingPromote) {
        this.headingPromote = headingPromote;
    }

    public Group getHeadingNew() {
        return this.headingNew;
    }

    public void setHeadingNew(Group headingNew) {
        this.headingNew = headingNew;
    }

    public Button getDeleteInterfaceButton() {
        return this.deleteInterfaceButton;
    }

    public void setDeleteInterfaceButton(Button deleteInterfaceButton) {
        this.deleteInterfaceButton = deleteInterfaceButton;
    }

    public Button getRemoveInterfaceButton() {
        return this.removeInterfaceButton;
    }

    public void setRemoveInterfaceButton(Button removeInterfaceButton) {
        this.removeInterfaceButton = removeInterfaceButton;
    }

    public Group getHeadingDelete() {
        return this.headingDelete;
    }

    public void setHeadingDelete(Group headingDelete) {
        this.headingDelete = headingDelete;
    }

    public IWizardPage getNextPage() {
        this.validateControls();
        if (this.getNewRemoteInterfaceButton().getSelection()) {
            this.getClientViewModel().setRemoteSelected(true);
        } else {
            this.getClientViewModel().setRemoteSelected(false);
        }
        if (this.getNewLocalInterfaceButton().getSelection()) {
            this.getClientViewModel().setLocalSelected(true);
        } else {
            this.getClientViewModel().setLocalSelected(false);
        }
        return super.getNextPage();
    }

    protected void setLocalExisting() {
        if (this.getEjbBean().getLocalInterface() != null && this.getEjbBean().getLocalHomeInterface() != null) {
            this.getClientViewModel().setLocalInterfaceExisting(this.getEjbBean().getLocalInterface());
            this.getClientViewModel().setLocalHomeInterfaceExisting(this.getEjbBean().getLocalHomeInterface());
        }
    }

    protected void setRemoteExisting() {
        if (this.getEjbBean().getHomeInterface() != null && this.getEjbBean().getRemoteInterface() != null) {
            this.getClientViewModel().setHomeInterfaceExisting(this.getEjbBean().getHomeInterface());
            this.getClientViewModel().setRemoteInterfaceExisting(this.getEjbBean().getRemoteInterface());
        }
    }
}

