/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.ejb.ui.wizards;

import com.ibm.etools.common.frameworks.internal.datamodel.WTPOperationDataModel;
import com.ibm.etools.common.ui.wizards.nls.CommonAppEJBWizardsResourceHandler;
import com.ibm.etools.ejb.ui.providers.MethodPageLabelProvider;
import com.ibm.etools.ejb.ui.providers.MethodsAdapterFactoryContentProvider;
import com.ibm.etools.ejb.ui.wizards.TreeSelectionControl;
import com.ibm.etools.ejb.ui.wizards.dialogs.AddBeanDialog;
import com.ibm.etools.ejb.ui.wizards.listeners.MethodsCheckStateListener;
import com.ibm.etools.ejb.ui.wizards.operations.EJBDataModel;
import com.ibm.etools.ejb.ui.wizards.operations.MethodElementDataModelSyncHelper;
import com.ibm.etools.emf.workbench.ui.wizard.datamodel.WTPDataModelSynchHelper;
import com.ibm.etools.emf.workbench.ui.wizard.datamodel.WTPWizardPage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.provider.ItemProvider;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.ICheckable;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jst.j2ee.ejb.EJBJar;
import org.eclipse.jst.j2ee.ejb.MethodElement;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.PlatformUI;

public abstract class AbstractMethodElementsWizardPage
extends WTPWizardPage {
    private static final Integer PAGE_OK = new Integer(4);
    private static Color BLACK = Display.getDefault().getSystemColor(2);
    private static Color GRAY = Display.getDefault().getSystemColor(16);
    protected TreeSelectionControl treeControl;
    Button selectAll;
    Button deselectAll;
    MethodsCheckStateListener checkListener;
    AdapterFactoryEditingDomain editingDomain;
    List genItemProviders = null;
    protected boolean isEditing = false;
    protected List providerList = new ArrayList();

    protected AbstractMethodElementsWizardPage(WTPOperationDataModel model, String pageName) {
        super(model, pageName);
    }

    public WTPDataModelSynchHelper initializeSynchHelper(WTPOperationDataModel dm) {
        return new MethodElementDataModelSyncHelper(dm);
    }

    protected EJBJar getEjbJar() {
        return (EJBJar)this.model.getProperty("EJBDataModel.EJB_JAR");
    }

    protected AdapterFactoryEditingDomain getEditingDomain() {
        return (AdapterFactoryEditingDomain)this.model.getProperty("ModelModifierOperationDataModel.EDITING_DOMAIN");
    }

    protected Composite createTopLevelComposite(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout gl = new GridLayout();
        GridData gd = new GridData(768);
        composite.setLayoutData((Object)gd);
        composite.setLayout((Layout)gl);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, "com.ibm.etools.j2ee.ui.ACCESS_INTENT_1_WIZARD_P3");
        Label methodsLabel = new Label(composite, 0);
        methodsLabel.setText(CommonAppEJBWizardsResourceHandler.Methods_found___UI_);
        methodsLabel.setLayoutData((Object)new GridData());
        this.checkListener = new MethodsCheckStateListener();
        this.treeControl = new TreeSelectionControl(composite, null, null, null, this.checkListener);
        GridData treeData = new GridData(768);
        treeData.heightHint = 200;
        this.treeControl.getViewer().getControl().setLayoutData((Object)treeData);
        this.treeControl.getViewer().getControl().addListener(13, (Listener)this);
        this.createButtons(composite);
        return composite;
    }

    protected void createButtons(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        layout.marginHeight = 0;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(768));
        this.selectAll = new Button(composite, 0);
        this.selectAll.setText(CommonAppEJBWizardsResourceHandler.Apply_To_All_UI_);
        this.selectAll.addListener(13, (Listener)this);
        this.deselectAll = new Button(composite, 0);
        this.deselectAll.setText(CommonAppEJBWizardsResourceHandler.Deselect_All_UI_);
        this.deselectAll.addListener(13, (Listener)this);
    }

    protected void setupControls() {
        MethodPageLabelProvider methodLabelProvider;
        MethodsAdapterFactoryContentProvider methodContentProvider;
        Object[] ejbs = null;
        if (this.model.getProperty("EJBDataModel.BEANS") == null) {
            methodContentProvider = (MethodsAdapterFactoryContentProvider)this.createContentProvider();
            methodLabelProvider = new MethodPageLabelProvider(this.getEditingDomain().getAdapterFactory());
        } else {
            ejbs = (Object[])this.model.getProperty("EJBDataModel.BEANS");
            methodContentProvider = new MethodsAdapterFactoryContentProvider(this.getEditingDomain().getAdapterFactory(), Arrays.asList(ejbs), true);
            methodLabelProvider = new MethodPageLabelProvider(this.getEditingDomain().getAdapterFactory());
        }
        this.treeControl.setupTree((IContentProvider)methodContentProvider, (ILabelProvider)methodLabelProvider);
        if (ejbs != null) {
            this.treeControl.setInput(new ItemProvider(Arrays.asList(ejbs)));
        }
        this.synchHelper.synchCheckBoxTreeViewer((CheckboxTreeViewer)this.treeControl.getViewer(), "EJBDataModel.METHOD_ELEMENTS", null);
    }

    public void handleEvent(Event event) {
        if (event.widget == this.selectAll) {
            this.handleSelect(true, event);
        } else if (event.widget == this.deselectAll) {
            this.handleSelect(false, event);
        }
        super.handleEvent(event);
    }

    protected void handleSelect(boolean state, Event event) {
        CheckboxTreeViewer checkBoxTreeViewer = (CheckboxTreeViewer)this.treeControl.getViewer();
        Object[] selectedBeans = (Object[])this.model.getProperty("EJBDataModel.BEANS");
        this.checkListener.checkStateChanged(new CheckStateChangedEvent((ICheckable)checkBoxTreeViewer, (Object)selectedBeans, state));
        this.model.setProperty("EJBDataModel.METHOD_ELEMENTS", (Object)checkBoxTreeViewer.getCheckedElements());
    }

    protected void addBeanDialog() {
        AddBeanDialog dialog = new AddBeanDialog(this.getWizard().getContainer().getShell(), (EJBDataModel)this.model);
        if (dialog.open() != 256) {
            ((CheckboxTreeViewer)this.treeControl.getViewer()).getCheckedElements();
            if (dialog.beans != null) {
                this.treeControl.setInput(new ItemProvider((Collection)dialog.beans));
                this.model.setProperty("EJBDataModel.BEANS", (Object)dialog.getBeanArray());
                this.treeControl.refresh();
                this.treeControl.getViewer().expandAll();
                this.resetDataModel();
            }
        }
    }

    protected List getMethodElements() {
        ArrayList<Object> me = new ArrayList<Object>();
        Object[] checked = this.treeControl.getSelection();
        for (int i = 0; i < checked.length; ++i) {
            if (!(checked[i] instanceof MethodElement)) continue;
            me.add(checked[i]);
        }
        return me;
    }

    protected void enter() {
        if (this.isFirstTimeToPage()) {
            this.setupControls();
        } else {
            Object ejbObject = this.model.getProperty("EJBDataModel.BEANS");
            if (ejbObject != null) {
                this.treeControl.setInput(new ItemProvider(Arrays.asList((Object[])ejbObject)));
            } else {
                this.treeControl.setInput(new ItemProvider());
            }
            this.treeControl.getViewer().expandAll();
            this.resetDataModel();
        }
        super.enter();
    }

    private void resetDataModel() {
        Object obj = this.model.getProperty("EJBDataModel.METHOD_ELEMENTS");
        Object[] beans = (Object[])this.model.getProperty("EJBDataModel.BEANS");
        if (obj == null) {
            return;
        }
        Object[] objArray = (Object[])obj;
        if (((EJBDataModel)this.model).doesContainMethodElementParentBean(objArray, beans)) {
            this.synchHelper.synchUIWithModel("EJBDataModel.METHOD_ELEMENTS", 0);
            this.unGreyUnchecked();
        } else {
            this.model.setProperty("EJBDataModel.METHOD_ELEMENTS", null);
        }
    }

    public void setTreeItemsGrey(TreeItem treeItem, boolean b) {
        TreeItem[] treeItems = treeItem.getItems();
        treeItem.setGrayed(b);
        for (int i = 0; i < treeItems.length; ++i) {
            TreeItem item = treeItems[i];
            item.setGrayed(b);
            if (b) {
                this.setForeground((Widget)item, GRAY);
            } else {
                this.setForeground((Widget)item, BLACK);
            }
            this.setTreeItemsGrey(item, b);
        }
    }

    private void unGreyUnchecked() {
        this.model.setProperty("EJBDataModel.METHOD_ELEMENTS", (Object)((CheckboxTreeViewer)this.treeControl.getViewer()).getCheckedElements());
        TreeItem[] tItems = this.treeControl.getTree().getItems();
        for (int i = 0; i < tItems.length; ++i) {
            TreeItem item = tItems[i];
            if (item.getChecked()) continue;
            this.setTreeItemsGrey(item, false);
            this.setForeground((Widget)item, GRAY);
        }
    }

    private void setForeground(Widget widget, Color color) {
        if (widget instanceof TreeItem) {
            TreeItem item = (TreeItem)widget;
            item.setForeground(color);
            item.getParent().redraw();
        }
    }

    protected void validateControls() {
        this.setOKStatus(PAGE_OK);
        if (this.getMethodElements().isEmpty()) {
            this.setErrorStatus(PAGE_OK, CommonAppEJBWizardsResourceHandler.Select_one_or_more_method_elements_from_the_list_UI_);
        }
    }

    protected abstract IContentProvider createContentProvider();

    public String getObjectTitle() {
        return "";
    }

    public Object[] getObjects(Object first) {
        return null;
    }
}

