/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.ejb.ui.java.actions;

import com.ibm.etools.ejb.ui.java.actions.InterfaceModificationOperation;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeParameter;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.ImportDeclaration;
import org.eclipse.jdt.core.dom.Javadoc;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.PrimitiveType;
import org.eclipse.jdt.core.dom.QualifiedName;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.TagElement;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.core.dom.rewrite.ListRewrite;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jem.internal.adapters.jdom.JDOMSearchHelper;
import org.eclipse.jem.java.JavaClass;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.ui.part.FileEditorInput;

public abstract class PromoteToInterfaceOperation
extends InterfaceModificationOperation {
    private ListRewrite interfaceMethodsRewrite;
    private ListRewrite interfaceImportsRewrite;
    private static final String WILDCARD_TYPE = "?";

    protected PromoteToInterfaceOperation(IMethod[] someClassMethods, JavaClass anInterface, boolean isLocalType) {
        super(someClassMethods, anInterface, isLocalType);
    }

    protected void addException(MethodDeclaration newMethod, String exceptionString) {
        if (!this.containsException(newMethod, exceptionString)) {
            newMethod.thrownExceptions().add(newMethod.getAST().newName(exceptionString));
        }
    }

    protected boolean containsException(MethodDeclaration newMethod, String exceptionString) {
        List exceptions = newMethod.thrownExceptions();
        if (exceptions != null && !exceptions.isEmpty()) {
            Name name = (Name)exceptions.get(0);
            String qualifiedName = name.getFullyQualifiedName();
            return qualifiedName.equals(exceptionString) || qualifiedName.equals(this.getShortName(exceptionString));
        }
        return false;
    }

    protected MethodDeclaration createInterfaceNode(IMethod aMethod, IType aType) throws JavaModelException {
        String classMethodSource = aMethod.getSource();
        ASTParser parser = ASTParser.newParser((int)3);
        parser.setSource(classMethodSource.toCharArray());
        parser.setProject(aMethod.getJavaProject());
        parser.setKind(4);
        TypeDeclaration domType = (TypeDeclaration)parser.createAST(null);
        if (domType.getMethods().length < 1) {
            return null;
        }
        MethodDeclaration newMethod = domType.getMethods()[0];
        this.modifyForInterface(newMethod, aMethod);
        this.generateComment(newMethod);
        return newMethod;
    }

    protected String getShortName(String qualifiedString) {
        return Signature.getSimpleName((String)qualifiedString);
    }

    protected void modifyForInterface(MethodDeclaration newMethod, IMethod beanMethod) {
        newMethod.setBody(null);
    }

    private void generateComment(MethodDeclaration newMethod) {
        List exceptions;
        Type returnType;
        Javadoc comment = newMethod.getAST().newJavadoc();
        newMethod.setJavadoc(comment);
        AST ast = newMethod.getAST();
        List tags = comment.tags();
        List parameters = newMethod.parameters();
        if (!parameters.isEmpty()) {
            for (SingleVariableDeclaration param : parameters) {
                TagElement tag = ast.newTagElement();
                tag.setTagName("@param");
                SimpleName paramName = ast.newSimpleName(param.getName().getIdentifier());
                tag.fragments().add(paramName);
                tags.add(tag);
            }
        }
        if (!((returnType = newMethod.getReturnType2()) == null || returnType.isPrimitiveType() && ((PrimitiveType)returnType).getPrimitiveTypeCode() == PrimitiveType.VOID)) {
            TagElement tag = ast.newTagElement();
            tag.setTagName("@return");
            tags.add(tag);
        }
        if (!(exceptions = newMethod.thrownExceptions()).isEmpty()) {
            for (Name exception : exceptions) {
                TagElement tag = ast.newTagElement();
                tag.setTagName("@throws");
                String name = exception.getFullyQualifiedName();
                if (exception.isQualifiedName()) {
                    String qualifier = Signature.getQualifier((String)name);
                    String simpleName = Signature.getSimpleName((String)name);
                    QualifiedName qualifiedName = ast.newQualifiedName(ast.newName(qualifier), ast.newSimpleName(simpleName));
                    tag.fragments().add(qualifiedName);
                    tags.add(tag);
                    continue;
                }
                String simpleName = Signature.getSimpleName((String)name);
                SimpleName sName = ast.newSimpleName(simpleName);
                tag.fragments().add(sName);
                tags.add(tag);
            }
        }
    }

    @Override
    protected void updateMethods(IProgressMonitor monitor, IMethod[] methods, ICompilationUnit workingCopyCU, IType type) throws JavaModelException {
        IResource resource = workingCopyCU.getUnderlyingResource();
        FileEditorInput editorInput = new FileEditorInput((IFile)resource);
        IDocument document = JavaUI.getDocumentProvider().getDocument((Object)editorInput);
        ASTParser parser = ASTParser.newParser((int)3);
        parser.setSource(workingCopyCU);
        CompilationUnit domCU = (CompilationUnit)parser.createAST(monitor);
        ASTRewrite rewrite = ASTRewrite.create((AST)domCU.getAST());
        TypeDeclaration domType = (TypeDeclaration)domCU.types().get(0);
        this.interfaceMethodsRewrite = rewrite.getListRewrite((ASTNode)domType, TypeDeclaration.BODY_DECLARATIONS_PROPERTY);
        this.interfaceImportsRewrite = rewrite.getListRewrite((ASTNode)domCU, CompilationUnit.IMPORTS_PROPERTY);
        super.updateMethods(monitor, methods, workingCopyCU, type);
        TextEdit edits = rewrite.rewriteAST();
        try {
            edits.apply(document);
        }
        catch (BadLocationException e) {
            throw new JavaModelException((Throwable)e, 4);
        }
    }

    @Override
    protected void updateMethod(IMethod aMethod, IType aType, ICompilationUnit cu) throws JavaModelException {
        this.promoteMethod(aMethod, aType, cu);
    }

    protected void promoteMethod(IMethod aMethod, IType aType, ICompilationUnit cu) throws JavaModelException {
        IMethod typeMethod = aType.getMethod(this.getInterfaceMethodName(aMethod), aMethod.getParameterTypes());
        if (!typeMethod.exists()) {
            MethodDeclaration newMethod = this.createInterfaceNode(aMethod, aType);
            if (newMethod != null) {
                this.interfaceMethodsRewrite.insertLast((ASTNode)newMethod, null);
            }
            this.addImports(aMethod, cu);
        }
    }

    protected void addImports(IMethod aMethod, ICompilationUnit cu) throws JavaModelException {
        String signature = aMethod.getSignature();
        HashSet<String> importNames = new HashSet<String>();
        String[] paramTypes = Signature.getParameterTypes((String)signature);
        for (int i = 0; i < paramTypes.length; ++i) {
            this.gatherTypeInfo(paramTypes[i], importNames);
        }
        ITypeParameter[] typeParams = aMethod.getTypeParameters();
        for (int i = 0; i < typeParams.length; ++i) {
            String[] bounds = typeParams[i].getBounds();
            for (int j = 0; j < bounds.length; ++j) {
                if (bounds[j].equals(WILDCARD_TYPE)) continue;
                String resolvedName = JDOMSearchHelper.resolveSimpleTypeName((IType)aMethod.getDeclaringType(), (String)bounds[j]);
                importNames.add(resolvedName);
            }
        }
        String rawReturnString = Signature.getReturnType((String)signature);
        this.gatherTypeInfo(rawReturnString, importNames);
        String[] exceptionTypes = aMethod.getExceptionTypes();
        for (int i = 0; i < exceptionTypes.length; ++i) {
            importNames.add(exceptionTypes[i]);
        }
        this.addImports(importNames, aMethod.getDeclaringType(), cu);
    }

    private void gatherTypeInfo(String qualifiedName, Set names) {
        String[] typeArguments;
        String erasureType = Signature.getTypeErasure((String)qualifiedName);
        if (erasureType != null) {
            names.add(erasureType);
        }
        if ((typeArguments = Signature.getTypeArguments((String)qualifiedName)) != null) {
            for (int i = 0; i < typeArguments.length; ++i) {
                char[] typeSig;
                char[] importSig = typeSig = typeArguments[i].toCharArray();
                if (Signature.getTypeSignatureKind((char[])typeSig) == 5) {
                    importSig = new char[typeSig.length - 1];
                    System.arraycopy(typeSig, 1, importSig, 0, importSig.length);
                }
                names.add(new String(importSig));
            }
        }
    }

    protected void addImports(Collection typeNames, IType aType, ICompilationUnit cu) throws JavaModelException {
        if (!typeNames.isEmpty()) {
            for (String typeName : typeNames) {
                String resolvedName;
                String name;
                try {
                    name = Signature.toString((String)typeName);
                    resolvedName = JDOMSearchHelper.resolveSimpleTypeName((IType)aType, (String)name);
                }
                catch (IllegalArgumentException e) {
                    name = null;
                    resolvedName = typeName;
                }
                if (name != null && name.equals(resolvedName) || resolvedName.startsWith("java.lang")) continue;
                int index = resolvedName.indexOf("[");
                if (index > 0) {
                    resolvedName = resolvedName.substring(0, index);
                }
                this.createImportNodeInInterface(resolvedName);
            }
        }
    }

    private void createImportNodeInInterface(String qualifiedName) {
        CompilationUnit cuAST = (CompilationUnit)this.interfaceImportsRewrite.getParent();
        boolean foundExisting = false;
        List importList = this.interfaceImportsRewrite.getRewrittenList();
        if (!importList.isEmpty()) {
            for (ImportDeclaration importDeclaration : importList) {
                String importQualifiedName = importDeclaration.getName().getFullyQualifiedName();
                if (!qualifiedName.equals(importQualifiedName)) continue;
                foundExisting = true;
                break;
            }
        }
        if (!foundExisting) {
            ImportDeclaration importDeclaration;
            AST ast = cuAST.getAST();
            importDeclaration = ast.newImportDeclaration();
            char[][] charFragments = CharOperation.splitOn((char)'.', (char[])qualifiedName.toCharArray(), (int)0, (int)qualifiedName.length());
            int length = charFragments.length;
            String[] strFragments = new String[length];
            for (int i = 0; i < length; ++i) {
                strFragments[i] = String.valueOf(charFragments[i]);
            }
            Name name = ast.newName(strFragments);
            importDeclaration.setName(name);
            this.interfaceImportsRewrite.insertLast((ASTNode)importDeclaration, null);
        }
    }
}

