/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.ejb.ui.java.actions;

import com.ibm.etools.j2ee.ui.plugin.J2EEUIPlugin;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jem.java.JavaClass;
import org.eclipse.jst.common.jdt.internal.integration.ui.WTPUIWorkingCopyManager;
import org.eclipse.jst.j2ee.internal.plugin.J2EEEditorUtility;
import org.eclipse.ui.actions.WorkspaceModifyOperation;

public abstract class InterfaceModificationOperation
extends WorkspaceModifyOperation {
    protected static final String FILTER_CREATE_METHOD_NAME = "ejbCreate";
    protected static final String FILTER_HOME_METHOD_NAME = "ejbHome";
    protected static final String CREATE_METHOD_NAME = "create";
    protected static final String FILTER_BMP_FIND_METHOD_PREFIX = "ejbFind";
    protected static final String BMP_FIND_METHOD_NAME_PREFIX = "find";
    protected IMethod[] classMethods;
    protected JavaClass interfaceClass;
    protected boolean isLocal = false;
    protected boolean isEJB20 = false;
    protected boolean isBMP = false;

    protected InterfaceModificationOperation(IMethod[] someClassMethods, JavaClass anInterface, boolean isLocalType) {
        this.classMethods = someClassMethods;
        this.interfaceClass = anInterface;
        this.isLocal = isLocalType;
    }

    protected IMethod[] getClassMethods() {
        return this.classMethods;
    }

    protected ICompilationUnit getInterfaceCU() {
        return J2EEEditorUtility.getCompilationUnit((JavaClass)this.getInterfaceClass(), (IJavaProject)this.getJavaProject());
    }

    protected ICompilationUnit getExistingInterfaceWorkingCopy(ICompilationUnit aCU) throws JavaModelException {
        if (aCU == null) {
            return null;
        }
        if (aCU.isWorkingCopy()) {
            return aCU;
        }
        return (ICompilationUnit)aCU.findSharedWorkingCopy(JavaUI.getBufferFactory());
    }

    protected JavaClass getInterfaceClass() {
        return this.interfaceClass;
    }

    protected IType getInterfaceType(ICompilationUnit aCU) throws JavaModelException {
        return aCU.getType(this.getInterfaceClass().getName());
    }

    protected IJavaProject getJavaProject() {
        return this.getClassMethods()[0].getJavaProject();
    }

    protected String getInterfaceMethodName(IMethod beanMethod) {
        return beanMethod.getElementName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void execute(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException, CoreException {
        IMethod[] methods = this.getClassMethods();
        if (methods.length == 0) {
            return;
        }
        WTPUIWorkingCopyManager wcMgr = new WTPUIWorkingCopyManager();
        try {
            ICompilationUnit cu = this.getInterfaceCU();
            ICompilationUnit workingCopyCU = wcMgr.getWorkingCopy(cu, false);
            boolean needsToSave = !wcMgr.isDirty(cu);
            IType type = this.getInterfaceType(workingCopyCU);
            this.updateMethods(monitor, methods, workingCopyCU, type);
            if (needsToSave) {
                wcMgr.saveCompilationUnits(monitor);
            }
        }
        catch (Exception e) {
            J2EEUIPlugin.logError(e);
        }
        finally {
            wcMgr.dispose();
        }
    }

    protected void updateMethods(IProgressMonitor monitor, IMethod[] methods, ICompilationUnit workingCopyCU, IType type) throws JavaModelException {
        for (int i = 0; i < methods.length; ++i) {
            this.updateMethod(methods[i], type, workingCopyCU);
            monitor.worked(1);
        }
    }

    protected abstract void updateMethod(IMethod var1, IType var2, ICompilationUnit var3) throws JavaModelException;

    public void setIsEJB20(boolean isEJB20) {
        this.isEJB20 = isEJB20;
    }

    public boolean isBMP() {
        return this.isBMP;
    }

    public void setIsBMP(boolean newIsBMP) {
        this.isBMP = newIsBMP;
    }

    public boolean isEJB20() {
        return this.isEJB20;
    }

    protected String getHomeInterfaceMethodName(IMethod beanMethod) {
        String methodName = beanMethod.getElementName();
        if (methodName.equals(FILTER_CREATE_METHOD_NAME)) {
            return CREATE_METHOD_NAME;
        }
        if (this.isEJB20() && methodName.startsWith(FILTER_CREATE_METHOD_NAME)) {
            return CREATE_METHOD_NAME + methodName.substring(FILTER_CREATE_METHOD_NAME.length());
        }
        if (methodName.startsWith(FILTER_HOME_METHOD_NAME)) {
            return this.setFirstAsLowercase(methodName.substring(FILTER_HOME_METHOD_NAME.length()));
        }
        if (this.isBMP() && methodName.startsWith(FILTER_BMP_FIND_METHOD_PREFIX)) {
            return BMP_FIND_METHOD_NAME_PREFIX + methodName.substring(FILTER_BMP_FIND_METHOD_PREFIX.length());
        }
        return methodName;
    }

    protected String setFirstAsLowercase(String aString) {
        if (aString == null || aString.length() == 0) {
            return aString;
        }
        char[] chars = aString.toCharArray();
        chars[0] = Character.toLowerCase(chars[0]);
        return new String(chars);
    }
}

