/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.ejb.ui.java.actions;

import com.ibm.etools.ejb.ui.java.actions.PromoteToInterfaceOperation;
import com.ibm.etools.ejb.ui.nls.EJBUIResourceHandler;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jem.internal.adapters.jdom.JDOMAdaptor;
import org.eclipse.jem.java.JavaClass;
import org.eclipse.jem.java.JavaRefFactory;
import org.eclipse.jem.java.Method;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jst.j2ee.ejb.EJBJar;
import org.eclipse.jst.j2ee.ejb.EnterpriseBean;
import org.eclipse.jst.j2ee.ejb.componentcore.util.EJBArtifactEdit;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.part.IPage;
import org.eclipse.ui.views.contentoutline.ContentOutline;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualResource;

public abstract class EJBPromoteAction
implements IObjectActionDelegate,
DisposeListener {
    protected static final String FILTER_METHOD_NAME = "ejbCreate";
    private IMethod[] selectedMethods;
    private IWorkbenchPart targetWorkbenchPart;
    private EnterpriseBean ejb;
    private boolean isEjbInitialized = false;
    private EJBArtifactEdit artifactEdit;
    private JavaClass javaClass;
    private Object currentData = null;

    protected EJBArtifactEdit getArtifactEdit() {
        return this.artifactEdit;
    }

    protected void setArtifactEdit(EJBArtifactEdit anArtifactEdit) {
        this.artifactEdit = anArtifactEdit;
    }

    protected EnterpriseBean getEjb() {
        if (!this.isEjbInitialized && this.getSelectedMethods() != null && this.getSelectedMethods().length > 0) {
            this.isEjbInitialized = true;
            this.initializeEJB();
        }
        return this.ejb;
    }

    protected void setEjb(EnterpriseBean anEJB) {
        this.ejb = anEJB;
        if (anEJB == null) {
            this.isEjbInitialized = false;
        }
    }

    protected void initializeEJB() {
        EJBJar jar;
        if (this.ejb != null) {
            return;
        }
        IJavaElement javaElemet = this.getJavaElement();
        this.initializeArtifactEdit(javaElemet);
        if (this.getArtifactEdit() != null && (jar = this.getArtifactEdit().getEJBJar()) != null) {
            this.setJavaClass(this.getJavaClass(javaElemet));
            this.setEjb(jar.getEnterpriseBeanWithReference(this.getJavaClass()));
        }
    }

    protected JavaClass getJavaClass(IJavaElement javaElement) {
        String className = javaElement.getElementName();
        int index = className.indexOf(".");
        if (index > -1) {
            className = className.substring(0, index);
        }
        IJavaElement packElement = javaElement.getParent();
        while (packElement.getElementType() != 4) {
            packElement = javaElement.getParent();
        }
        String packName = packElement.getElementName();
        return (JavaClass)JavaRefFactory.eINSTANCE.reflectType(packName, className, this.getArtifactEdit().getDeploymentDescriptorResource().getResourceSet());
    }

    protected IJavaElement getJavaElement() {
        if (this.currentData != null) {
            return (IJavaElement)this.currentData;
        }
        return null;
    }

    protected void initializeArtifactEdit(IJavaElement javaElement) {
        if (this.getArtifactEdit() == null && javaElement != null) {
            IProject project = javaElement.getJavaProject().getProject();
            IResource res = javaElement.getResource();
            IVirtualResource[] componentResources = ComponentCore.createResources((IResource)res);
            if (componentResources.length > 0) {
                this.setArtifactEdit(EJBArtifactEdit.getEJBArtifactEditForWrite((IProject)project));
            }
        }
    }

    protected boolean hasEjb() {
        return this.getEjb() != null;
    }

    protected boolean hasBeanClass() {
        return this.hasEjb() && this.getEjb().getEjbClass() == this.getJavaClass();
    }

    protected JavaClass getRemoteInterface() {
        if (this.getEjb() != null) {
            return this.getEjb().getRemoteInterface();
        }
        return null;
    }

    protected JavaClass getLocalInterface() {
        if (this.getEjb() != null) {
            return this.getEjb().getLocalInterface();
        }
        return null;
    }

    protected List getParameterTypes(IMethod aMethod) {
        String[] typeNames = aMethod.getParameterTypes();
        IType type = aMethod.getDeclaringType();
        String typeName = null;
        ArrayList<String> types = new ArrayList<String>(typeNames.length);
        for (int i = 0; i < typeNames.length; ++i) {
            typeName = JDOMAdaptor.convertJDOMtypeName((String)typeNames[i]);
            typeName = JDOMAdaptor.getResolvedTypeName((String)typeName, (IType)type);
            types.add(typeName);
        }
        return types;
    }

    protected String getPromotedMethodName(String aMethodName) {
        return aMethodName;
    }

    protected abstract PromoteToInterfaceOperation getPromoteToInterfaceOperation();

    protected IMethod[] getSelectedMethods() {
        return this.selectedMethods;
    }

    protected void updateSelectedMethods(ISelection sel) {
        Object[] vec;
        this.selectedMethods = null;
        if (sel instanceof IStructuredSelection && this.hasOnlyMethods(vec = ((IStructuredSelection)sel).toArray())) {
            this.selectedMethods = new IMethod[vec.length];
            for (int i = 0; i < vec.length; ++i) {
                this.selectedMethods[i] = (IMethod)vec[i];
            }
        }
    }

    protected boolean hasFilterMethodName() {
        IMethod[] methods = this.getSelectedMethods();
        for (int i = 0; i < methods.length; ++i) {
            if (!FILTER_METHOD_NAME.equals(methods[i].getElementName())) continue;
            return true;
        }
        return false;
    }

    protected boolean hasOnlyMethods(Object[] selectedObjects) {
        for (int i = 0; i < selectedObjects.length; ++i) {
            if (selectedObjects[i] instanceof IMethod) continue;
            return false;
        }
        return true;
    }

    protected boolean hasOnlyPublicMethodSelected() {
        IMethod[] methods = this.getSelectedMethods();
        try {
            for (int i = 0; i < methods.length; ++i) {
                if (Flags.isPublic((int)methods[i].getFlags())) continue;
                return false;
            }
        }
        catch (JavaModelException e) {
            return false;
        }
        return true;
    }

    protected boolean isAlreadyPromoted(JavaClass anInterface) {
        if (anInterface == null) {
            return true;
        }
        IMethod[] methods = this.getSelectedMethods();
        Method method = null;
        for (int i = 0; i < methods.length; ++i) {
            method = anInterface.getMethodExtended(this.getPromotedMethodName(methods[i].getElementName()), this.getParameterTypes(methods[i]));
            if (method == null) continue;
            return true;
        }
        return false;
    }

    public void run() {
        if (this.getSelectedMethods() != null) {
            Shell shell = this.getTargetShell();
            PromoteToInterfaceOperation op = this.getPromoteToInterfaceOperation();
            IStatus status = this.validateEdit(op.getInterfaceCU(), shell);
            if (status == null) {
                return;
            }
            if (!status.isOK()) {
                this.displayValidateEditError(status, shell);
                return;
            }
            ProgressMonitorDialog dialog = new ProgressMonitorDialog(shell);
            try {
                dialog.run(false, false, (IRunnableWithProgress)op);
            }
            catch (InvocationTargetException e1) {
                this.displayFailure(e1, shell);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    private void displayValidateEditError(IStatus status, Shell shell) {
        this.displayFailure(shell, status.getMessage());
    }

    private void displayFailure(InvocationTargetException e, Shell shell) {
        Throwable t = e.getTargetException();
        String message = null;
        if (t != null) {
            message = t.getMessage();
        }
        if (message == null) {
            message = "";
        }
        this.displayFailure(shell, message);
    }

    private IStatus validateEdit(ICompilationUnit cu, Shell aShell) {
        if (cu != null) {
            try {
                IResource res = cu.getUnderlyingResource();
                if (res.getType() == 1) {
                    return ResourcesPlugin.getWorkspace().validateEdit(new IFile[]{(IFile)res}, (Object)aShell);
                }
            }
            catch (JavaModelException e) {
                this.displayFailure(aShell, e.getMessage());
            }
        }
        return null;
    }

    private void displayFailure(Shell shell, String message) {
        MessageDialog.openError((Shell)shell, (String)EJBUIResourceHandler.Failed_to_promote_selected_methods_UI_, (String)message);
    }

    protected Shell getTargetShell() {
        Control ctrl = this.getTargetControl();
        if (ctrl != null) {
            return ctrl.getDisplay().getActiveShell();
        }
        return null;
    }

    protected Control getTargetControl() {
        return this.getTargetControl(this.targetWorkbenchPart);
    }

    protected Control getTargetControl(IWorkbenchPart aPart) {
        if (aPart != null && aPart instanceof ContentOutline) {
            IPage page = null;
            page = ((ContentOutline)aPart).getCurrentPage();
            if (page != null) {
                return page.getControl();
            }
        }
        return null;
    }

    public void run(IAction action) {
        this.run();
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.updateSelectedMethods(selection);
        if (!this.hasBeanClass() || this.getSelectedMethods() == null || !this.hasOnlyPublicMethodSelected()) {
            action.setEnabled(false);
        } else {
            action.setEnabled(this.updateSelection());
        }
    }

    protected boolean updateSelection() {
        return this.hasClientView();
    }

    protected abstract boolean hasClientView();

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        boolean sameControl;
        Control newControl = this.getTargetControl(targetPart);
        Object newData = null;
        if (newControl != null) {
            newData = newControl.getData();
        }
        if (this.currentData != null && this.currentData.equals(newData)) {
            return;
        }
        this.reset();
        this.currentData = newData;
        Control currentControl = this.getTargetControl();
        boolean bl = sameControl = newControl == currentControl;
        if (!sameControl && currentControl != null) {
            currentControl.removeDisposeListener((DisposeListener)this);
        }
        this.targetWorkbenchPart = targetPart;
        if (!sameControl && newControl != null) {
            newControl.addDisposeListener((DisposeListener)this);
        }
    }

    public void widgetDisposed(DisposeEvent e) {
    }

    protected void reset() {
        this.setEjb(null);
        this.setJavaClass(null);
    }

    public JavaClass getJavaClass() {
        return this.javaClass;
    }

    public void setJavaClass(JavaClass javaClass) {
        this.javaClass = javaClass;
    }

    protected boolean isLocalAction() {
        return false;
    }
}

