/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.ejb.ui.java;

import com.ibm.etools.ejb.ui.java.EJBJavaAdapter;
import com.ibm.etools.ejb.ui.java.EJBJavaMethodDecorator;
import com.ibm.etools.j2ee.ui.plugin.J2EEUIPlugin;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jem.java.JavaClass;
import org.eclipse.jem.java.JavaRefFactory;
import org.eclipse.jem.util.emf.workbench.ProjectUtilities;
import org.eclipse.jst.j2ee.ejb.EJBJar;
import org.eclipse.jst.j2ee.ejb.EnterpriseBean;
import org.eclipse.jst.j2ee.ejb.componentcore.util.EJBArtifactEdit;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualResource;
import org.eclipse.wst.common.internal.emfworkbench.integration.EditModel;
import org.eclipse.wst.common.internal.emfworkbench.integration.EditModelEvent;
import org.eclipse.wst.common.internal.emfworkbench.integration.EditModelListener;

public class EJBJavaModelManager {
    protected Map projectToArtifactEdits = new HashMap();
    protected EJBJavaMethodDecorator decorator;
    protected EditModelListener editModelListener;
    protected boolean isDisposing = false;

    public EJBJavaModelManager(EJBJavaMethodDecorator aDecorator) {
        this.decorator = aDecorator;
    }

    protected void createEJBJavaListener(final EnterpriseBean ejb, final ICompilationUnit cu) {
        if (ejb != null && EcoreUtil.getExistingAdapter((Notifier)ejb, (Object)"EJBJavaMethods") == null) {
            J2EEUIPlugin.getDefault().getWorkbench().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    IWorkbenchPage page = EJBJavaModelManager.this.getActivePage();
                    EJBJavaAdapter adapter = new EJBJavaAdapter(EJBJavaModelManager.this.decorator, cu, ejb, page.getActivePart());
                    ejb.eAdapters().add((Object)adapter);
                    page.addPartListener((IPartListener)adapter);
                }
            });
        }
    }

    protected IWorkbenchPage getActivePage() {
        return J2EEUIPlugin.getActiveWorkbenchWindow().getActivePage();
    }

    public EnterpriseBean getEnterperiseBeanForBeanClass(ICompilationUnit cu) {
        EJBArtifactEdit artifactEdit;
        EnterpriseBean ejb = null;
        if (cu != null && (artifactEdit = this.getEJBArtifactEdit(cu)) != null) {
            ejb = this.getEnterpriseBeanForBeanClass(cu, artifactEdit);
            this.createEJBJavaListener(ejb, cu);
        }
        return ejb;
    }

    protected EnterpriseBean getEnterpriseBeanForBeanClass(ICompilationUnit cu, EJBArtifactEdit artifactEdit) {
        JavaClass javaClass;
        EJBJar jar;
        EnterpriseBean ejb = null;
        if (cu != null && artifactEdit != null && (jar = artifactEdit.getEJBJar()) != null && ((ejb = jar.getEnterpriseBeanWithReference(javaClass = this.reflectJavaClass(cu, artifactEdit))) == null || ejb.getEjbClass() != javaClass)) {
            ejb = null;
        }
        return ejb;
    }

    protected JavaClass reflectJavaClass(ICompilationUnit cu, EJBArtifactEdit artifactEdit) {
        if (cu != null && artifactEdit != null) {
            ResourceSet set = artifactEdit.getEJBJarXmiResource().getResourceSet();
            String className = this.getSimpleName(cu);
            String packageName = this.getPackageName(cu);
            return (JavaClass)JavaRefFactory.eINSTANCE.reflectType(packageName, className, set);
        }
        return null;
    }

    protected String getSimpleName(ICompilationUnit cu) {
        if (cu != null) {
            String name = cu.getElementName();
            int dotIndex = name.lastIndexOf(46);
            if (dotIndex > -1) {
                return name.substring(0, dotIndex);
            }
            return name;
        }
        return null;
    }

    protected String getPackageName(ICompilationUnit cu) {
        if (cu != null) {
            return cu.getParent().getElementName();
        }
        return null;
    }

    protected EJBArtifactEdit getEJBArtifactEdit(ICompilationUnit cu) {
        EJBArtifactEdit artifactEdit = null;
        if (cu != null) {
            IResource res;
            IVirtualResource[] componentResources;
            IProject project = cu.getJavaProject().getProject();
            if (project != null) {
                artifactEdit = (EJBArtifactEdit)this.projectToArtifactEdits.get(project);
            }
            if (artifactEdit == null && (componentResources = ComponentCore.createResources((IResource)(res = cu.getResource()))).length > 0) {
                artifactEdit = EJBArtifactEdit.getEJBArtifactEditForRead((IProject)project);
                if (artifactEdit == null) {
                    return null;
                }
                artifactEdit.addListener(this.getEditModelListener());
                this.projectToArtifactEdits.put(project, artifactEdit);
            }
        }
        return artifactEdit;
    }

    protected EJBArtifactEdit getCachedArtifactEdit(IProject project) {
        if (project != null) {
            return (EJBArtifactEdit)this.projectToArtifactEdits.get(project);
        }
        return null;
    }

    protected void cacheArtifactEdit(EJBArtifactEdit artifactEdit, IProject project) {
        if (artifactEdit != null && project != null) {
            artifactEdit.addListener(this.getEditModelListener());
            this.projectToArtifactEdits.put(project, artifactEdit);
        }
    }

    protected void disposeArtifactEdit(EJBArtifactEdit artifactEdit) {
        this.projectToArtifactEdits.remove(ProjectUtilities.getProject((EObject)artifactEdit.getContentModelRoot()));
    }

    protected void dispose() {
        this.isDisposing = true;
        Iterator it = this.projectToArtifactEdits.values().iterator();
        EJBArtifactEdit artifactEdit = null;
        while (it.hasNext()) {
            artifactEdit = (EJBArtifactEdit)it.next();
            artifactEdit.dispose();
        }
        this.projectToArtifactEdits = null;
    }

    public EditModelListener getEditModelListener() {
        if (this.editModelListener == null) {
            this.editModelListener = new EditModelListener(){

                public void editModelChanged(EditModelEvent anEvent) {
                    if (!EJBJavaModelManager.this.isDisposing && anEvent.getEventCode() == 5) {
                        if (!anEvent.getChangedResources().isEmpty()) {
                            IProject project = ProjectUtilities.getProject(anEvent.getChangedResources().get(0));
                            EJBJavaModelManager.this.disposeArtifactEdit(EJBJavaModelManager.this.getCachedArtifactEdit(project));
                        } else {
                            EJBArtifactEdit artifactEdit;
                            EditModel editModel = anEvent.getEditModel();
                            if (editModel != null && (artifactEdit = EJBJavaModelManager.this.getCachedArtifactEdit(editModel.getProject())) != null) {
                                EJBJavaModelManager.this.disposeArtifactEdit(artifactEdit);
                            }
                        }
                    }
                }
            };
        }
        return this.editModelListener;
    }
}

