/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.ejb.ui.gef.widgets;

import com.ibm.etools.ejb.ui.gef.widgets.EJBFiguresResourceHandler;
import com.ibm.etools.ejb.ui.gef.widgets.RelationshipAction;
import java.util.ArrayList;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.MouseEvent;
import org.eclipse.draw2d.MouseListener;
import org.eclipse.draw2d.MouseMotionListener;
import org.eclipse.draw2d.PolylineConnection;
import org.eclipse.draw2d.PolylineDecoration;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;

public class RelationshipPolyLine
extends PolylineConnection
implements IMenuListener,
MouseListener,
MouseMotionListener {
    private boolean paintLineBoolean = false;
    private PolylineDecoration polyRightDec;
    private PolylineDecoration polyLeftDec;
    protected Cursor hand = new Cursor((Device)Display.getCurrent(), 21);
    protected Cursor arrow = new Cursor((Device)Display.getCurrent(), 0);
    public static final int RIGHT_END = 3;
    public static final int LEFT_END = 4;
    private ArrayList listeners = new ArrayList(3);
    Point currentPoint;

    public PolylineDecoration getPolyLeftDec() {
        return this.polyLeftDec;
    }

    public void setPolyLeftDec(PolylineDecoration polyLeftDec) {
        this.polyLeftDec = polyLeftDec;
    }

    public PolylineDecoration getPolyRightDec() {
        return this.polyRightDec;
    }

    public void setPolyRightDec(PolylineDecoration polyRightDec) {
        this.polyRightDec = polyRightDec;
    }

    public void addRelationshipMouseListner(MouseMotionListener mouseListener) {
        this.listeners.add(mouseListener);
    }

    public void mousePressed(MouseEvent me) {
        me.x = this.getEndInt(me.getLocation());
        this.notifyRelationshipMouseListeners(me);
    }

    public void mouseReleased(MouseEvent me) {
    }

    public void mouseDoubleClicked(MouseEvent me) {
    }

    public void mouseDragged(MouseEvent me) {
    }

    public void mouseEntered(MouseEvent me) {
        this.currentPoint = me.getLocation();
        me.x = this.getEndInt(me.getLocation());
        this.notifyRelationshipMouseListeners(me);
        this.setCursor(this.hand);
        this.paintLineBoolean = true;
        this.repaint();
        if (this.currentPoint == null) {
            return;
        }
    }

    public int getEndInt(Point point) {
        int start_x = (this.getStart().x + this.getEnd().x) / 2;
        if (point.x < start_x) {
            return 3;
        }
        return 4;
    }

    public void mouseExited(MouseEvent me) {
        this.setCursor(this.arrow);
        if (this.currentPoint == null) {
            return;
        }
    }

    public void mouseHover(MouseEvent me) {
    }

    public void mouseMoved(MouseEvent me) {
    }

    public RelationshipPolyLine(Control control) {
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.lineWidth = 2;
        this.setOutline(true);
    }

    protected void createContextMenuFor(Control control) {
        MenuManager contextMenu = new MenuManager("LABEL", "id");
        Menu menu = contextMenu.createContextMenu(control);
        contextMenu.setRemoveAllWhenShown(true);
        contextMenu.addMenuListener((IMenuListener)this);
        control.setMenu(menu);
    }

    protected void outlineShape(Graphics g) {
        super.outlineShape(g);
    }

    protected void paintClientArea(Graphics graphics) {
        super.paintClientArea(graphics);
        if (this.paintLineBoolean) {
            // empty if block
        }
        if (this.currentPoint == null) {
            return;
        }
        if (this.getEndInt(this.currentPoint) == 3) {
            graphics.drawLine(this.getStart().x, this.getStart().y, this.getEnd().x / 2 + 80, this.getEnd().y);
            graphics.drawLine(this.getStart().x, this.getStart().y - 1, this.getEnd().x / 2 + 80, this.getEnd().y - 1);
        } else {
            graphics.drawLine(this.getEnd().x / 2 + 80, this.getStart().y, this.getEnd().x, this.getEnd().y);
            graphics.drawLine(this.getEnd().x / 2 + 80, this.getStart().y - 1, this.getEnd().x, this.getEnd().y - 1);
        }
    }

    protected void notifyRelationshipMouseListeners(MouseEvent me) {
        for (int i = 0; i < this.listeners.size(); ++i) {
            ((MouseListener)this.listeners.get(i)).mousePressed(me);
        }
    }

    public void menuAboutToShow(IMenuManager manager) {
        MenuManager contextMenu = new MenuManager(EJBFiguresResourceHandler.getResourceString("RelationshipPolyLine_UI_0"), EJBFiguresResourceHandler.getResourceString("RelationshipPolyLine_UI_1"));
        MenuManager contextCmrMenu = new MenuManager(EJBFiguresResourceHandler.getResourceString("RelationshipPolyLine_UI_2"), EJBFiguresResourceHandler.getResourceString("RelationshipPolyLine_UI_3"));
        contextMenu.add((IAction)new RelationshipAction(EJBFiguresResourceHandler.getResourceString("RelationshipPolyLine_UI_4"), 0, this));
        contextMenu.add((IAction)new RelationshipAction(EJBFiguresResourceHandler.getResourceString("RelationshipPolyLine_UI_5"), 0, this));
        contextCmrMenu.add((IAction)new RelationshipAction(EJBFiguresResourceHandler.getResourceString("RelationshipPolyLine_UI_6"), 0, this));
        contextCmrMenu.add((IAction)new RelationshipAction(EJBFiguresResourceHandler.getResourceString("RelationshipPolyLine_UI_7"), 0, this));
        manager.add((IContributionItem)contextMenu);
        manager.add((IContributionItem)contextCmrMenu);
    }
}

