/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.ejb.ui.gef.widgets;

import com.ibm.etools.ejb.ui.gef.widgets.AlphaImageHelper;
import org.eclipse.draw2d.AbstractBorder;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;

public class DropShadowBorder
extends AbstractBorder {
    public static final Image BR;
    public static final Image BL;
    public static final Image TR;
    public static final Image R;
    public static final Image B;
    private static int SHADOW_WIDTH;
    private static int SHADOW_HEIGHT;
    private static int SHADOW_LEFT;
    private static int SHADOW_TOP;
    private static Insets INSETS;
    private static Dimension PREF_SIZE;

    public DropShadowBorder(Color color) {
        SHADOW_WIDTH = DropShadowBorder.BR.getBounds().width;
        SHADOW_HEIGHT = DropShadowBorder.BR.getBounds().height;
        SHADOW_LEFT = DropShadowBorder.BL.getBounds().width;
        SHADOW_TOP = DropShadowBorder.TR.getBounds().height;
        INSETS = new Insets(1, 1, SHADOW_HEIGHT + 1, SHADOW_WIDTH + 1);
    }

    public DropShadowBorder() {
        this(ColorConstants.black);
    }

    public Insets getInsets(IFigure figure) {
        return INSETS;
    }

    public Dimension getPreferredSize(IFigure figure) {
        return PREF_SIZE;
    }

    public boolean isOpaque() {
        return false;
    }

    public void paint(IFigure figure, Graphics g, Insets i) {
        int width = SHADOW_WIDTH;
        int height = SHADOW_HEIGHT;
        Rectangle r = DropShadowBorder.getPaintRectangle((IFigure)figure, (Insets)i);
        r.resize(-(width + 1), -(height + 1));
        g.drawRectangle(r);
        r.resize(1, 1);
        g.drawImage(BR, r.right(), r.bottom());
        g.drawImage(TR, r.right(), r.y);
        g.drawImage(BL, r.x, r.bottom());
        int stretch = r.width - SHADOW_LEFT;
        if (stretch > 0) {
            g.drawImage(B, 0, 0, DropShadowBorder.B.getBounds().width, height, r.x + SHADOW_LEFT, r.bottom(), stretch, height);
        }
        if ((stretch = r.height - SHADOW_TOP) > 0) {
            g.drawImage(R, 0, 0, DropShadowBorder.R.getBounds().width, DropShadowBorder.R.getBounds().height, r.right(), r.y + SHADOW_TOP, width, stretch);
        }
    }

    static {
        PREF_SIZE = new Dimension(SHADOW_WIDTH + SHADOW_LEFT + 3, SHADOW_HEIGHT + SHADOW_TOP + 3);
        BR = (Image)AlphaImageHelper.createAlphaImage(DropShadowBorder.class, "icons/shadowBR.bmp");
        TR = (Image)AlphaImageHelper.createAlphaImage(DropShadowBorder.class, "icons/shadowTR.bmp");
        BL = (Image)AlphaImageHelper.createAlphaImage(DropShadowBorder.class, "icons/shadowBL.bmp");
        R = (Image)AlphaImageHelper.createAlphaImage(DropShadowBorder.class, "icons/shadowR.bmp");
        B = (Image)AlphaImageHelper.createAlphaImage(DropShadowBorder.class, "icons/shadowB.bmp");
    }
}

