/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.ejb.ui.gef.widgets;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.draw2d.IFigure;
import org.eclipse.gef.internal.ui.palette.editparts.DrawerEditPart;
import org.eclipse.gef.internal.ui.palette.editparts.DrawerFigure;
import org.eclipse.gef.ui.palette.PaletteViewerPreferences;
import org.eclipse.gef.ui.palette.editparts.PaletteEditPart;

class DrawerAnimationController {
    private long startTime = System.currentTimeMillis();
    private long endTime = 0L;
    private long presentTime = 1L;
    private static final int NUM_OF_MILLISECONDS = 150;
    private boolean inProgress;
    private List drawers = new ArrayList();
    private DrawerFigure[] animate;
    private PaletteViewerPreferences prefs;

    public DrawerAnimationController(PaletteViewerPreferences prefs) {
        this.prefs = prefs;
    }

    public void addDrawer(DrawerEditPart drawer) {
        this.drawers.add(drawer);
    }

    public void animate(DrawerEditPart drawer) {
        int i;
        this.inProgress = true;
        drawer.getClass();
        if (drawer.getFigure().isExpanded()) {
            List categoriesToCollapse = this.getDrawersToCollapse(drawer);
            this.animate = new DrawerFigure[categoriesToCollapse.size() + 1];
            int count = 1;
            for (DrawerEditPart drwr : categoriesToCollapse) {
                drwr.setExpanded(false);
                this.animate[count++] = drwr.getFigure();
            }
            this.animate[0] = drawer.getFigure();
        } else {
            this.animate = new DrawerFigure[]{drawer.getFigure()};
        }
        for (i = 0; i < this.animate.length; ++i) {
            this.animate[i].revalidate();
        }
        this.animate[0].getParent().validate();
        for (i = 0; i < this.animate.length; ++i) {
            this.animate[i].setAnimating(true);
        }
        this.start();
        this.runAnimation();
        for (i = 0; i < this.animate.length; ++i) {
            this.animate[i].setAnimating(false);
            this.animate[i].revalidate();
        }
        this.animate[0].getUpdateManager().performUpdate();
        this.animate = null;
    }

    void runAnimation() {
        while (this.inProgress) {
            this.step();
        }
    }

    void step() {
        for (int i = 0; i < this.animate.length; ++i) {
            this.animate[i].revalidate();
        }
        this.presentTime = System.currentTimeMillis();
        this.animate[0].getUpdateManager().performUpdate();
        if (this.presentTime > this.endTime) {
            this.inProgress = false;
        }
    }

    public float getAnimationProgress() {
        if (this.presentTime > this.endTime) {
            return 1.0f;
        }
        long timePassed = this.presentTime - this.startTime;
        float progress = (float)timePassed / 150.0f;
        return progress;
    }

    public int getNumberOfOpenDrawers() {
        int count = 0;
        for (DrawerEditPart part : this.drawers) {
            if (!part.isExpanded()) continue;
            ++count;
        }
        return count;
    }

    public boolean isAnimationInProgress() {
        return this.inProgress;
    }

    public void removeDrawer(DrawerEditPart drawer) {
        this.drawers.remove(drawer);
    }

    public void start() {
        this.inProgress = true;
        this.presentTime = this.startTime = System.currentTimeMillis();
        this.endTime = this.startTime + 150L;
    }

    protected List getDrawersToCollapse(DrawerEditPart drawer) {
        int autoCollapseMode = this.prefs.getAutoCollapseSetting();
        if (autoCollapseMode == 1) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<Object> drawersToCollapse = new ArrayList<Object>();
        if (autoCollapseMode == 2) {
            for (DrawerEditPart cat : this.drawers) {
                if (!cat.isExpanded() || cat == drawer) continue;
                drawersToCollapse.add(cat);
            }
            return drawersToCollapse;
        }
        ArrayList<PaletteEditPart> potentialDrawersToCollapse = new ArrayList<PaletteEditPart>();
        DrawerFigure catFigure = drawer.getFigure();
        int availableWidth = catFigure.getParent().getClientArea().width;
        int availableHeight = catFigure.getParent().getSize().height;
        int requiredHeight = 0;
        for (PaletteEditPart part : drawer.getParent().getChildren()) {
            DrawerFigure figure;
            IFigure fig = part.getFigure();
            int height = fig.getPreferredSize((int)availableWidth, (int)-1).height;
            requiredHeight += height;
            if (!(part instanceof DrawerEditPart) || !(figure = (DrawerFigure)fig).isExpanded() || figure.isPinnedOpen()) continue;
            potentialDrawersToCollapse.add(part);
        }
        for (int i = potentialDrawersToCollapse.size() - 1; i >= 0 && requiredHeight > availableHeight; --i) {
            PaletteEditPart part;
            part = (DrawerEditPart)potentialDrawersToCollapse.get(i);
            if (part == drawer) continue;
            int expandedHeight = part.getFigure().getPreferredSize((int)availableWidth, (int)-1).height;
            part.setExpanded(false);
            int collapsedHeight = part.getFigure().getPreferredSize((int)availableWidth, (int)-1).height;
            requiredHeight -= expandedHeight - collapsedHeight;
            drawersToCollapse.add(part);
        }
        return drawersToCollapse;
    }
}

