/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.ejb.ui.dialogs;

import com.ibm.etools.ejb.ui.dialogs.PackageContainerSelectionDialog;
import com.ibm.etools.ejb.ui.nls.EJBUIResourceHandler;
import com.ibm.etools.j2ee.ejb.operations.ChangeKeyClassInfoProvider;
import java.util.Arrays;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaConventions;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.internal.ui.dialogs.FilteredTypesSelectionDialog;
import org.eclipse.jem.util.emf.workbench.ProjectUtilities;
import org.eclipse.jem.workbench.utility.JemProjectUtilities;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jst.j2ee.ejb.EJBJar;
import org.eclipse.jst.j2ee.ejb.EnterpriseBean;
import org.eclipse.jst.j2ee.internal.plugin.J2EEPlugin;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.IProgressService;

public class RequestNewKeyClassDialog
extends Dialog
implements ChangeKeyClassInfoProvider,
SelectionListener,
Listener {
    protected Button packagesButton;
    protected Text packageText;
    protected String packageName;
    protected Button keyClassButton;
    protected Text keyClassText;
    protected String keyClassName;
    protected boolean hasCancelled = false;
    protected Label messageLabel;
    protected Label messageText;
    protected EnterpriseBean ejb;
    protected Button useExistingClassButton;
    protected boolean primitiveError = false;
    protected Button createNewClassButton;
    protected boolean isExistingKeyClass;
    protected Button usePrimitiveTypeButton;
    protected boolean shouldUsePrimitiveType;
    protected boolean noKeyFields = false;
    private boolean cancelWarningFlag = false;

    public RequestNewKeyClassDialog(Shell parent) {
        super(parent);
    }

    public RequestNewKeyClassDialog(Shell parent, EnterpriseBean bean) {
        super(parent);
        this.ejb = bean;
    }

    public RequestNewKeyClassDialog(Shell parent, EnterpriseBean bean, boolean primitiveErrorFlag) {
        super(parent);
        this.ejb = bean;
        this.primitiveError = primitiveErrorFlag;
    }

    public RequestNewKeyClassDialog(Shell parent, EnterpriseBean bean, boolean primitiveErrorFlag, boolean cancelWarningFlag) {
        super(parent);
        this.ejb = bean;
        this.primitiveError = primitiveErrorFlag;
        this.cancelWarningFlag = cancelWarningFlag;
    }

    protected void cancelPressed() {
        this.hasCancelled = true;
        super.cancelPressed();
    }

    protected Button createCheckBox(Composite parent, String text, String key, boolean dflt) {
        Button result = new Button(parent, 32);
        result.setText(text);
        GridData gd = new GridData(768);
        gd.horizontalIndent = 10;
        result.setLayoutData((Object)gd);
        boolean selection = dflt;
        result.setSelection(selection);
        return result;
    }

    public Control createDialogArea(Composite parent) {
        Composite root = (Composite)super.createDialogArea(parent);
        String shellText = this.ejb != null ? NLS.bind((String)EJBUIResourceHandler.New_Key_Class_for_CMP_UI_, (Object[])new Object[]{this.ejb.getName()}) : EJBUIResourceHandler.New_Key_Class_UI_;
        this.getShell().setText(shellText);
        this.createInitialCompositeGroup(root);
        Composite composite = new Composite(root, 0);
        GridLayout lay = new GridLayout();
        lay.numColumns = 1;
        GridData data = new GridData(272);
        data.widthHint = 425;
        composite.setLayout((Layout)lay);
        composite.setLayoutData((Object)data);
        this.createTopLevelMessage(composite);
        this.createUsePrimitiveKeyGroup(composite);
        this.createNewKeyClassButtonGroup(composite);
        this.createUseExistingCheckboxGroup(composite);
        Composite composite2 = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        composite2.setLayout((Layout)layout);
        composite2.setLayoutData((Object)new GridData(272));
        this.createPackageNameGroup(composite2);
        this.createKeyClassNameGroup(composite2);
        this.createMessageTextGroup(composite2);
        this.createFinalCompositeGroup(root);
        this.setDefaults();
        return composite;
    }

    public void createFinalCompositeGroup(Composite parent) {
    }

    public void createInitialCompositeGroup(Composite parent) {
    }

    public void createKeyClassNameGroup(Composite parent) {
        Label message = new Label(parent, 0);
        message.setText(EJBUIResourceHandler.Key_class___UI_);
        GridData labelData = new GridData();
        labelData.horizontalIndent = 35;
        message.setLayoutData((Object)labelData);
        this.keyClassText = new Text(parent, 2052);
        GridData gridData = new GridData(768);
        gridData.widthHint = 200;
        this.keyClassText.setLayoutData((Object)gridData);
        this.keyClassText.addListener(24, (Listener)this);
        this.keyClassButton = new Button(parent, 8);
        GridData buttonData = new GridData();
        buttonData.widthHint = 60;
        this.keyClassButton.setLayoutData((Object)buttonData);
        this.keyClassButton.setText(EJBUIResourceHandler.Browse____UI_);
        this.keyClassButton.addListener(13, (Listener)this);
    }

    public void createMessageTextGroup(Composite composite) {
        Label emptyLabel = new Label(composite, 0);
        this.messageText = new Label(composite, 16456);
        GridData data = new GridData(768);
        data.horizontalSpan = 2;
        this.messageText.setLayoutData((Object)data);
        this.messageText.setBackground(emptyLabel.getBackground());
        this.messageText.setForeground(this.messageText.getDisplay().getSystemColor(3));
        if (this.cancelWarningFlag) {
            emptyLabel = new Label(composite, 0);
            this.messageLabel = new Label(composite, 16456);
            data = new GridData(768);
            data.horizontalSpan = 2;
            this.messageLabel.setLayoutData((Object)data);
            this.messageLabel.setBackground(emptyLabel.getBackground());
            this.messageLabel.setForeground(this.messageLabel.getDisplay().getSystemColor(3));
            this.messageLabel.setText(EJBUIResourceHandler.WARNING_FOR_CANCEL_UI_);
        }
    }

    public void createNewKeyClassButtonGroup(Composite parent) {
        this.createNewClassButton = new Button(parent, 16);
        this.createNewClassButton.setText(EJBUIResourceHandler.Create_a_new_key_class_UI_);
        GridData gd = new GridData(768);
        this.createNewClassButton.setLayoutData((Object)gd);
        this.createNewClassButton.addSelectionListener((SelectionListener)this);
    }

    public void createPackageNameGroup(Composite parent) {
        Label message = new Label(parent, 0);
        message.setText(EJBUIResourceHandler.Package___UI_);
        GridData labelData = new GridData();
        labelData.horizontalIndent = 35;
        message.setLayoutData((Object)labelData);
        this.packageText = new Text(parent, 2052);
        GridData gridData = new GridData(768);
        gridData.widthHint = 200;
        this.packageText.setLayoutData((Object)gridData);
        this.packageText.addListener(24, (Listener)this);
        this.packagesButton = new Button(parent, 8);
        GridData buttonData = new GridData();
        buttonData.widthHint = 60;
        this.packagesButton.setLayoutData((Object)buttonData);
        this.packagesButton.setText(EJBUIResourceHandler.Browse____UI_);
        this.packagesButton.addListener(13, (Listener)this);
    }

    public void createTopLevelMessage(Composite parent) {
        if (this.primitiveError) {
            Label message = new Label(parent, 64);
            message.setText(EJBUIResourceHandler.Primitive_Key_type_can_no__UI_);
            message.setForeground(message.getDisplay().getSystemColor(3));
        }
        Label blank = new Label(parent, 0);
        GridData data3 = new GridData(272);
        blank.setLayoutData((Object)data3);
    }

    public void createUseExistingCheckboxGroup(Composite parent) {
        this.useExistingClassButton = new Button(parent, 16);
        this.useExistingClassButton.setText(EJBUIResourceHandler.Use_an_existing_key_class_UI_);
        GridData gd = new GridData(768);
        this.useExistingClassButton.setLayoutData((Object)gd);
        this.useExistingClassButton.addSelectionListener((SelectionListener)this);
    }

    public void createUsePrimitiveKeyGroup(Composite parent) {
    }

    public EnterpriseBean getEnterpriseBean() {
        return this.ejb;
    }

    public String getKeyClassName() {
        return this.keyClassName;
    }

    public String getKeyClassPackageName() {
        return this.packageName;
    }

    public void handleBrowseClassButton() {
        Shell shell = this.keyClassButton.getShell();
        EJBJar selectedObject = this.ejb.getEjbJar();
        IProject ejbProject = ProjectUtilities.getProject((EObject)selectedObject);
        IJavaSearchScope searchScope = SearchEngine.createJavaSearchScope((IJavaElement[])new IJavaElement[]{JemProjectUtilities.getJavaProject((IProject)ejbProject)});
        IProgressService service = PlatformUI.getWorkbench().getProgressService();
        FilteredTypesSelectionDialog dialog = new FilteredTypesSelectionDialog(shell, false, (IRunnableContext)service, searchScope, 2);
        dialog.setTitle(EJBUIResourceHandler.Type_Selection_Dialog_UI_);
        dialog.setMessage(EJBUIResourceHandler.Select_an_exisitng_key_cla_UI_);
        dialog.open();
        Object[] types = dialog.getResult();
        if (types != null && types.length > 0) {
            String qualifiedName = ((IType)types[0]).getFullyQualifiedName();
            String javaName = ((IType)types[0]).getElementName();
            this.keyClassText.setText(javaName);
            this.keyClassName = javaName;
            this.packageText.setText(qualifiedName.substring(0, qualifiedName.length() - javaName.length() - 1));
            this.packageName = qualifiedName.substring(0, qualifiedName.length() - javaName.length() - 1);
        }
    }

    public void handleEvent(Event event) {
        if (this.noKeyFields) {
            return;
        }
        if (event.widget == this.keyClassButton) {
            this.handleBrowseClassButton();
        }
        if (event.widget == this.packagesButton) {
            this.handlePackagesButton();
        }
        if (this.packageText == null || this.keyClassText == null) {
            return;
        }
        IStatus javaPackageStatus = JavaConventions.validatePackageName((String)this.packageText.getText());
        IStatus javaKeyClassStatus = JavaConventions.validateJavaTypeName((String)this.keyClassText.getText());
        if (this.keyClassText.getText().equals("")) {
            if (this.useExistingClassButton.getSelection()) {
                this.messageText.setText(EJBUIResourceHandler.Browse_for_an_existing_key_UI_);
            } else {
                this.messageText.setText(EJBUIResourceHandler.Specify_a_class_name__UI_);
            }
        } else if (!javaPackageStatus.isOK()) {
            this.messageText.setText(javaPackageStatus.getMessage());
        } else if (!this.isClassNameValid(this.keyClassText.getText())) {
            this.messageText.setText(EJBUIResourceHandler.Specify_a_class_name__UI_);
        } else if (!javaKeyClassStatus.isOK()) {
            this.messageText.setText(javaKeyClassStatus.getMessage());
        } else {
            if (this.messageText == null) {
                return;
            }
            this.messageText.setText("");
        }
    }

    public void handlePackagesButton() {
        IProject ejbProject = null;
        EJBJar selectedObject = this.ejb.getEjbJar();
        ejbProject = ProjectUtilities.getProject((EObject)selectedObject);
        Shell shell = this.packagesButton.getShell();
        PackageContainerSelectionDialog dialog = new PackageContainerSelectionDialog(shell, (IContainer)ejbProject, false, EJBUIResourceHandler.Select_a_Package__INFO_);
        dialog.open();
        IPath selectedPath = (IPath)(dialog.getResult() == null || Arrays.asList(dialog.getResult()).isEmpty() ? null : Arrays.asList(dialog.getResult()).get(0));
        if (selectedPath != null) {
            String fullPackagePath = selectedPath.toString();
            ResourcesPlugin.getWorkspace().validatePath(fullPackagePath, 2);
            this.packageText.setText(selectedPath.removeFirstSegments(2).toString().replace('/', '.'));
        }
    }

    protected boolean isClassNameValid(String name) {
        if (name.equals("")) {
            return false;
        }
        for (int i = 0; i < name.length(); ++i) {
            if (Character.isJavaIdentifierPart(name.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public boolean isExistingKeyClass() {
        return this.isExistingKeyClass;
    }

    public boolean isHasCancelled() {
        return this.hasCancelled;
    }

    protected boolean isPackageNameValid(String name) {
        for (int i = 0; i < name.length(); ++i) {
            if (!(name.charAt(i) == '.' ? i == 0 || i == name.length() - 1 || name.charAt(i + 1) == '.' : !Character.isJavaIdentifierPart(name.charAt(i)))) continue;
            return false;
        }
        return true;
    }

    protected void okPressed() {
        if (this.usePrimitiveTypeButton == null && !this.useExistingClassButton.getSelection() && !this.createNewClassButton.getSelection()) {
            return;
        }
        if (!this.messageText.getText().equals("")) {
            return;
        }
        this.packageName = this.packageText.getText();
        this.keyClassName = this.keyClassText.getText();
        this.isExistingKeyClass = this.useExistingClassButton.getSelection();
        super.okPressed();
    }

    protected void setDefaults() {
        if (!J2EEPlugin.hasDevelopmentRole()) {
            this.createNewClassButton.setSelection(false);
            this.createNewClassButton.setEnabled(false);
        }
        this.createNewClassButton.setSelection(true);
        if (this.ejb != null && this.ejb.isEntity()) {
            this.keyClassText.setText(this.ejb.getName() + "Key");
            this.packageText.setText(this.ejb.getEjbClass().getJavaPackage().getName());
        }
        this.keyClassButton.setEnabled(false);
    }

    public boolean shouldUsePrimitiveKeyAttributeType() {
        return this.shouldUsePrimitiveType;
    }

    public boolean shouldDeleteObsoleteKeyClass() {
        return true;
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void widgetSelected(SelectionEvent e) {
        if (e.getSource() == this.useExistingClassButton) {
            this.packagesButton.setEnabled(false);
            this.packageText.setEnabled(false);
            this.keyClassText.setEnabled(false);
            this.keyClassButton.setEnabled(true);
            this.packageText.setText("");
            this.keyClassText.setText("");
        }
        if (e.getSource() == this.createNewClassButton) {
            this.packageText.setEnabled(true);
            this.packagesButton.setEnabled(true);
            this.keyClassText.setEnabled(true);
            this.keyClassButton.setEnabled(false);
            this.keyClassText.setText(this.ejb.getName() + "Key");
            this.packageText.setText(this.ejb.getEjbClass().getJavaPackage().getName());
        }
    }
}

