/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.ejb.ui.dialogs;

import com.ibm.etools.ejb.ui.dialogs.PackageContainerSelectionGroup;
import java.util.ArrayList;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.runtime.IPath;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ISelectionValidator;
import org.eclipse.ui.dialogs.SelectionDialog;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;

public class PackageContainerSelectionDialog
extends SelectionDialog {
    private PackageContainerSelectionGroup group;
    private IContainer initialSelection;
    private boolean allowNewContainerName = true;
    private Label statusMessage;
    private ISelectionValidator validator;

    public PackageContainerSelectionDialog(Shell parentShell, IContainer initialRoot, boolean allowNewContainerName, String message) {
        super(parentShell);
        this.setTitle(IDEWorkbenchMessages.ContainerSelectionDialog_title);
        this.initialSelection = initialRoot;
        this.allowNewContainerName = allowNewContainerName;
        if (message != null) {
            this.setMessage(message);
        } else {
            this.setMessage(IDEWorkbenchMessages.ContainerSelectionDialog_message);
        }
        this.setShellStyle(this.getShellStyle() | 0x10);
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)shell, "org.eclipse.ui.container_selection_dialog_context");
    }

    protected Control createDialogArea(Composite parent) {
        Composite aDialogArea = (Composite)super.createDialogArea(parent);
        Listener listener = new Listener(){

            public void handleEvent(Event event) {
                if (PackageContainerSelectionDialog.this.statusMessage != null && PackageContainerSelectionDialog.this.validator != null) {
                    String errorMsg = PackageContainerSelectionDialog.this.validator.isValid((Object)PackageContainerSelectionDialog.this.group.getContainerFullPath());
                    if (errorMsg == null || errorMsg.equals("")) {
                        PackageContainerSelectionDialog.this.statusMessage.setText("");
                        PackageContainerSelectionDialog.this.getOkButton().setEnabled(true);
                    } else {
                        PackageContainerSelectionDialog.this.statusMessage.setForeground(PackageContainerSelectionDialog.this.statusMessage.getDisplay().getSystemColor(3));
                        PackageContainerSelectionDialog.this.statusMessage.setText(errorMsg);
                        PackageContainerSelectionDialog.this.getOkButton().setEnabled(false);
                    }
                }
            }
        };
        this.group = new PackageContainerSelectionGroup(aDialogArea, listener, this.allowNewContainerName, this.getMessage(), this.initialSelection);
        if (this.initialSelection != null) {
            this.group.setSelectedContainer(this.initialSelection);
        }
        this.statusMessage = new Label(parent, 0);
        this.statusMessage.setLayoutData((Object)new GridData(1808));
        return aDialogArea;
    }

    protected void okPressed() {
        ArrayList<IPath> chosenContainerPathList = new ArrayList<IPath>();
        chosenContainerPathList.add(this.group.getContainerFullPath());
        this.setResult(chosenContainerPathList);
        super.okPressed();
    }

    public void setValidator(ISelectionValidator validator) {
        this.validator = validator;
    }
}

