/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.ejb.ui.dialogs;

import com.ibm.etools.ejb.ui.nls.EJBUIResourceHandler;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jst.j2ee.common.CommonPackage;
import org.eclipse.jst.j2ee.common.SecurityRole;
import org.eclipse.jst.j2ee.ejb.AssemblyDescriptor;
import org.eclipse.jst.j2ee.ejb.EJBJar;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wst.common.internal.emfworkbench.integration.ModifierHelper;

public class AddSecurityRoleDialog
extends Dialog
implements ISelectionChangedListener,
Listener {
    protected Text name;
    protected EJBJar jar;
    protected Text description;
    protected SecurityRole result;
    protected ModifierHelper helper;

    public AddSecurityRoleDialog(String windowTitle, Image windowImage, Shell shell) {
        super(shell);
    }

    public AddSecurityRoleDialog(Shell shell) {
        this(null, null, shell);
    }

    public AddSecurityRoleDialog(Shell shell, EJBJar jar) {
        this(null, null, shell);
        this.setJar(jar);
    }

    public Control createDialogArea(Composite parent) {
        Composite iconComposite = (Composite)super.createDialogArea(parent);
        this.getShell().setText(EJBUIResourceHandler.EJB_Security_Roles);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        iconComposite.setLayout((Layout)layout);
        GridData data = new GridData();
        data.verticalAlignment = 4;
        data.horizontalAlignment = 4;
        data.widthHint = 300;
        iconComposite.setLayoutData((Object)data);
        Label label = new Label(iconComposite, 16384);
        label.setText(EJBUIResourceHandler.Name_);
        data = new GridData();
        data.horizontalAlignment = 4;
        label.setLayoutData((Object)data);
        this.name = new Text(iconComposite, 2052);
        data = new GridData(272);
        data.grabExcessHorizontalSpace = true;
        data.widthHint = 100;
        this.name.setLayoutData((Object)data);
        label = new Label(iconComposite, 16384);
        label.setText(EJBUIResourceHandler.Description_);
        data = new GridData();
        data.horizontalAlignment = 4;
        label.setLayoutData((Object)data);
        this.description = new Text(iconComposite, 2052);
        data = new GridData();
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        data.verticalAlignment = 2;
        data.grabExcessVerticalSpace = false;
        this.description.setLayoutData((Object)data);
        this.name.setFocus();
        return iconComposite;
    }

    public ModifierHelper getHelper() {
        return this.helper;
    }

    protected EJBJar getJar() {
        return this.jar;
    }

    public SecurityRole getResult() {
        return this.result;
    }

    public void handleEvent(Event e) {
    }

    protected void initializeWidgets() {
    }

    protected void okPressed() {
        boolean flag = true;
        AssemblyDescriptor assembly = this.getJar().getAssemblyDescriptor();
        String roleName = this.name.getText();
        String roleDescription = this.description.getText();
        if (assembly == null) {
            flag = false;
        } else if (assembly.getSecurityRoleNamed(roleName) == null) {
            flag = false;
        } else {
            MessageDialog.openWarning((Shell)this.getShell(), (String)"Duplicate Role", (String)"Role already exsist");
        }
        if (roleName == null || roleName.trim().length() == 0 || flag) {
            if (!flag) {
                MessageDialog.openWarning((Shell)this.getShell(), (String)EJBUIResourceHandler.Role_name_empty_WARN__WARN_, (String)EJBUIResourceHandler.Role_name_can_not_be_empty_WARN__WARN_);
            }
            this.open();
        } else {
            CommonPackage pack = CommonPackage.eINSTANCE;
            ModifierHelper modifier = new ModifierHelper();
            modifier.addAttribute((EStructuralFeature)pack.getSecurityRole_RoleName(), (Object)roleName);
            if (roleDescription.length() > 0) {
                modifier.addAttribute((EStructuralFeature)pack.getSecurityRole_Description(), (Object)roleDescription);
            }
            this.setHelper(modifier);
        }
        super.okPressed();
    }

    public int open() {
        return super.open();
    }

    public void selectionChanged(SelectionChangedEvent event) {
    }

    public void setHelper(ModifierHelper newHelper) {
        this.helper = newHelper;
    }

    protected void setJar(EJBJar newJar) {
        this.jar = newJar;
    }
}

