/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.ejb.ui.dialogs;

import com.ibm.etools.ejb.ui.nls.EJBUIResourceHandler;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jst.j2ee.common.CommonPackage;
import org.eclipse.jst.j2ee.common.SecurityRole;
import org.eclipse.jst.j2ee.ejb.Entity;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wst.common.internal.emfworkbench.integration.ModifierHelper;

public class AddEJBResourceDialog
extends Dialog
implements ISelectionChangedListener,
SelectionListener,
Listener {
    protected Text name;
    protected Text textValue;
    protected ModifierHelper helper;
    protected Text homeValue;
    protected Text remoteValue;
    protected Text linkValue;
    protected Text descriptText;
    protected Text description;
    protected SecurityRole result;
    protected Combo methodCombo;
    protected Combo methodTypeCombo;
    protected Combo transCombo;
    protected Combo enviroCombo;
    protected Combo refTypeCombo;
    protected Combo combo;
    protected Object ejbjar;
    protected IStructuredSelection Iselect;

    public AddEJBResourceDialog(String windowTitle, Image windowImage, Shell shell) {
        super(shell);
    }

    public AddEJBResourceDialog(IStructuredSelection selection, Object ejb, Shell shell) {
        this(EJBUIResourceHandler.Add_Method_Permission, null, shell);
        this.setEjbjar(ejb);
        this.setIselect(selection);
    }

    public AddEJBResourceDialog(IStructuredSelection selection, Shell shell) {
        this(EJBUIResourceHandler.Add_Method_Permission, null, shell);
        this.setIselect(selection);
    }

    public void changeComboItems() {
        Object[] home = null;
        String[] methods = null;
        if (this.getIselect().getFirstElement() instanceof Entity) {
            Entity ent = (Entity)this.getIselect().getFirstElement();
            home = ent.getRemoteInterface().getMethodElementSignatures().toArray();
            methods = new String[home.length];
            for (int x = 0; x < home.length; ++x) {
                methods[x] = (String)home[x];
            }
        }
        this.combo.setItems(methods);
        if (methods != null) {
            this.combo.setText((String)methods[0]);
        }
    }

    public Control createDialogArea(Composite parent) {
        Composite iconComposite = (Composite)super.createDialogArea(parent);
        GridLayout lay = new GridLayout();
        lay.numColumns = 2;
        GridData data = new GridData(768);
        iconComposite.setLayout((Layout)lay);
        iconComposite.setLayoutData((Object)data);
        this.getShell().setText(EJBUIResourceHandler.New_EJB_Resource);
        Label labelName = new Label(iconComposite, 0);
        labelName.setText(EJBUIResourceHandler.Name);
        this.name = new Text(iconComposite, 2048);
        GridData data6 = new GridData();
        data6.widthHint = 150;
        this.name.setLayoutData((Object)data6);
        Label labela = new Label(iconComposite, 0);
        labela.setText(EJBUIResourceHandler.Type);
        this.enviroCombo = new Combo(iconComposite, 2060);
        Object[] values = CommonPackage.eINSTANCE.getEjbRefType().getELiterals().toArray();
        String[] enviromentValues = new String[values.length];
        for (int i = 0; i < values.length; ++i) {
            enviromentValues[i] = values[i].toString();
        }
        this.enviroCombo.setItems(enviromentValues);
        GridData data1 = new GridData(768);
        this.enviroCombo.setLayoutData((Object)data1);
        Label homeLabel = new Label(iconComposite, 0);
        homeLabel.setText("Home");
        this.homeValue = new Text(iconComposite, 2048);
        GridData data2 = new GridData(768);
        this.homeValue.setLayoutData((Object)data2);
        Label value = new Label(iconComposite, 0);
        value.setText("Remote");
        this.remoteValue = new Text(iconComposite, 2048);
        GridData data3 = new GridData(768);
        this.remoteValue.setLayoutData((Object)data3);
        Label link = new Label(iconComposite, 0);
        link.setText("Link");
        this.linkValue = new Text(iconComposite, 2048);
        GridData data4 = new GridData(768);
        this.linkValue.setLayoutData((Object)data4);
        Label descript = new Label(iconComposite, 0);
        descript.setText("Description");
        descript.setLayoutData((Object)new GridData(2));
        this.descriptText = new Text(iconComposite, 2050);
        GridData data5 = new GridData(768);
        data5.heightHint = 60;
        this.descriptText.setLayoutData((Object)data5);
        this.enviroCombo.setFocus();
        return iconComposite;
    }

    public Object getEjbjar() {
        return this.ejbjar;
    }

    public ModifierHelper getHelper() {
        return this.helper;
    }

    protected IStructuredSelection getIselect() {
        return this.Iselect;
    }

    public SecurityRole getResult() {
        return this.result;
    }

    public void handleEvent(Event e) {
        if (e.widget == this.combo) {
            this.getShell();
        }
        if (e.widget == this.methodTypeCombo && (this.methodTypeCombo.getText().equalsIgnoreCase("Remote") || this.methodTypeCombo.getText().equalsIgnoreCase("<Unspecified>"))) {
            this.changeComboItems();
        }
    }

    protected void initializeWidgets() {
    }

    void newMethod() {
    }

    protected void okPressed() {
        String refName = this.name.getText();
        String refType = this.enviroCombo.getText();
        String refHome = this.homeValue.getText();
        String refRemote = this.remoteValue.getText();
        String des = this.descriptText.getText();
        if (refName == null || refType == null || refHome == null || refRemote == null || des == null) {
            this.result = null;
        } else {
            CommonPackage pack = CommonPackage.eINSTANCE;
            ModifierHelper modifier = new ModifierHelper();
            if (refName.trim().length() == 0) {
                modifier.addAttribute((EStructuralFeature)pack.getEjbRef_Name(), (Object)refName);
            }
            if (refType.trim().length() == 0) {
                modifier.addAttribute((EStructuralFeature)pack.getEjbRef_Type(), (Object)refType);
            }
            if (refHome.trim().length() == 0) {
                modifier.addAttribute((EStructuralFeature)pack.getEjbRef_Home(), (Object)refHome);
            }
            if (refRemote.trim().length() == 0) {
                modifier.addAttribute((EStructuralFeature)pack.getEjbRef_Remote(), (Object)refRemote);
            }
            if (this.linkValue.getText() != null && this.linkValue.getText() != "") {
                modifier.addAttribute((EStructuralFeature)pack.getEjbRef_Link(), (Object)this.linkValue.getText());
            }
            modifier.addAttribute((EStructuralFeature)pack.getEjbRef_Description(), (Object)des);
            this.setHelper(modifier);
        }
        super.okPressed();
    }

    public int open() {
        return super.open();
    }

    public void selectionChanged(SelectionChangedEvent event) {
        event.getSelectionProvider();
    }

    public void setEjbjar(Object newEjbjar) {
        this.ejbjar = newEjbjar;
    }

    public void setHelper(ModifierHelper newHelper) {
        this.helper = newHelper;
    }

    public void setIselect(IStructuredSelection newIselect) {
        this.Iselect = newIselect;
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void widgetDoubleSelected(SelectionEvent e) {
    }

    public void widgetSelected(SelectionEvent e) {
        if (e.widget == this.combo) {
            this.getShell();
        }
        if (e.widget == this.methodTypeCombo) {
            this.methodTypeCombo.getText();
            this.getShell();
        }
    }
}

