/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.ejb.ui.actions.standalone;

import com.ibm.etools.application.nls.ApplicationEditorResourceHandler;
import com.ibm.etools.ejb.ui.actions.standalone.AbstractEJBAction;
import com.ibm.etools.ejb.ui.operations.RemoveReferenceDataModel;
import com.ibm.etools.ejb.ui.operations.RemoveReferenceOperation;
import com.ibm.etools.j2ee.ui.plugin.J2EEUIPlugin;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IProject;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jem.util.emf.workbench.ProjectUtilities;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jst.j2ee.client.ApplicationClient;
import org.eclipse.jst.j2ee.common.CommonPackage;
import org.eclipse.jst.j2ee.ejb.EJBJar;
import org.eclipse.jst.j2ee.ejb.EnterpriseBean;
import org.eclipse.jst.j2ee.webapplication.WebApp;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.wst.common.frameworks.internal.operations.IHeadlessRunnableWithProgress;

public class RemoveReferenceOperationBasedAction
extends AbstractEJBAction {
    private static RemoveReferenceOperationBasedAction instance = null;
    protected static final EClass EJBREF_CLASS = CommonPackage.eINSTANCE.getEjbRef();
    protected static final EClass EJBLOCALREF_CLASS = CommonPackage.eINSTANCE.getEJBLocalRef();
    protected static final EClass RESREF_CLASS = CommonPackage.eINSTANCE.getResourceRef();
    protected static final EClass RESENVREF_CLASS = CommonPackage.eINSTANCE.getResourceEnvRef();
    protected static final EClass SECROLEREF_CLASS = CommonPackage.eINSTANCE.getSecurityRoleRef();

    public static RemoveReferenceOperationBasedAction getInstance() {
        if (null == instance) {
            instance = new RemoveReferenceOperationBasedAction();
        }
        return instance;
    }

    private RemoveReferenceOperationBasedAction() {
        super(ApplicationEditorResourceHandler.REMOVE_MENU_LABEL_UI_);
    }

    public RemoveReferenceOperationBasedAction(String label) {
        super(label);
    }

    protected void doRun(Shell shell) {
        RemoveReferenceDataModel model = new RemoveReferenceDataModel();
        model.setProperty("RemoveReferenceDataModel.STRUCTURED_SELETION", this.getStructuredSelection());
        model.setProperty("ArtifactEditOperationDataModel.PROJECT_NAME", this.getSelectedProjectName());
        RemoveReferenceOperation op = new RemoveReferenceOperation(model);
        try {
            op.run(null);
        }
        catch (InvocationTargetException e) {
            J2EEUIPlugin.logError(e.toString());
        }
        catch (InterruptedException e) {
            J2EEUIPlugin.logError(e.toString());
        }
    }

    private Object getSelectedProjectName() {
        IProject project = this.getSelectedProject();
        if (project != null) {
            return project.getName();
        }
        return null;
    }

    private IProject getSelectedProject() {
        IStructuredSelection selectedReferences = this.getStructuredSelection();
        EObject ref = (EObject)selectedReferences.getFirstElement();
        EObject container = ref.eContainer();
        if (container instanceof ApplicationClient || container instanceof WebApp) {
            return ProjectUtilities.getProject((EObject)container);
        }
        if (container instanceof EnterpriseBean) {
            EJBJar project = ((EnterpriseBean)container).getEjbJar();
            return ProjectUtilities.getProject((EObject)project);
        }
        return null;
    }

    public static boolean isReferenceType(Object anObject) {
        if (anObject != null && anObject instanceof EObject) {
            EObject refObject = (EObject)anObject;
            EClass meta = refObject.eClass();
            return meta == EJBREF_CLASS || meta == EJBLOCALREF_CLASS || meta == RESREF_CLASS || meta == RESENVREF_CLASS || meta == SECROLEREF_CLASS;
        }
        return false;
    }

    @Override
    public boolean updateSelection(IStructuredSelection selection) {
        if (!super.updateSelection(selection)) {
            return false;
        }
        boolean result = false;
        for (Object obj : selection) {
            if (RemoveReferenceOperationBasedAction.isReferenceType(obj)) {
                result = true;
                continue;
            }
            return false;
        }
        return result;
    }

    @Override
    protected IHeadlessRunnableWithProgress getHeadlessOperation() {
        RemoveReferenceDataModel model = new RemoveReferenceDataModel();
        model.setProperty("RemoveReferenceDataModel.STRUCTURED_SELETION", this.getStructuredSelection());
        model.setProperty("ArtifactEditOperationDataModel.PROJECT_NAME", this.getSelectedProjectName());
        RemoveReferenceOperation op = new RemoveReferenceOperation(model);
        return op;
    }
}

