/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.ejb.ui.actions.standalone;

import com.ibm.etools.ejb.ui.actions.standalone.AbstractEJBAction;
import com.ibm.etools.ejb.ui.nls.EJBUIResourceHandler;
import com.ibm.etools.j2ee.ejb.operations.RemoveRelationshipDataModel;
import com.ibm.etools.j2ee.ejb.operations.RemoveRelationshipDataModelOperation;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jem.util.emf.workbench.ProjectUtilities;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jst.j2ee.ejb.CommonRelationship;
import org.eclipse.jst.j2ee.ejb.CommonRelationshipRole;
import org.eclipse.jst.j2ee.ejb.EJBJar;
import org.eclipse.jst.j2ee.ejb.EJBRelation;
import org.eclipse.jst.j2ee.ejb.EnterpriseBean;
import org.eclipse.wst.common.frameworks.internal.operations.IHeadlessRunnableWithProgress;

public class DeleteRelationshipAction
extends AbstractEJBAction {
    private static DeleteRelationshipAction instance = null;

    public static DeleteRelationshipAction getInstance() {
        if (null == instance) {
            instance = new DeleteRelationshipAction();
        }
        return instance;
    }

    private DeleteRelationshipAction() {
        super(EJBUIResourceHandler.Delete);
    }

    @Override
    protected IHeadlessRunnableWithProgress getHeadlessOperation() {
        List rels = this.getSelectedRelationships();
        if (rels == null || rels.isEmpty()) {
            return null;
        }
        RemoveRelationshipDataModel model = new RemoveRelationshipDataModel();
        model.setProperty("RemoveRelationshipDataModel.COMMON_RELATIONSHIP_LIST", (Object)rels);
        model.setProperty("ArtifactEditOperationDataModel.PROJECT_NAME", this.getSelectedProjectName());
        return new RemoveRelationshipDataModelOperation(model);
    }

    private Object getSelectedProjectName() {
        IProject selected = this.getSelectedProject();
        if (selected == null) {
            return null;
        }
        return selected.getName();
    }

    private IProject getSelectedProject() {
        IStructuredSelection selectedReferences = this.getStructuredSelection();
        EObject rel = (EObject)selectedReferences.getFirstElement();
        EObject container = rel.eContainer();
        if (container instanceof EnterpriseBean) {
            EJBJar project = ((EnterpriseBean)container).getEjbJar();
            return ProjectUtilities.getProject((EObject)project);
        }
        if (container instanceof EJBRelation) {
            EJBRelation relation = (EJBRelation)container;
            EJBJar project = relation.getFirstCommonRole().getSourceEntity().getEjbJar();
            return ProjectUtilities.getProject((EObject)project);
        }
        return null;
    }

    protected List getSelectedRelationships() {
        int size = this.getStructuredSelection().size();
        ArrayList<Object> list = new ArrayList<Object>(size);
        if (size == 1) {
            Object first = this.getStructuredSelection().getFirstElement();
            if (first instanceof CommonRelationship) {
                list.add(first);
            } else {
                list.add(((CommonRelationshipRole)first).getCommonRelationship());
            }
        } else {
            for (Object object : this.getStructuredSelection()) {
                if (object instanceof CommonRelationship) {
                    list.add(object);
                    continue;
                }
                list.add(((CommonRelationshipRole)object).getCommonRelationship());
            }
        }
        return list;
    }

    @Override
    public boolean updateSelection(IStructuredSelection sel) {
        if (sel.size() != 1 || !super.updateSelection(sel)) {
            return false;
        }
        Object first = sel.getFirstElement();
        if (first == null) {
            return false;
        }
        if (first instanceof CommonRelationship) {
            return true;
        }
        if (first instanceof CommonRelationshipRole) {
            return ((CommonRelationshipRole)first).getCommonRelationship() != null;
        }
        return false;
    }
}

