/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.ejb.ui.actions.standalone;

import com.ibm.etools.emf.workbench.ui.listeners.AnnotationsValidateEditListener;
import com.ibm.etools.emf.workbench.ui.listeners.IValidateEditListener;
import com.ibm.etools.j2ee.ui.plugin.J2EEUIPlugin;
import java.lang.reflect.InvocationTargetException;
import java.util.Iterator;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.common.command.BasicCommandStack;
import org.eclipse.emf.common.command.CommandStack;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jem.util.emf.workbench.ProjectUtilities;
import org.eclipse.jem.workbench.utility.JemProjectUtilities;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jst.j2ee.internal.plugin.J2EEPlugin;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.eclipse.ui.actions.SelectionListenerAction;
import org.eclipse.wst.common.frameworks.internal.operations.IHeadlessRunnableWithProgress;
import org.eclipse.wst.common.frameworks.internal.operations.IOperationHandler;
import org.eclipse.wst.common.frameworks.internal.ui.UIOperationHandler;
import org.eclipse.wst.common.frameworks.internal.ui.WTPUIPlugin;

public abstract class AbstractEJBAction
extends SelectionListenerAction
implements IWorkbenchWindowActionDelegate {
    protected static final String ERROR_BOX_TEXT = "Error executing command";
    private boolean applicable = false;
    protected static boolean CAN_BE_APPLICABLE = J2EEPlugin.isEJBSupportAvailable();
    private CommandStack commandStack;
    private IWorkbenchWindow workbenchWindow;
    private IOperationHandler operationHandler;
    private IValidateEditListener validateEditListener;

    public AbstractEJBAction(String label) {
        super(label);
    }

    public void actionPerformed(IAction action) {
        this.run(action);
    }

    protected IOperationHandler createOperationHandler() {
        return new UIOperationHandler(this.getWorkbenchWindow().getShell());
    }

    protected void displayError(Exception e) {
        Throwable t = e;
        while (t instanceof InvocationTargetException) {
            t = ((InvocationTargetException)t).getTargetException();
        }
        if (t != null) {
            this.displayError(t.toString());
        }
    }

    protected Shell getErrorDialogShell() {
        return J2EEUIPlugin.getActiveWorkbenchWindow().getShell();
    }

    protected void displayError(String message) {
        int iIconType = 1;
        MessageBox messageBox = new MessageBox(this.getErrorDialogShell(), 0x20 | iIconType | 0x10000);
        messageBox.setText(ERROR_BOX_TEXT);
        messageBox.setMessage(message);
        messageBox.open();
    }

    public void dispose() {
    }

    protected CommandStack getCommandStack() {
        if (this.commandStack == null) {
            this.commandStack = new BasicCommandStack();
        }
        return this.commandStack;
    }

    protected abstract IHeadlessRunnableWithProgress getHeadlessOperation();

    protected IRunnableWithProgress getOperation() {
        IHeadlessRunnableWithProgress headlessOp = this.getHeadlessOperation();
        if (headlessOp == null) {
            return null;
        }
        return WTPUIPlugin.getRunnableWithProgress((IHeadlessRunnableWithProgress)headlessOp);
    }

    protected IOperationHandler getOperationHandler() {
        if (this.operationHandler == null) {
            this.operationHandler = this.createOperationHandler();
        }
        return this.operationHandler;
    }

    protected ProgressMonitorDialog getProgressDialog() {
        return new ProgressMonitorDialog(this.getWorkbenchWindow().getShell());
    }

    protected IRunnableContext getRunnableContext() {
        return this.getWorkbenchWindow();
    }

    public IWorkbenchWindow getWorkbenchWindow() {
        if (this.workbenchWindow == null) {
            return JavaPlugin.getActiveWorkbenchWindow();
        }
        return this.workbenchWindow;
    }

    public void init(IWorkbenchWindow window) {
        this.setWorkbenchWindow(window);
    }

    protected int openErrorDialog(String title, String message) {
        IStatus status = J2EEUIPlugin.newErrorStatus(message, null);
        return ErrorDialog.openError((Shell)this.getWorkbenchWindow().getShell(), (String)title, null, (IStatus)status);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        IRunnableWithProgress runnable = this.getOperation();
        if (runnable != null) {
            IRunnableContext context = this.getRunnableContext();
            try {
                context.run(false, false, runnable);
            }
            catch (InterruptedException e) {
                this.displayError(e);
            }
            catch (InvocationTargetException e) {
                this.displayError(e);
            }
            finally {
                if (context instanceof ProgressMonitorDialog) {
                    ((ProgressMonitorDialog)context).close();
                }
            }
        }
    }

    public void run(IAction action) {
        action.run();
    }

    public void selectionChanged(IAction action, ISelection selection) {
        if (selection instanceof IStructuredSelection) {
            this.selectionChanged((IStructuredSelection)selection);
            action.setEnabled(this.updateSelection((IStructuredSelection)selection));
        }
    }

    public void setCommandStack(CommandStack newCommandStack) {
        this.commandStack = newCommandStack;
    }

    public void setWorkbenchWindow(IWorkbenchWindow newWorkbenchWindow) {
        this.workbenchWindow = newWorkbenchWindow;
    }

    protected IValidateEditListener getValidateEditListener() {
        return this.validateEditListener;
    }

    protected void setValidateEditListener(IValidateEditListener validateEditListener) {
        this.validateEditListener = validateEditListener;
    }

    protected boolean validateState() {
        IValidateEditListener listener = this.getValidateEditListener();
        if (listener != null) {
            if (listener instanceof AnnotationsValidateEditListener) {
                return ((AnnotationsValidateEditListener)listener).validateState().isOK();
            }
            return this.getValidateEditListener().validateState().isOK();
        }
        return true;
    }

    public final boolean isApplicable() {
        return this.applicable;
    }

    protected void setApplicable(boolean b) {
        this.applicable = b;
    }

    protected boolean updateSelection(IStructuredSelection selection) {
        this.applicable = false;
        if (!CAN_BE_APPLICABLE) {
            return false;
        }
        if (null == selection) {
            return false;
        }
        if (selection.size() > 0) {
            Iterator iterator = selection.iterator();
            Object next = iterator.next();
            if (next instanceof EObject) {
                IProject project = ProjectUtilities.getProject((EObject)((EObject)next));
                if (project == null) {
                    return false;
                }
                while (iterator.hasNext()) {
                    next = iterator.next();
                    IProject another = null;
                    if (next instanceof EObject) {
                        another = ProjectUtilities.getProject((EObject)((EObject)next));
                        if (!JemProjectUtilities.isBinaryProject((IProject)another) && project.equals((Object)another)) continue;
                        return false;
                    }
                    return false;
                }
            }
        } else {
            return false;
        }
        return true;
    }

    public EObject getTarget() {
        IStructuredSelection selection = this.getStructuredSelection();
        if (selection != null && !selection.isEmpty()) {
            return (EObject)selection.getFirstElement();
        }
        return null;
    }
}

