/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.ejb.creation.wizard;

import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jst.j2ee.internal.ejb.project.StringMatcher;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.SelectionDialog;

public class ElementListSelectionDialog
extends SelectionDialog {
    private Object[] fElements;
    private int[] fFilteredElements;
    private ILabelProvider fRenderer;
    private boolean fIgnoreCase;
    private Object[] fResult;
    protected Table fList;
    protected Text fText;
    protected Label fMessage;
    protected Button okButton;
    private String[] fRenderedStrings;
    private String fRememberedMatchText;
    private boolean fIsMultipleSelection;
    private String fMessageText;

    public ElementListSelectionDialog(Shell shell, Object[] elements, ILabelProvider renderer, boolean ignoreCase, boolean multipleSelection) {
        super(shell);
        this.fElements = elements;
        this.fRenderer = renderer;
        this.fIgnoreCase = ignoreCase;
        this.fIsMultipleSelection = multipleSelection;
        this.fFilteredElements = new int[this.fElements.length + 1];
        this.fMessageText = "";
        this.fRenderedStrings = this.renderStrings(this.fElements);
    }

    public void create() {
        super.create();
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.okButton = this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    public Control createDialogArea(Composite parent) {
        Composite contents = (Composite)super.createDialogArea(parent);
        ((GridLayout)contents.getLayout()).numColumns = 1;
        this.fMessage = this.createMessage(contents);
        this.fText = this.createText(contents);
        this.fList = this.createList(contents);
        this.fResult = null;
        this.fText.setFocus();
        this.rematch("");
        return contents;
    }

    protected Table createList(Composite parent) {
        int flags = 0;
        if (this.fIsMultipleSelection) {
            flags |= 2;
        }
        Table list = new Table(parent, flags | 0x800 | 0x200 | 0x100);
        list.addListener(13, new Listener(){

            public void handleEvent(Event evt) {
                ElementListSelectionDialog.this.handleSelectionChanged();
            }
        });
        list.addListener(8, new Listener(){

            public void handleEvent(Event evt) {
                ElementListSelectionDialog.this.handleDoubleClick();
            }
        });
        GridData spec = new GridData();
        spec.widthHint = 200;
        spec.heightHint = 200;
        spec.horizontalAlignment = 4;
        spec.verticalAlignment = 1;
        list.setLayoutData((Object)spec);
        return list;
    }

    protected Label createMessage(Composite parent) {
        Label text = new Label(parent, 0);
        text.setText(this.fMessageText);
        GridData spec = new GridData();
        spec.grabExcessVerticalSpace = false;
        spec.grabExcessHorizontalSpace = true;
        spec.horizontalAlignment = 4;
        spec.verticalAlignment = 1;
        text.setLayoutData((Object)spec);
        return text;
    }

    protected Text createText(Composite parent) {
        Text text = new Text(parent, 2048);
        GridData spec = new GridData();
        spec.grabExcessVerticalSpace = false;
        spec.grabExcessHorizontalSpace = true;
        spec.horizontalAlignment = 4;
        spec.verticalAlignment = 1;
        text.setLayoutData((Object)spec);
        Listener l = new Listener(){

            public void handleEvent(Event evt) {
                ElementListSelectionDialog.this.rematch(ElementListSelectionDialog.this.fText.getText());
            }
        };
        text.addListener(24, l);
        return text;
    }

    public Object[] getResult() {
        return this.fResult;
    }

    private Object[] getSelected() {
        if (this.fList == null || this.fList.isDisposed()) {
            return new Object[0];
        }
        int[] listSelection = this.fList.getSelectionIndices();
        Object[] selected = new Object[listSelection.length];
        for (int i = 0; i < listSelection.length; ++i) {
            selected[i] = this.fElements[this.fFilteredElements[listSelection[i]]];
        }
        return selected;
    }

    private void handleDoubleClick() {
        if (this.getSelected().length > 0) {
            this.buttonPressed(0);
        }
    }

    private void handleSelectionChanged() {
        if (this.okButton != null) {
            this.okButton.setEnabled(this.getSelected().length > 0);
        }
    }

    protected void okPressed() {
        this.fResult = this.getSelected();
        super.okPressed();
    }

    private void quickSort(String[] keys, Object[] values, int left, int right) {
        int original_left = left;
        int original_right = right;
        String mid = keys[(left + right) / 2];
        while (true) {
            if (this.smaller(keys[left], mid)) {
                ++left;
                continue;
            }
            while (this.smaller(mid, keys[right])) {
                --right;
            }
            if (left <= right) {
                String tmp = keys[left];
                keys[left] = keys[right];
                keys[right] = tmp;
                Object tmp2 = values[left];
                values[left] = values[right];
                values[right] = tmp2;
                ++left;
                --right;
            }
            if (left > right) break;
        }
        if (original_left < right) {
            this.quickSort(keys, values, original_left, right);
        }
        if (left < original_right) {
            this.quickSort(keys, values, left, original_right);
        }
    }

    private void rematch(String matchString) {
        int k = 0;
        String text = this.fText.getText();
        if (text.equals(this.fRememberedMatchText)) {
            return;
        }
        this.fRememberedMatchText = text;
        StringMatcher matcher = new StringMatcher(text + "*", this.fIgnoreCase, false);
        for (int i = 0; i < this.fElements.length; ++i) {
            if (!matcher.match(this.fRenderedStrings[i])) continue;
            this.fFilteredElements[k] = i;
            ++k;
        }
        this.fFilteredElements[k] = -1;
        this.updateListWidget(this.fFilteredElements, k);
    }

    private String[] renderStrings(Object[] p) {
        String[] strings = new String[p.length];
        for (int i = 0; i < strings.length; ++i) {
            strings[i] = this.fRenderer.getText(p[i]);
        }
        if (strings.length > 1) {
            this.quickSort(strings, p, 0, strings.length - 1);
        }
        return strings;
    }

    public void setMessage(String message) {
        if (message == null) {
            message = "";
        }
        this.fMessageText = message;
        if (this.fMessage != null && !this.fMessage.isDisposed()) {
            this.fMessage.setText(message);
        }
    }

    private boolean smaller(String left, String right) {
        return left.toLowerCase().compareTo(right.toLowerCase()) < 0;
    }

    private void updateListWidget(int[] indices, int size) {
        if (this.fList == null || this.fList.isDisposed()) {
            return;
        }
        this.fList.setRedraw(false);
        int itemCount = this.fList.getItemCount();
        if (size < itemCount) {
            this.fList.remove(0, itemCount - size - 1);
        }
        TableItem[] items = this.fList.getItems();
        for (int i = 0; i < size; ++i) {
            TableItem ti = null;
            ti = i < itemCount ? items[i] : new TableItem(this.fList, i);
            ti.setText(this.fRenderedStrings[indices[i]]);
            Image img = this.fRenderer.getImage(this.fElements[indices[i]]);
            if (img == null) continue;
            ti.setImage(img);
        }
        if (this.fList.getItemCount() > 0) {
            this.fList.setSelection(0);
        }
        this.fList.setRedraw(true);
        this.handleSelectionChanged();
    }
}

