/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.ejb.creation.model.wizard;

import com.ibm.etools.ejb.creation.model.wizard.ActivationConfigListItemProvider;
import com.ibm.etools.ejb.creation.model.wizard.ActivationConfigTableObjects;
import com.ibm.etools.ejb.creation.model.wizard.MDBActivationConfgUtil;
import com.ibm.etools.ejb.creation.model.wizard.TableData;
import com.ibm.etools.ejb.creation.ui.nls.EJBCreationUIResourceHandler;
import com.ibm.etools.webtools.flatui.SnappyTableViewer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jst.j2ee.ejb.ActivationConfigProperty;
import org.eclipse.jst.j2ee.ejb.internal.impl.ActivationConfigPropertyImpl;
import org.eclipse.jst.j2ee.ejb.internal.impl.EjbFactoryImpl;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;

public class MDBTableComposite
extends Composite {
    IDataModel mdbDataModel;
    ActivationConfigTableObjects tableObjects;
    Button addButton;
    Button removeButton;
    ArrayList tableDataList;
    private static String[] EMPTY_STRINGS = new String[]{"", ""};
    private static final int VALUE_NOT_FOUND = -1;
    private static final int NAME_COLUMN = 0;
    private static final int VALUE_COLUMN = 1;
    private Table table;
    private SnappyTableViewer viewer = null;
    private CellEditor[] columnEditors;
    private String[] columnProperties;

    public MDBTableComposite(Composite parent, int style) {
        super(parent, style);
        this.createContents();
    }

    private void createContents() {
        this.createTableViewer();
        this.createButtons();
    }

    private void createButtons() {
        Composite buttonComposite = new Composite((Composite)this, 0);
        GridLayout layout = new GridLayout();
        GridData data = new GridData(2);
        buttonComposite.setLayout((Layout)layout);
        buttonComposite.setLayoutData((Object)data);
        this.addButton = new Button(buttonComposite, 0);
        this.removeButton = new Button(buttonComposite, 0);
        this.addButton.setText(EJBCreationUIResourceHandler._And_Add____UI_);
        this.removeButton.setText(EJBCreationUIResourceHandler._And_Remove_UI_);
        this.removeButton.setEnabled(false);
        GridData buttonData = new GridData(768);
        this.addButton.setLayoutData((Object)buttonData);
        buttonData = new GridData(768);
        this.removeButton.setLayoutData((Object)buttonData);
        this.createButtonSelectionListeners(this.addButton, this.removeButton);
    }

    private void createButtonSelectionListeners(Button addButton2, Button removeButton2) {
        this.addButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                TableData tableData = new TableData("", "");
                MDBTableComposite.this.getTableDataList().add(tableData);
                MDBTableComposite.this.viewer.setInput((Object)MDBTableComposite.this.getTableDataList());
                MDBTableComposite.this.viewer.editElement((Object)tableData, 0);
                MDBTableComposite.this.removeButton.setEnabled(true);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.removeButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (MDBTableComposite.this.table.getSelection().length == 0) {
                    return;
                }
                TableItem item = MDBTableComposite.this.table.getSelection()[0];
                if (item == null || item.getData() == null) {
                    return;
                }
                TableData data = (TableData)item.getData();
                MDBTableComposite.this.getTableDataList().remove(data);
                this.removeActivationConfigKeyValue(new String[]{data.getName(), data.getValue()});
                MDBTableComposite.this.viewerRefresh();
            }

            public void removeActivationConfigKeyValue(String[] keyValue) {
                List configs = (List)MDBTableComposite.this.mdbDataModel.getProperty("ICreateMessageDrivenBeanDataModelProperties.activationConfig");
                ActivationConfigPropertyImpl configProperty = null;
                boolean foundKeyAndValue = false;
                for (int i = 0; i < configs.size(); ++i) {
                    configProperty = (ActivationConfigPropertyImpl)configs.get(i);
                    String name = configProperty.getName();
                    String value = configProperty.getValue();
                    if (!keyValue[0].equals(name) || !keyValue[1].equals(value)) continue;
                    foundKeyAndValue = true;
                    break;
                }
                if (configProperty != null && foundKeyAndValue) {
                    configs.remove(configProperty);
                    MDBTableComposite.this.mdbDataModel.setProperty("ICreateMessageDrivenBeanDataModelProperties.activationConfig", (Object)configs);
                    MDBTableComposite.this.mdbDataModel.notifyPropertyChange("ICreateMessageDrivenBeanDataModelProperties.activationConfig", 1);
                }
                if (configs.size() == 0) {
                    MDBTableComposite.this.removeButton.setEnabled(false);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    private void createTableViewer() {
        this.table = new Table((Composite)this, 2048);
        this.table.setHeaderVisible(true);
        this.table.setLinesVisible(true);
        this.viewer = new SnappyTableViewer(this.table);
        this.viewer.setSingleClickCellSelect(true);
        ActivationConfigListItemProvider provider = new ActivationConfigListItemProvider();
        this.viewer.setContentProvider((IContentProvider)provider);
        this.viewer.setLabelProvider((IBaseLabelProvider)provider);
        GridData data = new GridData(1808);
        this.table.setLayoutData((Object)data);
        this.setupTableColumns(this.table, this.viewer);
    }

    private void setupTableColumns(Table table, SnappyTableViewer viewer) {
        TableLayout tableLayout = new TableLayout();
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(10, true));
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(10, true));
        table.setLayout((Layout)tableLayout);
        TableColumn nameColumn = new TableColumn(table, 0);
        nameColumn.setText(EJBCreationUIResourceHandler.MDBActivationHeaderName);
        nameColumn.setResizable(true);
        TableColumn valueColumn = new TableColumn(table, 0);
        valueColumn.setText(EJBCreationUIResourceHandler.MDBActivationHeaderValue);
        valueColumn.setResizable(true);
        this.setupCellModifiers(table, viewer);
    }

    private void setupCellModifiers(Table table, SnappyTableViewer viewer) {
        this.columnProperties = new String[2];
        this.columnProperties[0] = "names";
        this.columnProperties[1] = "values";
        viewer.setColumnProperties(this.columnProperties);
        this.columnEditors = new CellEditor[table.getColumnCount()];
        this.columnEditors[0] = new ComboBoxCellEditor((Composite)table, EMPTY_STRINGS);
        this.columnEditors[1] = new ComboBoxCellEditor((Composite)table, EMPTY_STRINGS);
        viewer.setCellEditors(this.columnEditors);
        this.addCellModifier(viewer);
    }

    protected int getPropertyIntValue(String property) {
        if (this.columnProperties != null) {
            for (int i = 0; i < this.columnProperties.length; ++i) {
                if (!this.columnProperties[i].equals(property)) continue;
                return i;
            }
        }
        return -1;
    }

    protected CellEditor getCellEditor(String property) {
        int comboCellEditorIndex = this.getPropertyIntValue(property);
        if (comboCellEditorIndex == -1) {
            return null;
        }
        return this.columnEditors[comboCellEditorIndex];
    }

    protected ComboBoxCellEditor getComboBoxCellEditor(String property) {
        CellEditor cellEditor = this.getCellEditor(property);
        if (cellEditor instanceof ComboBoxCellEditor) {
            return (ComboBoxCellEditor)cellEditor;
        }
        return null;
    }

    protected void addCellModifier(SnappyTableViewer viewer) {
        viewer.setCellModifier(new ICellModifier(){

            public boolean canModify(Object element, String property) {
                ComboBoxCellEditor cellEditor = MDBTableComposite.this.getComboBoxCellEditor(property);
                return cellEditor != null;
            }

            private String[] getComboItems(String property) {
                ComboBoxCellEditor cellEditor = MDBTableComposite.this.getComboBoxCellEditor(property);
                if (cellEditor == null) {
                    return null;
                }
                return cellEditor.getItems();
            }

            private int getIndexOfComboStrings(String property, String value) {
                String[] comboItems = this.getComboItems(property);
                if (comboItems == null) {
                    return -1;
                }
                for (int i = 0; i < comboItems.length; ++i) {
                    if (!comboItems[i].equals(value)) continue;
                    return i;
                }
                return -1;
            }

            public Object getValue(Object element, String property) {
                int propertyInt = MDBTableComposite.this.getPropertyIntValue(property);
                int comboIndex = 0;
                TableData data = (TableData)element;
                ComboBoxCellEditor comboCellEditor = MDBTableComposite.this.getComboBoxCellEditor(property);
                MDBTableComposite.this.updateComboCellEditor(element, property, comboCellEditor);
                switch (propertyInt) {
                    case 0: {
                        String[] items = MDBTableComposite.this.addCurrentComboString(data.getName(), this.getComboItems(property));
                        comboCellEditor.setItems(items);
                        comboIndex = this.getIndexOfComboStrings(property, data.getName());
                        break;
                    }
                    case 1: {
                        String[] items = MDBTableComposite.this.addCurrentComboString(data.getValue(), this.getComboItems(property));
                        comboCellEditor.setItems(items);
                        comboIndex = this.getIndexOfComboStrings(property, data.getValue());
                        break;
                    }
                }
                return new Integer(comboIndex);
            }

            public void modify(Object element, String property, Object value) {
                int propertyInt = MDBTableComposite.this.getPropertyIntValue(property);
                String valueString = null;
                TableItem item = (TableItem)element;
                Table parent = item.getParent();
                int lastIndex = parent.getSelectionIndex();
                String[] comboItems = this.getComboItems(property);
                int itemIndex = (Integer)value;
                if (itemIndex == -1) {
                    valueString = MDBTableComposite.this.getComboText(property);
                } else {
                    valueString = comboItems[itemIndex];
                    if (valueString == "" || !valueString.equals(MDBTableComposite.this.getComboText(property))) {
                        valueString = MDBTableComposite.this.getComboText(property);
                    }
                }
                TableData data = (TableData)item.getData();
                switch (propertyInt) {
                    case 0: {
                        String oldName = data.getName();
                        data.setName(valueString);
                        if (valueString == null || valueString.length() <= 0 || oldName.equals(valueString)) break;
                        this.addActivationConfigKeyValue(MDBTableComposite.this.getKeyValueStringArray(data), property, lastIndex);
                        break;
                    }
                    case 1: {
                        data.setValue(valueString);
                        if (valueString == null) break;
                        this.addActivationConfigKeyValue(MDBTableComposite.this.getKeyValueStringArray(data), property, lastIndex);
                        this.validateTableItemsAndModelForDestinationType(valueString);
                    }
                }
                MDBTableComposite.this.viewerRefresh();
            }

            public void addActivationConfigKeyValue(String[] keyValue, String property, int curIndex) {
                List configsProperties = (List)MDBTableComposite.this.mdbDataModel.getProperty("ICreateMessageDrivenBeanDataModelProperties.activationConfig");
                ActivationConfigPropertyImpl configProperty = null;
                boolean foundKey = false;
                for (int i = 0; i < configsProperties.size(); ++i) {
                    configProperty = (ActivationConfigPropertyImpl)configsProperties.get(i);
                    if (i != curIndex) continue;
                    foundKey = true;
                    break;
                }
                if (configProperty != null && foundKey) {
                    if (!configProperty.getName().equals(keyValue[0])) {
                        configProperty.setName(keyValue[0]);
                        MDBTableComposite.this.mdbDataModel.notifyPropertyChange("ICreateMessageDrivenBeanDataModelProperties.activationConfig", 1);
                    } else if (configProperty.getValue() != null && property.equals("names")) {
                        ActivationConfigProperty cfgProp1 = null;
                        cfgProp1 = EjbFactoryImpl.getActiveFactory().createActivationConfigProperty();
                        cfgProp1.setName(keyValue[0]);
                        cfgProp1.setValue(keyValue[1]);
                        configsProperties.add(cfgProp1);
                        MDBTableComposite.this.mdbDataModel.notifyPropertyChange("ICreateMessageDrivenBeanDataModelProperties.activationConfig", 1);
                    } else if (configProperty.getValue() == null || configProperty.getValue().equals("") || configProperty.getValue() != keyValue[1]) {
                        configProperty.setValue(keyValue[1]);
                        MDBTableComposite.this.mdbDataModel.notifyPropertyChange("ICreateMessageDrivenBeanDataModelProperties.activationConfig", 1);
                    }
                } else {
                    configProperty = EjbFactoryImpl.getActiveFactory().createActivationConfigProperty();
                    configProperty.setName(keyValue[0]);
                    configProperty.setValue(keyValue[1]);
                    configsProperties.add(configProperty);
                    MDBTableComposite.this.mdbDataModel.notifyPropertyChange("ICreateMessageDrivenBeanDataModelProperties.activationConfig", 1);
                }
                MDBTableComposite.this.mdbDataModel.setProperty("ICreateMessageDrivenBeanDataModelProperties.activationConfig", (Object)configsProperties);
            }

            private void validateTableItemsAndModelForDestinationType(String valueString) {
                if (valueString.equals(MDBActivationConfgUtil.destinationTypeValues[0])) {
                    ArrayList tableDataList = MDBTableComposite.this.getTableDataList();
                    for (int i = 0; i < tableDataList.size(); ++i) {
                        TableData tableData = (TableData)tableDataList.get(i);
                        if (!tableData.getName().equals("subscriptionDurability")) continue;
                        tableDataList.remove(tableData);
                        MDBTableComposite.this.getTable().setData((Object)tableDataList);
                        this.removeDurabilityFromMDBCreationModel();
                    }
                }
            }

            private void removeDurabilityFromMDBCreationModel() {
                List activationConfigList = (List)MDBTableComposite.this.mdbDataModel.getProperty("ICreateMessageDrivenBeanDataModelProperties.activationConfig");
                boolean foundDurabilityProp = false;
                for (int i = 0; i < activationConfigList.size(); ++i) {
                    ActivationConfigProperty property = (ActivationConfigProperty)activationConfigList.get(i);
                    if (!property.getName().equals("subscriptionDurability")) continue;
                    activationConfigList.remove(property);
                    foundDurabilityProp = true;
                }
                if (foundDurabilityProp) {
                    MDBTableComposite.this.mdbDataModel.setProperty("ICreateMessageDrivenBeanDataModelProperties.activationConfig", (Object)activationConfigList);
                    List dupNamesProperty = (List)MDBTableComposite.this.mdbDataModel.getProperty("ICreateMessageDrivenBeanDataModelProperties.activationConfig");
                    if (dupNamesProperty.contains("subscriptionDurability")) {
                        for (int i = 0; i < dupNamesProperty.size(); ++i) {
                            String propertyName = (String)dupNamesProperty.get(i);
                            if (!propertyName.equals("subscriptionDurability")) continue;
                            dupNamesProperty.remove(propertyName);
                        }
                        MDBTableComposite.this.mdbDataModel.setProperty("ICreateMessageDrivenBeanDataModelProperties.activationConfig", (Object)dupNamesProperty);
                    }
                }
            }
        });
    }

    protected void viewerRefresh() {
        this.viewer.refresh();
    }

    private String getComboText(String property) {
        ComboBoxCellEditor ccEditor = this.getComboBoxCellEditor(property);
        if (ccEditor == null || ccEditor.getControl() == null) {
            return "";
        }
        CCombo combo = (CCombo)ccEditor.getControl();
        return combo.getText();
    }

    private String[] getKeyValueStringArray(TableData data) {
        String[] keyValue = new String[]{data.getName(), data.getValue()};
        return keyValue;
    }

    protected void updateComboCellEditor(Object element, String property, ComboBoxCellEditor comboCellEditor) {
        if (this.getCreateMessageDrivenBeanDataModel() == null) {
            return;
        }
        TableData data = (TableData)element;
        int columnIndex = this.getPropertyIntValue(property);
        String[] comboItems = null;
        switch (columnIndex) {
            case 0: {
                if (this.mdbDataModel.getBooleanProperty("CreateMessageDrivenBean21DataModel.listenerType")) {
                    String[] existingStrings = this.getExistingValues(property, columnIndex);
                    comboItems = MDBActivationConfgUtil.getStandardValidatedNameItems(existingStrings, this.tableDataList);
                    break;
                }
                comboItems = new String[]{""};
            }
            case 1: {
                comboItems = this.mdbDataModel.getBooleanProperty("CreateMessageDrivenBean21DataModel.listenerType") ? MDBActivationConfgUtil.getStandardValueItems(data.getName()) : new String[]{""};
            }
        }
        comboCellEditor.setItems(comboItems);
    }

    protected String[] addCurrentComboString(String currentString, String[] existingStrings) {
        String currentComboText;
        List<String> stringList = Arrays.asList(existingStrings);
        if (currentString.length() <= 0 || stringList.contains(currentString)) {
            return existingStrings;
        }
        String[] newStrings = new String[existingStrings.length + 1];
        newStrings[0] = currentComboText = currentString;
        for (int i = 0; i < existingStrings.length; ++i) {
            newStrings[i + 1] = existingStrings[i];
        }
        return newStrings;
    }

    private String[] getExistingValues(String property, int columnIndex) {
        if (columnIndex == -1) {
            return null;
        }
        List<TableItem> tableItems = Arrays.asList(this.table.getItems());
        String[] existingValues = new String[tableItems.size()];
        for (int i = 0; i < tableItems.size(); ++i) {
            String text;
            TableItem element = tableItems.get(i);
            existingValues[i] = text = element.getText(columnIndex);
        }
        return existingValues;
    }

    public Table getTable() {
        return this.table;
    }

    public void setTable(Table table) {
        this.table = table;
    }

    public SnappyTableViewer getViewer() {
        return this.viewer;
    }

    public void setViewer(SnappyTableViewer viewer) {
        this.viewer = viewer;
    }

    public void setInput(ActivationConfigTableObjects tableObjects) {
        this.convertTableObjects(tableObjects);
        this.viewer.setInput((Object)this.getTableDataList());
    }

    private void convertTableObjects(ActivationConfigTableObjects tableObjects) {
        List tableObjs = tableObjects.getTableObjects();
        for (TableItem element : tableObjs) {
            TableData tableData = new TableData(element.getText(0), element.getText(1));
            this.getTableDataList().add(tableData);
        }
    }

    public void setLabelProvider(IBaseLabelProvider labelProvider) {
        this.viewer.setLabelProvider(labelProvider);
    }

    public void setContentProvider(IContentProvider contentProvider) {
        this.viewer.setContentProvider(contentProvider);
    }

    public void setColumnData(Object[] columnData) {
        for (int i = 0; i < columnData.length; ++i) {
            this.table.getColumn(i).setData(columnData[i]);
        }
    }

    public IDataModel getCreateMessageDrivenBeanDataModel() {
        return this.mdbDataModel;
    }

    public void setCreateMessageDrivenBeanDataModel(IDataModel mdbDataModel) {
        this.mdbDataModel = mdbDataModel;
    }

    public ArrayList getTableDataList() {
        if (this.tableDataList == null) {
            this.tableDataList = new ArrayList();
        }
        return this.tableDataList;
    }

    public void setTableDataList(ArrayList tableDataList) {
        this.tableDataList = tableDataList;
    }
}

