/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.common.ui.sections;

import com.ibm.etools.j2ee.ui.plugin.J2EEUIPlugin;
import java.util.ArrayList;
import org.eclipse.core.internal.resources.Project;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jst.j2ee.project.JavaEEProjectUtilities;

public class EJBSearchScope
implements IJavaSearchScope {
    public static final int EJBHOME = 1;
    public static final int EJBLOCALHOME = 2;
    public static final int EJBOBJECT = 3;
    public static final int EJBLOCALOBJECT = 4;
    private IJavaSearchScope javaScope;
    IProject project;
    IProject[] ejbProjects;
    private String filterString;

    public EJBSearchScope(IProject project, int filter) {
        this.project = project;
        switch (filter) {
            case 1: {
                this.filterString = "EJBHome";
                break;
            }
            case 2: {
                this.filterString = "EJBLocalHome";
                break;
            }
            case 3: {
                this.filterString = "EJBObject";
                break;
            }
            case 4: {
                this.filterString = "EJBLocalObject";
                break;
            }
        }
        this.init();
    }

    protected void init() {
        try {
            this.javaScope = SearchEngine.createWorkspaceScope();
        }
        catch (Exception e) {
            J2EEUIPlugin.logError(e);
        }
    }

    public boolean includesClasspaths() {
        return true;
    }

    public boolean includesBinaries() {
        return true;
    }

    public boolean encloses(String resourcePath) {
        int index = resourcePath.indexOf(".java");
        if (index == -1) {
            return false;
        }
        IFile resource = this.findFile(resourcePath);
        if (resource == null) {
            return false;
        }
        IJavaElement element = JavaCore.create((IResource)resource);
        if (!(element instanceof ICompilationUnit)) {
            return false;
        }
        ICompilationUnit cu = (ICompilationUnit)element;
        try {
            cu.open(null);
            String source = cu.getSource();
            int indexStart = source.indexOf("extends");
            if (indexStart == -1) {
                return false;
            }
            int indexEnd = (source = source.substring(indexStart)).indexOf("{");
            if (indexEnd == -1) {
                return false;
            }
            if ((source = source.substring(0, indexEnd)).indexOf(this.filterString) != -1) {
                return true;
            }
        }
        catch (JavaModelException e) {
            return false;
        }
        return false;
    }

    protected IProject[] getReferencingEARProjects() {
        ArrayList<IProject> projectList = new ArrayList<IProject>();
        IProject[] refProjects = this.project.getReferencingProjects();
        for (int i = 0; i < refProjects.length; ++i) {
            if (!JavaEEProjectUtilities.isEJBProject((IProject)refProjects[i])) continue;
            projectList.add(refProjects[i]);
        }
        Project[] earProjects = new Project[projectList.size()];
        projectList.toArray(earProjects);
        return earProjects;
    }

    protected IProject[] getReferencedEJBProjectsInEAR() {
        IProject[] earProjects = this.getReferencingEARProjects();
        ArrayList<IProject> projectList = new ArrayList<IProject>();
        try {
            for (int j = 0; j < earProjects.length; ++j) {
                IProject[] refProjects = earProjects[j].getReferencedProjects();
                for (int i = 0; i < refProjects.length; ++i) {
                    if (!JavaEEProjectUtilities.isEJBProject((IProject)refProjects[i])) continue;
                    projectList.add(refProjects[i]);
                }
            }
        }
        catch (CoreException j) {
            // empty catch block
        }
        Project[] ejbProjects = new Project[projectList.size()];
        projectList.toArray(ejbProjects);
        return ejbProjects;
    }

    protected IFile findFile(String resourcePath) {
        IFile file = null;
        if (this.ejbProjects == null) {
            this.ejbProjects = this.getReferencedEJBProjectsInEAR();
        }
        for (int i = 0; i < this.ejbProjects.length; ++i) {
            file = this.ejbProjects[i].getFile(new Path(resourcePath).removeFirstSegments(1));
            if (file == null || !file.exists()) continue;
            return file;
        }
        return null;
    }

    public boolean encloses(IJavaElement element) {
        return true;
    }

    public IPath[] enclosingProjectsAndJars() {
        return this.javaScope.enclosingProjectsAndJars();
    }

    public void setIncludesBinaries(boolean includesBinaries) {
    }

    public void setIncludesClasspaths(boolean includesClasspaths) {
    }
}

