/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.common.ui.action;

import com.ibm.etools.ejb.ui.actions.standalone.AbstractEJBAction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jst.j2ee.common.internal.impl.CommonFactoryImpl;
import org.eclipse.jst.j2ee.ejb.EnterpriseBean;
import org.eclipse.wst.common.componentcore.ArtifactEdit;
import org.eclipse.wst.common.frameworks.internal.operations.IHeadlessRunnableWithProgress;
import org.eclipse.wst.common.internal.emfworkbench.integration.ModelModifier;
import org.eclipse.wst.common.internal.emfworkbench.integration.ModifierHelper;

public class RemoveReferenceAction
extends AbstractEJBAction {
    protected StructuredViewer viewer;
    protected EditingDomain editingDomain;
    protected ArtifactEdit artifactEdit;
    protected List selectedReferences;
    protected static final EClass EJBREF_CLASS = CommonFactoryImpl.getPackage().getEjbRef();
    protected static final EClass EJBLOCALREF_CLASS = CommonFactoryImpl.getPackage().getEJBLocalRef();
    protected static final EClass RESREF_CLASS = CommonFactoryImpl.getPackage().getResourceRef();
    protected static final EClass RESENVREF_CLASS = CommonFactoryImpl.getPackage().getResourceEnvRef();
    protected static final EClass SECROLEREF_CLASS = CommonFactoryImpl.getPackage().getSecurityRoleRef();

    public RemoveReferenceAction(String label, StructuredViewer viewer, EditingDomain editingDomain, ArtifactEdit artifactEdit) {
        super(label);
        this.viewer = viewer;
        this.editingDomain = editingDomain;
        this.artifactEdit = artifactEdit;
    }

    @Override
    protected IHeadlessRunnableWithProgress getHeadlessOperation() {
        return null;
    }

    @Override
    public void run() {
        List selectedObjectList = this.getSelectedReferences();
        ModelModifier modifier = new ModelModifier(this.editingDomain);
        for (int i = 0; i < selectedObjectList.size(); ++i) {
            EObject ref = (EObject)selectedObjectList.get(i);
            if (ref instanceof EnterpriseBean) continue;
            ModifierHelper helper = new ModifierHelper();
            helper.setOwner(ref.eContainer());
            helper.setFeature((EStructuralFeature)ref.eContainmentFeature());
            helper.setValue((Object)ref);
            helper.doUnsetValue();
            modifier.addHelper(helper);
        }
        modifier.execute();
    }

    protected List getSelectedReferences() {
        if (this.viewer != null) {
            return this.getStructuredSelectionFromViewer().toList();
        }
        if (this.selectedReferences == null) {
            return Collections.EMPTY_LIST;
        }
        return this.selectedReferences;
    }

    public StructuredSelection getStructuredSelectionFromViewer() {
        return (StructuredSelection)this.viewer.getSelection();
    }

    public static boolean isReferenceType(Object anObject) {
        if (anObject != null && anObject instanceof EObject) {
            EObject refObject = (EObject)anObject;
            EClass meta = refObject.eClass();
            return meta == EJBREF_CLASS || meta == EJBLOCALREF_CLASS || meta == RESREF_CLASS || meta == RESENVREF_CLASS || meta == SECROLEREF_CLASS;
        }
        return false;
    }

    @Override
    protected boolean updateSelection(IStructuredSelection selection) {
        boolean result;
        if (this.selectedReferences != null) {
            this.selectedReferences.clear();
        }
        if (result = super.updateSelection(selection)) {
            for (Object obj : selection) {
                if (RemoveReferenceAction.isReferenceType(obj)) {
                    if (this.selectedReferences == null) {
                        this.selectedReferences = new ArrayList();
                    }
                    this.selectedReferences.add(obj);
                    continue;
                }
                if (this.selectedReferences != null) {
                    this.selectedReferences.clear();
                }
                result = false;
                break;
            }
            result = this.selectedReferences != null && !this.selectedReferences.isEmpty();
        }
        return result;
    }
}

