/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.common.java;

import com.ibm.etools.common.java.DirectoryClasspath;
import com.ibm.etools.common.java.JarClasspath;
import java.io.File;
import java.io.IOException;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.env.INameEnvironment;
import org.eclipse.jdt.internal.compiler.env.NameEnvironmentAnswer;

public class JavaNameEnvironment
implements INameEnvironment {
    Classpath[] classpaths;
    String[] knownFileNames;

    public JavaNameEnvironment(String[] classpathNames, String[] initialFileNames) {
        int i;
        int classpathSize = classpathNames.length;
        this.classpaths = new Classpath[classpathSize];
        String[] pathNames = new String[classpathSize];
        int problemsOccured = 0;
        for (i = 0; i < classpathSize; ++i) {
            try {
                File file = new File(this.convertPathSeparators(classpathNames[i]));
                if (file.exists()) {
                    if (file.isDirectory()) {
                        this.classpaths[i] = new DirectoryClasspath(file);
                        pathNames[i] = ((DirectoryClasspath)this.classpaths[i]).path;
                    } else if (classpathNames[i].endsWith(".jar") | classpathNames[i].endsWith(".zip")) {
                        this.classpaths[i] = new JarClasspath(file);
                        pathNames[i] = classpathNames[i].substring(0, classpathNames[i].lastIndexOf(46));
                    }
                }
            }
            catch (IOException e) {
                this.classpaths[i] = null;
            }
            if (this.classpaths[i] != null) continue;
            ++problemsOccured;
        }
        if (problemsOccured > 0) {
            Classpath[] newPaths = new Classpath[classpathSize - problemsOccured];
            String[] newNames = new String[classpathSize - problemsOccured];
            int current = 0;
            for (int i2 = 0; i2 < classpathSize; ++i2) {
                if (this.classpaths[i2] == null) continue;
                newPaths[current] = this.classpaths[i2];
                newNames[current++] = pathNames[i2];
            }
            classpathSize = newPaths.length;
            this.classpaths = newPaths;
            pathNames = newNames;
        }
        this.knownFileNames = new String[initialFileNames.length];
        i = initialFileNames.length;
        while (--i >= 0) {
            String fileName = initialFileNames[i];
            String matchingPathName = null;
            if (fileName.lastIndexOf(".") != -1) {
                fileName = fileName.substring(0, fileName.lastIndexOf(46));
            }
            fileName = this.convertPathSeparators(fileName);
            for (int j = 0; j < classpathSize; ++j) {
                if (!fileName.startsWith(pathNames[j])) continue;
                matchingPathName = pathNames[j];
            }
            if (matchingPathName == null) {
                this.knownFileNames[i] = fileName;
                continue;
            }
            this.knownFileNames[i] = fileName.substring(matchingPathName.length());
        }
    }

    static String assembleName(char[] fileName, char[][] packageName, char separator) {
        return new String(CharOperation.concatWith((char[][])packageName, (char[])fileName, (char)separator));
    }

    static String assembleName(String fileName, char[][] packageName, char separator) {
        return new String(CharOperation.concatWith((char[][])packageName, (char[])(fileName == null ? null : fileName.toCharArray()), (char)separator));
    }

    public void cleanup() {
        int len = this.classpaths.length;
        for (int i = 0; i < len; ++i) {
            if (this.classpaths[i].getType() != 1) continue;
            this.classpaths[i].close();
        }
    }

    private String convertPathSeparators(String path) {
        if (File.separatorChar == '/') {
            return path.replace('\\', '/');
        }
        return path.replace('/', '\\');
    }

    private NameEnvironmentAnswer findClass(char[] name, char[][] packageName) {
        String fullName = JavaNameEnvironment.assembleName(name, packageName, File.separatorChar);
        int length = this.knownFileNames.length;
        for (int i = 0; i < length; ++i) {
            if (!fullName.equals(this.knownFileNames[i])) continue;
            return null;
        }
        String filename = new String(name);
        String binaryFilename = filename + ".class";
        String sourceFilename = filename + ".java";
        for (Classpath classpath : this.classpaths) {
            boolean sourceExists;
            boolean binaryExists = classpath.exists(binaryFilename, packageName);
            if (binaryExists == (sourceExists = classpath.exists(sourceFilename, packageName))) {
                long sourceModified;
                if (!binaryExists) continue;
                long binaryModified = classpath.lastModified(binaryFilename, packageName);
                if (binaryModified > (sourceModified = classpath.lastModified(sourceFilename, packageName))) {
                    return classpath.readClassFile(binaryFilename, packageName);
                }
                if (sourceModified <= 0L) continue;
                return classpath.readJavaFile(sourceFilename, packageName);
            }
            if (binaryExists) {
                return classpath.readClassFile(binaryFilename, packageName);
            }
            return classpath.readJavaFile(sourceFilename, packageName);
        }
        return null;
    }

    public NameEnvironmentAnswer findType(char[][] compoundName) {
        if (compoundName == null) {
            return null;
        }
        return this.findClass(compoundName[compoundName.length - 1], CharOperation.subarray((char[][])compoundName, (int)0, (int)(compoundName.length - 1)));
    }

    public NameEnvironmentAnswer findType(char[] name, char[][] compoundName) {
        if (name == null) {
            return null;
        }
        return this.findClass(name, compoundName);
    }

    public boolean isPackage(char[][] compoundName, char[] packageName) {
        if (compoundName == null) {
            compoundName = new char[0][];
        }
        int length = this.classpaths.length;
        for (int i = 0; i < length; ++i) {
            if (!this.classpaths[i].isPackage((char[][])compoundName, packageName)) continue;
            return true;
        }
        return false;
    }

    static interface Classpath {
        public static final int DIR_TYPE = 0;
        public static final int JAR_TYPE = 1;

        public int getType();

        public boolean exists(String var1, char[][] var2);

        public long lastModified(String var1, char[][] var2);

        public NameEnvironmentAnswer readClassFile(String var1, char[][] var2);

        public NameEnvironmentAnswer readJavaFile(String var1, char[][] var2);

        public boolean isPackage(char[][] var1, char[] var2);

        public void close();
    }
}

