/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.common.java;

import com.ibm.etools.common.java.JavaNameEnvironment;
import java.io.File;
import java.util.Hashtable;
import java.util.Map;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.internal.compiler.batch.CompilationUnit;
import org.eclipse.jdt.internal.compiler.classfmt.ClassFileReader;
import org.eclipse.jdt.internal.compiler.env.IBinaryType;
import org.eclipse.jdt.internal.compiler.env.ICompilationUnit;
import org.eclipse.jdt.internal.compiler.env.NameEnvironmentAnswer;
import org.eclipse.jdt.internal.compiler.impl.CompilerOptions;

class DirectoryClasspath
implements JavaNameEnvironment.Classpath {
    String path;
    Hashtable missingPackages;
    final int type = 0;
    Hashtable directoryCache;

    DirectoryClasspath(File directory) {
        this.path = directory.getAbsolutePath();
        if (!this.path.endsWith(File.separator)) {
            this.path = this.path + File.separator;
        }
        this.missingPackages = new Hashtable(11);
        this.directoryCache = new Hashtable(11);
    }

    @Override
    public void close() {
    }

    private String[] directoryList(char[][] compoundName, char[] packageName) {
        String partialPath = JavaNameEnvironment.assembleName(packageName, compoundName, File.separatorChar);
        String[] dirList = (String[])this.directoryCache.get(partialPath);
        if (dirList != null) {
            return dirList;
        }
        if (this.missingPackages.containsKey(partialPath)) {
            return null;
        }
        File dir = new File(this.path + partialPath);
        if (dir.isDirectory()) {
            boolean matchesName;
            boolean bl = matchesName = packageName == null;
            if (!matchesName && packageName != null) {
                int index = packageName.length;
                while (--index >= 0 && !Character.isUpperCase(packageName[index])) {
                }
                boolean bl2 = matchesName = index < 0 || this.exists(new String(packageName), compoundName);
            }
            if (matchesName) {
                dirList = dir.list();
                if (dirList == null) {
                    dirList = new String[]{};
                }
                this.directoryCache.put(partialPath, dirList);
                return dirList;
            }
        }
        this.missingPackages.put(partialPath, partialPath);
        return null;
    }

    @Override
    public boolean exists(String filename, char[][] packageName) {
        String[] dirList = this.directoryList(packageName, null);
        if (dirList != null) {
            int i = dirList.length;
            while (--i >= 0) {
                if (!filename.equals(dirList[i])) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public int getType() {
        return 0;
    }

    @Override
    public boolean isPackage(char[][] compoundName, char[] packageName) {
        return this.directoryList(compoundName, packageName) != null;
    }

    @Override
    public long lastModified(String filename, char[][] packageName) {
        File file = new File(this.path + JavaNameEnvironment.assembleName(filename, packageName, File.separatorChar));
        return file.lastModified();
    }

    @Override
    public NameEnvironmentAnswer readClassFile(String filename, char[][] packageName) {
        try {
            return new NameEnvironmentAnswer((IBinaryType)ClassFileReader.read((String)(this.path + JavaNameEnvironment.assembleName(filename, packageName, File.separatorChar))), null);
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public NameEnvironmentAnswer readJavaFile(String fileName, char[][] packageName) {
        String fullName = this.path + JavaNameEnvironment.assembleName(fileName, packageName, File.separatorChar);
        CompilerOptions compilerOptions = new CompilerOptions((Map)JavaCore.getOptions());
        return new NameEnvironmentAnswer((ICompilationUnit)new CompilationUnit(null, fullName, compilerOptions.defaultEncoding), null);
    }

    public String toString() {
        return "ClasspathDirectory " + this.path;
    }
}

