/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.application.ui.wizards.providers;

import java.util.List;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jst.j2ee.internal.common.J2EEVersionUtil;
import org.eclipse.jst.j2ee.internal.project.J2EEProjectUtilities;

public class ProjectListFilter
extends ViewerFilter {
    public static final int MODULE_PROJECT_1_2 = 112;
    public static final int MODULE_PROJECT_1_3 = 113;
    public static final int MODULE_PROJECT_1_4 = 114;
    public static final int UTILITY_JAR_PROJECT_1_2 = 212;
    public static final int UTILITY_JAR_PROJECT_1_3 = 213;
    public static final int UTILITY_JAR_PROJECT_1_4 = 214;
    public static final int CLIENT_PROJECT_1_2 = 311;
    public static final int CLIENT_PROJECT_1_3 = 312;
    public static final int CLIENT_PROJECT_1_4 = 313;
    public static final int EJB_PROJECT_1_2 = 412;
    public static final int EJB_PROJECT_1_3 = 413;
    public static final int EJB_PROJECT_1_4 = 414;
    public static final int WEB_PROJECT_1_2 = 512;
    public static final int WEB_PROJECT_1_3 = 513;
    public static final int WEB_PROJECT_1_4 = 514;
    public static final int CONNECTOR_PROJECT = 600;
    protected int type = -1;
    protected List excludeProjectList;

    public ProjectListFilter(int newType) {
        this.type = newType;
    }

    public ProjectListFilter(int newType, List excludeProjectList) {
        this.type = newType;
        this.excludeProjectList = excludeProjectList;
    }

    public boolean select(Viewer viewer, Object parentElement, Object element) {
        IFolder folder;
        IProject proj;
        String compId;
        boolean show = false;
        if (this.type == 212 || this.type == 213 || this.type == 214) {
            if (element instanceof IProject) {
                IProject project = (IProject)element;
                if (this.excludeProjectList == null || !this.excludeProjectList.contains(project)) {
                    show = true;
                }
            }
        } else if (element instanceof IProject) {
            IProject project = (IProject)element;
            if (this.excludeProjectList == null) {
                show = true;
            } else if (!this.excludeProjectList.contains(project)) {
                show = true;
            }
        } else if (element instanceof IFolder && ("jst.ejb".equals(compId = J2EEProjectUtilities.getJ2EEProjectType((IProject)(proj = (folder = (IFolder)element).getProject()))) || "jst.web".equals(compId) || "jst.appclient".equals(compId) || "jst.connector".equals(compId)) && (this.excludeProjectList == null || !this.excludeProjectList.contains(proj))) {
            String version = J2EEProjectUtilities.getJ2EEProjectVersion((IProject)proj);
            int versionInt = 0;
            if ("jst.ejb".equals(compId)) {
                versionInt = J2EEVersionUtil.convertEJBVersionStringToJ2EEVersionID((String)version);
            } else if ("jst.web".equals(compId)) {
                versionInt = J2EEVersionUtil.convertWebVersionStringToJ2EEVersionID((String)version);
            } else if ("jst.appclient".equals(compId)) {
                versionInt = J2EEVersionUtil.convertAppClientVersionStringToJ2EEVersionID((String)version);
            } else if ("jst.connector".equals(compId)) {
                versionInt = J2EEVersionUtil.convertConnectorVersionStringToJ2EEVersionID((String)version);
            }
            if (this.type >= versionInt) {
                show = true;
            }
        }
        return show;
    }
}

