/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.application.ui.wizards;

import com.ibm.etools.common.ui.wizards.nls.CommonAppEJBWizardsResourceHandler;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.FolderSelectionDialog;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.internal.datamodel.ui.DataModelWizardPage;

public class EditLibraryDirectoryPage
extends DataModelWizardPage {
    private static final String EAR_DEFAULT_LIB = "lib";
    private IProject project;
    private Button useDefaultButton;
    private Button useCustomLibDirButton;
    private Button browseButton;
    private Label libDirLabel;
    private Text libDirText;
    private ViewerFilter viewerFilter;

    protected EditLibraryDirectoryPage(IDataModel model, String pageName) {
        super(model, pageName);
        this.setTitle(CommonAppEJBWizardsResourceHandler.EDIT_LIBRARY_DIRECTORY_WIZARD_TITLE_UI_);
        this.setDescription(CommonAppEJBWizardsResourceHandler.EDIT_LIBRARY_DIRECTORY_WIZARD_DESC_UI_);
        this.project = (IProject)model.getProperty("EditLibraryDirectoryDataModel.PROJECT");
    }

    protected String[] getValidationPropertyNames() {
        return new String[]{"EditLibraryDirectoryDataModel.LIBRARY_DIRECTORY"};
    }

    protected Composite createTopLevelComposite(Composite parent) {
        Composite top = new Composite(parent, 0);
        top.setLayout((Layout)new GridLayout());
        top.setLayoutData((Object)new GridData(1808));
        this.setInfopopID("com.ibm.etools.j2ee.ui.EDIT_LIBRARY_DIRECTORY_WIZARD_PAGE1");
        this.createContents(top);
        Dialog.applyDialogFont((Control)parent);
        return top;
    }

    private void createContents(Composite parent) {
        boolean useCustom;
        Composite optionsComp = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        optionsComp.setLayout((Layout)layout);
        optionsComp.setLayoutData((Object)new GridData(768));
        this.useDefaultButton = new Button(optionsComp, 16);
        this.useDefaultButton.setText(CommonAppEJBWizardsResourceHandler.Use_default_library_directory_);
        String libDir = (String)this.model.getProperty("EditLibraryDirectoryDataModel.LIBRARY_DIRECTORY");
        if (libDir == null) {
            libDir = EAR_DEFAULT_LIB;
        }
        this.useDefaultButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                EditLibraryDirectoryPage.this.enableCustomLibDirComposite(false);
                EditLibraryDirectoryPage.this.model.setProperty("EditLibraryDirectoryDataModel.LIBRARY_DIRECTORY", (Object)EditLibraryDirectoryPage.EAR_DEFAULT_LIB);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.useCustomLibDirButton = new Button(optionsComp, 16);
        this.useCustomLibDirButton.setText(CommonAppEJBWizardsResourceHandler.Use_custom_library_directory_);
        this.useCustomLibDirButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                EditLibraryDirectoryPage.this.enableCustomLibDirComposite(true);
                EditLibraryDirectoryPage.this.model.setProperty("EditLibraryDirectoryDataModel.LIBRARY_DIRECTORY", (Object)EditLibraryDirectoryPage.this.libDirText.getText());
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        Composite subComposite = new Composite(optionsComp, 0);
        GridLayout sublayout = new GridLayout();
        sublayout.marginWidth = 0;
        sublayout.marginHeight = 0;
        sublayout.makeColumnsEqualWidth = false;
        sublayout.numColumns = 3;
        subComposite.setLayout((Layout)sublayout);
        GridData subGridData = new GridData(768);
        subGridData.horizontalIndent = 10;
        subComposite.setLayoutData((Object)subGridData);
        this.libDirLabel = new Label(subComposite, 0);
        this.libDirLabel.setText(CommonAppEJBWizardsResourceHandler.EAR_Library_Directory_);
        GridData data = new GridData();
        this.libDirLabel.setLayoutData((Object)data);
        this.libDirText = new Text(subComposite, 2048);
        this.libDirText.setText(libDir);
        this.libDirText.setLayoutData((Object)new GridData(768));
        this.libDirText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                EditLibraryDirectoryPage.this.model.setProperty("EditLibraryDirectoryDataModel.LIBRARY_DIRECTORY", (Object)EditLibraryDirectoryPage.this.libDirText.getText());
            }
        });
        this.browseButton = new Button(subComposite, 0);
        this.browseButton.setText(CommonAppEJBWizardsResourceHandler.Browse_);
        this.browseButton.setLayoutData((Object)new GridData());
        this.browseButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                EditLibraryDirectoryPage.this.handleBrowseButtonPressed();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        if (libDir.equals(EAR_DEFAULT_LIB)) {
            useCustom = false;
            this.useDefaultButton.setSelection(true);
        } else {
            useCustom = true;
            this.useCustomLibDirButton.setSelection(true);
        }
        this.enableCustomLibDirComposite(useCustom);
        this.libDirText.setText(libDir);
    }

    private void enableCustomLibDirComposite(boolean enable) {
        this.libDirLabel.setEnabled(enable);
        this.libDirText.setEnabled(enable);
        this.browseButton.setEnabled(enable);
    }

    public void handleBrowseButtonPressed() {
        String newFolder = this.getContainerPath();
        if (newFolder != null) {
            this.libDirText.setText(newFolder);
        }
    }

    private String getContainerPath() {
        String libDir = this.libDirText.getText();
        IVirtualComponent component = ComponentCore.createComponent((IProject)this.project);
        IContainer container = component.getRootFolder().getUnderlyingFolder();
        IContainer selectedContainer = null;
        if (libDir != null) {
            Path existingValuePath = new Path(libDir);
            IPath containerLocationPath = container.getFullPath().append((IPath)existingValuePath);
            if (container.getWorkspace().validatePath(containerLocationPath.toString(), 2).isOK()) {
                selectedContainer = container.getFolder((IPath)existingValuePath);
            }
        }
        if (selectedContainer == null || !selectedContainer.exists()) {
            selectedContainer = container;
        }
        FolderSelectionDialog dialog = new FolderSelectionDialog(Display.getDefault().getActiveShell(), (ILabelProvider)new WorkbenchLabelProvider(), (ITreeContentProvider)new WorkbenchContentProvider());
        dialog.setTitle(CommonAppEJBWizardsResourceHandler.BrowseContainerActionHandler_Folder_Selectio_);
        dialog.setMessage(CommonAppEJBWizardsResourceHandler.BrowseContainerActionHandler_Choose_the_folder_for_the_library_d_);
        dialog.setInput((Object)selectedContainer.getWorkspace());
        dialog.setInitialSelection((Object)selectedContainer);
        dialog.addFilter(this.getFilter(selectedContainer.getProject()));
        dialog.open();
        Object[] results = dialog.getResult();
        if (results == null || results.length == 0) {
            return null;
        }
        String folderName = null;
        if (results[0] != null && results[0] instanceof IContainer) {
            IPath pFull = ((IContainer)results[0]).getFullPath();
            IPath pBase = container.getFullPath();
            IPath newPath = pFull.removeFirstSegments(pBase.segmentCount());
            folderName = newPath.makeRelative().toString();
        }
        return folderName;
    }

    private ViewerFilter getFilter(IProject project) {
        final IProject targetProject = project;
        if (this.viewerFilter == null) {
            this.viewerFilter = new ViewerFilter(){

                public boolean select(Viewer viewer, Object parentElement, Object element) {
                    IContainer container;
                    return element instanceof IContainer && targetProject.equals((Object)(container = (IContainer)element).getProject()) && !".settings".equals(container.getName());
                }
            };
        }
        return this.viewerFilter;
    }

    public void storeDefaultSettings() {
        String result = (String)this.model.getProperty("EditLibraryDirectoryDataModel.LIBRARY_DIRECTORY");
        if (result.equals(EAR_DEFAULT_LIB)) {
            result = null;
        }
        this.model.setProperty("EditLibraryDirectoryDataModel.LIBRARY_DIRECTORY", (Object)result);
    }

    protected void enter() {
        super.enter();
        this.validatePage(true);
    }
}

