/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.common.internal.migration.validation.framework;

import com.ibm.etools.common.internal.migration.framework.MigrationMessages;
import com.ibm.etools.common.internal.migration.plugin.MigrationPlugin;
import com.ibm.etools.common.internal.migration.validation.framework.MigrationResult;
import com.ibm.etools.common.internal.migration.validation.framework.MigrationValidatorRegisty;
import com.ibm.etools.common.migration.validation.framework.AbstractMigrationValidator;
import com.ibm.etools.common.migration.validation.framework.IMigrationResult;
import com.ibm.etools.common.migration.validation.framework.IMigrationResultsListener;
import com.ibm.etools.common.migration.validation.framework.IMigrationValidatorListener;
import com.ibm.etools.common.migration.validation.framework.MigrationValidationUtils;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.osgi.util.NLS;

public class MigrationValidatorEngine
implements IMigrationValidatorListener {
    private ArrayList statusResults = new ArrayList();
    private ArrayList listeners = new ArrayList();
    private ArrayList legacyProjects;
    private boolean isLegacyProject;
    private String normalIndentString = "";
    private String errorIndentString = "";

    public IStatus validateMigration(IProgressMonitor monitor, IMigrationResultsListener listener) {
        IProject[] allProjects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        return this.runValidation(monitor, allProjects, listener, true);
    }

    public IStatus validateMigration(IProgressMonitor monitor, IProject[] allProjects, IMigrationResultsListener listener) {
        return this.runValidation(monitor, allProjects, listener, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IStatus runValidation(IProgressMonitor monitor, IProject[] allProjects, IMigrationResultsListener listener, boolean dynamicUpdate) {
        this.addMigrationResultsListener(listener);
        IStatus currentStatus = Status.OK_STATUS;
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)allProjects.length);
        try {
            this.clearResults();
            String taskName = MigrationMessages.MigrationValidatorEngine_migration_validation_task;
            progress.setTaskName(taskName);
            this.reportInformation(taskName);
            try {
                this.indent();
                for (int i = 0; i < allProjects.length; ++i) {
                    if (progress.isCanceled()) {
                        throw new OperationCanceledException();
                    }
                    IProject project = allProjects[i];
                    this.statusResults.clear();
                    IStatus nestedStatus = null;
                    this.isLegacyProject = false;
                    if (project.isAccessible()) {
                        nestedStatus = this.validateMigration(project, (IProgressMonitor)progress.newChild(1));
                    } else {
                        boolean isClosed = !project.isOpen();
                        nestedStatus = isClosed ? MigrationPlugin.createStatus(2, NLS.bind((String)MigrationMessages.MigrationValidatorEngine_closed_project, (Object)project.getName())) : MigrationPlugin.createStatus(2, NLS.bind((String)MigrationMessages.MigrationValidatorEngine_non_existant_project, (Object)project.getName()));
                        this.reportStatus(nestedStatus);
                        progress.worked(1);
                    }
                    MigrationResult result = new MigrationResult(project);
                    result.setSeverity(nestedStatus.getSeverity());
                    result.setStatusReports(this.statusResults);
                    if (this.isLegacyProject) {
                        this.getLegacyProjects().add(project);
                    }
                    this.postResult(result, dynamicUpdate);
                    if (nestedStatus.getSeverity() != 4 && nestedStatus.getSeverity() != 2) continue;
                    if (currentStatus.isOK()) {
                        currentStatus = nestedStatus;
                        continue;
                    }
                    if (!currentStatus.isMultiStatus()) {
                        MultiStatus multiStatus = MigrationValidationUtils.createMutliStatus(currentStatus);
                        currentStatus = multiStatus;
                    }
                    ((MultiStatus)currentStatus).add(nestedStatus);
                }
            }
            finally {
                this.outDent();
            }
        }
        catch (OperationCanceledException e) {
            throw e;
        }
        finally {
            this.removeMigrationResultsListener(listener);
            progress.done();
        }
        return currentStatus;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IStatus validateMigration(IProject project, IProgressMonitor monitor) {
        IStatus currentStatus = Status.OK_STATUS;
        List migrationValidators = MigrationValidatorRegisty.INSTANCE.getMigrationValidators();
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)migrationValidators.size());
        try {
            String taskName = NLS.bind((String)MigrationMessages.MigrationValidatorEngine_validating_project_task, (Object)project.getName());
            progress.setTaskName(taskName);
            this.reportInformation(taskName);
            HashSet<String> successfulMigratorIDs = new HashSet<String>();
            HashSet<String> failedMigratorIDs = new HashSet<String>();
            try {
                this.indent();
                for (int i = 0; i < migrationValidators.size(); ++i) {
                    if (progress.isCanceled()) {
                        throw new OperationCanceledException();
                    }
                    IStatus nestedStatus = null;
                    AbstractMigrationValidator migrationValidator = (AbstractMigrationValidator)migrationValidators.get(i);
                    String migrationValidatorID = null;
                    try {
                        migrationValidatorID = migrationValidator.getID();
                        migrationValidator.addMigrationValidatorListener(this);
                        try {
                            String subTaskName = NLS.bind((String)MigrationMessages.MigrationValidatorEngine_running_validator, (Object[])new Object[]{migrationValidator.getName(), migrationValidatorID});
                            progress.setTaskName(subTaskName);
                            this.reportInformation(subTaskName);
                            try {
                                this.indent();
                                HashSet<String> localSuccess = new HashSet<String>();
                                localSuccess.addAll(successfulMigratorIDs);
                                migrationValidator.setSuccessfulMigratorIDs(localSuccess);
                                HashSet<String> localFail = new HashSet<String>();
                                localFail.addAll(failedMigratorIDs);
                                migrationValidator.setFailedMigratorIDs(localFail);
                                nestedStatus = migrationValidator.validate(project, (IProgressMonitor)progress.newChild(1));
                                if (nestedStatus.getSeverity() == 4 && migrationValidator.isLegacyValidator()) {
                                    this.isLegacyProject = true;
                                }
                            }
                            finally {
                                this.outDent();
                            }
                        }
                        catch (Throwable throwable) {
                            this.reportInformation(NLS.bind((String)MigrationMessages.MigrationValidatorEngine_finished_validator, (Object[])new Object[]{migrationValidator.getName(), migrationValidatorID}));
                            progress.done();
                            throw throwable;
                        }
                        this.reportInformation(NLS.bind((String)MigrationMessages.MigrationValidatorEngine_finished_validator, (Object[])new Object[]{migrationValidator.getName(), migrationValidatorID}));
                        progress.done();
                    }
                    catch (OperationCanceledException e) {
                        throw e;
                    }
                    catch (Exception e) {
                        MigrationPlugin.logError(e);
                        nestedStatus = MigrationPlugin.createStatus(4, e.getMessage(), e);
                        this.reportStatus(nestedStatus);
                    }
                    finally {
                        if (migrationValidatorID != null) {
                            if (null != nestedStatus && nestedStatus.getSeverity() == 4) {
                                failedMigratorIDs.add(migrationValidator.getID());
                            } else {
                                successfulMigratorIDs.add(migrationValidator.getID());
                            }
                        }
                    }
                    if (null == nestedStatus || nestedStatus.getSeverity() != 4 && nestedStatus.getSeverity() != 2) continue;
                    if (currentStatus == null || currentStatus.isOK()) {
                        currentStatus = nestedStatus;
                        continue;
                    }
                    if (!currentStatus.isMultiStatus()) {
                        MultiStatus multiStatus = MigrationValidationUtils.createMutliStatus(currentStatus);
                        currentStatus = multiStatus;
                    }
                    ((MultiStatus)currentStatus).add(nestedStatus);
                }
            }
            finally {
                this.outDent();
            }
            this.reportInformation(NLS.bind((String)MigrationMessages.MigrationValidatorEngine_finished_validating_project, (Object)project.getName()));
        }
        catch (OperationCanceledException e) {
            this.reportInformation(NLS.bind((String)MigrationMessages.MigrationValidatorEngine_canceled_project_validation, (Object)project.getName()));
            throw e;
        }
        finally {
            monitor.done();
        }
        return currentStatus;
    }

    private void indent() {
        this.normalIndentString = this.normalIndentString + "  ";
        this.errorIndentString = this.errorIndentString + "**";
    }

    private void outDent() {
        this.normalIndentString = this.normalIndentString.substring(0, this.normalIndentString.length() - 2);
        this.errorIndentString = this.errorIndentString.substring(0, this.errorIndentString.length() - 2);
    }

    public void reportError(String message) {
        this.reportStatus(MigrationPlugin.createStatus(4, message));
    }

    public void reportWarning(String message) {
        this.reportStatus(MigrationPlugin.createStatus(2, message));
    }

    public void reportInformation(String message) {
        this.reportStatus(MigrationPlugin.createStatus(1, message));
    }

    public void reportSuccess(String message) {
        this.reportStatus(MigrationPlugin.createStatus(0, message));
    }

    @Override
    public void reportStatus(IStatus aStatus) {
        String newMessage = this.normalIndentString + aStatus.getMessage();
        MultiStatus wrapperStatus = new MultiStatus("com.ibm.etools.common.migration", aStatus.getCode(), new IStatus[]{aStatus}, newMessage, aStatus.getException());
        this.statusResults.add(wrapperStatus);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void postResult(IMigrationResult result, boolean dynamicUpdate) {
        ArrayList arrayList = this.listeners;
        synchronized (arrayList) {
            for (IMigrationResultsListener listener : this.listeners) {
                listener.resultsUpdate(result, dynamicUpdate);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearResults() {
        ArrayList arrayList = this.listeners;
        synchronized (arrayList) {
            for (IMigrationResultsListener listener : this.listeners) {
                listener.clearView();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMigrationResultsListener(IMigrationResultsListener listener) {
        ArrayList arrayList = this.listeners;
        synchronized (arrayList) {
            this.listeners.add(listener);
        }
    }

    public ArrayList<IProject> getLegacyProjects() {
        if (this.legacyProjects == null) {
            this.legacyProjects = new ArrayList();
        }
        return this.legacyProjects;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeMigrationResultsListener(IMigrationResultsListener listener) {
        ArrayList arrayList = this.listeners;
        synchronized (arrayList) {
            this.listeners.remove(listener);
        }
    }
}

