/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.common.internal.migration.validation.framework;

import com.ibm.etools.common.internal.migration.validation.framework.MigrationValidatorRegisty;
import com.ibm.etools.common.migration.validation.framework.IMigrationValidator;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.Stack;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;

public class MigrationValidatorDescriptor {
    protected IConfigurationElement configurationElement = null;
    private Set directRequires = null;
    private Set transitiveRequires = null;

    public MigrationValidatorDescriptor(IConfigurationElement configurationElement) {
        this.configurationElement = configurationElement;
    }

    public IConfigurationElement getElement() {
        return this.configurationElement;
    }

    public String getID() {
        return this.configurationElement.getAttribute("id");
    }

    public Set getRequires() {
        if (this.directRequires == null) {
            String rawRequires = this.configurationElement.getAttribute("requires");
            if (null == rawRequires || rawRequires.trim().length() == 0) {
                return Collections.EMPTY_SET;
            }
            HashSet<String> requires = new HashSet<String>();
            StringTokenizer strTok = new StringTokenizer(rawRequires);
            while (strTok.hasMoreElements()) {
                requires.add(strTok.nextToken());
            }
            this.directRequires = Collections.unmodifiableSet(requires);
        }
        return this.directRequires;
    }

    public Set getTransitiveRequires() {
        if (this.transitiveRequires == null) {
            Set direct = this.getRequires();
            HashSet<String> requires = new HashSet<String>();
            Stack toProcess = new Stack();
            toProcess.addAll(direct);
            while (!toProcess.isEmpty()) {
                String current = (String)toProcess.pop();
                if (requires.contains(current)) continue;
                requires.add(current);
                MigrationValidatorDescriptor descriptor = MigrationValidatorRegisty.INSTANCE.getMigrationValidatorsDescriptor(current);
                if (descriptor == null) continue;
                toProcess.addAll(descriptor.getRequires());
            }
            this.transitiveRequires = Collections.unmodifiableSet(requires);
        }
        return this.transitiveRequires;
    }

    public IMigrationValidator createExecutableExtension() throws CoreException {
        return (IMigrationValidator)this.configurationElement.createExecutableExtension("class");
    }

    public String toString() {
        StringBuffer buff = new StringBuffer();
        buff.append("ID:");
        buff.append(this.getID());
        buff.append(" requires:");
        String rawRequires = this.configurationElement.getAttribute("requires");
        if (null == rawRequires) {
            rawRequires = "null";
        }
        buff.append(rawRequires);
        return buff.toString();
    }
}

