/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.common.internal.migration.plugin;

import com.ibm.etools.common.internal.migration.framework.WorkspaceMigrationEngine;
import com.ibm.etools.common.internal.migration.framework.WorkspaceMigrationListener;
import com.ibm.etools.common.migration.framework.IMigrationFramework;
import java.util.HashMap;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class MigrationPlugin
extends Plugin {
    public static final String PLUGIN_ID = "com.ibm.etools.common.migration";
    public static final String ID = "com.ibm.etools.common.migration";
    public static final String BACK_COMPAT = "backward_compatible";
    public static final String WORKSPACE_MIGRATED = "com.ibm.etools.common.internal.migration.workspaceMigrated.2";
    private static MigrationPlugin plugin;
    private static boolean kickOffStartup;
    private static boolean finishedStartup;
    private ResourceBundle resourceBundle;
    private WorkspaceMigrationListener newWorkspaceListener;
    private HashMap moduleMaps;
    private static boolean doNewMigration;

    public MigrationPlugin() {
        plugin = this;
        try {
            this.resourceBundle = ResourceBundle.getBundle("com.ibm.etools.common.migration.plugin.MigrationPluginResources");
        }
        catch (MissingResourceException x) {
            this.resourceBundle = null;
        }
        String migrationType = System.getProperty("migrationFramework");
        if (migrationType != null && migrationType.equalsIgnoreCase("old")) {
            doNewMigration = false;
        }
        if (doNewMigration) {
            this.newWorkspaceListener = new WorkspaceMigrationListener();
        }
        if (kickOffStartup && doNewMigration) {
            this.workspaceCheck();
        }
    }

    private void workspaceCheck() {
        WorkspaceMigrationEngine engine = WorkspaceMigrationEngine.instance();
        IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        if (projects.length > 0) {
            for (int i = 0; i < projects.length; ++i) {
                IProject project = projects[i];
                if (!project.isSynchronized(2)) {
                    try {
                        project.refreshLocal(2, null);
                    }
                    catch (CoreException ce) {
                        MigrationPlugin.logError(ce);
                    }
                }
                engine.addProject(project);
            }
        }
        engine.begin(true);
        finishedStartup = true;
    }

    public static void earlyStartup() {
        kickOffStartup = true;
        if (null != plugin && doNewMigration) {
            plugin.workspaceCheck();
        }
    }

    public void setWorkspaceMigrated(boolean value) {
        this.getPluginPreferences().setValue(WORKSPACE_MIGRATED, value);
        this.savePluginPreferences();
    }

    public static MigrationPlugin getDefault() {
        return plugin;
    }

    public static IMigrationFramework getMigrationFramework() {
        return WorkspaceMigrationEngine.instance();
    }

    public static IWorkspace getWorkspace() {
        return ResourcesPlugin.getWorkspace();
    }

    public static String getResourceString(String key) {
        ResourceBundle bundle = MigrationPlugin.getDefault().getResourceBundle();
        try {
            return bundle != null ? bundle.getString(key) : key;
        }
        catch (MissingResourceException e) {
            return key;
        }
    }

    public ResourceBundle getResourceBundle() {
        return this.resourceBundle;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
    }

    public void stop(BundleContext context) throws Exception {
        if (this.newWorkspaceListener != null) {
            this.newWorkspaceListener.dispose();
        }
        super.stop(context);
    }

    public HashMap getModuleMaps() {
        return this.moduleMaps;
    }

    public void setModuleMaps(HashMap moduleMaps) {
        this.moduleMaps = moduleMaps;
    }

    public static IStatus createStatus(int severity, String message, Throwable exception) {
        return new Status(severity, "com.ibm.etools.common.migration", message, exception);
    }

    public static IStatus createStatus(int severity, String message) {
        return MigrationPlugin.createStatus(severity, message, null);
    }

    public static void logInfo(String message) {
        Platform.getLog((Bundle)Platform.getBundle((String)"com.ibm.etools.common.migration")).log(MigrationPlugin.createStatus(1, message));
    }

    public static void logError(String message) {
        Platform.getLog((Bundle)Platform.getBundle((String)"com.ibm.etools.common.migration")).log(MigrationPlugin.createStatus(4, message));
    }

    public static void logError(Throwable exception) {
        Platform.getLog((Bundle)Platform.getBundle((String)"com.ibm.etools.common.migration")).log(MigrationPlugin.createStatus(4, exception.getMessage(), exception));
    }

    public static void logError(CoreException exception) {
        Platform.getLog((Bundle)Platform.getBundle((String)"com.ibm.etools.common.migration")).log(exception.getStatus());
    }

    public static void logError(IStatus status) {
        Platform.getLog((Bundle)Platform.getBundle((String)"com.ibm.etools.common.migration")).log(status);
    }

    public static boolean isFinishedStartup() {
        return finishedStartup;
    }

    static {
        kickOffStartup = false;
        finishedStartup = false;
        doNewMigration = true;
    }
}

