/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.common.internal.migration.framework;

import com.ibm.etools.common.internal.migration.framework.AbstractMigrationHandler;
import com.ibm.etools.common.internal.migration.framework.IMigrationFrameworkDataModelProperties;
import com.ibm.etools.common.internal.migration.framework.MigrationEvent;
import com.ibm.etools.common.internal.migration.framework.MigrationFrameworkDataModelProvider;
import com.ibm.etools.common.internal.migration.framework.MigrationFrameworkDescriptor;
import com.ibm.etools.common.internal.migration.framework.MigrationFrameworkRegistry;
import com.ibm.etools.common.internal.migration.framework.MigrationHandlerRegistry;
import com.ibm.etools.common.internal.migration.framework.MigrationLog;
import com.ibm.etools.common.internal.migration.framework.MigrationMessages;
import com.ibm.etools.common.internal.migration.framework.MigrationProjectReferenceUtil;
import com.ibm.etools.common.internal.migration.plugin.MigrationPlugin;
import com.ibm.etools.common.migration.framework.AbstractMigration;
import com.ibm.etools.common.migration.framework.AbstractWorkspaceMigration;
import com.ibm.etools.common.migration.framework.IMigrationEvent;
import com.ibm.etools.common.migration.framework.IMigrationFramework;
import com.ibm.etools.common.migration.framework.IMigrationListener;
import com.ibm.etools.common.migration.framework.IMigrationStatus;
import com.ibm.etools.common.migration.framework.MigrationStatus;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.core.internal.jobs.JobMessages;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceDescription;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.common.frameworks.datamodel.DataModelFactory;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelProvider;

public class WorkspaceMigrationEngine
implements IMigrationFramework,
IMigrationFrameworkDataModelProperties {
    private static final String STATUS_PLUGINID = "com.ibm.etools.common.migration";
    public static final String MIGRATION_JOB = "MigrationDetectionJob";
    public static final String FIRST_MIGRATOR = "First migrator: ";
    private static WorkspaceMigrationEngine engine = null;
    private AbstractMigrationHandler migrationHandler = null;
    private List<IProject> projects = new ArrayList<IProject>();
    private Set<IProject> nonMigratedProjects = new HashSet<IProject>();
    private boolean wasAutoBuilding = true;
    private boolean buildFlagSet = false;
    private ISchedulingRule rule;
    private MigrationDetectionJob detectorJob = new MigrationDetectionJob();
    private Set<IMigrationListener> migrationListeners = new HashSet<IMigrationListener>();
    private IDataModel migrationDataModel;
    private boolean isManualMigration = false;
    private MigrationFrameworkDescriptor firstMigrator = null;

    public static WorkspaceMigrationEngine instance() {
        if (engine == null) {
            engine = new WorkspaceMigrationEngine();
        }
        return engine;
    }

    @Override
    public void addMigrationListener(IMigrationListener migrationListener) {
        this.migrationListeners.add(migrationListener);
    }

    @Override
    public void removeMigrationListener(IMigrationListener migrationListener) {
        this.migrationListeners.remove(migrationListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addProject(IProject project) {
        List<IProject> list = this.projects;
        synchronized (list) {
            if (project.isAccessible()) {
                this.projects.add(project);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasProjects() {
        List<IProject> list = this.projects;
        synchronized (list) {
            return !this.projects.isEmpty();
        }
    }

    public void lockWorkspace() {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        this.rule = workspace.getRoot();
        Job.getJobManager().beginRule(this.rule, null);
    }

    public void unlockWorkspace() {
        this.turnOnAutobuild();
        if (this.rule != null) {
            Job.getJobManager().endRule(this.rule);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void turnOffAutobuild() {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IWorkspaceDescription description = workspace.getDescription();
        WorkspaceMigrationEngine workspaceMigrationEngine = this;
        synchronized (workspaceMigrationEngine) {
            if (!this.buildFlagSet) {
                this.buildFlagSet = true;
                this.wasAutoBuilding = workspace.isAutoBuilding();
                description.setAutoBuilding(false);
                try {
                    workspace.setDescription(description);
                }
                catch (CoreException e) {
                    MigrationPlugin.logError(e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isAutoBuildEnabled() {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        WorkspaceMigrationEngine workspaceMigrationEngine = this;
        synchronized (workspaceMigrationEngine) {
            return workspace.isAutoBuilding();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void turnOnAutobuild() {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IWorkspaceDescription description = workspace.getDescription();
        WorkspaceMigrationEngine workspaceMigrationEngine = this;
        synchronized (workspaceMigrationEngine) {
            if (this.buildFlagSet) {
                this.buildFlagSet = false;
                if (this.wasAutoBuilding) {
                    description.setAutoBuilding(true);
                    try {
                        workspace.setDescription(description);
                    }
                    catch (CoreException e) {
                        MigrationPlugin.logError(e);
                    }
                }
            }
        }
    }

    private boolean cancelAutobuildJob() {
        Job[] build = Job.getJobManager().find(ResourcesPlugin.FAMILY_AUTO_BUILD);
        if (build.length == 1) {
            return build[0].cancel();
        }
        return true;
    }

    public void begin() {
        this.begin(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void begin(boolean includeWorkspaceMetadata) {
        ArrayList<IProject> projectsCopy = null;
        List<IProject> list = this.projects;
        synchronized (list) {
            if (this.projects.size() > 0 || includeWorkspaceMetadata) {
                projectsCopy = new ArrayList<IProject>();
                projectsCopy.addAll(this.projects);
                this.projects.clear();
            }
        }
        if (projectsCopy != null) {
            boolean autoBuildInitialState = this.isAutoBuildEnabled();
            this.turnOffAutobuild();
            try {
                this.notifyListeners(new MigrationEvent(3));
            }
            catch (RuntimeException e) {
                if (autoBuildInitialState) {
                    this.turnOnAutobuild();
                } else {
                    this.turnOffAutobuild();
                }
                MigrationPlugin.logError(e);
                throw e;
            }
            try {
                this.detectorJob.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.detectorJob.schedule(projectsCopy, includeWorkspaceMetadata);
        }
    }

    private boolean isMetadataEnabled(IProgressMonitor monitor) {
        List<MigrationFrameworkDescriptor> descriptors = MigrationFrameworkRegistry.INSTANCE.getMigrationFrameworkDescriptors();
        for (int j = 0; j < descriptors.size() && !monitor.isCanceled(); ++j) {
            MigrationFrameworkDescriptor descriptor = descriptors.get(j);
            if (!descriptor.isEnabledForWorkspaceMetadata()) continue;
            if (this.getFirstMigrator() == null) {
                this.setFirstMigrator(descriptor);
            }
            return true;
        }
        return false;
    }

    public List<IProject> getProjectsToMigrate(List<IProject> potentialProjects, IProgressMonitor monitor) {
        int amountWork = potentialProjects.size();
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)amountWork);
        progress.setTaskName(MigrationMessages.MigrationFramework_Finding_Projects);
        ArrayList<IProject> projectsToMigrate = new ArrayList<IProject>();
        Iterator<IProject> projectsIterator = potentialProjects.iterator();
        while (projectsIterator.hasNext()) {
            if (monitor.isCanceled()) continue;
            IProject project = projectsIterator.next();
            if (this.isEnabled(project, (IProgressMonitor)progress.newChild(1))) {
                projectsToMigrate.add(project);
            }
            progress.setWorkRemaining(--amountWork);
        }
        return projectsToMigrate;
    }

    private boolean isEnabled(IProject project, IProgressMonitor monitor) {
        List<MigrationFrameworkDescriptor> descriptors = MigrationFrameworkRegistry.INSTANCE.getMigrationFrameworkDescriptors();
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)descriptors.size());
        for (int j = 0; j < descriptors.size() && !monitor.isCanceled(); ++j) {
            MigrationFrameworkDescriptor descriptor = descriptors.get(j);
            if (descriptor.isEnabledForProject(project)) {
                if (this.getFirstMigrator() == null) {
                    this.setFirstMigrator(descriptor);
                }
                return true;
            }
            progress.worked(1);
        }
        return false;
    }

    public Set<IFile> getResourcesToChange(List<IProject> migrationProjects, IProgressMonitor monitor) {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)migrationProjects.size());
        progress.setTaskName(MigrationMessages.MigrationFramework_Finding_Resources);
        HashMap projectMigrators = (HashMap)this.migrationDataModel.getProperty("IMigrationFrameworkDataModelProperties.PROJECT_MIGRATORS");
        HashSet<IFile> resources = new HashSet<IFile>();
        for (IProject project : migrationProjects) {
            List migrators;
            if (projectMigrators.containsKey(project)) {
                migrators = (List)projectMigrators.get(project);
            } else {
                migrators = MigrationFrameworkRegistry.INSTANCE.getMigratorsForProject(project);
                projectMigrators.put(project, migrators);
            }
            int workRemaining = migrators.size();
            for (int i = 0; i < migrators.size(); ++i) {
                AbstractMigration migrator = (AbstractMigration)migrators.get(i);
                migrator.setDataModel(this.migrationDataModel);
                List<IFile> migratorResources = migrator.getResourcesToChange(project, (IProgressMonitor)progress.newChild(1));
                progress.setWorkRemaining(--workRemaining);
                if (migratorResources == null) continue;
                resources.addAll(migratorResources);
            }
        }
        this.migrationDataModel.setProperty("IMigrationFrameworkDataModelProperties.MIGRATION_RESOURCES", resources);
        this.migrationDataModel.setProperty("IMigrationFrameworkDataModelProperties.PROJECT_MIGRATORS", (Object)projectMigrators);
        progress.done();
        return resources;
    }

    public IStatus checkoutResources(Set<IFile> resourceSet, Object context, IProgressMonitor monitor) {
        Iterator<IFile> resourcesIterator = resourceSet.iterator();
        ArrayList<IFile> resourceFiles = new ArrayList<IFile>(resourceSet.size());
        while (resourcesIterator.hasNext()) {
            IFile resource = resourcesIterator.next();
            if (!(resource instanceof IFile) || !resource.exists()) continue;
            IFile file = resource;
            resourceFiles.add(file);
        }
        IFile[] files = new IFile[resourceFiles.size()];
        resourceFiles.toArray(files);
        MigrationLog.getInstance().logResourceCheckout(files);
        return ResourcesPlugin.getWorkspace().validateEdit(files, context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void migrateProjects(List<IProject> migrationProjects, IProgressMonitor monitor) {
        SubMonitor progress;
        HashMap projectMigrators;
        int amountWork;
        block21: {
            MigrationLog.getInstance().logMessage(FIRST_MIGRATOR + this.getFirstMigrator().getID());
            amountWork = 0;
            projectMigrators = (HashMap)this.migrationDataModel.getProperty("IMigrationFrameworkDataModelProperties.PROJECT_MIGRATORS");
            for (List migrators : projectMigrators.values()) {
                if (migrators == null) continue;
                amountWork += migrators.size();
            }
            boolean needsMetadataMigration = this.migrationDataModel.getBooleanProperty("IMigrationFrameworkDataModelProperties.NEEDS_METADATA_MIGRATION");
            List<AbstractWorkspaceMigration> workspaceMigrators = Collections.EMPTY_LIST;
            if (needsMetadataMigration) {
                workspaceMigrators = MigrationFrameworkRegistry.INSTANCE.getMigratorsForWorkspaceMetadata();
                amountWork += workspaceMigrators.size();
            }
            progress = SubMonitor.convert((IProgressMonitor)monitor, (int)amountWork);
            if (!needsMetadataMigration) break block21;
            progress.setTaskName(MigrationMessages.MigrationFramework_MigratingWorkspace);
            MigrationLog.getInstance().logMessage(MigrationMessages.MigrationFramework_MigratingWorkspace);
            for (int i = 0; i < workspaceMigrators.size(); ++i) {
                String message;
                String migratorID;
                AbstractWorkspaceMigration migrator = workspaceMigrators.get(i);
                IMigrationStatus migrationStatus = null;
                try {
                    IWorkspace workspace = ResourcesPlugin.getWorkspace();
                    migrator.setDataModel(this.migrationDataModel);
                    IPath metadataPluginsPath = workspace.getRoot().getLocation().append(".metadata/.plugins");
                    migrationStatus = migrator.migrateWorkspaceMetadata(metadataPluginsPath, (IProgressMonitor)progress.newChild(1));
                    progress.setWorkRemaining(--amountWork);
                }
                catch (Throwable exception) {
                    try {
                        MigrationPlugin.logError(exception);
                        MigrationLog.getInstance().logStatus((IStatus)new Status(4, STATUS_PLUGINID, exception.getMessage(), exception), true);
                    }
                    catch (Throwable throwable) {
                        String migratorID2 = migrator.getMigratorID();
                        if (migrationStatus == null) {
                            String message2 = MigrationMessages.bind((String)MigrationMessages.MigrationFrameworkOperation_migrationWorkspaceError, (Object[])new Object[]{migratorID2});
                            migrationStatus = new MigrationStatus((IStatus)new Status(4, STATUS_PLUGINID, message2));
                        }
                        MigrationLog.getInstance().logMigrationStatusFor(migrationStatus, migratorID2);
                        throw throwable;
                    }
                    migratorID = migrator.getMigratorID();
                    if (migrationStatus == null) {
                        message = MigrationMessages.bind((String)MigrationMessages.MigrationFrameworkOperation_migrationWorkspaceError, (Object[])new Object[]{migratorID});
                        migrationStatus = new MigrationStatus((IStatus)new Status(4, STATUS_PLUGINID, message));
                    }
                    MigrationLog.getInstance().logMigrationStatusFor(migrationStatus, migratorID);
                }
                migratorID = migrator.getMigratorID();
                if (migrationStatus == null) {
                    message = MigrationMessages.bind((String)MigrationMessages.MigrationFrameworkOperation_migrationWorkspaceError, (Object[])new Object[]{migratorID});
                    migrationStatus = new MigrationStatus((IStatus)new Status(4, STATUS_PLUGINID, message));
                }
                MigrationLog.getInstance().logMigrationStatusFor(migrationStatus, migratorID);
                this.migrationHandler.longRunningOperationComplete();
            }
        }
        MigrationProjectReferenceUtil refUtil = new MigrationProjectReferenceUtil(migrationProjects, true);
        Iterator<IProject> projectsIterator = refUtil.getReferencedProjects().iterator();
        this.signalMigrationStart();
        HashSet<IProject> projectsMigrated = new HashSet<IProject>();
        while (projectsIterator.hasNext()) {
            IProject project = projectsIterator.next();
            if (!migrationProjects.contains(project)) continue;
            progress.setTaskName(MigrationMessages.bind((String)MigrationMessages.MigrationFramework_MigratingProject, (Object)project.getName()));
            MigrationLog.getInstance().logProjectMigration(project.getName());
            List migrators = (List)projectMigrators.get(project);
            if (migrators == null || migrators.isEmpty()) {
                String message = MigrationMessages.bind((String)MigrationMessages.MigrationFrameworkOperation_migrationError_NoMigratorForProject, (Object[])new Object[]{project.getName()});
                Status status = new Status(4, STATUS_PLUGINID, message);
                MigrationLog.getInstance().logStatus((IStatus)status, true);
                continue;
            }
            for (int i = 0; i < migrators.size(); ++i) {
                String message;
                String migratorID;
                AbstractMigration migrator = (AbstractMigration)migrators.get(i);
                IMigrationStatus migrationStatus = null;
                try {
                    migrationStatus = migrator.migrate(project, (IProgressMonitor)progress.newChild(1));
                    progress.setWorkRemaining(--amountWork);
                    progress.subTask("");
                    projectsMigrated.add(project);
                }
                catch (Throwable exception) {
                    try {
                        MigrationPlugin.logError(exception);
                        MigrationLog.getInstance().logStatus((IStatus)new Status(4, STATUS_PLUGINID, exception.getMessage(), exception), true);
                        projectsMigrated.add(project);
                    }
                    catch (Throwable throwable) {
                        projectsMigrated.add(project);
                        String migratorID3 = migrator.getMigratorID();
                        if (migrationStatus == null) {
                            String message3 = MigrationMessages.bind((String)MigrationMessages.MigrationFrameworkOperation_migrationError, (Object[])new Object[]{migratorID3, project.getName()});
                            migrationStatus = new MigrationStatus((IStatus)new Status(4, STATUS_PLUGINID, message3));
                        }
                        MigrationLog.getInstance().logMigrationStatusFor(migrationStatus, migratorID3);
                        throw throwable;
                    }
                    migratorID = migrator.getMigratorID();
                    if (migrationStatus == null) {
                        message = MigrationMessages.bind((String)MigrationMessages.MigrationFrameworkOperation_migrationError, (Object[])new Object[]{migratorID, project.getName()});
                        migrationStatus = new MigrationStatus((IStatus)new Status(4, STATUS_PLUGINID, message));
                    }
                    MigrationLog.getInstance().logMigrationStatusFor(migrationStatus, migratorID);
                }
                migratorID = migrator.getMigratorID();
                if (migrationStatus == null) {
                    message = MigrationMessages.bind((String)MigrationMessages.MigrationFrameworkOperation_migrationError, (Object[])new Object[]{migratorID, project.getName()});
                    migrationStatus = new MigrationStatus((IStatus)new Status(4, STATUS_PLUGINID, message));
                }
                MigrationLog.getInstance().logMigrationStatusFor(migrationStatus, migratorID);
                this.migrationHandler.longRunningOperationComplete();
            }
        }
        if (projectsMigrated.size() > 0) {
            this.nonMigratedProjects.removeAll(projectsMigrated);
        }
        this.signalMigrationComplete();
    }

    private void signalMigrationStart() {
        this.notifyListeners(new MigrationEvent(1));
    }

    private void signalMigrationComplete() {
        this.notifyListeners(new MigrationEvent(2));
    }

    private void notifyListeners(IMigrationEvent event) {
        if (this.migrationListeners != null) {
            for (IMigrationListener listener : this.migrationListeners) {
                listener.handleEvent(event);
            }
        }
    }

    @Override
    public boolean isMigratedProject(IProject project) {
        return !this.nonMigratedProjects.contains(project);
    }

    public Set<IProject> getNonMigratedProjects() {
        return this.nonMigratedProjects;
    }

    public void setManualMigration(boolean manualMigration) {
        this.isManualMigration = manualMigration;
    }

    public MigrationFrameworkDescriptor getFirstMigrator() {
        return this.firstMigrator;
    }

    public void setFirstMigrator(MigrationFrameworkDescriptor firstMigrator) {
        this.firstMigrator = firstMigrator;
    }

    private class MigrationDetectionJob
    extends Job {
        List<IProject> detectionProjects;
        boolean hasWorkspaceMetadata;

        public MigrationDetectionJob() {
            super(WorkspaceMigrationEngine.MIGRATION_JOB);
            this.detectionProjects = null;
            this.hasWorkspaceMetadata = false;
            this.setSystem(true);
        }

        public boolean belongsTo(Object family) {
            return family == WorkspaceMigrationEngine.MIGRATION_JOB;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected IStatus run(IProgressMonitor monitor) {
            block34: {
                boolean hasMoreProjects = true;
                boolean needsMigration = false;
                boolean needsMetadataMigration = false;
                try {
                    IProject project;
                    WorkspaceMigrationEngine.instance().turnOffAutobuild();
                    boolean cancelResult = WorkspaceMigrationEngine.instance().cancelAutobuildJob();
                    if (!cancelResult && MigrationPlugin.getDefault().isDebugging()) {
                        MigrationPlugin.logInfo("Auto Build job is currently running");
                    }
                    if (this.hasWorkspaceMetadata) {
                        needsMetadataMigration = WorkspaceMigrationEngine.this.isMetadataEnabled(monitor);
                    }
                    while (!needsMetadataMigration && !needsMigration && hasMoreProjects) {
                        project = null;
                        List<IProject> list = this.detectionProjects;
                        synchronized (list) {
                            if (!this.detectionProjects.isEmpty()) {
                                project = this.detectionProjects.get(0);
                            } else {
                                hasMoreProjects = false;
                            }
                        }
                        if (!hasMoreProjects) continue;
                        if (WorkspaceMigrationEngine.this.isEnabled(project, monitor)) {
                            needsMigration = true;
                            continue;
                        }
                        list = this.detectionProjects;
                        synchronized (list) {
                            this.detectionProjects.remove(0);
                        }
                    }
                    if (needsMigration || needsMetadataMigration) {
                        try {
                            WorkspaceMigrationEngine.this.lockWorkspace();
                            WorkspaceMigrationEngine.this.migrationDataModel = DataModelFactory.createDataModel((IDataModelProvider)new MigrationFrameworkDataModelProvider());
                            project = this.detectionProjects;
                            synchronized (project) {
                                this.refreshWorkspace(this.detectionProjects);
                                WorkspaceMigrationEngine.this.migrationDataModel.setProperty("IMigrationFrameworkDataModelProperties.POTENTIAL_MIGRATION_PROJECTS", this.detectionProjects);
                            }
                            WorkspaceMigrationEngine.this.migrationDataModel.setBooleanProperty("IMigrationFrameworkDataModelProperties.NEEDS_METADATA_MIGRATION", needsMetadataMigration);
                            if (WorkspaceMigrationEngine.this.migrationHandler == null) {
                                WorkspaceMigrationEngine.this.migrationHandler = MigrationHandlerRegistry.INSTANCE.getMigrationHandler();
                            }
                            if (WorkspaceMigrationEngine.this.migrationHandler != null) {
                                WorkspaceMigrationEngine.this.migrationHandler.handleMigration(WorkspaceMigrationEngine.this.migrationDataModel);
                            }
                            break block34;
                        }
                        finally {
                            try {
                                MigrationLog.getInstance().endLogging();
                            }
                            finally {
                                WorkspaceMigrationEngine.this.unlockWorkspace();
                            }
                        }
                    }
                    if (WorkspaceMigrationEngine.this.isManualMigration) {
                        if (WorkspaceMigrationEngine.this.migrationHandler == null) {
                            WorkspaceMigrationEngine.this.migrationHandler = MigrationHandlerRegistry.INSTANCE.getMigrationHandler();
                        }
                        if (WorkspaceMigrationEngine.this.migrationHandler != null) {
                            WorkspaceMigrationEngine.this.migrationHandler.handleMigration(null);
                        }
                    }
                    WorkspaceMigrationEngine.instance().turnOnAutobuild();
                }
                catch (NoClassDefFoundError e) {
                    String message = NLS.bind((String)JobMessages.jobs_internalError, (Object)this.getName());
                    MigrationPlugin.logError((IStatus)new Status(4, WorkspaceMigrationEngine.STATUS_PLUGINID, message, (Throwable)e));
                }
                finally {
                    WorkspaceMigrationEngine.instance().turnOnAutobuild();
                }
            }
            WorkspaceMigrationEngine.this.isManualMigration = false;
            WorkspaceMigrationEngine.instance().setFirstMigrator(null);
            return Status.OK_STATUS;
        }

        private void refreshWorkspace(List<IProject> projects) {
            for (IProject project : projects) {
                if (project.isSynchronized(2)) continue;
                try {
                    project.refreshLocal(2, null);
                }
                catch (CoreException ce) {
                    MigrationPlugin.logError(ce);
                }
            }
        }

        public void schedule(List<IProject> projectList, boolean includeWorkspaceMetadata) {
            this.detectionProjects = projectList;
            this.hasWorkspaceMetadata = includeWorkspaceMetadata;
            this.schedule();
        }
    }
}

