/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.common.internal.migration.framework;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;

public class MigrationProjectReferenceUtil {
    private List<IProject> selectedProjects;
    private List<IProject> referencedProjects;
    private Set<IProject> visited;
    private boolean sort;

    public MigrationProjectReferenceUtil(List<IProject> selected) {
        this(selected, false);
    }

    public MigrationProjectReferenceUtil(List<IProject> selected, boolean sorted) {
        this.selectedProjects = sorted ? this.getProjectsSortedByName(selected) : selected;
        this.sort = sorted;
        this.referencedProjects = new ArrayList<IProject>();
        this.visited = new HashSet<IProject>();
        this.traverse();
    }

    public List<IProject> getReferencedProjects() {
        return this.referencedProjects;
    }

    private void traverse() {
        for (int i = 0; i < this.selectedProjects.size(); ++i) {
            IProject project = this.selectedProjects.get(i);
            this.traverse(project);
        }
    }

    private void traverse(IProject project) {
        if (project == null || this.visited.contains(project)) {
            return;
        }
        this.visited.add(project);
        List<IProject> referenced = this.getReferencedProjects(project);
        for (int i = 0; i < referenced.size(); ++i) {
            this.traverse(referenced.get(i));
        }
        this.referencedProjects.add(project);
    }

    private List<IProject> getReferencedProjects(IProject project) {
        List<IProject> referenced = new ArrayList<IProject>();
        if (project.isAccessible()) {
            try {
                referenced = this.sort ? this.getProjectsSortedByName(Arrays.asList(project.getReferencedProjects())) : Arrays.asList(project.getReferencedProjects());
            }
            catch (CoreException coreException) {
                // empty catch block
            }
        }
        return referenced;
    }

    private List<IProject> getProjectsSortedByName(List<IProject> projects) {
        ArrayList<IProject> projectsCopy = new ArrayList<IProject>();
        projectsCopy.addAll(projects);
        Comparator<IProject> comp = new Comparator<IProject>(){

            @Override
            public int compare(IProject project1, IProject project2) {
                return project1.getName().compareTo(project2.getName());
            }
        };
        Collections.sort(projectsCopy, comp);
        return projectsCopy;
    }
}

