/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.common.internal.migration.framework;

import com.ibm.etools.common.internal.migration.framework.MigrationFrameworkDescriptor;
import com.ibm.etools.common.internal.migration.framework.MigrationMessages;
import com.ibm.etools.common.internal.migration.plugin.MigrationPlugin;
import com.ibm.etools.common.migration.framework.AbstractMigration;
import com.ibm.etools.common.migration.framework.AbstractWorkspaceMigration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;

public class MigrationFrameworkRegistry {
    protected static final String EXTENSION_POINT = "migration";
    protected static final String MIGRATION_ELEMENT = "migrator";
    protected static final String ATTRIBUTE_ID = "id";
    protected static final String ATTRIBUTE_CLASS_NAME = "className";
    protected static final String ATTRIBUTE_WORKSPACE_METADTA = "migratesWorkspaceMetadata";
    protected static final String DEPENDS_ON_ELEMENT = "dependsOn";
    protected static final String ATTRIBUTE_FAIL_ON_ABSENT = "failOnAbsent";
    protected static final Set<String> WDT_ALLOWED_MIGRATOR_ID = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("com.ibm.imp.worklight.core.internal.WorklightProjectMigration", "com.ibm.etools.common.migration.extension.ui.migrator.UnresolvedRuntimeMigrator", "com.ibm.etools.webtools.dojo.core.internal.migration.DojoProjectMigration")));
    public static MigrationFrameworkRegistry INSTANCE = new MigrationFrameworkRegistry();
    private List<MigrationFrameworkDescriptor> migrationFrameworkDescriptors = null;

    public List<AbstractMigration> getMigrators() {
        List<MigrationFrameworkDescriptor> descriptors = this.getMigrationFrameworkDescriptors();
        ArrayList<AbstractMigration> instances = new ArrayList<AbstractMigration>();
        for (int i = 0; i < descriptors.size(); ++i) {
            MigrationFrameworkDescriptor descriptor = descriptors.get(i);
            try {
                AbstractMigration migrator = (AbstractMigration)descriptor.createExecutableExtension();
                migrator.setMigratorID(descriptor.getID());
                instances.add(migrator);
                continue;
            }
            catch (CoreException e) {
                MigrationPlugin.logError(MigrationMessages.bind((String)MigrationMessages.MigrationFrameworkRegistry_failedToLoad, (Object)descriptor));
                MigrationPlugin.logError(e);
                descriptors.remove(i);
                --i;
            }
        }
        return instances;
    }

    public List<AbstractMigration> getMigratorsForProject(IProject project) {
        List<MigrationFrameworkDescriptor> descriptors = this.getMigrationFrameworkDescriptors();
        ArrayList<AbstractMigration> instances = new ArrayList<AbstractMigration>();
        for (int i = 0; i < descriptors.size(); ++i) {
            MigrationFrameworkDescriptor descriptor = descriptors.get(i);
            if (!descriptor.isEnabledForProject(project)) continue;
            try {
                AbstractMigration migrator = (AbstractMigration)descriptor.createExecutableExtension();
                migrator.setMigratorID(descriptor.getID());
                instances.add(migrator);
                continue;
            }
            catch (CoreException e) {
                MigrationPlugin.logError(MigrationMessages.bind((String)MigrationMessages.MigrationFrameworkRegistry_failedToLoad, (Object)descriptor));
                MigrationPlugin.logError(e);
                descriptors.remove(i);
                --i;
            }
        }
        return instances;
    }

    public List<AbstractWorkspaceMigration> getMigratorsForWorkspaceMetadata() {
        List<MigrationFrameworkDescriptor> descriptors = this.getMigrationFrameworkDescriptors();
        ArrayList<AbstractWorkspaceMigration> instances = new ArrayList<AbstractWorkspaceMigration>();
        for (int i = 0; i < descriptors.size(); ++i) {
            MigrationFrameworkDescriptor descriptor = descriptors.get(i);
            if (!descriptor.isEnabledForWorkspaceMetadata()) continue;
            try {
                AbstractWorkspaceMigration migrator = (AbstractWorkspaceMigration)descriptor.createExecutableExtension();
                migrator.setMigratorID(descriptor.getID());
                instances.add(migrator);
                continue;
            }
            catch (CoreException e) {
                MigrationPlugin.logError(MigrationMessages.bind((String)MigrationMessages.MigrationFrameworkRegistry_failedToLoad, (Object)descriptor));
                MigrationPlugin.logError(e);
                descriptors.remove(i);
                --i;
            }
        }
        return instances;
    }

    public List<MigrationFrameworkDescriptor> getMigrationFrameworkDescriptors() {
        if (this.migrationFrameworkDescriptors == null) {
            this.readDescriptors();
        }
        return this.migrationFrameworkDescriptors;
    }

    public MigrationFrameworkDescriptor getMigrationFrameworkDescriptor(String id) {
        List<MigrationFrameworkDescriptor> descriptors = this.getMigrationFrameworkDescriptors();
        for (int i = 0; i < descriptors.size(); ++i) {
            MigrationFrameworkDescriptor descriptor = descriptors.get(i);
            if (!descriptor.getID().equals(id)) continue;
            return descriptor;
        }
        return null;
    }

    private void readDescriptors() {
        MigrationFrameworkDescriptor descriptor;
        String className;
        int i;
        this.migrationFrameworkDescriptors = new ArrayList<MigrationFrameworkDescriptor>();
        IExtensionPoint point = Platform.getExtensionRegistry().getExtensionPoint("com.ibm.etools.common.migration", EXTENSION_POINT);
        if (point == null) {
            return;
        }
        HashMap<String, MigrationFrameworkDescriptor> knownIds = new HashMap<String, MigrationFrameworkDescriptor>();
        IConfigurationElement[] elements = point.getConfigurationElements();
        boolean isWDT = Platform.getBundle((String)"com.ibm.cic.licensing.common.core") == null;
        for (i = 0; i < elements.length; ++i) {
            IConfigurationElement element = elements[i];
            if (MIGRATION_ELEMENT.equals(element.getName())) {
                String id = element.getAttribute(ATTRIBUTE_ID);
                className = element.getAttribute(ATTRIBUTE_CLASS_NAME);
                if (null == id || id.trim().length() == 0) {
                    MigrationPlugin.logError(MigrationMessages.bind((String)MigrationMessages.MigrationFrameworkRegistry_missingAttribute, (Object[])new Object[]{EXTENSION_POINT, MIGRATION_ELEMENT, ATTRIBUTE_ID}));
                    MigrationPlugin.logError(MigrationMessages.bind((String)MigrationMessages.MigrationFrameworkRegistry_ignoredMigrator, (Object)className));
                    continue;
                }
                if (null == className || className.trim().length() == 0) {
                    MigrationPlugin.logError(MigrationMessages.bind((String)MigrationMessages.MigrationFrameworkRegistry_missingAttribute, (Object[])new Object[]{EXTENSION_POINT, MIGRATION_ELEMENT, ATTRIBUTE_CLASS_NAME}));
                    MigrationPlugin.logError(MigrationMessages.bind((String)MigrationMessages.MigrationFrameworkRegistry_ignoredMigrator, (Object)className));
                    continue;
                }
                MigrationFrameworkDescriptor descriptor2 = new MigrationFrameworkDescriptor(element);
                if (knownIds.containsKey(id)) {
                    descriptor2.setDisabled(true);
                    MigrationPlugin.logError(MigrationMessages.bind((String)MigrationMessages.MigrationFrameworkRegistry_duplicateID, (Object)descriptor2));
                    MigrationPlugin.logError(MigrationMessages.bind((String)MigrationMessages.MigrationFrameworkRegistry_ignoredMigrator, (Object)className));
                } else {
                    knownIds.put(id, descriptor2);
                }
                if (!isWDT) {
                    this.migrationFrameworkDescriptors.add(descriptor2);
                    continue;
                }
                if (!WDT_ALLOWED_MIGRATOR_ID.contains(id)) continue;
                this.migrationFrameworkDescriptors.add(descriptor2);
                continue;
            }
            MigrationPlugin.logError(MigrationMessages.bind((String)MigrationMessages.MigrationFrameworkRegistry_elementName, (Object[])new Object[]{MIGRATION_ELEMENT, EXTENSION_POINT}));
            MigrationPlugin.logError(MigrationMessages.bind((String)MigrationMessages.MigrationFrameworkRegistry_invalidElement, (Object[])new Object[]{element.getName(), EXTENSION_POINT}));
        }
        for (i = 0; i < this.migrationFrameworkDescriptors.size(); ++i) {
            descriptor = this.migrationFrameworkDescriptors.get(i);
            if (descriptor.isDisabled()) continue;
            Set<String> dependsOnIDs = descriptor.getDependsOnIDs();
            for (String dependsOnID : dependsOnIDs) {
                if (knownIds.containsKey(dependsOnID) || !descriptor.isRequiredDependsOnID(dependsOnID)) continue;
                descriptor.setDisabled(true);
                MigrationPlugin.logError(MigrationMessages.bind((String)MigrationMessages.MigrationFrameworkRegistry_missingDependsOn, (Object[])new Object[]{EXTENSION_POINT, descriptor.getElement().getContributor().getName(), descriptor.getID(), dependsOnID}));
            }
            if (!descriptor.isDisabled()) continue;
            className = descriptor.getElement().getAttribute(ATTRIBUTE_CLASS_NAME);
            MigrationPlugin.logError(MigrationMessages.bind((String)MigrationMessages.MigrationFrameworkRegistry_ignoredMigrator, (Object)className));
        }
        for (i = 0; i < this.migrationFrameworkDescriptors.size(); ++i) {
            Set<String> transitiveIDs;
            descriptor = this.migrationFrameworkDescriptors.get(i);
            if (descriptor.isDisabled() || !(transitiveIDs = descriptor.getTransitiveDependsOnIDs()).contains(descriptor.getID())) continue;
            descriptor.setDisabled(true);
            HashSet<MigrationFrameworkDescriptor> cycle = new HashSet<MigrationFrameworkDescriptor>();
            for (String dependOnID : transitiveIDs) {
                MigrationFrameworkDescriptor dependOnDescriptor = (MigrationFrameworkDescriptor)knownIds.get(dependOnID);
                if (dependOnDescriptor.getDependsOnIDs().isEmpty()) continue;
                cycle.add(dependOnDescriptor);
            }
            StringBuffer strBuff = new StringBuffer();
            strBuff.append(MigrationMessages.bind((String)MigrationMessages.MigrationFrameworkRegistry_cyclicalDependsOn, (Object)EXTENSION_POINT));
            for (MigrationFrameworkDescriptor cycleDescriptor : cycle) {
                strBuff.append("plug-in: ");
                strBuff.append(cycleDescriptor.getElement().getContributor().getName());
                strBuff.append(ATTRIBUTE_ID);
                strBuff.append(": ");
                strBuff.append(cycleDescriptor.getID());
                strBuff.append(DEPENDS_ON_ELEMENT);
                strBuff.append(": ");
                Set<String> dependsOnIDs = cycleDescriptor.getDependsOnIDs();
                for (String dependsOnID : dependsOnIDs) {
                    strBuff.append(dependsOnID);
                    strBuff.append(" ");
                }
            }
            MigrationPlugin.logError(strBuff.toString());
            if (!descriptor.isDisabled()) continue;
            String className2 = descriptor.getElement().getAttribute(ATTRIBUTE_CLASS_NAME);
            MigrationPlugin.logError(MigrationMessages.bind((String)MigrationMessages.MigrationFrameworkRegistry_ignoredMigrator, (Object)className2));
        }
        this.migrationFrameworkDescriptors = this.sort(this.migrationFrameworkDescriptors);
    }

    private List<MigrationFrameworkDescriptor> sort(List<MigrationFrameworkDescriptor> descriptors) {
        List<MigrationFrameworkDescriptor> copy = this.getDescriptorsSortedByID(descriptors);
        ArrayList<MigrationFrameworkDescriptor> sortedDescriptors = new ArrayList<MigrationFrameworkDescriptor>();
        HashSet<String> sortedIDs = new HashSet<String>();
        while (!copy.isEmpty()) {
            for (int i = 0; i < copy.size(); ++i) {
                MigrationFrameworkDescriptor descriptor = copy.get(i);
                Set<String> transitiveIDs = descriptor.getTransitiveDependsOnIDs();
                if (!sortedIDs.containsAll(transitiveIDs)) continue;
                if (!descriptor.isDisabled()) {
                    sortedDescriptors.add(descriptor);
                }
                sortedIDs.add(descriptor.getID());
                copy.remove(i);
                --i;
            }
        }
        return sortedDescriptors;
    }

    private List<MigrationFrameworkDescriptor> getDescriptorsSortedByID(List<MigrationFrameworkDescriptor> descriptors) {
        ArrayList<MigrationFrameworkDescriptor> descriptorsCopy = new ArrayList<MigrationFrameworkDescriptor>();
        descriptorsCopy.addAll(descriptors);
        Comparator<MigrationFrameworkDescriptor> comp = new Comparator<MigrationFrameworkDescriptor>(){

            @Override
            public int compare(MigrationFrameworkDescriptor descriptor1, MigrationFrameworkDescriptor descriptor2) {
                return descriptor1.getID().toUpperCase().compareTo(descriptor2.getID().toUpperCase());
            }
        };
        Collections.sort(descriptorsCopy, comp);
        return descriptorsCopy;
    }
}

