/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.common.internal.migration.framework;

import com.ibm.etools.common.internal.migration.framework.WorkspaceMigrationEngine;
import com.ibm.etools.common.internal.migration.validation.framework.MigrationValidatorEngine;
import com.ibm.etools.common.migration.validation.framework.IMigrationResultsListener;
import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.wst.common.frameworks.datamodel.AbstractDataModelOperation;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;

public class MigrationFrameworkOperation
extends AbstractDataModelOperation {
    public MigrationFrameworkOperation(IDataModel dataModel) {
        super(dataModel);
    }

    public IStatus execute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        List migrationProjects = (List)this.getDataModel().getProperty("IMigrationFrameworkDataModelProperties.SELECTED_MIGRATION_PROJECTS");
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        WorkspaceMigrationEngine.instance().migrateProjects(migrationProjects, (IProgressMonitor)progress.newChild(75));
        IMigrationResultsListener resultsListener = (IMigrationResultsListener)this.getDataModel().getProperty("IMigrationFrameworkDataModelProperties.MIGRATION_RESULTS_VIEW_LISTENER");
        if (resultsListener != null && !progress.isCanceled()) {
            MigrationValidatorEngine validationEngine = new MigrationValidatorEngine();
            IProject[] projectArray = migrationProjects.toArray(new IProject[migrationProjects.size()]);
            IStatus status = validationEngine.validateMigration((IProgressMonitor)progress.newChild(25), projectArray, resultsListener);
            this.getDataModel().setProperty("IMigrationFrameworkDataModelProperties.MIGRATION_VALIDATION_STATUS", (Object)status);
            this.getDataModel().setProperty("IMigrationFrameworkDataModelProperties.LEGACY_PROJECTS", validationEngine.getLegacyProjects());
        }
        progress.done();
        return Status.OK_STATUS;
    }
}

