/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.common.internal.migration.framework;

import com.ibm.etools.common.internal.migration.framework.MigrationFrameworkRegistry;
import com.ibm.etools.common.internal.migration.framework.MigrationMessages;
import com.ibm.etools.common.internal.migration.plugin.MigrationPlugin;
import com.ibm.etools.common.migration.framework.IMigrator;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.Stack;
import org.eclipse.core.expressions.EvaluationContext;
import org.eclipse.core.expressions.EvaluationResult;
import org.eclipse.core.expressions.Expression;
import org.eclipse.core.expressions.ExpressionConverter;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IPath;

public class MigrationFrameworkDescriptor {
    protected IConfigurationElement configurationElement = null;
    private Set<String> dependsOnIDs;
    private Set<String> optionalDependsOnIDs;
    private Set<String> transitiveDependsOnIDs;
    private Set<Expression> enablements;
    private boolean disabled = false;
    private boolean isMetadataMigrator = false;
    private IMigrator migrator;
    private static final String FALSE = "false";

    public MigrationFrameworkDescriptor(IConfigurationElement element) {
        this.configurationElement = element;
        this.isMetadataMigrator = Boolean.parseBoolean(this.configurationElement.getAttribute("migratesWorkspaceMetadata"));
    }

    public IMigrator createExecutableExtension() throws CoreException {
        if (this.migrator == null) {
            this.migrator = (IMigrator)this.configurationElement.createExecutableExtension("className");
        }
        return this.migrator;
    }

    public IConfigurationElement getElement() {
        return this.configurationElement;
    }

    public String getID() {
        return this.configurationElement.getAttribute("id");
    }

    protected void setDisabled(boolean isDisabled) {
        this.disabled = isDisabled;
    }

    protected boolean isDisabled() {
        return this.disabled;
    }

    public boolean isMetadataMigrator() {
        return this.isMetadataMigrator;
    }

    public Set<String> getDependsOnIDs() {
        if (this.dependsOnIDs == null) {
            IConfigurationElement[] dependsElements = this.configurationElement.getChildren("dependsOn");
            if (null == dependsElements || dependsElements.length == 0) {
                this.dependsOnIDs = Collections.emptySet();
                return this.dependsOnIDs;
            }
            HashSet<String> ids = new HashSet<String>();
            HashSet<String> optionalIDs = new HashSet<String>();
            for (int i = 0; i < dependsElements.length; ++i) {
                String dependsOnID = dependsElements[i].getAttribute("id");
                if (null == dependsOnID || dependsOnID.trim().length() == 0) {
                    MigrationPlugin.logError(MigrationMessages.bind((String)MigrationMessages.MigrationFrameworkRegistry_missingAttribute, (Object[])new Object[]{"migration", "dependsOn", "id"}));
                    continue;
                }
                boolean isUniqueID = ids.add(dependsOnID);
                if (!isUniqueID) {
                    MigrationPlugin.logError(MigrationMessages.bind((String)MigrationMessages.MigrationFrameworkDescriptor_duplicateDependsOnID, (Object[])new Object[]{"migration", "dependsOn", dependsOnID}));
                }
                if (!FALSE.equals(dependsElements[i].getAttribute("failOnAbsent"))) continue;
                optionalIDs.add(dependsOnID);
            }
            this.dependsOnIDs = Collections.unmodifiableSet(ids);
            this.optionalDependsOnIDs = Collections.unmodifiableSet(optionalIDs);
        }
        return this.dependsOnIDs;
    }

    protected boolean isRequiredDependsOnID(String dependsOnID) {
        return !this.optionalDependsOnIDs.contains(dependsOnID);
    }

    public Set<String> getTransitiveDependsOnIDs() {
        if (this.transitiveDependsOnIDs == null) {
            Set<String> direct = this.getDependsOnIDs();
            HashSet<String> ids = new HashSet<String>();
            Stack<String> toProcess = new Stack<String>();
            toProcess.addAll(direct);
            while (!toProcess.isEmpty()) {
                MigrationFrameworkDescriptor descriptor;
                String currentID = (String)toProcess.pop();
                if (ids.contains(currentID) || (descriptor = MigrationFrameworkRegistry.INSTANCE.getMigrationFrameworkDescriptor(currentID)) == null) continue;
                ids.add(currentID);
                toProcess.addAll(descriptor.getDependsOnIDs());
            }
            this.transitiveDependsOnIDs = Collections.unmodifiableSet(ids);
        }
        return this.transitiveDependsOnIDs;
    }

    public boolean isEnabledForProject(IProject project) {
        if (this.isMetadataMigrator) {
            return false;
        }
        if (this.enablements == null) {
            this.createEnablements();
        }
        return this.getEvaluationResult(project);
    }

    public boolean isEnabledForWorkspaceMetadata() {
        if (!this.isMetadataMigrator) {
            return false;
        }
        if (this.enablements == null) {
            this.createEnablements();
        }
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IPath metadataPluginsPath = workspace.getRoot().getLocation().append(".metadata").append(".plugins");
        return this.getEvaluationResult(metadataPluginsPath);
    }

    private void createEnablements() {
        IConfigurationElement[] enablementElements = this.configurationElement.getChildren("enablement");
        if (null == enablementElements || enablementElements.length == 0) {
            this.enablements = Collections.emptySet();
        } else {
            HashSet<Expression> expressions = new HashSet<Expression>();
            for (int i = 0; i < enablementElements.length; ++i) {
                try {
                    Expression enablementExpression = ExpressionConverter.getDefault().perform(enablementElements[i]);
                    expressions.add(enablementExpression);
                    continue;
                }
                catch (CoreException e) {
                    MigrationPlugin.logError(MigrationMessages.bind((String)MigrationMessages.MigrationFrameworkDescriptor_badEnablement, (Object[])new Object[]{"migration", enablementElements[i]}));
                    MigrationPlugin.logError(e);
                }
            }
            this.enablements = Collections.unmodifiableSet(expressions);
        }
    }

    private boolean getEvaluationResult(Object defaultVariable) {
        Iterator<Expression> expressions = this.enablements.iterator();
        if (this.enablements.isEmpty()) {
            return false;
        }
        while (expressions.hasNext()) {
            Expression expression = expressions.next();
            if (expression == null) continue;
            try {
                EvaluationContext context = new EvaluationContext(null, defaultVariable);
                context.setAllowPluginActivation(true);
                EvaluationResult result = expression.evaluate((IEvaluationContext)context);
                if (result != EvaluationResult.FALSE && result != EvaluationResult.NOT_LOADED) continue;
                return false;
            }
            catch (CoreException e) {
                MigrationPlugin.logError(e);
                return false;
            }
        }
        return true;
    }

    public String toString() {
        StringBuffer buff = new StringBuffer();
        buff.append("id");
        buff.append('=');
        buff.append(this.getID());
        buff.append(' ');
        buff.append("dependsOn");
        buff.append('=');
        IConfigurationElement[] dependsElements = this.configurationElement.getChildren("dependsOn");
        for (int i = 0; i < dependsElements.length; ++i) {
            String rawRequires = dependsElements[i].getAttribute("id");
            buff.append(rawRequires);
            buff.append(' ');
        }
        if (dependsElements.length == 0) {
            buff.append("null");
        }
        return buff.toString();
    }
}

