/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.common.internal.migration;

import com.ibm.etools.common.internal.migration.plugin.MigrationPlugin;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.util.Properties;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.wst.common.frameworks.internal.SimpleValidateEdit;
import org.eclipse.wst.common.internal.emf.utilities.Assert;

public final class CompatibilityUtils {
    public static final String COMPATIBILITY_FILE_NAME = ".compatibility";
    public static final String COMPATIBILITY_MODE = "compatibilityMode";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties getCompatibilityProperties(IProject project) {
        Properties props;
        block6: {
            props = new Properties();
            Assert.isNotNull((Object)project, (String)"A valid IProject is required to acquire compatibility properties.");
            try {
                IFile dotCompat = project.getFile(COMPATIBILITY_FILE_NAME);
                if (!dotCompat.isAccessible()) break block6;
                try (InputStream dotCompatInputStream = null;){
                    dotCompatInputStream = dotCompat.getContents(true);
                    props.load(dotCompatInputStream);
                }
            }
            catch (Exception e) {
                MigrationPlugin.logError(e);
            }
        }
        return props;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveCompatibilityProperties(IProject project, Properties props) {
        block10: {
            Assert.isNotNull((Object)project, (String)"A valid IProject is required to save compatibility properties.");
            if (props == null || props.isEmpty()) {
                return;
            }
            ByteArrayOutputStream bos = null;
            ByteArrayInputStream biz = null;
            try {
                IFile dotCompat = project.getFile(COMPATIBILITY_FILE_NAME);
                if (!SimpleValidateEdit.validateEdit((IFile[])new IFile[]{dotCompat})) break block10;
                try {
                    bos = new ByteArrayOutputStream();
                    props.store(bos, null);
                    biz = new ByteArrayInputStream(bos.toByteArray());
                    if (!dotCompat.exists()) {
                        dotCompat.create((InputStream)biz, true, null);
                    } else {
                        dotCompat.setContents((InputStream)biz, true, false, null);
                    }
                }
                finally {
                    if (biz != null) {
                        biz.close();
                    }
                    if (bos != null) {
                        bos.close();
                    }
                }
            }
            catch (Exception e) {
                MigrationPlugin.logError(e);
            }
        }
    }

    public static boolean isPersistedTimestampCurrent(IProject project, IFile file) {
        long persistedTimestamp;
        Assert.isNotNull((Object)project, (String)"A valid IProject is required to acquire compatibility properties.");
        if (file == null || !file.exists()) {
            return false;
        }
        long fileStamp = file.getModificationStamp();
        return fileStamp == (persistedTimestamp = CompatibilityUtils.getPersistedTimestamp(project, file));
    }

    public static long getPersistedTimestamp(IProject project, IFile file) {
        Assert.isNotNull((Object)project, (String)"A valid IProject is required to acquire compatibility properties.");
        if (file == null) {
            return -1L;
        }
        Properties props = CompatibilityUtils.getCompatibilityProperties(project);
        String persistedTimestamp = props.getProperty(file.getName());
        if (persistedTimestamp != null && persistedTimestamp.length() > 0) {
            return Long.parseLong(persistedTimestamp);
        }
        return -1L;
    }

    public static void updateTimestamp(IProject project, IFile file) {
    }

    public static boolean getCompatibilityMode(IProject project) {
        boolean returnVal = true;
        Properties properties = CompatibilityUtils.getCompatibilityProperties(project);
        if (properties.containsKey(COMPATIBILITY_MODE)) {
            String compatibilityModeString = properties.getProperty(COMPATIBILITY_MODE);
            returnVal = Boolean.getBoolean(compatibilityModeString);
        }
        return returnVal;
    }

    public static void setCompatibilityMode(IProject project, boolean compatibilityMode) {
        Properties properties = CompatibilityUtils.getCompatibilityProperties(project);
        properties.setProperty(COMPATIBILITY_MODE, Boolean.valueOf(compatibilityMode).toString());
        CompatibilityUtils.saveCompatibilityProperties(project, properties);
    }
}

