/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.common.migration.extension.ui.internal.wizard;

import com.ibm.etools.common.migration.extension.ui.IMigrationDefaultSelectionProvider;
import com.ibm.etools.common.migration.extension.ui.internal.IMetaDataUtil;
import com.ibm.etools.common.migration.extension.ui.internal.IRetargetFilter;
import com.ibm.etools.common.migration.extension.ui.internal.MigrationPlugin;
import com.ibm.etools.common.migration.extension.ui.internal.MigrationPluginCoreMessages;
import com.ibm.etools.common.migration.extension.ui.internal.model.UnresolvedRuntime;
import com.ibm.etools.common.migration.extension.ui.internal.trace.Logger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.util.ConfigureColumns;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.CellNavigationStrategy;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerEditorActivationEvent;
import org.eclipse.jface.viewers.ColumnViewerEditorActivationListener;
import org.eclipse.jface.viewers.ColumnViewerEditorActivationStrategy;
import org.eclipse.jface.viewers.ColumnViewerEditorDeactivationEvent;
import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.FocusCellHighlighter;
import org.eclipse.jface.viewers.FocusCellOwnerDrawHighlighter;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SWTFocusCellManager;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.TableViewerEditor;
import org.eclipse.jface.viewers.TableViewerFocusCellManager;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.jst.server.core.FacetUtil;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.MenuDetectEvent;
import org.eclipse.swt.events.MenuDetectListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.internal.datamodel.ui.DataModelWizardPage;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.IRuntimeWorkingCopy;
import org.eclipse.wst.server.core.ServerCore;
import org.eclipse.wst.server.core.internal.IRuntimeLocator;
import org.eclipse.wst.server.core.internal.ServerPlugin;
import org.eclipse.wst.server.ui.internal.EclipseUtil;
import org.eclipse.wst.server.ui.internal.Messages;
import org.eclipse.wst.server.ui.internal.SWTUtil;
import org.osgi.framework.Bundle;
import org.w3c.dom.Document;

public class ProjectRetargetingPage
extends DataModelWizardPage
implements IShellProvider {
    public static final String RUNTIME_TYPE_ID_V51 = "com.ibm.etools.websphere.runtime.v51.base";
    public static final String RUNTIME_TYPE_ID_V50 = "com.ibm.etools.websphere.runtime.v50.base";
    Hashtable<org.eclipse.wst.common.project.facet.core.runtime.IRuntime, UnresolvedRuntime> unresolvedRuntimeList;
    ArrayList<IRetargetFilter> filterProviders = new ArrayList();
    IMetaDataUtil rad6MetaDataUtil = null;
    ArrayList<DefaultRuntimeProvider> defaultSelectionProviderList = new ArrayList();
    boolean hasLoadedExtensionPoints = false;
    TableViewer runtimesTableViewer;
    TableViewer projectsTableViewer;
    final Image image = MigrationPlugin.getImageDescriptor("arrowdown.gif").createImage();
    private IDataModel dataModel;
    private IRuntime[] supportedRuntimes;

    public void performHelp() {
        Bundle bundle = Platform.getBundle((String)"com.ibm.ws.ast.st.core.ext");
        if (bundle != null) {
            PlatformUI.getWorkbench().getHelpSystem().displayHelpResource("/com.ibm.servertools.doc/topics/tmigtargetruntime.html");
        } else {
            PlatformUI.getWorkbench().getHelpSystem().displayHelp("com.ibm.etools.common.migration.extension.ui.migr0000");
        }
    }

    public ProjectRetargetingPage(IDataModel dataModel) {
        super(dataModel, "ProjectRetargetingPage");
        this.loadExtensionPoints();
        if (this.rad6MetaDataUtil != null) {
            this.rad6MetaDataUtil.migrateMetaData();
        }
        this.setTitle(MigrationPluginCoreMessages.L_ProjectRetargetingWizPage);
        this.setDescription(MigrationPluginCoreMessages.L_ProjectRetargetingWizPageWarning);
        this.dataModel = dataModel;
        this.setSupportedRuntimesWithLatestFromServerCore();
    }

    protected void setSupportedRuntimesWithLatestFromServerCore() {
        List<IRuntime> runtimeList = Arrays.asList(ServerCore.getRuntimes());
        ArrayList<IRuntime> supportedRuntimeList = new ArrayList<IRuntime>();
        for (IRuntime runtime : runtimeList) {
            if (ProjectRetargetingPage.isRuntimeUnSupported(runtime)) continue;
            supportedRuntimeList.add(runtime);
        }
        this.supportedRuntimes = supportedRuntimeList.toArray(new IRuntime[supportedRuntimeList.size()]);
    }

    protected boolean hasFilteredRuntime(org.eclipse.wst.common.project.facet.core.runtime.IRuntime facetRuntime) {
        if (facetRuntime == null) {
            return false;
        }
        UnresolvedRuntime curUnresolvedRuntime = this.unresolvedRuntimeList.get(facetRuntime);
        if (curUnresolvedRuntime == null) {
            return false;
        }
        IRuntime[] filteredRuntimes = curUnresolvedRuntime.getAvailableRuntimes();
        return filteredRuntimes != null && filteredRuntimes.length > 0;
    }

    private IRuntime[] getFilteredRuntimes(org.eclipse.wst.common.project.facet.core.runtime.IRuntime facetedRuntime, IRuntime[] availableRuntimes) {
        IRetargetFilter[] runtimeFilters;
        UnresolvedRuntime curUnresolvedRuntime = this.unresolvedRuntimeList.get(facetedRuntime);
        if (curUnresolvedRuntime == null) {
            return new IRuntime[0];
        }
        ArrayList filteredList = new ArrayList();
        if (this.filterProviders.isEmpty()) {
            this.loadExtensionPoints();
        }
        for (IRetargetFilter filter : runtimeFilters = this.filterProviders.toArray(new IRetargetFilter[0])) {
            IProject[] projectList = curUnresolvedRuntime.getSelectedProjects();
            IRuntime[] curFilterRuntimes = filter.filter(facetedRuntime, availableRuntimes, projectList);
            if (curFilterRuntimes != null && curFilterRuntimes.length > 0) {
                Collections.addAll(filteredList, curFilterRuntimes);
                continue;
            }
            curUnresolvedRuntime.setErrorMessage(filter.getError());
        }
        return filteredList.toArray(new IRuntime[0]);
    }

    private void loadExtensionPoints() {
        IConfigurationElement exElement;
        int i;
        if (Logger.DETAILS) {
            Logger.println("/debug/details", (Object)this, "loadExtensionPoints()", "load RetargetingFilters extension point");
        }
        if (this.hasLoadedExtensionPoints) {
            return;
        }
        this.hasLoadedExtensionPoints = true;
        IExtensionRegistry reg = Platform.getExtensionRegistry();
        IConfigurationElement[] extensions = reg.getConfigurationElementsFor("com.ibm.etools.common.migration.extension.ui.retargetFilter");
        for (i = 0; i < extensions.length; ++i) {
            block13: {
                exElement = extensions[i];
                try {
                    IRetargetFilter retargetingFilter = (IRetargetFilter)exElement.createExecutableExtension("class");
                    this.filterProviders.add(retargetingFilter);
                }
                catch (CoreException e) {
                    if (!Logger.ERROR) break block13;
                    Logger.println("/debug/error", ((Object)((Object)this)).getClass(), "loadExtensionPoints", ".retargetFilter failed to load" + extensions[i].toString(), (Throwable)e);
                }
            }
            if (!Logger.DETAILS) continue;
            Logger.println("/debug/details", (Object)this, "loadExtensionPoints()", "loaded IRetargetFilter: " + extensions[i].getAttribute("id"));
        }
        extensions = reg.getConfigurationElementsFor("com.ibm.etools.common.migration.extension.ui.migrationDefaultSelection");
        for (i = 0; i < extensions.length; ++i) {
            exElement = extensions[i];
            try {
                if (Logger.DETAILS) {
                    Logger.println("/debug/details", ((Object)((Object)this)).getClass(), "loadExtensionPoints", ".migrationDefaultSelection processing: " + extensions[i].toString());
                }
                String weight = exElement.getAttribute("weight");
                IMigrationDefaultSelectionProvider provider = (IMigrationDefaultSelectionProvider)exElement.createExecutableExtension("class");
                DefaultRuntimeProvider p = new DefaultRuntimeProvider(provider, weight);
                this.defaultSelectionProviderList.add(p);
                continue;
            }
            catch (CoreException e) {
                if (!Logger.ERROR) continue;
                Logger.println("/debug/error", ((Object)((Object)this)).getClass(), "loadExtensionPoints", ".migrationDefaultSelection failed to load" + extensions[i].toString(), (Throwable)e);
            }
        }
        extensions = reg.getConfigurationElementsFor("com.ibm.etools.common.migration.extension.ui.radMetaDataUtil");
        for (i = 0; i < extensions.length; ++i) {
            exElement = extensions[i];
            try {
                if (Logger.DETAILS) {
                    Logger.println("/debug/details", ((Object)((Object)this)).getClass(), "loadExtensionPoints", ".migrationDefaultSelection processing: " + extensions[i].toString());
                }
                this.rad6MetaDataUtil = (IMetaDataUtil)exElement.createExecutableExtension("class");
                continue;
            }
            catch (CoreException e) {
                if (!Logger.ERROR) continue;
                Logger.println("/debug/error", ((Object)((Object)this)).getClass(), "loadExtensionPoints", ".migrationDefaultSelection failed to load" + extensions[i].toString(), (Throwable)e);
            }
        }
    }

    public Composite createTopLevelComposite(Composite parent) {
        Composite contentArea = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout(2, true);
        contentArea.setLayout((Layout)gridLayout);
        this.setUnresolvedRuntime(this.dataModel);
        this.setDefaultRuntime();
        this.createLabel(contentArea, MigrationPluginCoreMessages.L_ProjectRetargetingWizPageDescription);
        this.createLabel(contentArea, MigrationPluginCoreMessages.L_RuntimeTableDescription);
        this.createRuntimeArea(contentArea);
        this.createServerRuntimeEnviromentsLinkArea(contentArea);
        this.createLabel(contentArea, "");
        this.createLabel(contentArea, MigrationPluginCoreMessages.L_ProjectTableDescription);
        this.createProjectArea(contentArea);
        this.setDefaults();
        this.runtimesTableViewer.getTable().pack();
        Dialog.applyDialogFont((Control)contentArea);
        this.setControl((Control)contentArea);
        return contentArea;
    }

    private void createRuntimeArea(Composite contentArea) {
        if (Logger.INFO) {
            Logger.println("/debug/info", (Object)this, "createRuntimeArea()", "Create Runtime area");
        }
        Table table = new Table(contentArea, 67584);
        GridData data = new GridData(4, 4, true, true);
        data.horizontalSpan = 2;
        table.setLayoutData((Object)data);
        table.setHeaderVisible(true);
        int COLUMN_WIDTH = 315;
        this.runtimesTableViewer = new TableViewer(table);
        this.runtimesTableViewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public Object[] getElements(Object inputElement) {
                Set unresolvedRuntimeKeySet = (Set)inputElement;
                return unresolvedRuntimeKeySet.toArray();
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        });
        TableViewerColumn unresolvedColumnViewer = new TableViewerColumn(this.runtimesTableViewer, 0);
        unresolvedColumnViewer.getColumn().setText(MigrationPluginCoreMessages.L_UnResolvedRuntime);
        unresolvedColumnViewer.getColumn().setWidth(315);
        unresolvedColumnViewer.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                org.eclipse.wst.common.project.facet.core.runtime.IRuntime runtime = (org.eclipse.wst.common.project.facet.core.runtime.IRuntime)element;
                try {
                    IProject project = ProjectRetargetingPage.this.unresolvedRuntimeList.get(runtime).getProjectAsList()[0];
                    IFile file = project.getFile(".settings/org.eclipse.wst.common.project.facet.core.xml");
                    DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
                    DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
                    Document doc = dBuilder.parse(file.getContents());
                    doc.getDocumentElement().normalize();
                    return doc.getElementsByTagName("runtime").item(0).getAttributes().getNamedItem("name").getNodeValue();
                }
                catch (Exception project) {
                    IRuntime runtime2 = FacetUtil.getRuntime((org.eclipse.wst.common.project.facet.core.runtime.IRuntime)runtime);
                    if (runtime2 != null && runtime2.getRuntimeType() != null) {
                        return runtime2.getRuntimeType().getName();
                    }
                    return "";
                }
            }

            public String getToolTipText(Object element) {
                return this.getText(element);
            }

            public int getToolTipDisplayDelayTime(Object object) {
                return 1300;
            }
        });
        TableViewerColumn resolvedColumnViewer = new TableViewerColumn(this.runtimesTableViewer, 0);
        final TableColumn resolvedColumn = resolvedColumnViewer.getColumn();
        resolvedColumn.setText(MigrationPluginCoreMessages.L_ResolvedRuntime);
        resolvedColumn.setWidth(315);
        Listener paintListener = new Listener(){

            public void handleEvent(Event event) {
                switch (event.type) {
                    case 41: {
                        if (event.index != 1) break;
                        Rectangle rect = ProjectRetargetingPage.this.image.getBounds();
                        event.width += rect.width;
                        event.height = Math.max(event.height, rect.height + 2);
                        break;
                    }
                    case 42: {
                        if (!ProjectRetargetingPage.this.hasFilteredRuntime((org.eclipse.wst.common.project.facet.core.runtime.IRuntime)event.item.getData())) {
                            return;
                        }
                        if (event.index != 1) break;
                        Rectangle rect = ProjectRetargetingPage.this.image.getBounds();
                        int x = Math.max(0, event.x + resolvedColumn.getWidth() - rect.width);
                        int offset = Math.max(0, (event.height - rect.height) / 2);
                        event.gc.drawImage(ProjectRetargetingPage.this.image, x, event.y + offset);
                    }
                }
            }
        };
        table.addListener(41, paintListener);
        table.addListener(42, paintListener);
        resolvedColumnViewer.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                org.eclipse.wst.common.project.facet.core.runtime.IRuntime facetedRuntime = (org.eclipse.wst.common.project.facet.core.runtime.IRuntime)element;
                IRuntime runtime = ProjectRetargetingPage.this.unresolvedRuntimeList.get(facetedRuntime).getRuntime();
                String text = runtime == null ? MigrationPluginCoreMessages.L_NoRuntimeSelected : runtime.getName();
                return text;
            }

            public String getToolTipText(Object element) {
                return this.getText(element);
            }

            public int getToolTipDisplayDelayTime(Object object) {
                return 1300;
            }
        });
        resolvedColumnViewer.setEditingSupport((EditingSupport)new ResolvedRuntimeEditor(this.runtimesTableViewer));
        CellNavigationStrategy strategy = new CellNavigationStrategy(){

            public ViewerCell findSelectedCell(ColumnViewer viewer, ViewerCell currentSelectedCell, Event event) {
                ViewerCell cell = super.findSelectedCell(viewer, currentSelectedCell, event);
                if (cell != null) {
                    TableColumn t = ProjectRetargetingPage.this.runtimesTableViewer.getTable().getColumn(cell.getColumnIndex());
                    ProjectRetargetingPage.this.runtimesTableViewer.getTable().showColumn(t);
                }
                return cell;
            }
        };
        TableViewerFocusCellManager focusCellManager = new TableViewerFocusCellManager(this.runtimesTableViewer, (FocusCellHighlighter)new FocusCellOwnerDrawHighlighter((ColumnViewer)this.runtimesTableViewer), strategy);
        ColumnViewerEditorActivationStrategy actSupport = new ColumnViewerEditorActivationStrategy((ColumnViewer)this.runtimesTableViewer){

            protected boolean isEditorActivationEvent(ColumnViewerEditorActivationEvent event) {
                return event.eventType == 5 || event.eventType == 2 || event.eventType == 1 && event.keyCode == 0x1000002 || event.eventType == 4;
            }
        };
        TableViewerEditor.create((TableViewer)this.runtimesTableViewer, (SWTFocusCellManager)focusCellManager, (ColumnViewerEditorActivationStrategy)actSupport, (int)60);
        this.runtimesTableViewer.getColumnViewerEditor().addEditorActivationListener(new ColumnViewerEditorActivationListener(){

            public void afterEditorActivated(ColumnViewerEditorActivationEvent event) {
            }

            public void afterEditorDeactivated(ColumnViewerEditorDeactivationEvent event) {
            }

            public void beforeEditorActivated(ColumnViewerEditorActivationEvent event) {
                ViewerCell cell = (ViewerCell)event.getSource();
                ProjectRetargetingPage.this.runtimesTableViewer.getTable().showColumn(ProjectRetargetingPage.this.runtimesTableViewer.getTable().getColumn(cell.getColumnIndex()));
            }

            public void beforeEditorDeactivated(ColumnViewerEditorDeactivationEvent event) {
            }
        });
        Set<org.eclipse.wst.common.project.facet.core.runtime.IRuntime> curUnresolvedRuntimeItems = this.unresolvedRuntimeList.keySet();
        this.runtimesTableViewer.setInput(curUnresolvedRuntimeItems);
        this.runtimesTableViewer.getTable().setLinesVisible(true);
        this.runtimesTableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ProjectRetargetingPage.this.setMessage(MigrationPluginCoreMessages.L_ProjectRetargetingWizPageWarning);
                org.eclipse.wst.common.project.facet.core.runtime.IRuntime curSelectedRuntime = ProjectRetargetingPage.this.getSelectedRuntime();
                if (curSelectedRuntime != null) {
                    UnresolvedRuntime selectedUnresolvedRuntime = ProjectRetargetingPage.this.unresolvedRuntimeList.get(curSelectedRuntime);
                    ProjectRetargetingPage.this.updateProjectList(selectedUnresolvedRuntime.getProjectAsList());
                    if (!ProjectRetargetingPage.this.hasFilteredRuntime(curSelectedRuntime)) {
                        ProjectRetargetingPage.this.setMessage(this.buildErrorMessage(selectedUnresolvedRuntime.getErrorMessage()), 2);
                    }
                }
            }

            private String buildErrorMessage(String[] errMsgs) {
                if (errMsgs == null) {
                    return null;
                }
                Object finalErrorMsg = null;
                for (String curErrMsg : errMsgs) {
                    finalErrorMsg = finalErrorMsg == null ? curErrMsg : (String)finalErrorMsg + "\n" + curErrMsg;
                }
                return finalErrorMsg;
            }
        });
        this.runtimesTableViewer.getTable().addMenuDetectListener(new MenuDetectListener(){

            public void menuDetected(MenuDetectEvent arg0) {
                Object object;
                int index = ProjectRetargetingPage.this.runtimesTableViewer.getTable().getSelectionIndex();
                if (index > -1 && (object = ProjectRetargetingPage.this.runtimesTableViewer.getElementAt(index)) != null) {
                    ProjectRetargetingPage.this.runtimesTableViewer.editElement(object, 1);
                }
            }
        });
        if (Logger.INFO) {
            Logger.println("/debug/info", (Object)this, "createRuntimeArea()", "Runtime area created");
        }
    }

    private void createProjectArea(Composite contentArea) {
        if (Logger.INFO) {
            Logger.println("/debug/info", (Object)this, "createProjectArea()", "Create Project area");
        }
        Composite projectComposite = new Composite(contentArea, 0);
        GridLayout gridLayout = new GridLayout(2, false);
        projectComposite.setLayout((Layout)gridLayout);
        GridData data = new GridData(4, 4, true, true);
        data.horizontalSpan = 2;
        projectComposite.setLayoutData((Object)data);
        Table projectTable = new Table(projectComposite, 67616);
        projectTable.setLinesVisible(false);
        projectTable.setHeaderVisible(true);
        data = new GridData(4, 4, true, true);
        data.heightHint = 40;
        projectTable.setLayoutData((Object)data);
        this.projectsTableViewer = new TableViewer(projectTable);
        TableViewerColumn projectsColumn = new TableViewerColumn(this.projectsTableViewer, 0);
        projectsColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                IProject project = (IProject)element;
                return project.getName();
            }

            public void update(ViewerCell cell) {
                UnresolvedRuntime selectedUnresolvedRuntime = ProjectRetargetingPage.this.unresolvedRuntimeList.get(ProjectRetargetingPage.this.getSelectedRuntime());
                ((TableItem)cell.getItem()).setChecked(selectedUnresolvedRuntime.isProjectSelected((IProject)cell.getElement()));
                super.update(cell);
            }
        });
        projectsColumn.getColumn().setWidth(250);
        projectsColumn.getColumn().setText(MigrationPluginCoreMessages.L_ProjectList);
        this.projectsTableViewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public Object[] getElements(Object inputElement) {
                Object[] projects = (IProject[])inputElement;
                return projects;
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        });
        this.projectsTableViewer.getTable().addListener(13, new Listener(){

            public void handleEvent(Event event) {
                if (event.detail == 32) {
                    TableItem item = (TableItem)event.item;
                    final UnresolvedRuntime selectedUnresolvedRuntime = ProjectRetargetingPage.this.unresolvedRuntimeList.get(ProjectRetargetingPage.this.getSelectedRuntime());
                    selectedUnresolvedRuntime.setProjectSelected((IProject)item.getData(), item.getChecked());
                    if (selectedUnresolvedRuntime.getSelectedProjects().length <= 20) {
                        BusyIndicator.showWhile((Display)Display.getCurrent(), (Runnable)new Runnable(){

                            @Override
                            public void run() {
                                selectedUnresolvedRuntime.setAvailableRuntimes(ProjectRetargetingPage.this.getFilteredRuntimes(ProjectRetargetingPage.this.getSelectedRuntime(), ProjectRetargetingPage.this.supportedRuntimes));
                            }
                        });
                    }
                }
            }
        });
        Composite buttonComposite = new Composite(projectComposite, 0);
        GridLayout gridLayot = new GridLayout();
        gridLayot.numColumns = 1;
        buttonComposite.setLayout((Layout)gridLayot);
        data = new GridData(1, 4, true, true);
        buttonComposite.setLayoutData((Object)data);
        new Label(buttonComposite, 0);
        Button selectAll = new Button(buttonComposite, 8);
        selectAll.setText(MigrationPluginCoreMessages.L_SelectAll);
        data = new GridData(1808);
        selectAll.setLayoutData((Object)data);
        selectAll.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                UnresolvedRuntime selectedUnresolvedRuntime = ProjectRetargetingPage.this.unresolvedRuntimeList.get(ProjectRetargetingPage.this.getSelectedRuntime());
                for (IProject iProject : selectedUnresolvedRuntime.getProjectAsList()) {
                    selectedUnresolvedRuntime.setProjectSelected(iProject, true);
                }
                for (IProject iProject : ProjectRetargetingPage.this.projectsTableViewer.getTable().getItems()) {
                    iProject.setChecked(true);
                }
                selectedUnresolvedRuntime.setAvailableRuntimes(ProjectRetargetingPage.this.getFilteredRuntimes(ProjectRetargetingPage.this.getSelectedRuntime(), ProjectRetargetingPage.this.supportedRuntimes));
            }
        });
        Button deselectAll = new Button(buttonComposite, 8);
        deselectAll.setText(MigrationPluginCoreMessages.L_DeSelectAll);
        data = new GridData(1808);
        deselectAll.setLayoutData((Object)data);
        deselectAll.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                UnresolvedRuntime selectedUnresolvedRuntime = ProjectRetargetingPage.this.unresolvedRuntimeList.get(ProjectRetargetingPage.this.getSelectedRuntime());
                for (IProject iProject : selectedUnresolvedRuntime.getProjectAsList()) {
                    selectedUnresolvedRuntime.setProjectSelected(iProject, false);
                }
                for (IProject iProject : ProjectRetargetingPage.this.projectsTableViewer.getTable().getItems()) {
                    iProject.setChecked(false);
                }
                selectedUnresolvedRuntime.setAvailableRuntimes(ProjectRetargetingPage.this.getFilteredRuntimes(ProjectRetargetingPage.this.getSelectedRuntime(), ProjectRetargetingPage.this.supportedRuntimes));
            }
        });
        if (Logger.INFO) {
            Logger.println("/debug/info", (Object)this, "createProjectArea()", "Project area created");
        }
        Button colButton = new Button(buttonComposite, 8);
        data = new GridData(1808);
        colButton.setLayoutData((Object)data);
        colButton.setText(Messages.actionColumns);
        final ProjectRetargetingPage thisClass = this;
        colButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ConfigureColumns.forTable((Table)ProjectRetargetingPage.this.projectsTableViewer.getTable(), (IShellProvider)thisClass);
            }
        });
    }

    private void createServerRuntimeEnviromentsLinkArea(Composite contentArea) {
        Link link = new Link(contentArea, 0);
        link.setText("<a>" + MigrationPluginCoreMessages.L_SearchForServerRuntimeEnviroments + "</a>");
        link.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                block13: {
                    try {
                        DirectoryDialog directoryDialog = new DirectoryDialog(ProjectRetargetingPage.this.getShell());
                        directoryDialog.setMessage(Messages.dialogRuntimeSearchMessage);
                        directoryDialog.setText(Messages.dialogRuntimeSearchTitle);
                        String pathStr = directoryDialog.open();
                        if (pathStr == null) {
                            return;
                        }
                        Path path = new Path(pathStr);
                        final ProgressMonitorDialog dialog = new ProgressMonitorDialog(ProjectRetargetingPage.this.getShell());
                        dialog.setBlockOnOpen(false);
                        dialog.setCancelable(true);
                        dialog.open();
                        final IProgressMonitor monitor = dialog.getProgressMonitor();
                        final IRuntimeLocator[] locators = ServerPlugin.getRuntimeLocators();
                        monitor.beginTask(Messages.dialogRuntimeSearchProgress, 100 * locators.length + 10);
                        final ArrayList list = new ArrayList();
                        IRuntimeLocator.IRuntimeSearchListener listener = new IRuntimeLocator.IRuntimeSearchListener(){

                            public void runtimeFound(final IRuntimeWorkingCopy runtime) {
                                dialog.getShell().getDisplay().syncExec(new Runnable(){

                                    @Override
                                    public void run() {
                                        monitor.subTask(runtime.getName());
                                    }
                                });
                                list.add(runtime);
                            }
                        };
                        IRunnableWithProgress runnable = new IRunnableWithProgress(){
                            final /* synthetic */ IPath val$path;
                            final /* synthetic */ IRuntimeLocator.IRuntimeSearchListener val$listener;
                            {
                                this.val$path = iPath;
                                this.val$listener = iRuntimeSearchListener;
                            }

                            public void run(IProgressMonitor monitor2) {
                                int size = locators.length;
                                for (int i = 0; i < size; ++i) {
                                    if (monitor2.isCanceled()) continue;
                                    try {
                                        locators[i].searchForRuntimes(this.val$path, this.val$listener, monitor2);
                                        continue;
                                    }
                                    catch (CoreException ce) {
                                        if (!Logger.WARNING) continue;
                                        Logger.println("/debug/warning", this, "createServerRuntimeEnviromentsLinkArea()", "Error locating runtimes: " + locators[i].getId(), (Throwable)ce);
                                    }
                                }
                                if (Logger.INFO) {
                                    Logger.println("/debug/info", this, "createServerRuntimeEnviromentsLinkArea()", "Done search");
                                }
                            }
                        };
                        dialog.run(true, true, runnable);
                        if (Logger.INFO) {
                            Logger.println("/debug/info", this, "createServerRuntimeEnviromentsLinkArea()", "Found runtimes: " + list.size());
                        }
                        if (!monitor.isCanceled()) {
                            if (list.isEmpty()) {
                                EclipseUtil.openError((Shell)ProjectRetargetingPage.this.getShell(), (String)Messages.infoNoRuntimesFound);
                                return;
                            }
                            monitor.worked(5);
                            if (Logger.INFO) {
                                Logger.println("/debug/info", this, "createServerRuntimeEnviromentsLinkArea()", "Removing duplicates");
                            }
                            ArrayList<IRuntime> good = new ArrayList<IRuntime>();
                            Iterator iterator2 = list.iterator();
                            while (iterator2.hasNext()) {
                                boolean dup = false;
                                IRuntime wc = (IRuntime)iterator2.next();
                                IRuntime[] runtimes = ServerCore.getRuntimes();
                                if (runtimes != null) {
                                    int size = runtimes.length;
                                    for (int i = 0; i < size; ++i) {
                                        if (runtimes[i].getLocation() == null || !runtimes[i].getLocation().equals((Object)wc.getLocation())) continue;
                                        dup = true;
                                    }
                                }
                                if (dup) continue;
                                good.add(wc);
                            }
                            monitor.worked(5);
                            if (Logger.INFO) {
                                Logger.println("/debug/info", this, "createServerRuntimeEnviromentsLinkArea()", "Adding runtimes: " + good.size());
                            }
                            for (IRuntime wc : good) {
                                wc.save(false, monitor);
                            }
                            if (good.size() > 0) {
                                ProjectRetargetingPage.this.setSupportedRuntimesWithLatestFromServerCore();
                            }
                            monitor.done();
                        }
                        dialog.close();
                    }
                    catch (Exception ex) {
                        if (!Logger.ERROR) break block13;
                        Logger.println("/debug/error", this, "createServerRuntimeEnviromentsLinkArea()", "Error finding runtimes", (Throwable)ex);
                    }
                }
                ProjectRetargetingPage.this.setDefaultRuntime();
                ProjectRetargetingPage.this.runtimesTableViewer.refresh(true);
                ProjectRetargetingPage.this.setDefaults();
            }
        });
        Composite btnComp = new Composite(contentArea, 0);
        GridLayout layout = new GridLayout();
        layout.horizontalSpacing = 0;
        layout.verticalSpacing = this.convertVerticalDLUsToPixels(3);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.numColumns = 1;
        btnComp.setLayout((Layout)layout);
        GridData data = new GridData(144);
        data.horizontalAlignment = 0x1000008;
        data.grabExcessHorizontalSpace = true;
        btnComp.setLayoutData((Object)data);
        Button colButton = SWTUtil.createButton((Composite)btnComp, (String)Messages.actionColumns);
        data = (GridData)colButton.getLayoutData();
        final ProjectRetargetingPage thisClass = this;
        colButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ConfigureColumns.forTable((Table)ProjectRetargetingPage.this.runtimesTableViewer.getTable(), (IShellProvider)thisClass);
            }
        });
    }

    private Label createLabel(Composite parent, String nlsString) {
        Label label = new Label(parent, 64);
        label.setText(nlsString);
        GridData data = new GridData(4, 4, true, true);
        data.horizontalSpan = 2;
        label.setLayoutData((Object)data);
        return label;
    }

    protected void updateProjectList(IProject[] projects) {
        this.projectsTableViewer.setInput((Object)projects);
    }

    protected org.eclipse.wst.common.project.facet.core.runtime.IRuntime getSelectedRuntime() {
        IStructuredSelection selection = (IStructuredSelection)this.runtimesTableViewer.getSelection();
        if (selection.getFirstElement() != null) {
            org.eclipse.wst.common.project.facet.core.runtime.IRuntime runtime = (org.eclipse.wst.common.project.facet.core.runtime.IRuntime)selection.getFirstElement();
            return runtime;
        }
        return null;
    }

    public void setUnresolvedRuntime(IDataModel dataModel) {
        if (dataModel.isNestedModel("com.ibm.etools.common.migration.extension.ui.migrator.UnresolvedRuntimeMigrator")) {
            IDataModel STDataModel = this.getDataModel().getNestedModel("com.ibm.etools.common.migration.extension.ui.migrator.UnresolvedRuntimeMigrator");
            Object o = STDataModel.getProperty("STMigrationDataModelProvider.unresolvedRuntimesProperty");
            this.unresolvedRuntimeList = (Hashtable)o;
        }
    }

    protected void setDefaultRuntime() {
        for (org.eclipse.wst.common.project.facet.core.runtime.IRuntime curFacetRuntime : this.unresolvedRuntimeList.keySet()) {
            IRuntime[] curFilteredRuntimes = this.getFilteredRuntimes(curFacetRuntime, this.supportedRuntimes);
            this.unresolvedRuntimeList.get(curFacetRuntime).setAvailableRuntimes(curFilteredRuntimes);
            if (curFilteredRuntimes != null && curFilteredRuntimes.length > 0) {
                IRuntime runtime = null;
                int weight = -1;
                for (DefaultRuntimeProvider p : this.defaultSelectionProviderList) {
                    IRuntime tempRuntime;
                    if (Logger.DETAILS) {
                        Logger.println("/debug/details", (Object)this, "setDefaultRuntime()", "the provider class is:" + p.provider.getClass().getCanonicalName());
                    }
                    if ((tempRuntime = p.provider.getDefaultRuntime(curFacetRuntime, curFilteredRuntimes)) == null || p.weight < weight) continue;
                    runtime = tempRuntime;
                    weight = p.weight;
                }
                if (runtime == null) {
                    if (Logger.DETAILS) {
                        Logger.println("/debug/details", (Object)this, "setDefaultRuntime()", "pick the first one from the filtered list due to no default returned by the providers");
                    }
                    runtime = curFilteredRuntimes[0];
                }
                this.unresolvedRuntimeList.get(curFacetRuntime).setRuntime(runtime);
                continue;
            }
            if (Logger.DETAILS) {
                Logger.println("/debug/details", (Object)this, "setDefaultRuntime()", "set to null due to filtered runtime is null or none");
            }
            this.unresolvedRuntimeList.get(curFacetRuntime).setRuntime(null);
        }
    }

    protected void setDefaults() {
        Set<org.eclipse.wst.common.project.facet.core.runtime.IRuntime> curUnresolvedRuntimeItems = this.unresolvedRuntimeList.keySet();
        if (curUnresolvedRuntimeItems != null && curUnresolvedRuntimeItems.size() > 0) {
            org.eclipse.wst.common.project.facet.core.runtime.IRuntime defaultSelectedRuntime = curUnresolvedRuntimeItems.iterator().next();
            this.runtimesTableViewer.setSelection((ISelection)new StructuredSelection((Object)defaultSelectedRuntime), true);
        }
    }

    protected String[] getValidationPropertyNames() {
        return null;
    }

    public static boolean isRuntimeUnSupported(IRuntime runtime) {
        if (runtime.getRuntimeType() == null) {
            return true;
        }
        return runtime.getRuntimeType().getId().compareTo(RUNTIME_TYPE_ID_V50) == 0 || runtime.getRuntimeType().getId().compareTo(RUNTIME_TYPE_ID_V51) == 0;
    }

    class DefaultRuntimeProvider {
        IMigrationDefaultSelectionProvider provider;
        int weight;

        public DefaultRuntimeProvider(IMigrationDefaultSelectionProvider provider, String sWeight) {
            this.provider = provider;
            try {
                this.weight = Integer.parseInt(sWeight);
            }
            catch (Exception e) {
                this.weight = 0;
            }
        }
    }

    private class ResolvedRuntimeEditor
    extends EditingSupport {
        Hashtable<org.eclipse.wst.common.project.facet.core.runtime.IRuntime, ComboBoxCellEditor> editorsHash;

        public ResolvedRuntimeEditor(TableViewer viewer) {
            super((ColumnViewer)viewer);
            this.editorsHash = new Hashtable();
        }

        protected boolean canEdit(Object element) {
            return ProjectRetargetingPage.this.hasFilteredRuntime((org.eclipse.wst.common.project.facet.core.runtime.IRuntime)element);
        }

        protected CellEditor getCellEditor(Object element) {
            org.eclipse.wst.common.project.facet.core.runtime.IRuntime facetedRuntime = (org.eclipse.wst.common.project.facet.core.runtime.IRuntime)element;
            ComboBoxCellEditor cellEditor = this.editorsHash.get(element);
            if (cellEditor == null) {
                cellEditor = new ComboBoxCellEditorFix(((TableViewer)this.getViewer()).getTable(), new String[0]);
                this.editorsHash.put(facetedRuntime, cellEditor);
            }
            IRuntime[] filteredRuntimes = ProjectRetargetingPage.this.unresolvedRuntimeList.get(facetedRuntime).getAvailableRuntimes();
            String[] filteredRuntimesNames = new String[filteredRuntimes.length];
            for (int i = 0; i < filteredRuntimes.length; ++i) {
                filteredRuntimesNames[i] = filteredRuntimes[i].getName();
            }
            cellEditor.setItems(filteredRuntimesNames);
            return cellEditor;
        }

        protected Object getValue(Object element) {
            IRuntime[] filteredRuntimes = ProjectRetargetingPage.this.unresolvedRuntimeList.get(ProjectRetargetingPage.this.getSelectedRuntime()).getAvailableRuntimes();
            org.eclipse.wst.common.project.facet.core.runtime.IRuntime facetedRuntime = (org.eclipse.wst.common.project.facet.core.runtime.IRuntime)element;
            IRuntime selectedRuntime = ProjectRetargetingPage.this.unresolvedRuntimeList.get(facetedRuntime).getRuntime();
            int selectedIndex = 0;
            for (int i = 0; i < filteredRuntimes.length; ++i) {
                if (filteredRuntimes[i] != selectedRuntime) continue;
                selectedIndex = i;
                break;
            }
            return selectedIndex;
        }

        protected void setValue(Object element, Object value) {
            IRuntime[] filteredRuntimes = ProjectRetargetingPage.this.unresolvedRuntimeList.get(ProjectRetargetingPage.this.getSelectedRuntime()).getAvailableRuntimes();
            org.eclipse.wst.common.project.facet.core.runtime.IRuntime facetedRuntime = (org.eclipse.wst.common.project.facet.core.runtime.IRuntime)element;
            int selectedValue = (Integer)value;
            if (selectedValue >= 0) {
                ProjectRetargetingPage.this.unresolvedRuntimeList.get(facetedRuntime).setRuntime(filteredRuntimes[(Integer)value]);
            } else {
                ProjectRetargetingPage.this.unresolvedRuntimeList.get(facetedRuntime).setRuntime(null);
            }
            this.getViewer().update(element, null);
            ProjectRetargetingPage.this.getWizard().getContainer().updateButtons();
        }
    }

    private class ComboBoxCellEditorFix
    extends ComboBoxCellEditor {
        final CCombo cmb;

        public ComboBoxCellEditorFix(Table table, String[] filteredRuntimesNames) {
            super((Composite)table, filteredRuntimesNames, 8);
            this.cmb = (CCombo)this.getControl();
        }

        public void setFocus() {
            this.cmb.setFocus();
            this.cmb.setListVisible(true);
        }
    }
}

