/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.common.migration.extension.ui.internal;

import com.ibm.etools.common.migration.extension.ui.IRuntimeMigratorModifier;
import com.ibm.etools.common.migration.extension.ui.internal.IRetargetFilter;
import com.ibm.etools.common.migration.extension.ui.internal.MigrationPluginCoreMessages;
import com.ibm.etools.common.migration.extension.ui.internal.RuntimeMigratorExtensions;
import com.ibm.etools.common.migration.extension.ui.internal.trace.Logger;
import java.util.LinkedHashMap;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.jst.server.core.FacetUtil;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.eclipse.wst.common.project.facet.core.runtime.IRuntime;
import org.eclipse.wst.server.core.IRuntimeType;

public class ProjectFilter
implements IRetargetFilter {
    @Override
    public org.eclipse.wst.server.core.IRuntime[] filter(IRuntime originalRuntime, org.eclipse.wst.server.core.IRuntime[] availableRuntimes, IProject[] projects) {
        LinkedHashMap<String, org.eclipse.wst.server.core.IRuntime> filteredRuntimes = new LinkedHashMap<String, org.eclipse.wst.server.core.IRuntime>(3, 1.0f, false);
        org.eclipse.wst.server.core.IRuntime origRuntime = FacetUtil.getRuntime((IRuntime)originalRuntime);
        IRuntimeType origRuntimeType = origRuntime == null ? null : origRuntime.getRuntimeType();
        for (org.eclipse.wst.server.core.IRuntime runtime : availableRuntimes) {
            boolean isTargetable = true;
            IRuntimeType curRuntimeType = runtime.getRuntimeType();
            if (origRuntimeType != null && curRuntimeType != null && origRuntimeType.getId().startsWith("com.ibm.ws.ast.st.runtime.v85") && curRuntimeType.getId().startsWith("com.ibm.ws.ast.st.runtime.v85") && !curRuntimeType.getId().endsWith("portal")) {
                isTargetable = true;
            } else {
                for (IProject project : projects) {
                    try {
                        IFacetedProject facetedProject = ProjectFacetsManager.create((IProject)project);
                        if (curRuntimeType != null && curRuntimeType.getId().startsWith("com.ibm.ws.ast.st.runtime.v85") && !curRuntimeType.getId().endsWith("portal") && ProjectFilter.facetedProjectContainsPortalFacets(facetedProject)) {
                            isTargetable = false;
                            break;
                        }
                        if (curRuntimeType == null) continue;
                        IRuntime facetRuntime = FacetUtil.getRuntime((org.eclipse.wst.server.core.IRuntime)runtime);
                        RuntimeMigratorExtensions rmex = RuntimeMigratorExtensions.getInstance();
                        for (IProjectFacetVersion facet : facetedProject.getProjectFacets()) {
                            IRuntimeMigratorModifier adopter = rmex.getSupportedMigrators(facet);
                            Boolean isProjectTargetableOverride = null;
                            if (adopter != null) {
                                isProjectTargetableOverride = adopter.isProjectTargetable(facetedProject, runtime);
                            }
                            if (isProjectTargetableOverride == null) {
                                if (facetRuntime.supports(facet)) continue;
                                isTargetable = false;
                                continue;
                            }
                            if (isProjectTargetableOverride.booleanValue()) continue;
                            isTargetable = false;
                        }
                    }
                    catch (Exception e) {
                        isTargetable = false;
                        if (!Logger.WARNING) continue;
                        Logger.println("/debug/warning", this, "filter()", "Skipping project: " + String.valueOf(project) + " due to internal errors", (Throwable)e);
                    }
                }
            }
            if (!isTargetable || filteredRuntimes.containsKey(runtime.getId())) continue;
            filteredRuntimes.put(runtime.getId(), runtime);
        }
        return filteredRuntimes.values().toArray(new org.eclipse.wst.server.core.IRuntime[0]);
    }

    @Override
    public String[] getError() {
        return new String[]{MigrationPluginCoreMessages.L_NoSupportedRuntime};
    }

    private static boolean facetedProjectContainsPortalFacets(IFacetedProject facetedProject) {
        Set projectFacets = facetedProject.getProjectFacets();
        for (IProjectFacetVersion currentProjectFacetVersion : projectFacets) {
            String id;
            IProjectFacet projectFacet = currentProjectFacetVersion.getProjectFacet();
            if (projectFacet == null || !"jsr168.portal".equals(id = projectFacet.getId()) && !"jsr.portal".equals(id)) continue;
            return true;
        }
        return false;
    }
}

