/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.common.migration.extension.ui.internal;

import com.ibm.etools.common.migration.extension.ui.internal.trace.Logger;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.util.Properties;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.wst.server.core.IRuntime;

public class MigrationProjectProperties {
    private static final String PREFERENCE_FOLDER = ".settings";
    private static final String PREFERENCE_FILE = "com.ibm.etools.common.migration.prefs";
    private static final String MIGRATION_PROJECT_PREF = "com.ibm.etools.common.migration.isMigrated";
    private static final String MIGRATION_PROJECT_PREF_LASTKNOWN_VERSION = "com.ibm.etools.common.migration.lastKnownVersion";
    protected IProject project;
    protected boolean isMigrated = false;
    protected boolean doesSettingsFileExist = false;
    protected float lkv = 0.0f;

    public MigrationProjectProperties(IProject project) {
        this.project = project;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadPreferences() {
        if (Logger.INFO) {
            Logger.println("/debug/info", this, "loadPreferences()", "Loading project preferences: " + String.valueOf(this.project));
        }
        if (!this.project.isAccessible()) {
            return;
        }
        InputStream in = null;
        try {
            IFile file = this.project.getFolder(PREFERENCE_FOLDER).getFile(PREFERENCE_FILE);
            if (file == null || !file.isAccessible()) {
                return;
            }
            this.doesSettingsFileExist = true;
            in = file.getContents();
            Properties p = new Properties();
            p.load(in);
            String level = p.getProperty(MIGRATION_PROJECT_PREF_LASTKNOWN_VERSION);
            if (level != null && !level.isEmpty()) {
                this.lkv = Float.parseFloat(level);
            } else {
                String s = p.getProperty(MIGRATION_PROJECT_PREF);
                if (s != null && "true".equals(s)) {
                    this.isMigrated = true;
                    this.lkv = 7.5f;
                } else {
                    this.isMigrated = false;
                }
            }
        }
        catch (Exception e) {
            if (Logger.ERROR) {
                Logger.println("/debug/error", this, "loadPreferences()", "Could not load preferences " + e.getMessage(), (Throwable)e);
            }
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    private void savePreferences(IProgressMonitor monitor) throws CoreException {
        IStatus status;
        IFile file;
        if (this.project == null || !this.project.isAccessible()) {
            return;
        }
        IFolder folder = this.project.getFolder(PREFERENCE_FOLDER);
        if (!folder.exists()) {
            folder.create(true, true, monitor);
        }
        if ((file = this.project.getFolder(PREFERENCE_FOLDER).getFile(PREFERENCE_FILE)).exists() && file.isReadOnly() && (status = ResourcesPlugin.getWorkspace().validateEdit(new IFile[]{file}, null)).getSeverity() == 4) {
            throw new CoreException(status);
        }
        Properties p = new Properties();
        p.put("eclipse.preferences.version", "1");
        p.put(MIGRATION_PROJECT_PREF_LASTKNOWN_VERSION, Float.toString(this.lkv));
        InputStream in = null;
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            p.store(out, null);
            in = new ByteArrayInputStream(out.toByteArray());
            if (file.exists()) {
                file.setContents(in, true, true, monitor);
            } else {
                file.create(in, true, monitor);
            }
        }
        catch (Exception e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.wst.server.core", 0, "", (Throwable)e));
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public IRuntime getRuntimeTarget() {
        return null;
    }

    public boolean isMigrationAttemped() {
        this.loadPreferences();
        return this.doesSettingsFileExist;
    }

    public float getLastKnownRADVersion() {
        this.loadPreferences();
        return this.lkv;
    }

    public void setMigratedProject(boolean b, IProgressMonitor monitor) throws CoreException {
        this.loadPreferences();
        this.isMigrated = b;
        this.lkv = 8.5f;
        this.savePreferences(monitor);
    }

    public String toString() {
        return "ProjectProperties[" + String.valueOf(this.project) + "," + this.lkv + "," + this.isMigrated + "," + this.doesSettingsFileExist + "]";
    }

    public boolean isMigrationRequired() {
        if (!this.isMigrationAttemped()) {
            return true;
        }
        return this.getLastKnownRADVersion() <= 8.5f;
    }
}

