/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.common.migration.extension.ui;

import com.ibm.etools.common.migration.extension.ui.IRuntimeMigratorModifier;
import com.ibm.etools.common.migration.extension.ui.internal.MigrationPlugin;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.runtime.IRuntime;

public class AbstractRuntimeMigratorModifier
implements IRuntimeMigratorModifier {
    List<IFacetedProject> projects = new LinkedList<IFacetedProject>();

    @Override
    public Boolean isProjectTargetable(IFacetedProject facetedProject, org.eclipse.wst.server.core.IRuntime runtime) {
        return null;
    }

    @Override
    public void runtimeMigrationAction(int action, IFacetedProject facetedProject, IRuntime targetedRuntime, org.eclipse.wst.server.core.IRuntime userSelectedRuntime) throws CoreException {
    }

    protected void add(IFacetedProject project) {
        if (!this.projects.contains(project)) {
            this.projects.add(project);
        }
    }

    protected boolean contains(IFacetedProject project) {
        return this.projects.contains(project);
    }

    protected boolean remove(IFacetedProject project) {
        return this.projects.remove(project);
    }

    protected void removeProjectFacet(IFacetedProject facetedProject, String projectFacetPluginId) throws CoreException {
        Set projectFacets = facetedProject.getProjectFacets();
        Iterator iterator = projectFacets.iterator();
        HashSet<IFacetedProject.Action> actions = new HashSet<IFacetedProject.Action>();
        while (iterator.hasNext()) {
            IProjectFacetVersion facet = (IProjectFacetVersion)iterator.next();
            String pluginId = facet.getPluginId();
            if (pluginId == null || !pluginId.equalsIgnoreCase(projectFacetPluginId)) continue;
            IFacetedProject.Action action = new IFacetedProject.Action(IFacetedProject.Action.Type.UNINSTALL, facet, null);
            actions.add(action);
        }
        if (!actions.isEmpty()) {
            IRuntime facetedRuntime = facetedProject.getPrimaryRuntime();
            facetedProject.modify(actions, null);
            if (facetedRuntime != null) {
                MigrationPlugin.setRuntime(facetedProject, facetedRuntime);
            }
        }
    }

    protected void removeProjectFacetStartsWith(IFacetedProject facetedProject, String projectFacetPluginId) throws CoreException {
        Set projectFacets = facetedProject.getProjectFacets();
        Iterator iterator = projectFacets.iterator();
        HashSet<IFacetedProject.Action> actions = new HashSet<IFacetedProject.Action>();
        while (iterator.hasNext()) {
            IProjectFacetVersion facet = (IProjectFacetVersion)iterator.next();
            String pluginId = facet.getPluginId();
            if (pluginId == null || !pluginId.startsWith(projectFacetPluginId)) continue;
            IFacetedProject.Action action = new IFacetedProject.Action(IFacetedProject.Action.Type.UNINSTALL, facet, null);
            actions.add(action);
        }
        if (!actions.isEmpty()) {
            IRuntime facetedRuntime = facetedProject.getPrimaryRuntime();
            facetedProject.modify(actions, null);
            MigrationPlugin.setRuntime(facetedProject, facetedRuntime);
        }
    }
}

