/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.attrview.utils;

import com.ibm.etools.attrview.AVAccessibleAdapter;
import com.ibm.etools.attrview.AVWidgetFactory;
import com.ibm.etools.attrview.internal.ImageDescriptorUtil;
import com.ibm.etools.attrview.internal.ResourceHandler;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Hyperlink;
import org.eclipse.ui.forms.widgets.ImageHyperlink;

public class WidgetUtil {
    public static final int BEGINNING = 1;
    public static final int CENTER = 2;
    public static final int END = 3;
    public static final int FILL = 4;
    public static final int LEFT = 1;
    public static final int RIGHT = 3;
    public static final int TOP = 1;
    public static final int MIDDLE = 2;
    public static final int BOTTOM = 3;
    public static int IMAGE_WIDTH_MARGIN = 4;
    public static int IMAGE_HEIGHT_MARGIN = 4;
    public static int COMBO_BORDER_STYLE = 0;
    private static final String BROWSE;

    public static void addAccessibleListener(Control control, String accText) {
        if (control == null || accText == null) {
            return;
        }
        control.getAccessible().addAccessibleListener((AccessibleListener)new AVAccessibleAdapter(accText));
    }

    public static void alignWidth(Control[] controls) {
        int i;
        int maxWidth = 0;
        for (i = 0; i < controls.length; ++i) {
            if (controls[i] == null) continue;
            int width = controls[i].computeSize((int)-1, (int)-1).x;
            int widthHint = WidgetUtil.getWidthHint(controls[i]);
            if (width < widthHint) {
                width = widthHint;
            }
            if (maxWidth >= (width += WidgetUtil.getHorizontalIndent(controls[i]))) continue;
            maxWidth = width;
        }
        if (maxWidth > 0) {
            for (i = 0; i < controls.length; ++i) {
                if (controls[i] == null) continue;
                WidgetUtil.setWidthHint(controls[i], maxWidth - WidgetUtil.getHorizontalIndent(controls[i]));
            }
        }
    }

    public static Composite createAreaComposite(AVWidgetFactory factory, Composite parent, int numColumns) {
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = numColumns;
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        gridLayout.horizontalSpacing = 0;
        gridLayout.verticalSpacing = 0;
        GridData gridData = new GridData();
        return WidgetUtil.createComposite(factory, parent, 0, (Layout)gridLayout, gridData);
    }

    public static Button createBrowseButton(AVWidgetFactory factory, Composite parent) {
        return WidgetUtil.createBrowseButton(factory, parent, BROWSE, BROWSE);
    }

    public static Button createBrowseButton(AVWidgetFactory factory, Composite parent, String accText, String tooltipText) {
        Image image = ImageDescriptorUtil.createFullClcl16ImageDescriptor("file.gif").createImage();
        return WidgetUtil.createImageButton(factory, parent, image, accText, tooltipText);
    }

    public static Button createButton(AVWidgetFactory factory, Composite parent, String text) {
        Button button = factory.createButton(parent, 8);
        if (text != null) {
            button.setText(text);
        }
        return button;
    }

    public static Button createButton(AVWidgetFactory factory, Composite parent, String text, int style, GridData gridData) {
        Button button = factory.createButton(parent, style);
        if (text != null) {
            button.setText(text);
        }
        if (gridData != null) {
            button.setLayoutData((Object)gridData);
        }
        return button;
    }

    public static Button createCheckButton(AVWidgetFactory factory, Composite parent, String text) {
        Button button = factory.createButton(parent, 32);
        if (text != null) {
            button.setText(text);
        }
        return button;
    }

    public static Button createRadioButton(AVWidgetFactory factory, Composite parent, String text) {
        Button button = factory.createButton(parent, 16);
        if (text != null) {
            button.setText(text);
        }
        return button;
    }

    public static CLabel createCLabel(AVWidgetFactory factory, Composite parent, String text) {
        CLabel label = factory.createCLabel(parent, 0);
        if (text != null) {
            label.setText(text);
        }
        return label;
    }

    public static CCombo createCombo(AVWidgetFactory factory, Composite parent, boolean fill, boolean readonly) {
        int style = 0 | COMBO_BORDER_STYLE;
        if (readonly) {
            style |= 8;
        }
        GridData gridData = null;
        if (fill) {
            gridData = new GridData(768);
        }
        return WidgetUtil.createCombo(factory, parent, null, style, gridData);
    }

    public static CCombo createCombo(AVWidgetFactory factory, Composite parent, String[] items, int style, GridData gridData) {
        if (parent == null) {
            return null;
        }
        Display display = parent.getDisplay();
        CCombo combo = factory.createCombo(parent, style);
        combo.setBackground(display.getSystemColor(25));
        combo.setForeground(display.getSystemColor(24));
        if (items != null) {
            combo.setItems(items);
            combo.select(0);
        }
        if (gridData != null) {
            combo.setLayoutData((Object)gridData);
        }
        return combo;
    }

    public static Composite createComposite(AVWidgetFactory factory, Composite parent, int style, Layout layout, Object layoutData) {
        Composite composite = factory.createComposite(parent, style);
        if (layout != null) {
            composite.setLayout(layout);
        }
        if (layoutData != null) {
            composite.setLayoutData(layoutData);
        }
        return composite;
    }

    public static Hyperlink createHyperlink(AVWidgetFactory factory, Composite parent, String text) {
        Hyperlink hyperlink = factory.createHyperlink(parent, 0);
        if (text != null) {
            hyperlink.setText(text);
        }
        return hyperlink;
    }

    public static Button createImageButton(AVWidgetFactory factory, Composite parent, Image image) {
        return WidgetUtil.createImageButton(factory, parent, image, BROWSE, BROWSE);
    }

    public static Button createImageButton(AVWidgetFactory factory, Composite parent, Image image, String accText, String tooltipText) {
        Button button = factory.createButton(parent, 8);
        if (accText != null) {
            WidgetUtil.addAccessibleListener((Control)button, accText);
        }
        if (tooltipText != null) {
            button.setToolTipText(tooltipText);
        }
        if (image != null) {
            button.setImage(image);
            Rectangle r = image.getBounds();
            GridData gd = new GridData();
            gd.heightHint = r.height + IMAGE_HEIGHT_MARGIN;
            gd.widthHint = r.width + IMAGE_WIDTH_MARGIN;
            button.setLayoutData((Object)gd);
            button.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    Image img;
                    if (e.widget instanceof Button && (img = ((Button)e.widget).getImage()) != null && !img.isDisposed()) {
                        img.dispose();
                    }
                }
            });
        }
        return button;
    }

    public static ImageHyperlink createImageHyperlink(AVWidgetFactory factory, Composite parent, String text) {
        ImageHyperlink hyperlink = factory.createImageHyperlink(parent, 0);
        if (text != null) {
            hyperlink.setToolTipText(text);
        }
        return hyperlink;
    }

    public static Text createIntegerTextField(AVWidgetFactory factory, Composite parent, boolean readonly) {
        int style = 4;
        if (readonly) {
            style |= 8;
        }
        Text text = factory.createText(parent, style);
        WidgetUtil.setWidthHint((Control)text, WidgetUtil.getTextExtent((Control)parent, (String)"000000").x);
        return text;
    }

    public static Label createLabel(AVWidgetFactory factory, Composite parent, String text) {
        Label label = factory.createLabel(parent, 0);
        if (text != null) {
            label.setText(text);
        }
        return label;
    }

    public static List createList(AVWidgetFactory factory, Composite parent, String[] items, int style, GridData gridData) {
        if (parent == null) {
            return null;
        }
        List list = factory.createList(parent, style);
        if (items != null) {
            list.setItems(items);
        }
        if (gridData != null) {
            list.setLayoutData((Object)gridData);
        }
        return list;
    }

    public static Button createMultiBrowseButton(AVWidgetFactory factory, Composite parent) {
        return WidgetUtil.createMultiBrowseButton(factory, parent, BROWSE, BROWSE);
    }

    public static Button createMultiBrowseButton(AVWidgetFactory factory, Composite parent, String accText, String tooltipText) {
        Image image = ImageDescriptorUtil.createFullClcl16ImageDescriptor("file_expand.gif").createImage();
        return WidgetUtil.createImageButton(factory, parent, image, accText, tooltipText);
    }

    public static Label createSeparator(AVWidgetFactory factory, Composite parent) {
        Label separator = factory.createLabel(parent, 258);
        separator.setLayoutData((Object)new GridData(768));
        return separator;
    }

    public static Label createSeparator(AVWidgetFactory factory, Composite parent, String text) {
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        Composite area = WidgetUtil.createComposite(factory, parent, 0, (Layout)gridLayout, new GridData(768));
        Label label = WidgetUtil.createLabel(factory, area, text);
        Label separator = factory.createLabel(area, 258);
        separator.setLayoutData((Object)new GridData(768));
        return label;
    }

    public static Table createTable(AVWidgetFactory factory, Composite parent, boolean fill, boolean check, boolean multi) {
        int style = 67584;
        if (check) {
            style |= 0x20;
        }
        style = multi ? (style |= 2) : (style |= 4);
        style |= 0x100;
        Table table = WidgetUtil.createTable(factory, parent, style |= 0x200);
        if (fill) {
            table.setLayoutData((Object)new GridData(1808));
        }
        return table;
    }

    public static Table createTable(AVWidgetFactory factory, Composite parent, int style) {
        Table table = factory.createTable(parent, style);
        return table;
    }

    public static TableColumn createTableColumn(AVWidgetFactory factory, Table table, int style) {
        TableColumn column = factory.createTableColumn(table, style);
        return column;
    }

    public static TableItem createTableItem(AVWidgetFactory factory, Table table, int style) {
        TableItem item = factory.createTableItem(table, style);
        return item;
    }

    public static Text createText(AVWidgetFactory factory, Composite parent, int style, GridData gridData) {
        if (parent == null) {
            return null;
        }
        Text text = factory.createText(parent, style);
        if (gridData != null) {
            text.setLayoutData((Object)gridData);
        }
        return text;
    }

    public static Text createTextArea(AVWidgetFactory factory, Composite parent, int numRows) {
        return WidgetUtil.createTextArea(factory, parent, numRows, false);
    }

    public static Text createTextArea(AVWidgetFactory factory, Composite parent, int numRows, boolean noborder) {
        GridData gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        if (numRows > 0) {
            gridData.heightHint = WidgetUtil.getTextExtent((Control)parent, (String)"X").y * numRows;
        }
        int style = 770;
        if (!noborder) {
            style |= 0x800;
        }
        return WidgetUtil.createText(factory, parent, style, gridData);
    }

    public static Text createTextField(AVWidgetFactory factory, Composite parent, boolean fill, boolean readonly) {
        Display display = parent.getDisplay();
        int style = 4;
        if (readonly) {
            style |= 8;
        }
        Text text = factory.createText(parent, style);
        text.setBackground(display.getSystemColor(25));
        text.setForeground(display.getSystemColor(24));
        if (fill) {
            text.setLayoutData((Object)new GridData(768));
        }
        return text;
    }

    public static Tree createTree(AVWidgetFactory factory, Composite parent, int style) {
        Tree tree = factory.createTree(parent, style);
        return tree;
    }

    public static Point getDefaultTextExtent(Control control, String text) {
        GC gc = new GC((Drawable)control);
        Font font = JFaceResources.getFontRegistry().get("org.eclipse.jface.defaultfont");
        gc.setFont(font);
        Point point = gc.textExtent(text);
        gc.dispose();
        return point;
    }

    public static Control getFocusControl(Control c) {
        if (c != null) {
            Control[] children;
            if (c.isFocusControl()) {
                return c;
            }
            if (c instanceof Composite && (children = ((Composite)c).getChildren()) != null) {
                for (int i = 0; i < children.length; ++i) {
                    Control d = WidgetUtil.getFocusControl(children[i]);
                    if (d == null) continue;
                    return d;
                }
            }
        }
        return null;
    }

    public static int getHorizontalIndent(Control control) {
        Object layoutData;
        if (control != null && (layoutData = control.getLayoutData()) != null && layoutData instanceof GridData) {
            return ((GridData)layoutData).horizontalIndent;
        }
        return 0;
    }

    public static Point getTextExtent(Control control, String text) {
        if (control != null) {
            GC gc = new GC((Drawable)control);
            Point point = gc.textExtent(text);
            gc.dispose();
            return point;
        }
        return new Point(0, 0);
    }

    public static Point getTextExtentMax(Control control, String[] text) {
        if (control != null && text != null) {
            GC gc = new GC((Drawable)control);
            Point point = new Point(0, 0);
            for (int i = 0; i < text.length; ++i) {
                Point p = gc.textExtent(text[i]);
                if (point.x < p.x) {
                    point.x = p.x;
                }
                if (point.y >= p.y) continue;
                point.y = p.y;
            }
            gc.dispose();
            return point;
        }
        return new Point(0, 0);
    }

    public static int getWidthHint(Control control) {
        Object layoutData;
        if (control != null && (layoutData = control.getLayoutData()) != null && layoutData instanceof GridData) {
            return ((GridData)layoutData).widthHint;
        }
        return 0;
    }

    public static void setGrabExcessHorizontalSpace(Control control, boolean grabExcessHorizontalSpace) {
        if (control != null) {
            Object layoutData = control.getLayoutData();
            if (layoutData != null && layoutData instanceof GridData) {
                ((GridData)layoutData).grabExcessHorizontalSpace = grabExcessHorizontalSpace;
            } else {
                GridData gridData = new GridData();
                gridData.grabExcessHorizontalSpace = grabExcessHorizontalSpace;
                control.setLayoutData((Object)gridData);
            }
        }
    }

    public static void setHeightHint(Control control, int heightHint) {
        if (control != null) {
            Object layoutData = control.getLayoutData();
            if (layoutData != null && layoutData instanceof GridData) {
                ((GridData)layoutData).heightHint = heightHint;
            } else {
                GridData gridData = new GridData();
                gridData.heightHint = heightHint;
                control.setLayoutData((Object)gridData);
            }
        }
    }

    public static void setHorizontalIndent(Control control, int horizontalIndent) {
        if (control != null) {
            Object layoutData = control.getLayoutData();
            if (layoutData != null && layoutData instanceof GridData) {
                ((GridData)layoutData).horizontalIndent = horizontalIndent;
            } else {
                GridData gridData = new GridData();
                gridData.horizontalIndent = horizontalIndent;
                control.setLayoutData((Object)gridData);
            }
        }
    }

    public static void setHorizontalSpan(Control control, int horizontalSpan) {
        if (control != null) {
            Object layoutData = control.getLayoutData();
            if (layoutData != null && layoutData instanceof GridData) {
                ((GridData)layoutData).horizontalSpan = horizontalSpan;
            } else {
                GridData gridData = new GridData();
                gridData.horizontalSpan = horizontalSpan;
                control.setLayoutData((Object)gridData);
            }
        }
    }

    public static void setMakeColumnsEqualWidth(Composite composite, boolean makeColumnsEqualWidth) {
        if (composite != null) {
            Layout layout = composite.getLayout();
            if (layout != null && layout instanceof GridLayout) {
                ((GridLayout)layout).makeColumnsEqualWidth = makeColumnsEqualWidth;
            } else {
                GridLayout gridLayout = new GridLayout();
                gridLayout.makeColumnsEqualWidth = makeColumnsEqualWidth;
                composite.setLayout((Layout)gridLayout);
            }
        }
    }

    public static void setVerticalAlignment(Control control, int align) {
        Object layoutData = control.getLayoutData();
        if (layoutData != null && layoutData instanceof GridData) {
            ((GridData)layoutData).verticalAlignment = align;
        } else {
            GridData gridData = new GridData();
            gridData.verticalAlignment = align;
            control.setLayoutData((Object)gridData);
        }
    }

    public static void setWidthHint(Control control, int widthHint) {
        if (control != null) {
            Object layoutData = control.getLayoutData();
            if (layoutData != null && layoutData instanceof GridData) {
                ((GridData)layoutData).widthHint = widthHint;
            } else {
                GridData gridData = new GridData();
                gridData.widthHint = widthHint;
                control.setLayoutData((Object)gridData);
            }
        }
    }

    static {
        String osName = System.getProperty("os.name");
        if (osName.startsWith("Linux")) {
            IMAGE_WIDTH_MARGIN = 10;
            IMAGE_HEIGHT_MARGIN = 10;
        } else if (osName.startsWith("Windows XP")) {
            IMAGE_WIDTH_MARGIN = 8;
            IMAGE_HEIGHT_MARGIN = 8;
        }
        FormToolkit toolkit = new FormToolkit(Display.getDefault());
        COMBO_BORDER_STYLE = toolkit.getBorderStyle();
        BROWSE = ResourceHandler._UI_WU_0;
    }
}

