/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.attrview.utils;

public class StringUtil {
    public static boolean belongsTo(String sample, String[] group) {
        if (sample != null && group != null) {
            for (int i = 0; i < group.length; ++i) {
                if (!sample.equals(group[i])) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean belongsToIgnoreCase(String sample, String[] group) {
        if (sample != null && group != null) {
            for (int i = 0; i < group.length; ++i) {
                if (!sample.equalsIgnoreCase(group[i])) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean compare(String a, String b) {
        return a != null && b != null ? a.equals(b) : a == null && b == null;
    }

    public static boolean compare(String[] a, String[] b) {
        if (a == null && b == null) {
            return true;
        }
        if (a != null && b != null) {
            if (a.length != b.length) {
                return false;
            }
            for (int i = 0; i < a.length; ++i) {
                if (StringUtil.compare(a[i], b[i])) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static boolean compareIgnoreCase(String a, String b) {
        return a != null && b != null ? a.equalsIgnoreCase(b) : a == null && b == null;
    }

    public static boolean compareIgnoreCase(String[] a, String[] b) {
        if (a == null && b == null) {
            return true;
        }
        if (a != null && b != null) {
            if (a.length != b.length) {
                return false;
            }
            for (int i = 0; i < a.length; ++i) {
                if (StringUtil.compareIgnoreCase(a[i], b[i])) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static boolean contains(String a, String[] b) {
        if (a != null && b != null) {
            for (int i = 0; i < b.length; ++i) {
                if (!StringUtil.compare(a, b[i])) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean containsIgnoreCase(String a, String[] b) {
        if (a != null && b != null) {
            for (int i = 0; i < b.length; ++i) {
                if (!StringUtil.compareIgnoreCase(a, b[i])) continue;
                return true;
            }
        }
        return false;
    }

    public static String createDisplayString(String text) {
        if (text == null || text.length() < 1) {
            return text;
        }
        char[] p = text.toCharArray();
        char[] q = new char[p.length];
        for (int i = 0; i < p.length; ++i) {
            q[i] = !Character.isWhitespace(p[i]) ? p[i] : 32;
        }
        return new String(q);
    }

    public static String formatText(String text) {
        if (text == null || text.length() < 1) {
            return null;
        }
        char[] p = text.toCharArray();
        char[] q = new char[p.length];
        int c = 0;
        boolean space = false;
        for (int i = 0; i < p.length; ++i) {
            if (!space) {
                if (!Character.isWhitespace(p[i])) {
                    q[c++] = p[i];
                    continue;
                }
                q[c++] = 32;
                space = true;
                continue;
            }
            if (Character.isWhitespace(p[i])) continue;
            q[c++] = p[i];
            space = false;
        }
        if (c > 0) {
            return new String(q, 0, c);
        }
        return null;
    }

    public static boolean hasNonWhitespace(String value) {
        if (value != null) {
            char[] p = value.toCharArray();
            for (int i = 0; i < p.length; ++i) {
                if (Character.isWhitespace(p[i])) continue;
                return true;
            }
        }
        return false;
    }

    public static String trimForeZeros(String value) {
        int index;
        if (value == null) {
            return null;
        }
        if ((value = value.trim()).length() < 1) {
            return value;
        }
        char[] p = value.toCharArray();
        for (index = 0; index < p.length && p[index] == '0'; ++index) {
        }
        if (index == 0) {
            return value;
        }
        if (index < p.length) {
            if (!Character.isDigit(p[index])) {
                return value.substring(index - 1);
            }
            return value.substring(index);
        }
        return "0";
    }
}

