/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.attrview.sdk;

import com.ibm.etools.attrview.sdk.AVValueItem;
import com.ibm.etools.attrview.utils.StringUtil;

public class AVValueItemUtil {
    public static AVValueItem getItem(AVValueItem[] items, int index) {
        if (items != null && 0 <= index && index < items.length) {
            return items[index];
        }
        return null;
    }

    public static AVValueItem getItemByDisplayString(AVValueItem[] items, String displayString) {
        return AVValueItemUtil.getItem(items, AVValueItemUtil.getItemIndexByDisplayString(items, displayString));
    }

    public static AVValueItem getItemByValue(AVValueItem[] items, String value) {
        return AVValueItemUtil.getItem(items, AVValueItemUtil.getItemIndexByValue(items, value));
    }

    public static int getItemCount(AVValueItem[] items) {
        return items != null ? items.length : 0;
    }

    public static int getItemIndexByDisplayString(AVValueItem[] items, String displayString) {
        return AVValueItemUtil.getItemIndexByDisplayString(items, displayString, false);
    }

    public static int getItemIndexByDisplayString(AVValueItem[] items, String displayString, boolean ignoreCase) {
        if (items != null && displayString != null) {
            for (int i = 0; i < items.length; ++i) {
                AVValueItem item = items[i];
                if (!(ignoreCase ? StringUtil.compareIgnoreCase(item.getDisplayString(), displayString) : StringUtil.compare(item.getDisplayString(), displayString))) continue;
                return i;
            }
        }
        return -1;
    }

    public static int getItemIndexByValue(AVValueItem[] items, String value) {
        if (items != null) {
            for (int i = 0; i < items.length; ++i) {
                AVValueItem item = items[i];
                if (!item.matches(value)) continue;
                return i;
            }
        }
        return -1;
    }

    public static String getDisplayString(AVValueItem[] items, int index) {
        AVValueItem item = AVValueItemUtil.getItem(items, index);
        if (item != null) {
            return item.getDisplayString();
        }
        return null;
    }

    public static String getDisplayString(AVValueItem[] items, String value) {
        AVValueItem item = AVValueItemUtil.getItemByValue(items, value);
        if (item != null) {
            return item.getDisplayString();
        }
        return null;
    }

    public static String[] getDisplayStrings(AVValueItem[] items) {
        int count = AVValueItemUtil.getItemCount(items);
        if (count > 0) {
            String[] displayStrings = new String[count];
            for (int i = 0; i < count; ++i) {
                displayStrings[i] = items[i].getDisplayString();
            }
            return displayStrings;
        }
        return null;
    }

    public static String getValue(AVValueItem[] items, int index) {
        AVValueItem item = AVValueItemUtil.getItem(items, index);
        if (item != null) {
            return item.getValue();
        }
        return null;
    }

    public static String getValue(AVValueItem[] items, String displayString) {
        AVValueItem item = AVValueItemUtil.getItemByDisplayString(items, displayString);
        if (item != null) {
            return item.getValue();
        }
        return null;
    }

    public static String[] getValues(AVValueItem[] items) {
        int count = AVValueItemUtil.getItemCount(items);
        if (count > 0) {
            String[] values = new String[count];
            for (int i = 0; i < count; ++i) {
                values[i] = items[i].getValue();
            }
            return values;
        }
        return null;
    }
}

